<?php
session_start();
date_default_timezone_set('America/Sao_Paulo');
header('Content-Type: text/html; charset=utf-8');

require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
include_once('../../funcoes/general.php');

// Carrega traduções
$traducao = require '../../custom/translations/pt-br.php';

require '../../class/walletClass.php';
require '../../class/adicionaisWhitelabels.php';
require '../../class/getPlanosConfig.php';
require '../../class/vendasClass.php';
require '../../class/produtosClass.php';
require '../../class/validaAssinatura.php';

// Verifica se está logado ou não
if (!isset($_SESSION['usuario']['email'])) {
    header('Location: /login');
    exit();
}

$customBase = __DIR__ . '/../../custom/includes/';
if (isset($_SESSION['usuario']['is_adm']) && $_SESSION['usuario']['is_adm'] == 1) {
    $customDir = $customBase . 'admin/';
} else {
    $customDir = $customBase . 'user/';
}

if (is_dir($customDir)) {
    foreach (glob($customDir . '*.php') as $filename) {
        include_once $filename;
    }
}

$dados = $_SESSION;

$adicionais = new AdicionaisWhitelabels($pdo);

// 🔧 VALIDAÇÃO DE SESSÃO VIA API (com cache)
$idUsuario = $_SESSION['usuario']['id_usuario'];
$whitelabelContas = Config::get('database.dbname');

try {
    // 🔧 CACHE DE VALIDAÇÃO: Evita chamadas excessivas à API
    // Verifica última validação (cache de 5 minutos)
    $cacheKey = 'last_session_validation_' . $idUsuario;
    $lastValidation = $_SESSION[$cacheKey] ?? 0;
    $cacheTime = 300; // 5 minutos em segundos

    // Só valida se o cache expirou
    if ((time() - $lastValidation) >= $cacheTime) {
        // Faz requisição para a API do núcleo
        $url = 'https://v1.api.codefly.site/api.php/user/find-by-id?' . http_build_query([
            'id' => $idUsuario,
            'whitelabel' => $whitelabelContas
        ]);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curlError = curl_error($ch);
        curl_close($ch);

        // Valida resposta da API
        if ($response && $httpCode === 200) {
            $apiResult = json_decode($response, true);

            if ($apiResult['success']) {
                $row = $apiResult['user'];

                // Comparar os dados da sessão com os da API
                $dadosSessao = $_SESSION['usuario'] ?? [];
                $atualizarSessao = false;

                foreach ($row as $chave => $valorBanco) {
                    // Ignorar campos sensíveis na comparação
                    if (in_array($chave, ['senha', 'senha_master', 'twofa_secret'])) {
                        continue;
                    }

                    if (!isset($dadosSessao[$chave]) || $dadosSessao[$chave] != $valorBanco) {
                        $atualizarSessao = true;
                        break;
                    }
                }

                // Atualizar a sessão se houver diferença ou se as contas não estiverem na sessão
                if ($atualizarSessao || !isset($_SESSION['usuarios_api_contas'])) {
                    $_SESSION['usuario'] = [
                        'id_usuario' => $row['id'],
                        'email' => $row['email'],
                        'celular' => $row['celular'],
                        'nome' => $row['nome'],
                        'documento' => $row['documento'],
                        'n_acesso' => $row['n_acesso'],
                        'plano_id' => $row['plano_id'],
                        'forcar_edt_senha' => $row['forcar_edt_senha'],
                        'dta_inicio_assinatura' => $row['dta_inicio_assinatura'],
                        'dta_fim_assinatura' => $row['dta_fim_assinatura'],
                        'cadastro_completo' => $row['cadastro_completo'],
                        'wallet_id' => $row['wallet_id'],
                        'is_adm' => $row['is_admin'],
                        'is_supplier' => $row['is_supplier'],
                        'is_affiliate' => $row['is_affiliate'],
                    ];

                    // Busca contas de API
                    $urlLojas = 'https://v1.api.codefly.site/api.php/user/api-accounts?' . http_build_query([
                        'user_id' => $idUsuario,
                        'whitelabel' => $whitelabelContas
                    ]);

                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $urlLojas);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
                    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);

                    $responseLojas = curl_exec($ch);
                    curl_close($ch);

                    if ($responseLojas) {
                        $lojasResult = json_decode($responseLojas, true);
                        if ($lojasResult['success']) {
                            $_SESSION['usuarios_api_contas'] = $lojasResult['accounts'];
                            $_SESSION['drophub_global.usuarios_api_contas'] = $lojasResult['accounts'];
                        }
                    }
                }
            } else {
                // API retornou erro - apenas loga
                error_log("[VALIDAÇÃO SESSÃO] API retornou erro para usuário {$idUsuario}: " . ($apiResult['message'] ?? 'Erro desconhecido'));
            }
        } else {
            // API não respondeu - apenas loga
            error_log("[VALIDAÇÃO SESSÃO] API não respondeu para usuário {$idUsuario}: HTTP {$httpCode} - {$curlError}");
        }

        // Atualiza cache independente do resultado
        $_SESSION[$cacheKey] = time();
    }
} catch (Exception $e) {
    error_log("[VALIDAÇÃO SESSÃO] Erro ao validar a sessão via API: " . $e->getMessage());
}

?>

<!DOCTYPE html>
<html lang="pt-br" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer-starter">

<head>
    <meta charset="UTF-8">
    <?php include('../../includes/dashHead.php'); ?>

    <link rel="stylesheet" href="../../assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/swiper/swiper.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/pages/cards-advance.css" />

    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/vendor/js/template-customizer.js"></script>
    <script src="../../assets/js/config.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
    <script src="../../assets/js/funcoes.js"></script>

    <style>
        /* Garante que SweetAlert fique acima do modal Bootstrap */
        .swal-overlay-high {
            z-index: 10000 !important;
        }

        .swal2-container.swal-overlay-high {
            z-index: 10000 !important;
        }
    </style>

</head>

<body>

    <!-- Define ID_USUARIO global para uso no JS -->
    <script>
        <?php if (isset($_SESSION['usuario']['id_usuario'])): ?>
            window.ID_USUARIO = <?php echo json_encode($_SESSION['usuario']['id_usuario']); ?>;
        <?php endif; ?>
    </script>

    <!-- Modal de Progresso -->
    <div id="progressOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); z-index: 9999; justify-content: center; align-items: center; color: white;">
        <div style="text-align: center;">
            <h3 id="progressTitle" class="text-white">Iniciando anúncio...</h3>
            <div style="background: #444; border-radius: 5px; margin: 10px auto; width: 300px; height: 25px;">
                <div id="progressBar" style="width: 0%; height: 100%; background: green; border-radius: 5px;"></div>
            </div>
            <p id="progressText" class="text-secondary">Aguarde enquanto o produto está sendo anunciado.</p>
        </div>
    </div>


    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo mt-3">
                    <a href="dashboard" class="app-brand-link">

                        <?php
                        if (Config::get('site_configs.text_icon') == true) {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                            <span class="app-brand-text text-body fw-bold ms-1"><?php echo Config::get('site_configs.name'); ?></span>
                        <?php
                        } else {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                        <?php
                        }
                        ?>

                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                        <i class="ti menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
                        <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1">
                    <?php
                    if ($_SESSION['usuario']['n_acesso'] == '0') {
                        include('../../includes/sidebars-menus/sidebar_usuario.php');
                    } else {
                        include('../../includes/sidebars-menus/sidebar_master.php');
                    }
                    ?>
                </ul>
            </aside>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="ti ti-menu-2 ti-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <?php include('../../includes/dashnav.php') ?>

                    </div>
                </nav>





                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <div class="mt-3">
                            <div class="card p-2 rounded shadow">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-1">Cadastrar Produto</h5>
                                </div>

                                <div class="card-body">
                                    <div class="mt-4 shadow-sm border rounded mb-4 p-4">
                                        <h5>Selecione a loja!</h5>

                                        <div class="row" id="cardsContainer">
                                            <?php
                                            // Busca as lojas/contas API do usuário diretamente do banco
                                            if (isset($_POST['produto'])) {
                                                $produtojson = json_decode($_POST['produto'], true);
                                                $produto_temp = json_decode(base64_decode($produtojson['produto']), true);
                                                $fornecedorNome = $produto_temp['fornecedor_nome'] ?? '';
                                                
                                                try {
                                                    $idUsuario = $_SESSION['usuario']['id_usuario'];
                                                    $whitelabelContas = Config::get('database.dbname');
                                                    
                                                    // DEBUG: Log dos parâmetros
                                                    echo "<script>console.log('=== DEBUG BUSCA LOJAS ===');</script>";
                                                    echo "<script>console.log('ID Usuario: " . addslashes($idUsuario) . "');</script>";
                                                    echo "<script>console.log('Whitelabel: " . addslashes($whitelabelContas) . "');</script>";
                                                    echo "<script>console.log('Fornecedor Nome: " . addslashes($fornecedorNome) . "');</script>";
                                                    
                                                    $sql = "
                                                        SELECT uac.*, f.nome as forn_nome 
                                                        FROM drophub_global.usuarios_api_contas uac 
                                                        INNER JOIN drophub_global.fornecedores f ON uac.fornecedor = f.id 
                                                        WHERE uac.user_id = ?
                                                        AND uac.whitelabel = ?
                                                        AND f.nome = ?
                                                        AND uac.plataforma NOT LIKE 'envioecom%'
                                                    ";
                                                    
                                                    echo "<script>console.log('SQL Query: " . addslashes(str_replace(["\n", "\r"], ' ', $sql)) . "');</script>";
                                                    
                                                    $stmt = $pdo->prepare($sql);
                                                    $stmt->execute([$idUsuario, $whitelabelContas, $fornecedorNome]);
                                                    $lojas = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                                    
                                                    // DEBUG: Log do resultado
                                                    echo "<script>console.log('Total de lojas encontradas: " . count($lojas) . "');</script>";
                                                    echo "<script>console.log('Lojas:', " . json_encode($lojas) . ");</script>";

                                                    if ($lojas && count($lojas) > 0) {
                                                        foreach ($lojas as $loja) {
                                                            $titulo = htmlspecialchars($loja['nome']);
                                                            $limite = 10;
                                                            if (strlen($titulo) > $limite) {
                                                                $tituloExibido = substr($titulo, 0, $limite) . '...';
                                                            } else {
                                                                $tituloExibido = $titulo;
                                                            }
                                                            
                                                            $contaJson = htmlspecialchars(json_encode([
                                                                'nome_api_contas' => $loja['nome'],
                                                                'id_api_contas' => $loja['user_id'],
                                                                'seller_id_api_contas' => $loja['seller_id'],
                                                                'plataforma_api_contas' => $loja['plataforma'],
                                                                'fornecedor' => $loja['forn_nome'],
                                                                'percent_venda' => $loja['percent_venda'],
                                                                'percent_com_mkp' => $loja['percent_com_mkp'],
                                                                'taxa' => $loja['taxa'],
                                                                'frete' => $loja['frete'],
                                                                'percent_imposto' => $loja['percent_imposto'],
                                                                'client_id' => $loja['client_id'],
                                                                'client_secret' => $loja['client_secret'],
                                                                'access_token' => $loja['access_token'],
                                                                'refresh_token' => $loja['code'],
                                                            ]), ENT_QUOTES);
                                                            
                                                            echo '<div class="col-md-3">';
                                                            echo '<div class="card border mb-3 rounded">';
                                                            echo '<div class="card-header">';
                                                            echo '<div class="d-flex flex-column align-items-center justify-content-center">';
                                                            echo '<div class="d-flex w-100 flex-row align-items-center gap-3 mb-2">';
                                                            echo '<div class="form-check">';
                                                            echo '<input class="form-check-input loja-checkbox" type="checkbox" name="selectedCards[]" value="' . $contaJson . '" id="checkbox' . htmlspecialchars($loja['user_id']) . '">';
                                                            echo '</div>';
                                                            echo '<img src="../../../assets/img/icons/brands/' . htmlspecialchars($loja['plataforma']) . '.png" height="30px" alt="Plataforma">';
                                                            echo '<h5 class="card-title mb-0">' . $tituloExibido . '</h5>';
                                                            echo '</div>';
                                                            echo '<small class="text-muted align-items-end">' . htmlspecialchars($loja['forn_nome']) . '</small>';
                                                            echo '</div>';
                                                            echo '</div>';
                                                            echo '</div>';
                                                            echo '</div>';
                                                        }
                                                    } else {
                                                        echo '<p class="text-danger">Nenhuma conta correspondente foi encontrada para o fornecedor especificado.</p>';
                                                    }
                                                } catch (Exception $e) {
                                                    echo '<p class="text-danger">Erro ao buscar contas: ' . htmlspecialchars($e->getMessage()) . '</p>';
                                                }
                                            }
                                            ?>
                                        </div>
                                    </div>


                                    <?php

                                    if (isset($_POST['produto'])) {
                                        $produtojson = json_decode($_POST['produto'], true);
                                        $produto = json_decode(base64_decode($produtojson['produto']), true);

                                        // Pega todas as imagens do produto
                                        $sql = "SELECT DISTINCT(imagem_url) FROM drophub_global.produtos_imagens WHERE produto_id = :produto_id";
                                        $stmt = $pdo->prepare($sql);
                                        $stmt->execute([':produto_id' => $produto['id']]);
                                        $images_url = $stmt->fetchAll(PDO::FETCH_ASSOC); // Garante array associativo

                                        // Pega a imagem de capa (a com menor imagem_url)
                                        $sqlCapa = "SELECT MIN(imagem_url) AS imagem_capa FROM drophub_global.produtos_imagens WHERE produto_id = :produto_id";
                                        $stmtCapa = $pdo->prepare($sqlCapa);
                                        $stmtCapa->execute([':produto_id' => $produto['id']]);
                                        $imagem_capa = $stmtCapa->fetchColumn();

                                        $sqlFilho = "SELECT count(*) FROM produtos WHERE produto_pai = :produto_id";
                                        $stmtFilho = $pdo->prepare($sqlFilho);
                                        $stmtFilho->execute([':produto_id' => $produto['id']]);
                                        $have_filho = $stmtFilho->fetchColumn();


                                        // Adiciona os campos ao array do produto
                                        $produto['imagem_capa'] = $imagem_capa;
                                        $produto['todas_imagens'] = array_column($images_url, 'imagem_url');

                                        echo '<form class="d-none" method="post" id="produto-form">';

                                        if ($produto['sensivel'] === 1) {
                                            echo '<div class="alert alert-danger" role="alert">
                                                <i class="ti ti-alert-triangle me-2"></i> Atenção: este produto é classificado como sensível. Certifique-se de revisar cuidadosamente as informações antes de prosseguir com o anúncio.
                                            </div>';
                                        }

                                        if ($have_filho >= 1) {
                                            echo '
                                            <div class="card mb-3 border border-primary h-100">
                                                <div class="card-body d-flex flex-column align-items-start">
                                                        <h6 class="mb-0 text-primary"><i class="me-1 ti ti-alert-square-rounded"></i> Este produto possui variações. Por favor, selecione a variação desejada para anunciar junto ao produto principal.</h6>
                                                </div>
                                            </div>';
                                        }

                                        echo '
                                        <div class="col-md-6 mb-3 d-none">
                                            <label for="id" class="form-label">ID:</label>
                                            <input type="text" class="form-control" id="id" name="id" value="' . htmlspecialchars($produto['id']) . '">
                                        </div>

                                        <div class="col-md-6 mb-3 d-none">
                                            <label for="usuario" class="form-label">usuario:</label>
                                            <input type="text" class="form-control" id="usuario" name="usuario" value="' . $_SESSION['usuario']['email'] . '">
                                        </div>

                                        <div class="col-md-6 mb-3 d-none">
                                            <label for="id_usuario" class="form-label">id_usuario:</label>
                                            <input type="text" class="form-control" id="id_usuario" name="id_usuario" value="' . $_SESSION['usuario']['id_usuario'] . '">
                                        </div>

                                        <div class="col-md-6 mb-3 d-none">
                                            <label for="loja_selecionada" class="form-label">loja:</label>
                                            <input type="text" class="form-control" id="loja_selecionada" name="loja_selecionada">
                                        </div>

                                         <div class="col-md-6 mb-3 d-none">
                                            <label for="percent_venda" class="form-label">percent_venda:</label>
                                            <input type="text" class="form-control" id="percent_venda" name="percent_venda">
                                        </div>


                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="card h-100 border ' . ($produto['sensivel'] == 1 ? 'border-danger' : '') . ' shadow rounded">
                                                    <div class="card-body d-flex flex-column">
                                                        <div class="col-md-3 mb-3 me-3">
                                                            <img src="' . $produto['imagem_capa'] . '" id="img_capa" class="img-fluid p-2 border rounded">
                                                        </div>
                                                        <div class="w-100">
                                                            <div class="mb-3">
                                                                <label for="titulo" class="form-label d-flex justify-content-between">
                                                                    Título:' .
                                            ($adicionais->listarAdicionais("gerar_titulo_ia") === 1 ? '
                                                                    <button type="button" class="btn btn-primary btn-sm waves-effect waves-light" id="generateTitleBtn" onclick="generateTitle()">
                                                                        <span id="loading-title" class="spinner-border spinner-border-sm me-2" role="status" style="display: none;"></span>
                                                                        Gerar com IA
                                                                    </button>' : '') . '
                                                                </label>
                                                                <input type="text" class="form-control" id="titulo" maxlength="60" name="titulo" value="' . htmlspecialchars(substr($produto['titulo'], 0, 60)) . '">
                                                            </div>

                                                            <div class="mb-3">
                                                                <label for="descricao" class="form-label d-flex justify-content-between">
                                                                    Descrição:' .
                                            ($adicionais->listarAdicionais("gerar_descricao_ia") === 1 ? '
                                                                    <button type="button" class="btn btn-primary btn-sm waves-effect waves-light" id="generateDescBtn" onclick="generateDesc()">
                                                                        <span id="loading-desc" class="spinner-border spinner-border-sm me-2" role="status" style="display: none;"></span>
                                                                        Gerar com IA
                                                                    </button>' : '') . '
                                                                </label>
                                                                <textarea class="form-control" id="descricao" name="descricao" rows="4">' . htmlspecialchars(base64_decode($produtojson['descricao'])) . '</textarea>
                                                            </div>

                                                            <!-- Preço de custo em destaque -->
                                                            <div class="mt-4 mb-3 d-flex flex-column text-start float-start">
                                                                <span class="h6 text-muted mb-0">Preço de Custo </span>
                                                                <span class="h6" id="display_custo">R$ 0,00</span>
                                                            </div>

                                                            <!-- Preço Mínimo -->
                                                            <div class="mt-4 mb-3 d-flex d-none flex-column text-start float-start ms-4">
                                                                <label for="preco_minimo" class="h6 text-muted mb-2">Preço Mínimo <i class="ti ti-info-circle" title="Se definido, o preço final não será menor que este valor"></i></label>
                                                                <input type="number" step="0.01" min="0" class="form-control" id="preco_minimo" name="preco_minimo" value="' . htmlspecialchars($produto['preco_minimo'] ?? '0') . '" placeholder="0.00" style="max-width: 150px;">
                                                                <small class="text-muted mt-1" id="preco_minimo_status">Digite um valor para ativar</small>
                                                            </div>

                                                            <div class="d-flex flex-row gap-2">
                                                                <div class="mt-3 mb-3 w-100 d-none">
                                                                    <label for="margem_lucro" class="form-label d-flex justify-content-between">Margem de lucro (%):</label>
                                                                    <input type="number" class="form-control" id="margem_lucro" min="0" name="margem_lucro">
                                                                    
                                                                    <!-- Checkbox para margem individual -->
                                                                    <div class="form-check2 mt-2">
                                                                        <input class="form-check-input" type="checkbox" checked disabled id="margem_individual">
                                                                        <label class="form-check-label small text-muted" for="margem_individual">
                                                                            Margem individual por loja
                                                                        </label>
                                                                    </div>
                                                                </div>

                                                            </div>

                                                            <input type="hidden" class="form-control" id="marketplace" name="marketplace">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-4 mt-4 mt-md-0">
                                                <div class="card ' . ($produto['sensivel'] == 1 ? 'border-danger' : '') . ' h-100 border shadow rounded">
                                                    <div class="card-body d-flex flex-column">
                                                        <h3 class="modal-title text-center mb-2 fs-5" id="modalComposicaoVenda"><i class="ti ti-calculator me-2"></i>Calculo do valor sugerido</h3>
                                                        <div class="card p-3 mb-2">
                                                            <div class="d-flex align-items-center">
                                                                <div class="badge bg-primary me-2">1</div>
                                                                <h6 class="mb-0">Custo base</h6>
                                                            </div>
                                                            <small class="text-muted mt-1">Preço de custo + Taxas + Frete + Impostos</small>
                                                            <div class="input-group mt-2">
                                                                <span class="input-group-text bg-primary text-white"><i class="ti ti-math-equal"></i></span>
                                                                <input readonly class="form-control bg-white" disabled id="CustoTaxaImposto" type="text">
                                                            </div>
                                                        </div>
                                                        <div class="card p-3 mb-2">
                                                            <div class="d-flex align-items-center">
                                                                <div class="badge bg-success me-2">2</div>
                                                                <h6 class="mb-0">Margem de lucro</h6>
                                                            </div>
                                                            <small class="text-muted mt-1">Porcentagem aplicada sobre o custo</small>
                                                            <div class="input-group mt-2">
                                                                <span class="input-group-text bg-success text-white"><i class="ti ti-percentage"></i></span>
                                                                <input readonly class="form-control bg-white" disabled id="MargemLucroInfo" type="text">
                                                            </div>
                                                        </div>
                                                        <div class="card p-3">
                                                            <div class="d-flex align-items-center">
                                                                <div class="badge bg-danger me-2">3</div>
                                                                <h6 class="mb-0">Preço final</h6>
                                                            </div>
                                                            <small class="text-muted mt-1">Valor ajustado para garantir seu lucro após comissões</small>
                                                            <div class="bg-white p-2 rounded mt-2 text-center">
                                                                <small><b>Preço = Valor Necessário ÷ (1 - Comissão)</b></small>
                                                            </div>
                                                            <div class="input-group mt-2">
                                                                <span class="input-group-text bg-danger text-white"><i class="ti ti-equal"></i></span>
                                                                <input readonly class="form-control bg-white" disabled id="CalcFinal" type="text">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                       

                                    ';

                                        $peso = $produto['peso'];
                                        $altura = $produto['altura'];
                                        $largura = $produto['largura'];
                                        $ncm = $produto['ncm'];
                                        $comprimento = $produto['comprimento'];
                                        $pesoValor = explode(" ", $peso)[0] ?? 1;

                                        //hidden inputs
                                        echo '
                                        <div class="d-none">
                                            <div class="col-md-6 mb-3">
                                                <label for="peso" class="form-label">Peso:</label>
                                                <input type="text" class="form-control" value="' . $pesoValor . '" id="peso" name="peso">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="ncm" class="form-label">ncm:</label>
                                                <input type="text" class="form-control" value="' . $ncm . '" id="ncm" name="ncm">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="altura" class="form-label">altura:</label>
                                                <input type="text" class="form-control" value="' . $altura . '" id="altura" name="altura">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="largura" class="form-label">largura:</label>
                                                <input type="text" class="form-control" value="' . $largura . '" id="largura" name="largura">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="comprimento" class="form-label">comprimento:</label>
                                                <input type="text" class="form-control" value="' . $comprimento . '" id="comprimento" name="comprimento">
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="plataforma" class="form-label">Plataforma:</label>
                                                <input type="text" class="form-control" id="plataforma" name="plataforma">
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="sku" class="form-label">SKU:</label>
                                                <input type="text" class="form-control" id="sku" name="sku" value="' . htmlspecialchars($produto['sku']) . '">
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="categoria_ml" class="form-label">categoria_ml:</label>
                                                <input type="text" class="form-control" id="categoria_ml" name="categoria_ml" value="' . htmlspecialchars($produto['categoria_ml']) . '">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="category_domain" class="form-label">category_domain:</label>
                                                <input type="text" class="form-control" id="category_domain" name="category_domain" value="' . htmlspecialchars($produto['category_domain']) . '">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="id_cat_ml" class="form-label">id_cat_ml:</label>
                                                <input type="text" class="form-control" id="id_cat_ml" name="id_cat_ml" value="' . htmlspecialchars($produto['id_cat_ml']) . '">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="categoria_shopee" class="form-label">categoria_shopee:</label>
                                                <input type="text" class="form-control" id="categoria_shopee" name="categoria_shopee" value="' . htmlspecialchars($produto['categoria_shopee']) . '">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="codigo_universal" class="form-label">Código Universal:</label>
                                                <input type="text" class="form-control" id="codigo_universal" name="codigo_universal" value="' . $produto['codigo_universal'] . '">
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="estoque" class="form-label">Estoque:</label>
                                                <input type="text" class="form-control" id="estoque" name="estoque" value="' . htmlspecialchars($produto['estoque']) . '">
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="preco_custo" class="form-label">Preço Custo:</label>
                                                <input type="text" class="form-control" id="preco_custo" name="preco_custo" value="' . htmlspecialchars($produto['preco_custo']) . '">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="preco_calc_base" class="form-label">Preço calc base:</label>
                                                <input type="text" class="form-control" id="preco_calc_base" name="preco_calc_base" value="0.00">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="preco_sugerido" class="form-label">Preço Sugerido:</label>
                                                <input type="text" class="form-control" id="preco_sugerido" name="preco_sugerido" value="0.00">
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="fornecedor_nome" class="form-label">Fornecedor:</label>
                                                <input type="text" class="form-control" id="fornecedor_nome" name="fornecedor_nome" value="' . htmlspecialchars($produto['fornecedor_nome']) . '">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="client_id" class="form-label">client_id:</label>
                                                <input type="text" class="form-control" id="client_id" name="client_id">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="client_secret" class="form-label">client_secret:</label>
                                                <input type="text" class="form-control" id="client_secret" name="client_secret">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="access_token" class="form-label">access_token:</label>
                                                <input type="text" class="form-control" id="access_token" name="access_token">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="refresh_token" class="form-label">refresh_token:</label>
                                                <input type="text" class="form-control" id="refresh_token" name="refresh_token">
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label for="imagem_capa" class="form-label">Imagem Capa:</label>';
                                        $imagemCapa = isset($produto['todas_imagens'][0]) ? $produto['todas_imagens'][0] : '';
                                        echo '<input type="text" class="form-control" id="imagem_capa" name="imagem_capa" value="' . htmlspecialchars($imagemCapa) . '">
                                            </div>
                                        </div>
                                    ';

                                        // Inputs para outras imagens
                                        if (!empty($produto['todas_imagens'])) {
                                            $imagens = $produto['todas_imagens']; // Pega o array inteiro diretamente
                                            echo '<div class="mb-3 d-none">';
                                            echo '<label>Imagens do Produto:</label>';
                                            foreach ($imagens as $imagem) {
                                                echo '<input type="text" class="form-control mb-2 imagem-url" name="imagens[]" value="' . htmlspecialchars(trim($imagem)) . '">';
                                            }
                                            echo '</div>';
                                        }

                                        echo '<div class="border ' . ($produto['sensivel'] == 1 ? 'border-danger' : '') . ' rounded shadow p-4 mt-3 mb-3">';
                                        echo '<div class="d-flex justify-content-between align-items-center mb-3">';
                                        echo '<h4 class="mt-3">Imagens do Produto</h4>';
                                        echo '<div class="d-flex gap-2">';
                                        echo '<button id="download-images-btn" type="button" class="btn btn-primary" data-produto-id="' . htmlspecialchars($produto['id']) . '" title="Baixar imagens"><i class="ti ti-download"></i></button>';
                                        echo '<button id="add-image-btn" type="button" class="btn btn-success">Adicionar Imagem</button>';
                                        echo '</div>';
                                        echo '</div>';

                                        echo '<div id="image-list" class="image-cad" style="display: flex; flex-wrap: wrap;">';

                                        if (!empty($produto['todas_imagens'][0])) {
                                            foreach ($imagens as $imagem) {
                                                echo '<div class="image-item d-flex flex-column gap-1" data-url="' . htmlspecialchars(trim($imagem)) . '">';


                                                // Container para a imagem com a sobreposição
                                                echo '<div class="image-container" style="position: relative; display: inline-block; max-width: 100px; max-height: 100px;">';
                                                echo '<img src="' . htmlspecialchars(trim($imagem)) . '" alt="Produto" class="img-fluid" style="max-width: 100px; max-height: 100px; border: 1px solid #ddd; border-radius: 4px;">';
                                                echo '<div class="overlay" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(255, 0, 0, 0.3); border-radius: 4px; display: none;"></div>';
                                                echo '</div>'; // Fecha o container da imagem

                                                // Botão de remoção
                                                echo '<button type="button" class="btn btn-danger btn-sm remove-image"><i class="ti ti-trash"></i> Remover</button>';
                                                echo '</div>'; // Fecha o item da imagem
                                            }
                                        } else {
                                            echo '<p>Sem imagem disponível</p>';
                                        }

                                        echo '</div>';
                                        echo '</div>';

                                        echo '<div class="border ' . ($have_filho == 0 ? 'd-none ' : '') . ($produto['sensivel'] == 1 ? 'border-danger' : 'border-primary') . ' card rounded shadow p-4 mt-3 mb-3">';
                                        echo '<div class="d-flex justify-content-between align-items-center mb-3">';
                                        echo '<h4 class="mt-3">Variações</h4>';
                                        echo '</div>';
                                        echo '<div class="card-body">';

                                        $sql_variacoes = "SELECT * FROM produtos WHERE produto_pai = :produto_id AND is_filho = 1";
                                        $stmt_variacoes = $pdo->prepare($sql_variacoes);
                                        $stmt_variacoes->bindParam(':produto_id', $produto['id'], PDO::PARAM_STR);
                                        $stmt_variacoes->execute();
                                        $variacoes = $stmt_variacoes->fetchAll(PDO::FETCH_ASSOC);

                                        if ($variacoes) {
                                            echo '<div class="row g-4" id="card-variacoes-lista">';
                                            foreach ($variacoes as $variacao) {
                                                $sql_img = "SELECT MIN(imagem_url) AS imagem_capa FROM drophub_global.produtos_imagens WHERE produto_id = :produto_id";
                                                $stmt_img = $pdo->prepare($sql_img);
                                                $stmt_img->execute([':produto_id' => $variacao['id']]);
                                                $imagem_capa = $stmt_img->fetchColumn();
                                                if (!$imagem_capa) {
                                                    $imagem_capa = '../../images/drophub_global.produtos_imagens/noimage.jpg';
                                                }

                                                if ($variacao['variacao_cor'] != null) {
                                                    $tipo_variacao = 'Cor';
                                                    $valor_variacao = $variacao['variacao_cor'];
                                                } else if ($variacao['variacao_tamanho'] != null) {
                                                    $tipo_variacao = 'Tamanho';
                                                    $valor_variacao = $variacao['variacao_tamanho'];
                                                } else {
                                                    $tipo_variacao = '';
                                                    $valor_variacao = '';
                                                }

                                                // Verificar se o estoque está baixo
                                                $estoque_variacao = (int)$variacao['estoque'];
                                                $estoque_baixo = $estoque_variacao <= 0;
                                                $disabled_checkbox = $estoque_baixo ? 'disabled' : '';
                                                $card_opacity = $estoque_baixo ? 'style="opacity: 0.6;"' : '';
                                                $aviso_estoque = $estoque_baixo ? '<small class="text-danger fw-bold">Estoque baixo (' . $estoque_variacao . ')</small>' : '<small class="text-success">Estoque: ' . $estoque_variacao . '</small>';

                                                echo '
                                                <div class="col-12 col-sm-6 col-md-2 col-lg-2">
                                                    <div class="card position-relative h-100 shadow-sm border-0" ' . $card_opacity . ' style="min-height: 220px;">
                                                        <div class="position-absolute top-0 start-0 p-2">
                                                            <input type="checkbox" class="form-check-input" name="variacoes_selecionadas[]" value="' . htmlspecialchars($variacao['id']) . '" ' . $disabled_checkbox . '>
                                                        </div>
                                                        <div class="card-body d-flex flex-column align-items-center justify-content-center pt-4">
                                                            <img src="' . htmlspecialchars($imagem_capa) . '" alt="Variação" class="mb-3" style="max-width: 110px; max-height: 110px; object-fit: contain;">
                                                            <div class="text-muted text-center" style="font-size: 1.1em;">
                                                                ' . ($tipo_variacao ? $tipo_variacao . ': ' : '') . htmlspecialchars($valor_variacao) . '
                                                            </div>
                                                            <div class="mt-2 text-center">
                                                                ' . $aviso_estoque . '
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                ';
                                            }
                                            echo '</div>';
                                        } else {
                                            echo '<p class="text-muted">Nenhuma variação cadastrada para este produto.</p>';
                                        }

                                        echo '</div>';
                                        echo '</div>';

                                        echo '<button class="btn float-end btn-primary btn-anunciar mt-3">Anunciar Produto</button>';

                                        echo '</form>';
                                    } else {
                                        echo '<p>Nenhum produto recebido.</p>';
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="content-backdrop fade"></div>
                </div>

                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <div class="layout-overlay layout-menu-toggle"></div>

        <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->

    <script>
        function logout() {
            Swal.fire({
                toast: true,
                position: "top-end",
                icon: 'success',
                title: 'Você se desconectou com sucesso! Até logo. ðŸ˜‰',
                showConfirmButton: false,
                timer: 2000,
            }).then(function() {
                window.location.href = '/logout';
            });
        }
    </script>

    <script src="../../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../../assets/vendor/libs/popper/popper.js"></script>
    <script src="../../assets/vendor/js/bootstrap.js"></script>
    <script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="../../assets/vendor/libs/hammer/hammer.js"></script>
    <script src="../../assets/vendor/libs/i18n/i18n.js"></script>
    <script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="../../assets/vendor/js/menu.js"></script>
    <script src="../../assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="../../assets/vendor/libs/swiper/swiper.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/dashboards-analytics.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/ui-modals.js"></script>
    <script src="../../assets/js/depositar_saldo.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.14.0/Sortable.min.js"></script>



    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Event listener for dynamically created select inputs
            document.addEventListener('change', function(event) {
                if (event.target.classList.contains('dynamic-select')) {
                    const selectedOption = event.target.options[event.target.selectedIndex];
                    const attributeId = event.target.getAttribute('data-attribute-id');
                    const valueId = selectedOption.value;
                    const originalName = selectedOption.getAttribute('data-original-name');
                    const valueUnit = selectedOption.getAttribute('data-unit');

                    // Check if hidden inputs already exist
                    let valueIdInput = document.querySelector(`input[name='hidden_value_id_${attributeId}']`);
                    let originalNameInput = document.querySelector(`input[name='hidden_original_name_${attributeId}']`);
                    let valueUnitInput = document.querySelector(`input[name='hidden_value_unit_${attributeId}']`);

                    if (!valueIdInput) {
                        valueIdInput = document.createElement('input');
                        valueIdInput.type = 'hidden';
                        valueIdInput.name = `hidden_value_id_${attributeId}`;
                        event.target.parentNode.appendChild(valueIdInput);
                    }

                    if (!originalNameInput) {
                        originalNameInput = document.createElement('input');
                        originalNameInput.type = 'hidden';
                        originalNameInput.name = `hidden_original_name_${attributeId}`;
                        event.target.parentNode.appendChild(originalNameInput);
                    }

                    if (!valueUnitInput) {
                        valueUnitInput = document.createElement('input');
                        valueUnitInput.type = 'hidden';
                        valueUnitInput.name = `hidden_value_unit_${attributeId}`;
                        event.target.parentNode.appendChild(valueUnitInput);
                    }

                    // Update hidden inputs with selected values
                    valueIdInput.value = valueId;
                    originalNameInput.value = originalName;
                    valueUnitInput.value = valueUnit || '';
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#vendas').DataTable({
                "language": {
                    "url": "https://cdn.datatables.net/plug-ins/1.10.25/i18n/Portuguese.json"
                },
                "paging": false,
                "responsive": true,
                "searching": false
            });
        });
    </script>


    <script>
        const maxImages = 9; // Número máximo de imagens permitidas
        const imageList = document.getElementById('image-list');
        const imagemCapaInput = document.getElementById('imagem_capa');
        const imgCapa = document.getElementById('img_capa');

        function atualizarInputs() {
            const imageItems = document.querySelectorAll('#image-list .image-item');
            const imagemUrls = [];

            // Captura as URLs na ordem atual
            imageItems.forEach((item, index) => {
                const url = item.getAttribute('data-url');
                imagemUrls.push(url);

                // Atualiza a imagem de capa apenas para a primeira imagem
                if (index === 0) {
                    imagemCapaInput.value = url;
                    imgCapa.src = url;
                }
            });

            // Limpa os inputs existentes
            const inputsExistentes = document.querySelectorAll('.imagem-url');
            inputsExistentes.forEach(input => input.remove());

            // Cria novos inputs na ordem correta
            imagemUrls.forEach(url => {
                const novoInput = document.createElement('input');
                novoInput.type = 'text';
                novoInput.name = 'imagens[]';
                novoInput.classList.add('form-control', 'mb-2', 'imagem-url', 'd-none');
                novoInput.value = url;
                novoInput.readOnly = true;

                // Adiciona cada novo input no final da lista
                imageList.parentNode.insertBefore(novoInput, imageList.nextSibling);
            });

            // Inverte a ordem dos inputs
            const novosInputs = document.querySelectorAll('.imagem-url');
            for (let i = novosInputs.length - 1; i >= 0; i--) {
                const input = novosInputs[i];
                imageList.parentNode.insertBefore(input, imageList);
            }
        }

        // Função para mover imagens
        function moverImagem(itemIndex, novoIndex) {
            const imageItems = document.querySelectorAll('#image-list .image-item');

            // Verifica se os índices estão válidos
            if (itemIndex < 0 || itemIndex >= imageItems.length || novoIndex < 0 || novoIndex >= imageItems.length) {
                return;
            }

            const itemToMove = imageItems[itemIndex];

            // Remove o item da posição original
            imageList.removeChild(itemToMove);
            // Insere o item na nova posição
            const targetPosition = novoIndex === imageItems.length ? null : imageItems[novoIndex];
            imageList.insertBefore(itemToMove, targetPosition);

            atualizarInputs(); // Atualiza os inputs após mover
        }

        Sortable.create(imageList, {
            animation: 150,
            ghostClass: 'sortable-ghost',
            onEnd: function() {
                atualizarInputs();
            }
        });

        // Função para remover uma imagem
        document.getElementById('image-list').addEventListener('click', function(e) {
            if (e.target.classList.contains('remove-image')) {
                e.preventDefault(); // Impede qualquer comportamento padrão do botão
                e.stopPropagation(); // Evita propagação do evento para elementos pais

                const imageItems = document.querySelectorAll('#image-list .image-item');

                if (imageItems.length > 1) {
                    const imageItem = e.target.closest('.image-item');
                    imageItem.remove();
                    atualizarInputs();
                } else {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Atenção',
                        text: 'Você deve manter pelo menos uma imagem.',
                        confirmButtonText: 'Entendido'
                    });
                }


            }
        });

        document.getElementById('add-image-btn').addEventListener('click', function() {
            const imageItems = document.querySelectorAll('#image-list .image-item');

            if (imageItems.length >= maxImages) {
                Swal.fire({
                    icon: 'error',
                    title: 'Limite de Imagens',
                    text: `Você pode adicionar no máximo ${maxImages} imagens.`,
                    confirmButtonText: 'Entendido'
                });
                return;
            }

            const fileInput = document.createElement('input');
            fileInput.type = 'file';
            fileInput.accept = 'image/*';

            fileInput.onchange = function(event) {
                const file = event.target.files[0];

                if (file) {
                    const formData = new FormData();
                    formData.append('image', file);

                    fetch('../../assets/ajax/upload_image.php', {
                            method: 'POST',
                            body: formData
                        })
                        .then(response => response.json())
                        .then(data => {
                            let imageUrl = '';
                            if (data.success && data.url) {
                                imageUrl = data.url;
                            } else if (data.status === 'success' && data.image_url) {
                                imageUrl = data.image_url;
                            }

                            if (imageUrl) {
                                imageUrl = imageUrl.replace(/\\/g, '/');

                                const newImageItem = document.createElement('div');
                                newImageItem.classList.add('image-item', 'd-flex', 'flex-column');
                                newImageItem.setAttribute('data-url', imageUrl);
                                newImageItem.style.marginRight = '10px';
                                newImageItem.style.marginBottom = '10px';

                                newImageItem.innerHTML = `
                                <img src="${imageUrl}" alt="Produto" style="max-width: 100px; max-height: 100px; border: 1px solid #ddd; border-radius: 4px;">
                                <button type="button" class="btn btn-danger btn-sm remove-image mt-1"><i class="ti ti-trash"></i> Remover</button>
                            `;

                                imageList.appendChild(newImageItem);
                                atualizarInputs();
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Erro ao enviar imagem',
                                    text: data.message || 'Ocorreu um erro ao enviar a imagem.',
                                    confirmButtonText: 'Entendido'
                                });
                            }
                        })
                        .catch(error => {
                            console.error('Erro ao enviar a imagem:', error);
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: 'Ocorreu um erro ao enviar a imagem.',
                                confirmButtonText: 'Entendido'
                            });
                        });
                }
            };

            fileInput.click();
        });

        // Evento para download das imagens
        document.addEventListener('DOMContentLoaded', function() {
            const downloadBtn = document.getElementById('download-images-btn');

            if (downloadBtn) {
                downloadBtn.addEventListener('click', function() {
                    const produtoId = this.getAttribute('data-produto-id');

                    if (!produtoId) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: 'ID do produto não encontrado.',
                            confirmButtonText: 'Entendido'
                        });
                        return;
                    }

                    // Mostra loading
                    Swal.fire({
                        title: 'Preparando download...',
                        text: 'Aguarde enquanto as imagens são preparadas',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });

                    // Faz requisição AJAX
                    fetch('../../assets/ajax/produtos/download_imagens.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            body: JSON.stringify({
                                produto_id: produtoId
                            })
                        })
                        .then(response => {
                            if (!response.ok) {
                                throw new Error('Erro ao processar requisição');
                            }
                            return response.blob();
                        })
                        .then(blob => {
                            Swal.close();

                            // Cria URL temporária para o blob
                            const url = window.URL.createObjectURL(blob);
                            const a = document.createElement('a');
                            a.href = url;
                            a.download = `produto_${produtoId}_imagens.zip`;
                            document.body.appendChild(a);
                            a.click();
                            window.URL.revokeObjectURL(url);
                            document.body.removeChild(a);

                            Swal.fire({
                                icon: 'success',
                                title: 'Download iniciado!',
                                text: 'As imagens estão sendo baixadas.',
                                timer: 2000,
                                showConfirmButton: false
                            });
                        })
                        .catch(error => {
                            console.error('Erro ao baixar imagens:', error);
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: 'Ocorreu um erro ao baixar as imagens.',
                                confirmButtonText: 'Entendido'
                            });
                        });
                });
            }
        });


        async function generateTitle() {
            const titleInput = document.getElementById('titulo');
            const loadingElement = document.getElementById('loading-title');
            const generateTitleBtn = document.getElementById('generateTitleBtn');

            if (loadingElement && generateTitleBtn) {
                loadingElement.style.display = 'inline-block';
                generateTitleBtn.disabled = true;
            }

            const generatedTitle = await getGeneratedText('title', titleInput.value);

            if (generatedTitle) {
                titleInput.value = generatedTitle;
            } else {
                console.log('Erro ao gerar o título.');
            }

            if (loadingElement && generateTitleBtn) {
                loadingElement.style.display = 'none';
                generateTitleBtn.disabled = false;
            }
        }

        async function generateDesc() {
            const descriptionInput = document.getElementById('descricao');
            const loadingElement = document.getElementById('loading-desc'); // Spinner dentro do botão "Gerar com IA"
            const generateDescBtn = document.getElementById('generateDescBtn'); // Botão "Gerar com IA"

            if (loadingElement && generateDescBtn) {
                loadingElement.style.display = 'inline-block'; // Exibe o loading
                generateDescBtn.disabled = true; // Desativa o botão
            }

            const generatedDesc = await getGeneratedText('description', descriptionInput.value);

            if (generatedDesc) {
                descriptionInput.value = generatedDesc;
            } else {
                console.log('Erro ao gerar a descrição.');
            }

            if (loadingElement && generateDescBtn) {
                loadingElement.style.display = 'none'; // Esconde o loading
                generateDescBtn.disabled = false; // Reativa o botão
            }
        }

        async function getGeneratedText(type, inputText) {
            try {
                const response = await fetch('../../assets/ajax/produtos/gerar_texto.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        type,
                        text: inputText
                    })
                });

                if (response.ok) {
                    const data = await response.json();
                    return data.generatedText;
                } else {
                    const errorResponse = await response.json();
                    console.error('Erro ao chamar a API:', errorResponse.error);
                    return null;
                }
            } catch (error) {
                console.error('Erro na requisição:', error);
                return null;
            }
        }


        function limitarTexto(texto, limite) {
            return texto.length > limite ? texto.substring(0, limite) + '...' : texto;
        }

        // Função de debounce para evitar cálculos excessivos durante a digitação
        function debounce(func, wait) {
            let timeout;
            return function executedFunction(...args) {
                const later = () => {
                    clearTimeout(timeout);
                    func(...args);
                };
                clearTimeout(timeout);
                timeout = setTimeout(later, wait);
            };
        }

        // Array para armazenar dados das lojas selecionadas (escopo global)
        let lojasSelecionadas = [];

        // Objeto para armazenar preços finais customizados por loja
        let precosCustomizados = {};

        // Função para gerenciar lojas selecionadas (escopo global)
        function gerenciarLojasSelecionadas() {
            const checkboxes = document.querySelectorAll('input[name="selectedCards[]"]:checked');
            lojasSelecionadas = [];

            checkboxes.forEach(checkbox => {
                const dadosLoja = JSON.parse(checkbox.value);
                lojasSelecionadas.push(dadosLoja);
            });

            if (lojasSelecionadas.length > 0) {
                exibirLojasSelecionadas();
                // Usa a primeira loja como referência para os cálculos iniciais
                exibirLojaSelecionada(lojasSelecionadas[0]);
            } else {
                document.getElementById('produto-form').classList.add('d-none');
                const container = document.getElementById('lojas-selecionadas-container');
                if (container) {
                    container.innerHTML = '';
                }
            }
        }

        // Função para exibir resumo das lojas selecionadas (escopo global)
        function exibirLojasSelecionadas() {
            if (lojasSelecionadas.length === 0) {
                // Remove containers de lojas se existirem
                const containerLojas = document.getElementById('lojas-selecionadas-container');
                if (containerLojas) {
                    containerLojas.remove();
                }
                return;
            }

            // Se há lojas selecionadas, cria ou atualiza o container
            let container = document.getElementById('lojas-selecionadas-container');

            if (!container) {
                container = document.createElement('div');
                container.id = 'lojas-selecionadas-container';
                container.className = 'col-md-4 mt-4 mt-md-0';

                // Substitui a seção "Cálculo do valor sugerido"
                const calculoSection = document.querySelector('.col-md-4.mt-4.mt-md-0');
                if (calculoSection) {
                    calculoSection.parentElement.insertBefore(container, calculoSection);
                    calculoSection.style.display = 'none';
                } else {
                    // Fallback: adiciona após o cardsContainer se não encontrar a seção
                    const cardsContainer = document.getElementById('cardsContainer').parentElement;
                    cardsContainer.parentElement.insertBefore(container, cardsContainer.nextSibling);
                }
            }

            // Sempre considera margem individual como ativa (checkbox sempre marcado e desabilitado)
            const margemIndividual = true;
            const margemGlobal = parseFloat(document.getElementById('margem_lucro').value) || 0;

            let html = '';

            // Se tem mais de 1 loja, adiciona um card container
            if (lojasSelecionadas.length > 1) {
                html += '<div class="card h-100 border shadow rounded">';
                html += '<div class="card-body d-flex flex-column">';
                html += '<h5 class="text-center mb-3"><i class="ti ti-shopping-cart me-2"></i>Lojas Selecionadas (' + lojasSelecionadas.length + ')</h5>';
                html += '<div style="overflow-x: hidden; overflow-y: auto; max-height: 400px;">';
            } else {
                // Para uma única loja, usa o formato de card completo
                html += '<div class="card h-100 border shadow rounded">';
                html += '<div class="card-body d-flex flex-column">';
                html += '<h3 class="text-center mb-2 fs-5"><i class="ti ti-shopping-cart me-2"></i>Loja Selecionada</h3>';
            }

            html += '<div class="row">';

            lojasSelecionadas.forEach((loja, index) => {
                // Pega a margem específica da loja ou usa a global
                let margemLoja = margemGlobal;
                if (margemIndividual) {
                    const inputMargem = document.querySelector(`input[name="margem_lucro"][data-loja-id="${loja.seller_id_api_contas}"]`);
                    // Se já existe input renderizado, usa o valor dele, senão usa o percent_venda da loja
                    margemLoja = inputMargem ? parseFloat(inputMargem.value) || 0 : parseFloat(loja.percent_venda) || 0;
                }

                const precoCalculado = calcularPrecoParaLojaComMargem(loja, margemLoja);
                const precoCusto = parseFloat(document.getElementById('preco_custo').value) || 0;

                // Verifica se o preço foi customizado
                const precoCustomizado = precosCustomizados[loja.seller_id_api_contas] !== undefined;
                const badgeCustomizado = precoCustomizado ? '<span class="badge bg-warning text-dark ms-1" style="font-size: 0.65rem;">EDITADO</span>' : '';

                // Calcula os componentes do preço
                const taxaFormatada = parseFloat(loja.taxa) || 0;
                const freteFormatado = parseFloat(loja.frete) || 0;
                const impostoPercent = parseFloat(loja.percent_imposto) || 0;
                const comissaoPercent = parseFloat(loja.percent_com_mkp) || 0;

                // Calcula o lucro líquido real baseado no preço final
                // Lucro Líquido = Preço Final - Taxa MKT - Taxa Fixa - Impostos - Preço de Custo
                const taxaMKT = precoCalculado * (comissaoPercent / 100);
                const taxaFixaTotal = taxaFormatada + freteFormatado;
                const impostoValor = precoCusto * (impostoPercent / 100);
                const lucroValor = precoCalculado - taxaMKT - taxaFixaTotal - impostoValor - precoCusto;

                // Classe do card baseada na quantidade de lojas
                const cardClass = lojasSelecionadas.length === 1 ? 'col-12 mb-3' : 'col-12 mb-2';

                html += `
                    <div class="${cardClass}">
                        <div class="card border-success h-100">
                            <div class="card-body p-2">
                                <div class="d-flex align-items-center gap-2 mb-2">
                                    <img src="../../../assets/img/icons/brands/${loja.plataforma_api_contas}.png" height="20px" alt="Plataforma">
                                    <div>
                                        <strong class="d-block small">${limitarTexto(loja.nome_api_contas, 15)}</strong>
                                        <small class="text-muted">${loja.fornecedor}</small>
                                    </div>
                                </div>

                                <!-- Preço em destaque -->
                                <div class="row g-2 mb-2">
                                    <div class="col-6">
                                        <div class="text-center p-2 border rounded preco-final-editavel" 
                                             style="cursor: pointer; transition: all 0.2s;"
                                             data-loja-id="${loja.seller_id_api_contas}"
                                             data-loja-nome="${loja.nome_api_contas}"
                                             data-preco-calculado="${precoCalculado.toFixed(2)}"
                                             onmouseover="this.style.backgroundColor='#e3f2fd'; this.style.transform='scale(1.02)';"
                                             onmouseout="this.style.backgroundColor=''; this.style.transform='scale(1)';"
                                             title="Clique para editar o preço final">
                                            <small class="text-muted d-block">Preço final <i class="ti ti-edit" style="font-size: 0.8rem;"></i> ${badgeCustomizado}</small>
                                            <strong class="h6 text-success mb-0">R$ ${precoCalculado.toFixed(2)}</strong>
                                        </div>
                                    </div>

                                    <div class="col-6">
                                        <div class="text-center p-2 border rounded">
                                            <small class="text-muted d-block">Lucro Liquido</small>
                                            <strong class="h6 text-primary mb-0">R$ ${lucroValor.toFixed(2)}</strong>
                                        </div>
                                    </div>
                                </div>

                                <!-- Input de margem individual (se habilitado) -->
                                ${margemIndividual ? `
                                    <div class="mb-2">
                                        <label class="form-label small mb-1">Margem de lucro</label>
                                        <div class="input-group input-group-sm">
                                            <input type="number" class="form-control margem-loja-input" 
                                                   name="margem_lucro"
                                                   id="margem_loja_${loja.seller_id_api_contas}" 
                                                   value="${margemLoja}" 
                                                   step="0.01" min="0" max="100"
                                                   data-loja-id="${loja.seller_id_api_contas}">
                                            <span class="input-group-text">%</span>
                                        </div>
                                    </div>
                                ` : ''}
                                
                                <!-- Tipo de anúncio para Mercado Livre -->
                                ${(loja.plataforma_api_contas === 'MercadoLivre' || loja.plataforma_api_contas === 'mercado_livre') ? `
                                    <div class="mb-2">
                                        <label class="form-label small mb-1">Tipo de anúncio</label>
                                        <select class="form-control form-control-sm tipo-anuncio-loja" 
                                                name="tipo_anuncio"
                                                id="tipo_anuncio_loja_${loja.seller_id_api_contas}"
                                                data-loja-id="${loja.seller_id_api_contas}">
                                            <option value="gold_special">Clássico</option>
                                            <option value="gold_pro">Premium</option>
                                        </select>
                                    </div>
                                ` : ''}
                                
                                <!-- Detalhes resumidos -->
                                <div class="border-top pt-2 pb-3">
                                    <small class="text-muted mt-2 d-block mb-1"><strong>Composição das taxas</strong> - [Marketplace] :</small>
                                    <div class="row mt-2 g-1 small">
                                        <div class="col-6">Taxa Fixa:</div>
                                        <div class="col-6 text-end">R$ ${(taxaFormatada + freteFormatado).toFixed(2)}</div>
                                        
                                        <div class="col-6">Taxa MKT:</div>
                                        <div class="col-6 text-end">${comissaoPercent}%</div>
                                        
                                        <div class="col-6">Impostos:</div>
                                        <div class="col-6 text-end">${impostoPercent}%</div>
                                    </div>
                                    
                                    ${precoCustomizado ? `
                                        <div class="mt-2">
                                            <button type="button" class="btn btn-sm btn-outline-secondary w-100 btn-resetar-preco" 
                                                    data-loja-id="${loja.seller_id_api_contas}"
                                                    data-loja-nome="${loja.nome_api_contas}">
                                                <i class="ti ti-refresh me-1"></i>Resetar Preço
                                            </button>
                                        </div>
                                    ` : ''}

                                </div>
                            </div>
                        </div>
                    </div>
                `;
            });

            html += '</div>';

            // Fecha o card container se tem mais de 1 loja
            if (lojasSelecionadas.length > 1) {
                html += '</div>'; // fecha overflow-auto
                html += '</div>'; // fecha card-body
                html += '</div>'; // fecha card
            }

            container.innerHTML = html;

            // Gerencia a visibilidade do campo margem global
            gerenciarVisibilidadeMargemGlobal();

            // Adiciona event listeners para os novos elementos
            adicionarEventListenersLojas();
        }

        // Função para exibir dados da loja selecionada (escopo global)
        function exibirLojaSelecionada(conta) {
            const {
                nome_api_contas,
                percent_venda,
                percent_com_mkp,
                taxa,
                frete,
                percent_imposto,
                plataforma_api_contas,
                seller_id_api_contas,
                client_id,
                client_secret,
                access_token,
                refresh_token
            } = conta;

            // Mostra o formulário
            document.getElementById('produto-form').classList.remove('d-none');

            // Preenche os dados da loja de referência (primeira selecionada)
            document.getElementById('marketplace').value = plataforma_api_contas;
            document.getElementById('loja_selecionada').value = seller_id_api_contas;
            document.getElementById('margem_lucro').value = percent_venda;
            document.getElementById('client_id').value = client_id;
            document.getElementById('client_secret').value = client_secret;
            document.getElementById('access_token').value = access_token;
            document.getElementById('refresh_token').value = refresh_token;

            // Formatação mais amigável para o usuário
            var PrecoCusto = parseFloat(document.getElementById('preco_custo').value) || 0;
            var precoCustoFormatado = 'R$ ' + PrecoCusto.toFixed(2);
            var taxaFormatada = parseFloat(taxa) > 0 ? 'R$ ' + parseFloat(taxa).toFixed(2) : 'R$ 0.00';
            var freteFormatado = parseFloat(frete) > 0 ? 'R$ ' + parseFloat(frete).toFixed(2) : 'R$ 0.00';
            var impostoFormatado = parseFloat(percent_imposto) > 0 ? parseFloat(percent_imposto).toFixed(2) + '%' : '0%';
            var CustoTaxaImpostoCalc = `Preço de custo (${precoCustoFormatado}) + Taxa (${taxaFormatada}) + Frete (${freteFormatado}) + Imposto (${impostoFormatado})`;
            document.getElementById('CustoTaxaImposto').value = CustoTaxaImpostoCalc;

            const vlr_custo = parseFloat(document.getElementById('preco_custo').value) || 0;
            const percent_venda_dec = parseFloat(percent_venda) / 100;
            const percent_com_mkp_dec = parseFloat(percent_com_mkp) / 100;
            const percent_imposto_dec = parseFloat(percent_imposto) / 100;

            const precoBase = vlr_custo +
                (vlr_custo * percent_com_mkp_dec) +
                parseFloat(taxa) +
                parseFloat(frete) +
                (vlr_custo * percent_imposto_dec);

            document.getElementById('preco_calc_base').value = precoBase.toFixed(2);
            margem_lucro();

            verificaPlataforma(plataforma_api_contas);
        }

        // Função para verificar a plataforma e mostrar/ocultar campos específicos (escopo global)
        function verificaPlataforma(plataforma_api_contas) {
            const plataforma = document.getElementById('marketplace');
            plataforma.value = plataforma_api_contas;

            const tipoAnuncio = document.getElementById('tipoAnuncio');
            if (plataforma_api_contas === 'MercadoLivre' || plataforma_api_contas === 'mercado_livre') {
                tipoAnuncio.classList.remove('d-none');
            } else {
                tipoAnuncio.classList.add('d-none');
            }
        }

        // Função para calcular preço específico para uma loja (escopo global)
        function calcularPrecoParaLoja(loja) {
            const precoCusto = parseFloat(document.getElementById('preco_custo').value) || 0;
            const margem = parseFloat(document.getElementById('margem_lucro').value) || 0;

            // Aplicação da nova fórmula
            const taxaMarketplace = parseFloat(loja.percent_com_mkp) / 100;
            const taxaFixa = parseFloat(loja.taxa) || 0;
            const freteValor = parseFloat(loja.frete) || 0;
            const impostoPercent = parseFloat(loja.percent_imposto) / 100;

            // Passo 1: Lucro líquido
            const lucroLiquido = precoCusto * (margem / 100);

            // Passo 2: Imposto sobre o custo
            const impostoValor = precoCusto * impostoPercent;

            // Passo 3: Recebimento necessário
            const recebimentoNecessario = precoCusto + lucroLiquido + impostoValor;

            // Passo 4: Preço base
            const taxaFixaTotal = taxaFixa + freteValor;
            const precoBase = (recebimentoNecessario + taxaFixaTotal) / (1 - taxaMarketplace);

            // Passo 5: Regra do adicional de R$25
            let precoVenda;

            // Adicional de R$25 apenas para Mercado Livre
            if (loja.plataforma_api_contas === 'MercadoLivre' || loja.plataforma_api_contas === 'mercado_livre') {
                if (precoBase > 79) {
                    precoVenda = precoBase + 25;
                } else {
                    precoVenda = precoBase;
                }
            } else {
                precoVenda = precoBase;
            }

            // Validação do preço mínimo
            const precoMinimo = parseFloat(document.getElementById('preco_minimo')?.value) || 0;
            if (precoMinimo > 0 && precoVenda < precoMinimo) {
                console.log(`[calcularPrecoParaLoja] Loja: ${loja.nome_api_contas}, Preço ajustado de R$ ${precoVenda.toFixed(2)} para o mínimo de R$ ${precoMinimo.toFixed(2)}`);
                precoVenda = precoMinimo;
            }

            return precoVenda;
        }

        // Função para calcular preço com margem específica por loja
        function calcularPrecoParaLojaComMargem(loja, margemEspecifica) {
            // Verifica se existe preço customizado para esta loja
            if (precosCustomizados[loja.seller_id_api_contas]) {
                return precosCustomizados[loja.seller_id_api_contas];
            }

            const precoCusto = parseFloat(document.getElementById('preco_custo').value) || 0;

            // Aplicação da nova fórmula
            const taxaMarketplace = parseFloat(loja.percent_com_mkp) / 100;
            const taxaFixa = parseFloat(loja.taxa) || 0;
            const freteValor = parseFloat(loja.frete) || 0;
            const impostoPercent = parseFloat(loja.percent_imposto) / 100;

            // Passo 1: Lucro líquido
            const lucroLiquido = precoCusto * (margemEspecifica / 100);

            // Passo 2: Imposto sobre o custo
            const impostoValor = precoCusto * impostoPercent;

            // Passo 3: Recebimento necessário
            const recebimentoNecessario = precoCusto + lucroLiquido + impostoValor;

            // Passo 4: Preço base
            const taxaFixaTotal = taxaFixa + freteValor;
            const precoBase = (recebimentoNecessario + taxaFixaTotal) / (1 - taxaMarketplace);

            // Passo 5: Regra do adicional de R$25
            let precoVenda;
            if (precoBase > 79) {
                precoVenda = precoBase + 25;
            } else {
                precoVenda = precoBase;
            }

            // Validação do preço mínimo
            const precoMinimo = parseFloat(document.getElementById('preco_minimo')?.value) || 0;
            if (precoMinimo > 0 && precoVenda < precoMinimo) {
                console.log(`[calcularPrecoParaLojaComMargem] Loja: ${loja.nome_api_contas}, Margem: ${margemEspecifica}%, Preço ajustado de R$ ${precoVenda.toFixed(2)} para o mínimo de R$ ${precoMinimo.toFixed(2)}`);
                precoVenda = precoMinimo;
            }

            return precoVenda;
        }

        // Função para gerenciar visibilidade do campo margem global
        function gerenciarVisibilidadeMargemGlobal() {
            // Sempre considera margem individual ativa (checkbox sempre marcado e desabilitado)
            const margemIndividual = true;
            const campoMargemGlobal = document.getElementById('margem_lucro');

            // Sempre esconde o input global já que margem individual está sempre ativa
            campoMargemGlobal.style.display = 'none';
            // Sempre habilita inputs de margem individual nas lojas
            document.querySelectorAll('input[name="margem_lucro"][data-loja-id]').forEach(input => {
                input.disabled = false;
            });
        }

        // Função para adicionar event listeners às lojas
        function adicionarEventListenersLojas() {
            // Event listener para o checkbox de margem individual removido
            // pois o checkbox está sempre marcado e desabilitado

            // Event listeners para os inputs de margem individual com debounce melhorado
            const inputsMargem = document.querySelectorAll('.margem-loja-input');
            const exibirLojasDebounced = debounce(exibirLojasSelecionadas, 500); // 500ms de delay para inputs das lojas

            inputsMargem.forEach(input => {
                // Remove event listeners anteriores para evitar duplicação
                input.removeEventListener('input', exibirLojasDebounced);

                // Adiciona novo event listener com debounce
                input.addEventListener('input', function() {
                    // Impede valores negativos
                    if (parseFloat(this.value) < 0) {
                        this.value = 0;
                    }

                    // Remove preço customizado ao alterar margem de lucro
                    const lojaId = this.dataset.lojaId;
                    if (lojaId && precosCustomizados[lojaId]) {
                        delete precosCustomizados[lojaId];
                        console.log(`🔄 Preço customizado removido para loja ${lojaId} - margem alterada`);
                    }

                    // Recalcula as lojas com debounce
                    exibirLojasDebounced();
                });

                // Adiciona validação no evento blur (quando perde o foco)
                input.addEventListener('blur', function() {
                    if (this.value === '' || parseFloat(this.value) < 0) {
                        this.value = 0;
                    }
                });
            });

            // Event listeners para os selects de tipo de anúncio
            const selectsTipoAnuncio = document.querySelectorAll('.tipo-anuncio-loja');
            const tipoAnuncioGlobal = document.getElementById('tipo_anuncio');
            const valorGlobal = tipoAnuncioGlobal ? tipoAnuncioGlobal.value : 'gold_special';

            selectsTipoAnuncio.forEach(select => {
                // Define o valor inicial baseado no global
                select.value = valorGlobal;

                select.addEventListener('change', function() {
                    // Atualiza o valor do tipo de anúncio global se necessário
                    if (tipoAnuncioGlobal) {
                        tipoAnuncioGlobal.value = this.value;
                    }
                });
            });
        }

        // Função para atualizar o status das lojas após anúncio (escopo global)
        function atualizarStatusLojas(resultados) {
            let container;

            // Se só tem 1 loja, usa o container separado
            if (lojasSelecionadas.length === 1) {
                container = document.getElementById('lojas-selecionadas-container');
            } else if (lojasSelecionadas.length > 1) {
                // Se tem mais de 1 loja, usa o container junto ao produto
                container = document.getElementById('lojas-multiplas-container');
            }

            if (!container) return;

            // Sempre considera margem individual como ativa (checkbox sempre marcado e desabilitado)
            const margemIndividual = true;
            const margemGlobal = parseFloat(document.getElementById('margem_lucro').value) || 0;

            let html = '';

            // Se tem mais de 1 loja, adiciona um card container
            if (lojasSelecionadas.length > 1) {
                html += '<div class="card h-100 border shadow rounded">';
                html += '<div class="card-body d-flex flex-column">';
                html += '<h5 class="text-center mb-3"><i class="ti ti-shopping-cart me-2"></i>Lojas Selecionadas (' + lojasSelecionadas.length + ')</h5>';
                html += '<div class="overflow-auto" style="max-height: 600px;">';
            } else {
                html += '<h5><i class="ti ti-shopping-cart me-2"></i>Loja Selecionada</h5>';
            }

            html += '<div class="row">';

            lojasSelecionadas.forEach((loja, index) => {
                // Pega a margem específica da loja ou usa a global
                let margemLoja = margemGlobal;
                if (margemIndividual) {
                    const inputMargem = document.querySelector(`input[name="margem_lucro"][data-loja-id="${loja.seller_id_api_contas}"]`);
                    margemLoja = inputMargem ? parseFloat(inputMargem.value) || 0 : 0;
                }

                const precoCalculado = calcularPrecoParaLojaComMargem(loja, margemLoja);
                const resultado = resultados.find(r => r.loja === loja.nome_api_contas);

                let statusClass = 'border-success';
                let statusIcon = '';
                let statusBg = '';
                let permalinkButton = '';

                if (resultado) {
                    if (resultado.success) {
                        statusClass = 'border-success';
                        statusBg = 'bg-success bg-opacity-10';
                        statusIcon = '<i class="ti ti-check text-success"></i>';
                        if (resultado.permalink) {
                            permalinkButton = `<div class="mt-2">
                                <a href="${resultado.permalink}" target="_blank" class="btn btn-sm btn-outline-primary w-100">
                                    <i class="ti ti-external-link"></i> Ver Anúncio
                                </a>
                            </div>`;
                        }
                    } else {
                        statusClass = 'border-danger';
                        statusBg = 'bg-danger bg-opacity-10';
                        statusIcon = '<i class="ti ti-x text-danger"></i>';
                    }
                }

                const precoCusto = parseFloat(document.getElementById('preco_custo').value) || 0;
                const taxaFormatada = parseFloat(loja.taxa) || 0;
                const freteFormatado = parseFloat(loja.frete) || 0;
                const impostoPercent = parseFloat(loja.percent_imposto) || 0;
                const comissaoPercent = parseFloat(loja.percent_com_mkp) || 0;

                // Calcula o lucro líquido real baseado no preço final
                // Lucro Líquido = Preço Final - Taxa MKT - Taxa Fixa - Impostos - Preço de Custo
                const taxaMKT = precoCalculado * (comissaoPercent / 100);
                const taxaFixaTotal = taxaFormatada + freteFormatado;
                const impostoValor = precoCusto * (impostoPercent / 100);
                const lucroValor = precoCalculado - taxaMKT - taxaFixaTotal - impostoValor - precoCusto;

                // Classe do card baseada na quantidade de lojas
                const cardClass = lojasSelecionadas.length === 1 ? 'col-md-4 mb-3' : 'col-12 mb-2';

                html += `
                    <div class="${cardClass}">
                        <div class="card ${statusClass} h-100">
                            <div class="card-body p-2 ${statusBg}">
                                <div class="d-flex align-items-center gap-2 mb-2">
                                    ${statusIcon}
                                    <img src="../../../assets/img/icons/brands/${loja.plataforma_api_contas}.png" height="20px" alt="Plataforma">
                                    <div>
                                        <strong class="d-block small">${limitarTexto(loja.nome_api_contas, 15)}</strong>
                                        <small class="text-muted">${loja.fornecedor}</small>
                                    </div>
                                </div>

                                <!-- Preço de custo abaixo da descrição -->
                                <h6 class="text-dark mb-2">Custo: R$ ${precoCusto.toFixed(2)}</h6>
                                
                                <!-- Preço em destaque -->
                                <div class="row g-2 mb-2">
                                    <div class="col-6">
                                        <div class="text-center p-2 bg-white bg-opacity-75 rounded preco-final-editavel" 
                                             style="cursor: pointer; transition: all 0.2s;"
                                             data-loja-id="${loja.seller_id_api_contas}"
                                             data-loja-nome="${loja.nome_api_contas}"
                                             data-preco-calculado="${precoCalculado.toFixed(2)}"
                                             onmouseover="this.style.backgroundColor='#e3f2fd'; this.style.transform='scale(1.02)';"
                                             onmouseout="this.style.backgroundColor='rgba(255,255,255,0.75)'; this.style.transform='scale(1)';"
                                             title="Clique para editar o preço final">
                                            <small class="text-muted d-block">Preço final <i class="ti ti-edit" style="font-size: 0.8rem;"></i></small>
                                            <strong class="h6 text-success mb-0">R$ ${precoCalculado.toFixed(2)}</strong>
                                        </div>
                                    </div>

                                    <div class="col-6">
                                        <div class="text-center p-2 bg-white bg-opacity-75 rounded">
                                            <small class="text-muted d-block">Lucro Liquido</small>
                                            <strong class="h6 text-primary mb-0">R$ ${lucroValor.toFixed(2)}</strong>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Input de margem individual (se habilitado) -->
                                ${margemIndividual ? `
                                    <div class="mb-2">
                                        <label class="form-label small mb-1">Margem de lucro</label>
                                        <div class="input-group input-group-sm">
                                            <input type="number" class="form-control margem-loja-input" 
                                                   name="margem_lucro"
                                                   id="margem_loja_${loja.seller_id_api_contas}" 
                                                   value="${margemLoja}" 
                                                   step="0.01" min="0" max="100"
                                                   data-loja-id="${loja.seller_id_api_contas}"
                                                   disabled>
                                            <span class="input-group-text">%</span>
                                        </div>
                                    </div>
                                ` : ''}
                                
                                <!-- Detalhes resumidos -->
                                <div class="border-top pt-2">
                                    <small class="text-muted d-block mb-1"><strong>Composição das taxas:</strong></small>
                                    <div class="row g-1 small">
                                        <div class="col-6">Lucro (${margemLoja}%):</div>
                                        <div class="col-6 text-end">R$ ${lucroValor.toFixed(2)}</div>
                                        
                                        <div class="col-6">Taxa + Frete:</div>
                                        <div class="col-6 text-end">R$ ${(taxaFormatada + freteFormatado).toFixed(2)}</div>
                                        
                                        <div class="col-6">Comissão:</div>
                                        <div class="col-6 text-end">${comissaoPercent}%</div>
                                        
                                        <div class="col-6">Impostos:</div>
                                        <div class="col-6 text-end">${impostoPercent}%</div>
                                    </div>
                                </div>
                                
                                ${permalinkButton}
                            </div>
                        </div>
                    </div>
                `;
            });

            html += '</div>';

            // Fecha o card container se tem mais de 1 loja
            if (lojasSelecionadas.length > 1) {
                html += '</div>'; // fecha overflow-auto
                html += '</div>'; // fecha card-body
                html += '</div>'; // fecha card
            }

            container.innerHTML = html;

            // Gerencia a visibilidade do campo margem global
            gerenciarVisibilidadeMargemGlobal();

            // Adiciona event listeners para os novos elementos
            adicionarEventListenersLojas();
        }

        document.addEventListener('DOMContentLoaded', function() {
            console.log('=== Página Cadastrar Produtos Carregada ===');

            // Verifica o valor do preço mínimo carregado
            const precoMinimoField = document.getElementById('preco_minimo');
            if (precoMinimoField) {
                console.log('Preço Mínimo carregado do banco:', precoMinimoField.value);

                // Se houver um preço mínimo definido, atualiza o status
                if (parseFloat(precoMinimoField.value) > 0) {
                    const statusElement = document.getElementById('preco_minimo_status');
                    if (statusElement) {
                        statusElement.innerHTML = '<span class="text-info">✓ Validação ativa (R$ ' + parseFloat(precoMinimoField.value).toFixed(2) + ')</span>';
                    }
                }
            }

            // Adiciona event listeners aos checkboxes das lojas (gerados pelo PHP)
            document.querySelectorAll('.loja-checkbox').forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    gerenciarLojasSelecionadas();
                });
            });

            // Adiciona validação para o campo margem_lucro global (oculto)
            const margemLucroGlobal = document.getElementById('margem_lucro');
            if (margemLucroGlobal) {
                margemLucroGlobal.addEventListener('input', function() {
                    if (parseFloat(this.value) < 0) {
                        this.value = 0;
                    }
                });

                margemLucroGlobal.addEventListener('blur', function() {
                    if (this.value === '' || parseFloat(this.value) < 0) {
                        this.value = 0;
                    }
                });
            }
        });



        function margem_lucro() {
            console.log('=== margem_lucro() chamada ===');

            /**
             * Cálculo do preço de venda baseado na fórmula matemática correta:
             * 
             * Passo 1: Lucro = Custo × Margem%
             * Passo 2: Recebimento necessário = Custo + Lucro + Impostos
             * Passo 3: Preço base = (Recebimento necessário + Taxa fixa) ÷ (1 - Taxa%)
             * Passo 4: Se Preço base > 79, então Preço final = Preço base + 25
             */

            // ===== OBTENÇÃO DOS VALORES BÁSICOS =====
            var precoCusto = parseFloat(document.getElementById('preco_custo').value) || 0; // C
            var margem = parseFloat(document.getElementById('margem_lucro').value) || 0; // L% em porcentagem

            console.log('Preço Custo:', precoCusto, 'Margem:', margem);

            // ===== OBTÉM OS DADOS DA LOJA/MARKETPLACE SELECIONADA =====
            var marketplace = document.getElementById('marketplace').value;
            var lojaInfo = document.querySelector('input[name="selectedCards[]"]:checked');

            console.log('Marketplace:', marketplace, 'Loja Info:', lojaInfo);

            // Verifica se há uma loja selecionada antes de prosseguir
            if (lojaInfo) {
                var dadosLoja = JSON.parse(lojaInfo.value);

                // Valores das configurações de taxas
                var taxaMarketplace = parseFloat(dadosLoja.percent_com_mkp) / 100; // TM% (comissão)
                var taxaFixa = parseFloat(dadosLoja.taxa) || 0; // TMfixo (taxa fixa)
                var freteValor = parseFloat(dadosLoja.frete) || 0; // Frete
                var impostoPercent = parseFloat(dadosLoja.percent_imposto) / 100; // Imposto em %

                // ===== PASSO 1: CÁLCULO DO LUCRO LÍQUIDO DESEJADO =====
                var lucroLiquido = precoCusto * (margem / 100); // Lucro = C × L%

                // ===== PASSO 2: CÁLCULO DOS IMPOSTOS EM VALOR =====
                // Imposto calculado sobre o custo (pode ser ajustado conforme necessário)
                var impostoValor = precoCusto * impostoPercent; // Imp

                // ===== PASSO 3: RECEBIMENTO NECESSÁRIO =====
                var recebimentoNecessario = precoCusto + lucroLiquido + impostoValor; // C + Lucro + Imp

                // ===== PASSO 4: PREÇO BASE (CONSIDERANDO TAXA DO MARKETPLACE) =====
                // Inclui frete na taxa fixa total
                var taxaFixaTotal = taxaFixa + freteValor;
                var precoBase = (recebimentoNecessario + taxaFixaTotal) / (1 - taxaMarketplace);

                // ===== PASSO 5: REGRA DO ADICIONAL DE R$25 =====
                var precoVenda;
                if (precoBase > 79) {
                    precoVenda = precoBase + 25;
                } else {
                    precoVenda = precoBase;
                }

                // ===== VALIDAÇÃO DO PREÇO MÍNIMO =====
                var precoMinimo = parseFloat(document.getElementById('preco_minimo')?.value) || 0;
                var precoAntesMinimo = precoVenda; // Guarda o valor antes de aplicar o mínimo
                var statusElement = document.getElementById('preco_minimo_status');

                console.log('Validando Preço Mínimo - Preço Calculado:', precoVenda.toFixed(2), 'Preço Mínimo:', precoMinimo);

                if (precoMinimo > 0 && precoVenda < precoMinimo) {
                    precoVenda = precoMinimo;
                    console.log(`✅ PREÇO AJUSTADO! De R$ ${precoAntesMinimo.toFixed(2)} para R$ ${precoMinimo.toFixed(2)}`);
                    if (statusElement) {
                        statusElement.innerHTML = '<span class="text-success">✓ Preço ajustado para mínimo</span>';
                    }
                } else if (precoMinimo > 0) {
                    console.log('✓ Preço OK - Não precisa ajustar');
                    if (statusElement) {
                        statusElement.innerHTML = '<span class="text-info">✓ Validação ativa</span>';
                    }
                } else {
                    if (statusElement) {
                        statusElement.innerHTML = '<span class="text-muted">Digite um valor para ativar</span>';
                    }
                }

                // ===== CÁLCULO DO PREÇO SEM MARGEM (PARA REFERÊNCIA) =====
                var recebimentoSemMargem = precoCusto + impostoValor;
                var precoOriginal = (recebimentoSemMargem + taxaFixaTotal) / (1 - taxaMarketplace);
                if (precoOriginal > 79) {
                    precoOriginal = precoOriginal + 25;
                }

                // Valida preço mínimo também para o preço original
                var precoOriginalAntesMinimo = precoOriginal; // Guarda o valor antes de aplicar o mínimo
                if (precoMinimo > 0 && precoOriginal < precoMinimo) {
                    precoOriginal = precoMinimo;
                    console.log(`Preço original ajustado de R$ ${precoOriginalAntesMinimo.toFixed(2)} para o mínimo de R$ ${precoMinimo.toFixed(2)}`);
                }

                // ===== ATUALIZAÇÃO DOS CAMPOS DE INTERFACE =====
                // Atualiza as informações de composição do preço
                document.getElementById('MargemLucroInfo').value = margem + '%';

                // Formatação da fórmula para mostrar o cálculo correto
                var custoFormatado = 'R$ ' + precoCusto.toFixed(2);
                var lucroFormatado = 'R$ ' + lucroLiquido.toFixed(2);
                var impostoFormatado = 'R$ ' + impostoValor.toFixed(2);
                var recebimentoFormatado = 'R$ ' + recebimentoNecessario.toFixed(2);
                var taxaFixaFormatada = 'R$ ' + taxaFixaTotal.toFixed(2);
                var taxaMarketplaceFormatada = (taxaMarketplace * 100).toFixed(2) + '%';
                var precoBaseFormatado = 'R$ ' + precoBase.toFixed(2);
                var adicionalFormatado = precoBase > 79 ? ' + R$ 25.00' : '';

                var formulaFinal = `(${custoFormatado} + ${lucroFormatado} + ${impostoFormatado} + ${taxaFixaFormatada}) ÷ (1 - ${taxaMarketplaceFormatada})${adicionalFormatado} = R$ ${precoVenda.toFixed(2)}`;
                document.getElementById('CalcFinal').value = formulaFinal;

                // Seleciona os elementos para exibir o preço sugerido
                var precoSugeridoInput = document.getElementById('preco_sugerido');
                var precoSugeridoLabel = document.getElementById('preco_sugerido_label');
                // var lucroLiquidoLabel = document.getElementById('lucro_liquido_label');
                var labelMargem = document.getElementById('new_margem_lucro');

                // Se a margem estiver preenchida e for maior que zero
                if (!isNaN(margem) && margem > 0) {
                    // Usa o preço calculado com base na nova fórmula
                    precoSugeridoInput.value = precoVenda.toFixed(2);
                    precoSugeridoLabel.innerHTML = precoVenda.toFixed(2);
                    // lucroLiquidoLabel.innerHTML = lucroLiquido.toFixed(2);
                    labelMargem.value = margem;
                } else {
                    // Se não houver margem definida, mantém o preço original
                    precoSugeridoInput.value = precoOriginal.toFixed(2);
                    precoSugeridoLabel.innerHTML = precoOriginal.toFixed(2);
                    // lucroLiquidoLabel.innerHTML = "0.00";
                }

                // Atualiza a exibição das lojas selecionadas com novos preços
                if (typeof exibirLojasSelecionadas === 'function') {
                    exibirLojasSelecionadas();
                }
            }
        }

        // Função para atualizar o display do custo
        function atualizarDisplayCusto() {
            const precoCusto = parseFloat(document.getElementById('preco_custo').value) || 0;
            const displayCusto = document.getElementById('display_custo');
            if (displayCusto) {
                displayCusto.textContent = 'R$ ' + precoCusto.toFixed(2).replace('.', ',');
            }
        }

        // Cria versão com debounce da função margem_lucro
        const margemLucroDebounced = debounce(margem_lucro, 800); // 800ms de delay para campo principal

        // Atualiza o cálculo quando qualquer parâmetro relevante for alterado
        const margemLucroField = document.getElementById('margem_lucro');
        if (margemLucroField) {
            margemLucroField.addEventListener('input', margemLucroDebounced);
        }

        const precoCustoField = document.getElementById('preco_custo');
        if (precoCustoField) {
            precoCustoField.addEventListener('input', function() {
                // Limpa todos os preços customizados ao alterar o preço de custo
                if (Object.keys(precosCustomizados).length > 0) {
                    precosCustomizados = {};
                    console.log('🔄 Todos os preços customizados foram removidos - preço de custo alterado');
                }
                atualizarDisplayCusto();
                margemLucroDebounced();
            });
            // Atualiza o display inicial
            atualizarDisplayCusto();
        }

        // Event listener para o campo de preço mínimo
        const precoMinimoField = document.getElementById('preco_minimo');
        if (precoMinimoField) {
            console.log('✓ Event listener do preço mínimo configurado');

            precoMinimoField.addEventListener('input', function() {
                console.log('Campo preço_minimo alterado para:', this.value);
                // Impede valores negativos
                if (parseFloat(this.value) < 0) {
                    this.value = 0;
                }
                margemLucroDebounced();
            });

            precoMinimoField.addEventListener('blur', function() {
                console.log('Campo preço_minimo perdeu o foco. Valor:', this.value);
                if (this.value === '' || parseFloat(this.value) < 0) {
                    this.value = 0;
                }
            });
        } else {
            console.error('❌ Campo preco_minimo não encontrado!');
        }

        function updateProgress(step, message, currentLoja = null, totalLojas = null) {
            const steps = 7; // Total de etapas do processo
            let percent;
            let title;

            if (currentLoja && totalLojas) {
                // Progresso considerando múltiplas lojas
                const lojaProgress = ((currentLoja - 1) / totalLojas) * 100;
                const stepProgress = (step / steps) * (100 / totalLojas);
                percent = Math.floor(lojaProgress + stepProgress);
                title = `Loja ${currentLoja} de ${totalLojas} - Etapa ${step} de ${steps}`;
            } else {
                // Progresso padrão
                percent = Math.floor((step / steps) * 100);
                title = `Etapa ${step} de ${steps}`;
            }

            $('#progressTitle').text(title);
            $('#progressBar').css('width', `${percent}%`);
            $('#progressText').text(message);
        }

        // IDs dos timeouts para poder cancelar depois
        let progressTimeouts = [];

        function clearAllProgressTimeouts() {
            progressTimeouts.forEach(clearTimeout);
            progressTimeouts = [];
        }

        $('.btn-anunciar').off('click').on('click', function(e) {
            e.preventDefault();

            // Desabilita o botão para evitar múltiplos cliques
            const btnAnunciar = $(this);
            if (btnAnunciar.prop('disabled')) return;
            btnAnunciar.prop('disabled', true);

            if (lojasSelecionadas.length === 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Selecione pelo menos uma loja para anunciar o produto.',
                    confirmButtonText: 'Entendido'
                });
                btnAnunciar.prop('disabled', false);
                return;
            }

            // Pega as variações selecionadas
            var variacoesSelecionadas = [];
            $('input[name="variacoes_selecionadas[]"]:checked').each(function() {
                variacoesSelecionadas.push($(this).val());
            });

            // Verificar se há variações com estoque baixo selecionadas
            var variacoesEstoqueBaixo = [];
            $('input[name="variacoes_selecionadas[]"]:disabled:checked').each(function() {
                variacoesEstoqueBaixo.push($(this));
            });

            if (variacoesEstoqueBaixo.length > 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Existem variações com estoque baixo selecionadas. Estas variações não podem ser anunciadas.',
                    confirmButtonText: 'Entendido'
                });
                btnAnunciar.prop('disabled', false);
                return;
            }

            var form = $('#produto-form');
            var baseFormData = form.serialize();
            var imageUrl = $('input[name="image_url"]').map(function() {
                return $(this).val();
            }).get();
            baseFormData += '&image_url=' + encodeURIComponent(JSON.stringify(imageUrl));

            $('#progressOverlay').fadeIn();
            $('#progressOverlay').addClass('d-flex');
            resetProgressOverlay();
            clearAllProgressTimeouts();

            // Função para anunciar um produto (principal ou variação) em uma loja
            function anunciarProduto(produtoId, loja, indexLoja, indexProduto, totalProdutos, isVariacao = false) {
                return new Promise((resolve, reject) => {
                    // Sempre busca os dados do produto (principal ou variação) via AJAX
                    $.ajax({
                        type: 'GET',
                        url: '../../assets/ajax/produtos/get_produto.php',
                        data: {
                            id: produtoId
                        },
                        dataType: 'json',
                        success: function(produtoData) {
                            if (!produtoData || produtoData.error) {
                                reject({
                                    loja: loja.nome_api_contas,
                                    error: produtoData && produtoData.error ? produtoData.error : 'Produto não encontrado',
                                    variacao: isVariacao
                                });
                                return;
                            }

                            // Monta o formData com os dados do produto
                            let formData = '';
                            formData += 'id=' + encodeURIComponent(produtoId);

                            // PRIORIZA os valores do formulário para título e descrição
                            const tituloForm = document.getElementById('titulo');
                            const descricaoForm = document.getElementById('descricao');

                            let tituloFinal = '';
                            if (tituloForm && tituloForm.value.trim()) {
                                tituloFinal = tituloForm.value.trim();
                            } else if (produtoData.titulo) {
                                tituloFinal = produtoData.titulo;
                            }

                            // Se for variação e tiver cor, adiciona ao título respeitando o limite de 60 caracteres
                            if (isVariacao && produtoData.variacao_cor) {
                                const corSuffix = ' ' + produtoData.variacao_cor;
                                const maxBaseLength = 60 - corSuffix.length;

                                if (tituloFinal.length > maxBaseLength) {
                                    tituloFinal = tituloFinal.substring(0, maxBaseLength);
                                }
                                tituloFinal += corSuffix;
                            } else {
                                // Garante limite de 60 caracteres
                                if (tituloFinal.length > 60) {
                                    tituloFinal = tituloFinal.substring(0, 60);
                                }
                            }

                            formData += '&titulo=' + encodeURIComponent(tituloFinal);

                            if (produtoData.codigo_universal) {
                                formData += '&codigo_universal=' + encodeURIComponent(produtoData.codigo_universal);
                            }
                            if (produtoData.atributos) {
                                formData += '&atributos=' + encodeURIComponent(JSON.stringify(produtoData.atributos));
                            }
                            // Tratamento de imagens
                            let imagensArray = [];

                            if (isVariacao) {
                                // Se for variação:
                                // 1. Pega a imagem da variação (do banco) como capa
                                if (produtoData.imagens && Array.isArray(produtoData.imagens) && produtoData.imagens.length > 0) {
                                    imagensArray.push(produtoData.imagens[0]);
                                } else if (produtoData.imagem_capa) {
                                    imagensArray.push(produtoData.imagem_capa);
                                }

                                // 2. Adiciona as imagens do produto pai (da tela atual)
                                const imagensPai = Array.from(document.querySelectorAll('input[name="imagens[]"]')).map(input => input.value);
                                imagensPai.forEach(img => {
                                    // Evita duplicar a imagem se ela já for a capa da variação
                                    if (!imagensArray.includes(img)) {
                                        imagensArray.push(img);
                                    }
                                });
                            } else {
                                // Se for produto principal:
                                // Prioriza as imagens que estão na tela (podem ter sido reordenadas/editadas)
                                const imagensTela = Array.from(document.querySelectorAll('input[name="imagens[]"]')).map(input => input.value);

                                if (imagensTela.length > 0) {
                                    imagensArray = imagensTela;
                                } else {
                                    // Fallback para dados do banco
                                    if (produtoData.imagens && Array.isArray(produtoData.imagens)) {
                                        imagensArray = produtoData.imagens.filter(Boolean);
                                    } else if (produtoData.imagens && typeof produtoData.imagens === 'string') {
                                        imagensArray = [produtoData.imagens];
                                    }
                                }
                            }

                            formData += '&imagens=' + encodeURIComponent(JSON.stringify(imagensArray));
                            // Adiciona o campo usuario se vier do backend
                            if (produtoData.usuario) {
                                formData += '&usuario=' + encodeURIComponent(produtoData.usuario);
                            }
                            // Adiciona o campo id_usuario vindo do backend
                            if (typeof window.ID_USUARIO !== 'undefined' && window.ID_USUARIO) {
                                formData += '&id_usuario=' + encodeURIComponent(window.ID_USUARIO);
                            }
                            formData += '&marketplace=' + encodeURIComponent(loja.plataforma_api_contas);
                            formData += '&loja_selecionada=' + encodeURIComponent(loja.seller_id_api_contas);
                            formData += '&client_id=' + encodeURIComponent(loja.client_id);
                            formData += '&client_secret=' + encodeURIComponent(loja.client_secret);
                            formData += '&access_token=' + encodeURIComponent(loja.access_token);
                            formData += '&refresh_token=' + encodeURIComponent(loja.refresh_token);

                            // Sempre usa margem individual (checkbox sempre marcado e desabilitado)
                            const margemIndividual = true;
                            let margemParaLoja;

                            // Busca por qualquer input com name="margem_lucro" que tenha o data-loja-id correspondente
                            const inputMargem = document.querySelector(`input[name="margem_lucro"][data-loja-id="${loja.seller_id_api_contas}"]`);
                            margemParaLoja = inputMargem ? parseFloat(inputMargem.value) || 0 : 0;

                            var precoLoja = calcularPrecoParaLojaComMargem(loja, margemParaLoja);
                            formData += '&preco_sugerido=' + encodeURIComponent(precoLoja.toFixed(2));

                            // PRIORIZA a descrição do formulário
                            if (descricaoForm && descricaoForm.value.trim()) {
                                formData += '&descricao=' + encodeURIComponent(descricaoForm.value.trim());
                            } else if (produtoData.descricao) {
                                formData += '&descricao=' + encodeURIComponent(produtoData.descricao);
                            }

                            // Adiciona todos os campos relevantes do produto
                            if (produtoData.peso) {
                                formData += '&peso=' + encodeURIComponent(produtoData.peso);
                            }
                            if (produtoData.ncm) {
                                formData += '&ncm=' + encodeURIComponent(produtoData.ncm);
                            }
                            if (produtoData.altura) {
                                formData += '&altura=' + encodeURIComponent(produtoData.altura);
                            }
                            if (produtoData.largura) {
                                formData += '&largura=' + encodeURIComponent(produtoData.largura);
                            }
                            if (produtoData.comprimento) {
                                formData += '&comprimento=' + encodeURIComponent(produtoData.comprimento);
                            }
                            if (produtoData.plataforma) {
                                formData += '&plataforma=' + encodeURIComponent(produtoData.plataforma);
                            }
                            if (produtoData.sku) {
                                formData += '&sku=' + encodeURIComponent(produtoData.sku);
                            }
                            if (produtoData.categoria_ml) {
                                formData += '&categoria_ml=' + encodeURIComponent(produtoData.categoria_ml);
                            }
                            if (produtoData.category_domain) {
                                formData += '&category_domain=' + encodeURIComponent(produtoData.category_domain);
                            }
                            if (produtoData.id_cat_ml) {
                                formData += '&id_cat_ml=' + encodeURIComponent(produtoData.id_cat_ml);
                            }
                            if (produtoData.categoria_shopee) {
                                formData += '&categoria_shopee=' + encodeURIComponent(produtoData.categoria_shopee);
                            }
                            if (produtoData.estoque) {
                                formData += '&estoque=' + encodeURIComponent(produtoData.estoque);
                            }
                            if (produtoData.preco_custo) {
                                formData += '&preco_custo=' + encodeURIComponent(produtoData.preco_custo);
                            }
                            if (produtoData.preco_calc_base) {
                                formData += '&preco_calc_base=' + encodeURIComponent(produtoData.preco_calc_base);
                            }
                            if (produtoData.fornecedor_nome) {
                                formData += '&fornecedor_nome=' + encodeURIComponent(produtoData.fornecedor_nome);
                            }
                            if (produtoData.imagem_capa) {
                                formData += '&imagem_capa=' + encodeURIComponent(produtoData.imagem_capa);
                            }
                            // Removido envio duplicado de imagens

                            // Adiciona tipo_anuncio do select, se existir
                            var tipoAnuncioVal = '';

                            // Verifica se é Mercado Livre e se tem tipo específico para a loja
                            if (loja.plataforma_api_contas === 'MercadoLivre' || loja.plataforma_api_contas === 'mercado_livre') {
                                const tipoAnuncioLoja = document.getElementById(`tipo_anuncio_loja_${loja.seller_id_api_contas}`);
                                if (tipoAnuncioLoja) {
                                    tipoAnuncioVal = tipoAnuncioLoja.value;
                                } else if (document.getElementById('tipo_anuncio')) {
                                    tipoAnuncioVal = document.getElementById('tipo_anuncio').value;
                                }
                            }

                            if (tipoAnuncioVal) {
                                formData += '&tipo_anuncio=' + encodeURIComponent(tipoAnuncioVal);
                            } else if (produtoData.tipo_anuncio) {
                                formData += '&tipo_anuncio=' + encodeURIComponent(produtoData.tipo_anuncio);
                            }

                            let nomeProduto = isVariacao ? `Variação #${indexProduto}` : 'Produto principal';
                            updateProgress(
                                1,
                                `Anunciando ${nomeProduto} na loja: ${loja.nome_api_contas}`,
                                indexLoja + 1,
                                lojasSelecionadas.length * totalProdutos
                            );

                            // Simula as etapas do processo
                            progressTimeouts.push(setTimeout(() => {
                                updateProgress(
                                    2,
                                    `Validando dados para ${loja.nome_api_contas}...`,
                                    indexLoja + 1,
                                    lojasSelecionadas.length * totalProdutos
                                );
                            }, 1000));

                            progressTimeouts.push(setTimeout(() => {
                                updateProgress(
                                    3,
                                    `Verificando estoque para ${loja.nome_api_contas}...`,
                                    indexLoja + 1,
                                    lojasSelecionadas.length * totalProdutos
                                );
                            }, 2000));

                            progressTimeouts.push(setTimeout(() => {
                                updateProgress(
                                    4,
                                    `Enviando imagens para ${loja.nome_api_contas}...`,
                                    indexLoja + 1,
                                    lojasSelecionadas.length * totalProdutos
                                );
                            }, 3000));

                            progressTimeouts.push(setTimeout(() => {
                                updateProgress(
                                    5,
                                    `Cadastrando produto em ${loja.nome_api_contas}...`,
                                    indexLoja + 1,
                                    lojasSelecionadas.length * totalProdutos
                                );
                            }, 4000));

                            progressTimeouts.push(setTimeout(() => {
                                updateProgress(
                                    6,
                                    `Finalizando anúncio em ${loja.nome_api_contas}...`,
                                    indexLoja + 1,
                                    lojasSelecionadas.length * totalProdutos
                                );
                            }, 5000));

                            $.ajax({
                                type: 'POST',
                                url: '../../assets/ajax/plataformas/' + loja.plataforma_api_contas + '/anunciar.php',
                                data: formData,
                                success: function(response) {
                                    let resp;
                                    try {
                                        resp = typeof response === 'string' ? JSON.parse(response) : response;
                                    } catch (e) {
                                        reject({
                                            loja: loja.nome_api_contas,
                                            error: 'Erro ao processar resposta do servidor',
                                            variacao: isVariacao
                                        });
                                        return;
                                    }

                                    if (resp && resp.status === 'success') {
                                        updateProgress(
                                            7,
                                            `Anúncio criado com sucesso em ${loja.nome_api_contas}!`,
                                            indexLoja + 1,
                                            lojasSelecionadas.length * totalProdutos
                                        );
                                        resolve({
                                            loja: loja.nome_api_contas,
                                            success: true,
                                            message: resp.message,
                                            permalink: resp.permalink || null,
                                            variacao: isVariacao
                                        });
                                    } else {
                                        if (resp.message == 'Validation error' || resp.message == 'body.required_fields') {
                                            reject({
                                                loja: loja.nome_api_contas,
                                                error: resp.causes ? JSON.stringify(resp.causes) : 'Validation error',
                                                variacao: isVariacao
                                            });
                                        } else {
                                            reject({
                                                loja: loja.nome_api_contas,
                                                error: resp && resp.message ? resp.message : 'Erro desconhecido',
                                                variacao: isVariacao
                                            });
                                        }
                                    }
                                },
                                error: function(xhr, status, error) {
                                    reject({
                                        loja: loja.nome_api_contas,
                                        error: xhr.responseJSON && xhr.responseJSON.message ? xhr.responseJSON.message : 'Erro na requisição',
                                        variacao: isVariacao
                                    });
                                }
                            });
                        },
                        error: function(xhr, status, error) {
                            reject({
                                loja: loja.nome_api_contas,
                                error: xhr.responseJSON && xhr.responseJSON.message ? xhr.responseJSON.message : 'Erro ao buscar dados do produto',
                                variacao: isVariacao
                            });
                        }
                    });
                });
            }

            // Função para processar todas as lojas e produtos (principal + variações)
            async function processarTudo() {
                const resultados = [];
                const idPrincipal = $('input[name="id"]').val();
                // As variações são apenas os valores dos checkboxes, nunca incluindo o principal
                const variacoesSelecionadas = [];
                $('input[name="variacoes_selecionadas[]"]:checked').each(function() {
                    const val = $(this).val();
                    if (val !== idPrincipal && !variacoesSelecionadas.includes(val)) {
                        variacoesSelecionadas.push(val);
                    }
                });
                // Envia o principal e depois cada variação
                const produtosParaEnviar = [idPrincipal, ...variacoesSelecionadas];
                const totalProdutos = produtosParaEnviar.length;

                for (let p = 0; p < totalProdutos; p++) {
                    for (let l = 0; l < lojasSelecionadas.length; l++) {
                        try {
                            const resultado = await anunciarProduto(
                                produtosParaEnviar[p],
                                lojasSelecionadas[l],
                                l,
                                p,
                                totalProdutos,
                                p > 0 // se não for o primeiro, é variação
                            );
                            resultados.push(resultado);
                        } catch (error) {
                            resultados.push(error);
                        }
                    }
                }
                return resultados;
            }

            // Executa o processo
            processarTudo().then(resultados => {
                $('#progressOverlay').fadeOut();
                clearAllProgressTimeouts();

                // Atualiza o status das lojas com os resultados
                atualizarStatusLojas(resultados);

                // Separa sucessos e falhas
                const sucessos = resultados.filter(r => r.success);
                const falhas = resultados.filter(r => !r.success);

                let mensagem = '';
                let icone = 'success';

                if (sucessos.length > 0 && falhas.length === 0) {
                    mensagem = `Produto${variacoesSelecionadas.length ? ' e variações' : ''} anunciado(s) com sucesso em ${sucessos.length} operação(ões)!`;
                    icone = 'success';
                } else if (sucessos.length > 0 && falhas.length > 0) {
                    mensagem = `Alguns anúncios foram feitos com sucesso (${sucessos.length}), outros falharam (${falhas.length}).`;
                    icone = 'warning';
                } else {
                    mensagem = `Falha ao anunciar em todas as lojas.`;
                    icone = 'error';
                }

                // Monta detalhes dos resultados com HTML
                let htmlContent = '';
                if (sucessos.length > 0) {
                    htmlContent += '<div class="mb-3"><h6 class="text-success">✓ Sucessos:</h6><ul class="list-unstyled">';
                    sucessos.forEach(s => {
                        htmlContent += `<li class="mb-2">
                            <strong>${s.loja}${s.variacao ? ' (Variação)' : ' (Principal)'}</strong>`;
                        if (s.permalink) {
                            htmlContent += `<br><a href="${s.permalink}" target="_blank" class="btn btn-sm btn-outline-primary mt-1">
                                <i class="ti ti-external-link"></i> Ver Anúncio
                            </a>`;
                        }
                        htmlContent += '</li>';
                    });
                    htmlContent += '</ul></div>';
                }
                if (falhas.length > 0) {
                    htmlContent += '<div class="mb-3"><h6 class="text-danger">✗ Falhas:</h6><ul class="list-unstyled">';
                    falhas.forEach(f => {
                        htmlContent += `<li class="mb-1"><strong>${f.loja}${f.variacao ? ' (Variação)' : ' (Principal)'}:</strong> ${f.error}</li>`;
                    });
                    htmlContent += '</ul></div>';
                }

                Swal.fire({
                    icon: icone,
                    title: mensagem,
                    html: `<div style="max-height: 300px; overflow-y: auto; text-align: left;">${htmlContent}</div>`,
                    confirmButtonText: 'Ok',
                    showCancelButton: sucessos.length > 0,
                    width: '600px',
                    customClass: {
                        htmlContainer: 'text-left'
                    }
                }).then(function(result) {
                    if (result.isConfirmed || result.dismiss === Swal.DismissReason.cancel) {
                        window.location.href = '/dash/catalogo';
                    }
                });

                $('#progressOverlay').addClass('d-none');
                $('#progressOverlay').removeClass('d-flex');
                $('.btn-anunciar').prop('disabled', false);
            }).catch(error => {
                $('#progressOverlay').fadeOut();
                $('#progressOverlay').removeClass('d-flex').addClass('d-none');
                clearAllProgressTimeouts();
                $('.btn-anunciar').prop('disabled', false);
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: 'Erro inesperado durante o processo de anúncio.'
                });
            });
        });

        // Função para resetar o progresso visual antes de iniciar
        function resetProgressOverlay() {
            $('#progressOverlay').find('.progress-step').removeClass('completed'); // Exemplo de limpeza
            $('#progressOverlay').find('.progress-message').text(''); // Limpa mensagens anteriores
        }

        // Função para salvar os valores de configuração das taxas
        $('.btn-salvar-taxas').on('click', function(e) {
            e.preventDefault();

            // Captura os valores configurados pelo usuário
            var percentVenda = parseFloat($('#percent_venda').val()) || 0;
            var percentComMkp = parseFloat($('#percent_com_mkp').val()) || 0;
            var taxa = parseFloat($('#taxa').val()) || 0;
            var frete = parseFloat($('#frete').val()) || 0;
            var percentImposto = parseFloat($('#percent_imposto').val()) || 0;

            // ID da loja selecionada (primeira loja como referência)
            var idLoja = document.getElementById('loja_selecionada').value;

            // Dados a serem enviados para a atualização
            var dadosConfig = {
                id_loja: idLoja,
                percent_venda: percentVenda,
                percent_com_mkp: percentComMkp,
                taxa: taxa,
                frete: frete,
                percent_imposto: percentImposto
            };

            // Envia os dados para atualização no servidor
            $.ajax({
                type: 'POST',
                url: '../../assets/ajax/loja/atualizar_taxas.php',
                data: dadosConfig,
                success: function(response) {
                    if (typeof response === 'string') {
                        response = JSON.parse(response);
                    }

                    if (response.status === 'success') {
                        // Atualiza os valores na configuração das lojas selecionadas
                        lojasSelecionadas.forEach(loja => {
                            if (loja.seller_id_api_contas === idLoja) {
                                loja.percent_venda = percentVenda;
                                loja.percent_com_mkp = percentComMkp;
                                loja.taxa = taxa;
                                loja.frete = frete;
                                loja.percent_imposto = percentImposto;
                            }
                        });

                        // Atualiza os checkboxes com os novos dados
                        const checkboxes = document.querySelectorAll('input[name="selectedCards[]"]:checked');
                        checkboxes.forEach(checkbox => {
                            const dadosLoja = JSON.parse(checkbox.value);
                            if (dadosLoja.seller_id_api_contas === idLoja) {
                                dadosLoja.percent_venda = percentVenda;
                                dadosLoja.percent_com_mkp = percentComMkp;
                                dadosLoja.taxa = taxa;
                                dadosLoja.frete = frete;
                                dadosLoja.percent_imposto = percentImposto;
                                checkbox.value = JSON.stringify(dadosLoja);
                            }
                        });

                        // Atualiza o cálculo com as novas configurações
                        document.getElementById('margem_lucro').value = percentVenda;
                        margem_lucro();

                        // Notifica o usuário sobre a atualização bem-sucedida
                        Swal.fire({
                            icon: 'success',
                            title: 'Configurações salvas',
                            text: 'As taxas foram atualizadas com sucesso.',
                            confirmButtonText: 'Ok'
                        });
                    } else {
                        // Notifica o usuário sobre o erro
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: response.message || 'Erro ao atualizar as configurações.',
                            confirmButtonText: 'Ok'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    // Notifica o usuário sobre o erro
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Erro ao processar a requisição.',
                        confirmButtonText: 'Ok'
                    });
                }
            });
        });
    </script>

    <!-- Modal para Editar Preço Final -->
    <div class="modal fade" id="modalEditarPrecoFinal" tabindex="-1" aria-labelledby="modalEditarPrecoFinalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalEditarPrecoFinalLabel">
                        <i class="ti ti-edit me-2"></i>Editar Preço Final
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Loja:</label>
                        <p class="mb-2" id="modal-loja-nome"></p>
                    </div>

                    <div class="mb-3">
                        <label for="modal-preco-final-input" class="form-label fw-bold">Novo Preço Final:</label>
                        <div class="input-group">
                            <span class="input-group-text">R$</span>
                            <input type="number" class="form-control" id="modal-preco-final-input"
                                step="0.01" min="0" placeholder="0.00">
                        </div>
                        <small class="text-muted d-block mt-1" id="modal-preco-minimo-info"></small>
                    </div>

                    <div class="alert alert-info mb-0" role="alert">
                        <small>
                            <i class="ti ti-info-circle me-1"></i>
                            <strong>Informação:</strong> O preço será recalculado mantendo a regra do valor mínimo configurado.
                        </small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" id="btn-salvar-preco-final">Salvar Alteração</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Gerenciamento do Modal de Edição de Preço Final
        let lojaAtualModal = null;

        // Event delegation para cliques nos preços finais
        document.addEventListener('click', function(e) {
            const precoElement = e.target.closest('.preco-final-editavel');
            if (precoElement) {
                const lojaId = precoElement.dataset.lojaId;
                const lojaNome = precoElement.dataset.lojaNome;
                const precoAtual = precoElement.dataset.precoCalculado;

                // Encontra a loja completa nos dados
                lojaAtualModal = lojasSelecionadas.find(loja => loja.seller_id_api_contas === lojaId);

                if (lojaAtualModal) {
                    abrirModalEditarPreco(lojaAtualModal, lojaNome, precoAtual);
                }
            }

            // Event listener para botão de resetar preço
            const btnResetar = e.target.closest('.btn-resetar-preco');
            if (btnResetar) {
                const lojaId = btnResetar.dataset.lojaId;
                const lojaNome = btnResetar.dataset.lojaNome;

                Swal.fire({
                    icon: 'question',
                    title: 'Resetar Preço',
                    html: `Deseja resetar o preço customizado da loja <strong>${lojaNome}</strong>?<br><br>O preço voltará a ser calculado automaticamente.`,
                    showCancelButton: true,
                    confirmButtonText: 'Sim, Resetar',
                    cancelButtonText: 'Cancelar',
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33'
                }).then((result) => {
                    if (result.isConfirmed) {
                        delete precosCustomizados[lojaId];
                        exibirLojasSelecionadas();

                        const notyf = new Notyf({
                            duration: 3000,
                            position: {
                                x: 'right',
                                y: 'top'
                            }
                        });
                        notyf.success('Preço resetado com sucesso!');

                        console.log(`✅ Preço customizado removido para loja ID: ${lojaId}`);
                    }
                });
            }
        });

        function abrirModalEditarPreco(loja, nomeLoja, precoAtual) {
            const modal = new bootstrap.Modal(document.getElementById('modalEditarPrecoFinal'));
            const inputPreco = document.getElementById('modal-preco-final-input');
            const infoPrecoMinimo = document.getElementById('modal-preco-minimo-info');
            const precoMinimo = parseFloat(document.getElementById('preco_minimo')?.value) || 0;

            // Preenche os dados do modal
            document.getElementById('modal-loja-nome').textContent = nomeLoja;

            // Preenche o input com o preço atual (customizado ou calculado)
            const precoExibir = precosCustomizados[loja.seller_id_api_contas] || precoAtual;
            inputPreco.value = parseFloat(precoExibir).toFixed(2);

            // Define o mínimo permitido
            if (precoMinimo > 0) {
                inputPreco.min = precoMinimo;
                infoPrecoMinimo.innerHTML = `<i class="ti ti-alert-circle text-warning"></i> Preço mínimo configurado: R$ ${precoMinimo.toFixed(2)}`;
                infoPrecoMinimo.classList.remove('text-muted');
                infoPrecoMinimo.classList.add('text-warning');
            } else {
                inputPreco.min = 0;
                infoPrecoMinimo.innerHTML = 'Nenhum preço mínimo configurado.';
                infoPrecoMinimo.classList.remove('text-warning');
                infoPrecoMinimo.classList.add('text-muted');
            }

            modal.show();
        }

        // Salvar alteração de preço
        document.getElementById('btn-salvar-preco-final').addEventListener('click', function() {
            const inputPreco = document.getElementById('modal-preco-final-input');
            const novoPreco = parseFloat(inputPreco.value);
            const precoMinimo = parseFloat(document.getElementById('preco_minimo')?.value) || 0;

            // Validações
            if (isNaN(novoPreco) || novoPreco <= 0) {
                Swal.fire({
                    icon: 'error',
                    title: 'Valor Inválido',
                    text: 'Por favor, digite um valor válido maior que zero.',
                    confirmButtonText: 'OK',
                    customClass: {
                        container: 'swal-overlay-high'
                    }
                });
                return;
            }

            if (precoMinimo > 0 && novoPreco < precoMinimo) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    html: `O preço informado (R$ ${novoPreco.toFixed(2)}) está abaixo do mínimo configurado (R$ ${precoMinimo.toFixed(2)}).<br><br>O preço será ajustado automaticamente para o valor mínimo.`,
                    confirmButtonText: 'OK, Entendi',
                    showCancelButton: true,
                    cancelButtonText: 'Cancelar',
                    customClass: {
                        container: 'swal-overlay-high'
                    }
                }).then((result) => {
                    if (result.isConfirmed) {
                        salvarPrecoCustomizado(lojaAtualModal, precoMinimo);
                    }
                });
            } else {
                salvarPrecoCustomizado(lojaAtualModal, novoPreco);
            }
        });

        function salvarPrecoCustomizado(loja, novoPreco) {
            // Armazena o preço customizado
            precosCustomizados[loja.seller_id_api_contas] = novoPreco;

            // Fecha o modal
            const modal = bootstrap.Modal.getInstance(document.getElementById('modalEditarPrecoFinal'));
            modal.hide();

            // Atualiza a exibição das lojas
            exibirLojasSelecionadas();

            // Notificação de sucesso
            const notyf = new Notyf({
                duration: 3000,
                position: {
                    x: 'right',
                    y: 'top'
                }
            });
            notyf.success(`Preço alterado para R$ ${novoPreco.toFixed(2)}`);

            console.log(`✅ Preço customizado salvo para ${loja.nome_api_contas}: R$ ${novoPreco.toFixed(2)}`);
        }
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const leftCard = document.querySelector('.d-flex > .w-50:first-child');
            const rightCard = document.querySelector('.d-flex > .w-50:last-child');

            function adjustCardHeights() {
                const maxHeight = Math.max(leftCard.offsetHeight, rightCard.offsetHeight);

                leftCard.style.height = `${maxHeight}px`;
                rightCard.style.height = `${maxHeight}px`;
            }

            window.addEventListener('resize', adjustCardHeights);
            adjustCardHeights();
        });
    </script>
</body>

</html>