<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
date_default_timezone_set('America/Sao_Paulo');

require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../funcoes/general.php');

// Pega o ID direto, sem base64
$produtoId = base64_decode($_GET['n'] ?? '');

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <?php include('../../includes/dashHead.php'); ?>

  <link rel="stylesheet" href="../../assets/vendor/libs/apex-charts/apex-charts.css" />
  <link rel="stylesheet" href="../../assets/vendor/libs/swiper/swiper.css" />
  <link rel="stylesheet" href="../../assets/vendor/css/pages/cards-advance.css" />

  <!-- Helpers -->
  <script src="../../assets/vendor/js/helpers.js"></script>
  <script src="../../assets/vendor/js/template-customizer.js"></script>
  <script src="../../assets/js/config.js"></script>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
  <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
  <script src="../../assets/js/funcoes.js"></script>
  
</head>
<body>
    
    <!-- Header Banner -->
    <header class="header-banner border-bottom shadow-sm mb-4">
        <div class="container header-content py-4">
            <div class="row align-items-center">
                <div class="col-auto">
                    <a href="catalogo_externo" class="btn btn-voltar btn-sm">
                        <i class="ti ti-arrow-left me-1"></i> Voltar
                    </a>
                </div>
                <div class="col text-center">
                    <div class="logo-container d-inline-block">
                        <img src="<?php echo Config::get('site_configs.icon'); ?>" alt="Logo" height="40">
                    </div>
                </div>
                <div class="col-auto">
                    <button class="btn theme-toggle-btn" title="Alternar tema">
                        <i class="ti ti-moon ti-md"></i>
                    </button>
                </div>
            </div>
        </div>
    </header>

    <div class="container py-4">
        
        <div id="loading-detalhes" class="text-center py-5">
            <div class="spinner-border text-dark" role="status">
                <span class="visually-hidden">Carregando...</span>
            </div>
            <p class="mt-3 text-muted">Carregando detalhes...</p>
        </div>

        <div id="produto-detalhes" style="display: none;"></div>

        <div id="erro-detalhes" style="display: none;" class="text-center py-5">
            <i class="ti ti-exclamation-triangle display-1 text-danger"></i>
            <h3 class="mt-3">Produto não encontrado</h3>
            <a href="catalogo_externo.php" class="btn btn-dark mt-3">Voltar</a>
        </div>
        
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>

    <script>
        const API_URL = '<?php echo Config::get('api_configs.base_url'); ?>';
        const API_TOKEN = '<?php echo Config::get('api_configs.token'); ?>';
        const WHITELABEL = '<?php echo Config::get('database.dbname'); ?>';
        const PRODUTO_ID = <?php echo json_encode($produtoId); ?>;

        console.log('=== DEBUG PRODUTO DETALHES ===');
        console.log('API_URL:', API_URL);
        console.log('API_TOKEN:', API_TOKEN ? 'Presente (' + API_TOKEN.length + ' chars)' : 'AUSENTE');
        console.log('WHITELABEL:', WHITELABEL);
        console.log('PRODUTO_ID:', PRODUTO_ID);

        $(document).ready(function() {
            if (!PRODUTO_ID) {
                console.error('❌ PRODUTO_ID está vazio!');
                mostrarErro();
                return;
            }
            carregarDetalhes();
        });

        async function carregarDetalhes() {
            try {
                const query = `
                    SELECT 
                        p.id, p.titulo, p.descricao, p.categoria_interna,
                        f.nome as fornecedor_nome
                    FROM drophub_global.produtos p
                    LEFT JOIN drophub_global.fornecedores f ON p.fornecedor = f.id
                    WHERE p.id = :produto_id
                `;

                console.log('📤 Buscando produto...');
                console.log('SQL:', query);
                console.log('Params:', { produto_id: PRODUTO_ID });

                const response = await $.ajax({
                    url: API_URL + 'query/custom',
                    method: 'POST',
                    headers: {
                        'Authorization': 'Bearer ' + API_TOKEN,
                        'Content-Type': 'application/json'
                    },
                    data: JSON.stringify({ sql: query, params: { produto_id: PRODUTO_ID } })
                });

                console.log('📥 Resposta:', response);

                if (response.success && response.data.data && response.data.data.length > 0) {
                    const produto = response.data.data[0];
                    console.log('✅ Produto encontrado:', produto);
                    await carregarImagens(produto);
                } else {
                    console.error('❌ Produto não encontrado na resposta:', response);
                    mostrarErro();
                }
            } catch (error) {
                console.error('❌ Erro ao carregar produto:', error);
                console.error('Response Text:', error.responseText);
                mostrarErro();
            }
        }

        async function carregarImagens(produto) {
            try {
                const query = `SELECT imagem_url FROM drophub_global.produtos_imagens WHERE produto_id = :produto_id ORDER BY id`;

                const response = await $.ajax({
                    url: API_URL + 'query/custom',
                    method: 'POST',
                    headers: {
                        'Authorization': 'Bearer ' + API_TOKEN,
                        'Content-Type': 'application/json'
                    },
                    data: JSON.stringify({ sql: query, params: { produto_id: PRODUTO_ID } })
                });

                const imagens = response.success && response.data.data ? response.data.data : [];
                renderizarProduto(produto, imagens);
            } catch (error) {
                renderizarProduto(produto, []);
            }
        }

        function renderizarProduto(produto, imagens) {
            let carouselHTML = '';
            
            if (imagens.length > 0) {
                const indicators = imagens.map((_, i) => 
                    `<button type="button" data-bs-target="#carousel" data-bs-slide-to="${i}" ${i === 0 ? 'class="active"' : ''}></button>`
                ).join('');
                
                const slides = imagens.map((img, i) => `
                    <div class="carousel-item ${i === 0 ? 'active' : ''}">
                        <img src="${img.imagem_url}" class="d-block w-100" style="height: 450px; object-fit: contain;" alt="Imagem ${i + 1}">
                    </div>
                `).join('');
                
                const thumbnails = imagens.map((img, i) => `
                    <div class="col-3 mb-2">
                        <img src="${img.imagem_url}" 
                             class="img-thumbnail cursor-pointer thumbnail-img ${i === 0 ? 'border-dark border-3' : ''}" 
                             style="height: 80px; width: 100%; object-fit: cover; cursor: pointer;" 
                             data-bs-target="#carousel" 
                             data-bs-slide-to="${i}"
                             alt="Miniatura ${i + 1}">
                    </div>
                `).join('');
                
                carouselHTML = `
                    <div id="carousel" class="carousel slide mb-3" data-bs-ride="carousel">
                        <div class="carousel-indicators">${indicators}</div>
                        <div class="carousel-inner bg-white rounded p-4">${slides}</div>
                        ${imagens.length > 1 ? `
                            <button class="carousel-control-prev" type="button" data-bs-target="#carousel" data-bs-slide="prev">
                                <span class="carousel-control-prev-icon"></span>
                            </button>
                            <button class="carousel-control-next" type="button" data-bs-target="#carousel" data-bs-slide="next">
                                <span class="carousel-control-next-icon"></span>
                            </button>
                        ` : ''}
                    </div>
                    ${imagens.length > 1 ? `
                        <div class="row g-2 mx-0">
                            ${thumbnails}
                        </div>
                    ` : ''}
                `;
            } else {
                carouselHTML = `
                    <div class="bg-white rounded p-5 text-center">
                        <i class="ti ti-image display-1 text-muted"></i>
                        <p class="text-muted mt-2">Sem imagens</p>
                    </div>
                `;
            }

            const html = `
                <div class="row g-4">
                    <div class="col-lg-6">${carouselHTML}</div>
                    <div class="col-lg-6">
                        <div class="card shadow-sm h-100">
                            <div class="card-body p-4">
                                ${produto.categoria ? `<span class="badge bg-secondary mb-3"><i class="ti ti-tag me-1"></i>${produto.categoria}</span>` : ''}
                                <h1 class="h3 fw-bold mb-3">${produto.titulo}</h1>
                               
                                ${produto.fornecedor_nome ? `
                                    <div class="alert alert-light border mb-4">
                                        <i class="ti ti-truck me-2"></i><strong>Fornecedor:</strong> ${produto.fornecedor_nome}
                                    </div>
                                ` : ''}
                                <div class="mb-4">
                                    <h5 class="fw-semibold mb-3"><i class="ti ti-card-text me-2"></i>Descrição</h5>
                                    <div class="bg-light rounded p-3" style="max-height: 300px; overflow-y: auto;">
                                        <p class="text-dark mb-0" style="white-space: pre-line; line-height: 1.6;">${produto.descricao || 'Sem descrição disponível'}</p>
                                    </div>
                                </div>
                              
                                <div class="row g-2 text-center">
                                    <div class="col-6">
                                        <div class="p-3 bg-light rounded">
                                            <i class="ti ti-shield-check text-success fs-4"></i>
                                            <small class="d-block mt-1">Verificado</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="p-3 bg-light rounded">
                                            <i class="ti ti-clock text-primary fs-4"></i>
                                            <small class="d-block mt-1">Disponível</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `;

            $('#loading-detalhes').hide();
            $('#produto-detalhes').html(html).fadeIn();
            
            // Adiciona interação às miniaturas
            $('.thumbnail-img').on('click', function() {
                $('.thumbnail-img').removeClass('border-dark border-3').addClass('border-1');
                $(this).addClass('border-dark border-3').removeClass('border-1');
            });
            
            // Atualiza borda da miniatura quando o carousel muda
            $('#carousel').on('slide.bs.carousel', function(e) {
                $('.thumbnail-img').removeClass('border-dark border-3').addClass('border-1');
                $(`.thumbnail-img[data-bs-slide-to="${e.to}"]`).addClass('border-dark border-3').removeClass('border-1');
            });
        }

        function mostrarErro() {
            $('#loading-detalhes').hide();
            $('#erro-detalhes').fadeIn();
        }

        // ===== CONTROLE DE TEMA =====
        function updateThemeIcon(theme) {
            const themeIcon = document.querySelector('.theme-toggle-btn i');
            if (!themeIcon) return;

            themeIcon.className = 'ti ti-md';
            
            if (theme === 'light') {
                themeIcon.classList.add('ti-moon');
            } else {
                themeIcon.classList.add('ti-sun');
            }
        }

        function getCurrentTheme() {
            let templateName = document.documentElement.getAttribute('data-template') || 'vertical-menu-template-no-customizer-starter';
            let theme = localStorage.getItem('templateCustomizer-' + templateName + '--Style') || 'light';
            
            if (theme === 'system') {
                theme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
            }
            
            return theme;
        }

        function toggleTheme() {
            const currentTheme = getCurrentTheme();
            const newTheme = currentTheme === 'light' ? 'dark' : 'light';
            applyTheme(newTheme);
        }

        function applyTheme(theme) {
            let templateName = document.documentElement.getAttribute('data-template') || 'vertical-menu-template-no-customizer-starter';
            localStorage.setItem('templateCustomizer-' + templateName + '--Style', theme);
            changeThemeDirectly(theme);
            updateThemeIcon(theme);
        }

        function changeThemeDirectly(theme) {
            const html = document.documentElement;
            const themeLink = document.querySelector('.template-customizer-theme-css');
            const coreLink = document.querySelector('.template-customizer-core-css');
            
            html.classList.remove('light-style', 'dark-style');
            html.classList.add(theme + '-style');
            
            if (coreLink) {
                let newCoreHref = coreLink.href;
                if (theme === 'dark') {
                    newCoreHref = newCoreHref.replace('core.css', 'core-dark.css');
                } else {
                    newCoreHref = newCoreHref.replace('core-dark.css', 'core.css');
                }
                coreLink.href = newCoreHref;
            }
            
            if (themeLink) {
                let newThemeHref = themeLink.href;
                if (theme === 'dark') {
                    newThemeHref = newThemeHref.replace('theme-default.css', 'theme-default-dark.css');
                } else {
                    newThemeHref = newThemeHref.replace('theme-default-dark.css', 'theme-default.css');
                }
                themeLink.href = newThemeHref;
            }
        }

        $(document).ready(function() {
            const currentTheme = getCurrentTheme();
            updateThemeIcon(currentTheme);
            
            $('.theme-toggle-btn').on('click', function(e) {
                e.preventDefault();
                toggleTheme();
            });
        });
    </script>
</body>
</html>
