<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require '../../../class/configClass.php';
Config::load('../../../config/config.php');
include_once('../../../conexao/conexao.php');
include_once('../../../funcoes/general.php');
require '../../../class/getTokens.php';

$plataforma = $_GET['plataforma'] ?? null;

// Se for fornecedor salva em outra tabela
if ($plataforma == 'fornecedor_bling') {
    $website_url = $_GET['website_url'] ?? null;
    $id_usuario = $_GET['id_usuario'] ?? null;
    $loja = $_GET['fornecedor'] ?? null;
    $fornecedor = 'Forn: ' . $loja;
    $access_token = $_GET['access_token'] ?? null;
    $refresh_token = $_GET['refresh_token'] ?? null;
    $plataforma = $_GET['plataforma'] ?? null;
    $shop_id = $_GET['shop_id'] ?? null;
    $partner_id = $_GET['partner_id'] ?? null;
    $partner_key = $_GET['partner_key'] ?? null;
    $code = $_GET['code'] ?? null;
    $shopId = isset($_GET['shop_id']) ? (int)$_GET['shop_id'] : null;

    echo '<br><br>';
    echo 'fornecedor: '.$fornecedor.'<br>';
    echo 'id_usuario: '.$id_usuario.'<br>';
    echo 'loja: '.$loja.'<br>';
    echo 'plataforma: '.$plataforma.'<br>';
    echo 'shop_id: '.$shop_id.'<br>';
    echo 'partner_id: '.$partner_id.'<br>';
    echo 'partner_key: '.$partner_key.'<br>';
    echo 'shopId: '.$shopId.'<br>';

    echo 'access_token: '.$access_token.'<br>';
    echo 'refresh_token: '.$refresh_token.'<br>';
    
    // Calcula data de expiração (6 horas = 21600 segundos)
    $expires_at = date('Y-m-d H:i:s', time() + 21600);
    
    $sql = "INSERT INTO drophub_global.usuarios_api_contas 
    (nome, user_id, access_token, code, expires_at, plataforma, fornecedor, seller_id, client_id, client_secret)
    VALUES
    (:nome, :user_id, :access_token, :code, :expires_at, :plataforma, :fornecedor, :seller_id, :partnerId, :partnerKey)";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':nome', $loja);
    $stmt->bindParam(':user_id', $id_usuario);
    $stmt->bindParam(':access_token', $access_token);
    $stmt->bindParam(':code', $refresh_token);
    $stmt->bindParam(':expires_at', $expires_at);
    $stmt->bindParam(':plataforma', $plataforma);
    $stmt->bindParam(':fornecedor', $fornecedor);
    $stmt->bindParam(':seller_id', $shopId);
    $stmt->bindParam(':partnerId', $partner_id);
    $stmt->bindParam(':partnerKey', $partner_key);

    if ($stmt->execute()) {
    // Redireciona para a página de integrações
    header('Location: /dash/configuracoes');
    exit;
    } else {
    echo "Erro ao salvar os dados no banco de dados!";
    }
    
} elseif ($plataforma == 'bling' || $plataforma == 'usuario_bling') {
    // Para usuários/clientes do Bling
    $website_url = $_GET['website_url'] ?? null;
    $id_usuario = $_GET['id_usuario'] ?? null;
    $loja = $_GET['cliente'] ?? $_GET['loja'] ?? null;
    $cliente = 'Cliente: ' . $loja;
    $access_token = $_GET['access_token'] ?? null;
    $refresh_token = $_GET['refresh_token'] ?? null;
    $plataforma = $_GET['plataforma'] ?? null;
    $shop_id = $_GET['shop_id'] ?? null;
    $partner_id = $_GET['partner_id'] ?? null;
    $partner_key = $_GET['partner_key'] ?? null;
    $code = $_GET['code'] ?? null;
    $shopId = isset($_GET['shop_id']) ? (int)$_GET['shop_id'] : null;
    $fornecedor = $_GET['fornecedor'] ?? null;
    $fornecedor = $fornecedor;

    // Log para debug
    $logFile = '/var/www/whitelabels/homolog/logs/bling_integration_debug.log';
    $logDir = dirname($logFile);
    if (!file_exists($logDir)) {
        mkdir($logDir, 0777, true);
    }
    
    // Verifica se já processamos este shop_id (evita reprocessamento)
    $sessionKey = 'bling_processed_' . $shopId . '_' . $id_usuario;
    if (isset($_SESSION[$sessionKey]) && $_SESSION[$sessionKey] === true) {
        file_put_contents($logFile, date('Y-m-d H:i:s') . " - Bling Shop ID $shopId já foi processado, redirecionando...\n", FILE_APPEND);
        header('Location: /dash/integracoes');
        exit;
    }

    file_put_contents($logFile, date('Y-m-d H:i:s') . " - Iniciando integração Bling\n", FILE_APPEND);
    file_put_contents($logFile, date('Y-m-d H:i:s') . " - cliente: $cliente\n", FILE_APPEND);
    file_put_contents($logFile, date('Y-m-d H:i:s') . " - id_usuario: $id_usuario\n", FILE_APPEND);
    echo 'loja: '.$loja.'<br>';
    echo 'plataforma: '.$plataforma.'<br>';
    echo 'shop_id: '.$shop_id.'<br>';
    echo 'partner_id: '.$partner_id.'<br>';
    echo 'partner_key: '.$partner_key.'<br>';
    echo 'shopId: '.$shopId.'<br>';
    echo 'access_token: '.$access_token.'<br>';
    echo 'refresh_token: '.$refresh_token.'<br>';
    echo '<br>';
    
    // Calcula data de expiração (6 horas = 21600 segundos)
    $expires_at = date('Y-m-d H:i:s', time() + 21600);
    
    // Antes de inserir, verifica se há produtos de outros fornecedores para esse seller_id
    if ($shopId) {
        // Busca produtos cadastrados para esse seller_id que sejam de outros fornecedores
        $stmtCheckProdutos = $pdo->prepare("
            SELECT DISTINCT pc.fornecedor, f.nome as fornecedor_nome
            FROM drophub_global.produtos_cadastrados pc
            LEFT JOIN drophub_global.fornecedores f ON pc.fornecedor = f.id
            WHERE pc.loja = ? 
            AND pc.id_usuario = ?
            AND pc.fornecedor IS NOT NULL
            AND pc.fornecedor != ''
            AND pc.fornecedor != ?
        ");
        $stmtCheckProdutos->execute([$shopId, $id_usuario, $fornecedor]);
        $fornecedores_conflitantes = $stmtCheckProdutos->fetchAll(PDO::FETCH_ASSOC);

        if (count($fornecedores_conflitantes) > 0) {
            // Tem produtos de outros fornecedores para esse seller_id
            $nomes_fornecedores = array_unique(array_map(function($f) {
                return $f['fornecedor_nome'];
            }, $fornecedores_conflitantes));

            // Busca o nome do fornecedor que está tentando integrar
            $stmtFornecedor = $pdo->prepare("SELECT nome FROM drophub_global.fornecedores WHERE id = ?");
            $stmtFornecedor->execute([$fornecedor]);
            $novo_fornecedor = $stmtFornecedor->fetch(PDO::FETCH_ASSOC);

            // Monta a mensagem
            if (count($nomes_fornecedores) == 1) {
                $mensagem = 'Você precisa remover todos os produtos do fornecedor ' . reset($nomes_fornecedores) . ' para integrar no novo fornecedor ' . $novo_fornecedor['nome'] . '.';
            } else {
                $nomes_array = array_values($nomes_fornecedores);
                $ultimo = array_pop($nomes_array);
                $mensagem = 'Você precisa remover todos os produtos dos fornecedores ' . implode(', ', $nomes_array) . ' e ' . $ultimo . ' para integrar no novo fornecedor ' . $novo_fornecedor['nome'] . '.';
            }

            header('Location: /dash/integracoes?info=' . base64_encode($mensagem));
            exit;
        }
    }
    
    // Salvar no banco usando a função helper
    salvarConexaoAPIGlobal($pdo, [
        'nome' => $loja,
        'user_id' => $id_usuario,
        'seller_id' => $shopId,
        'access_token' => $access_token,
        'code' => $refresh_token,
        'expires_at' => $expires_at,
        'expires_in' => 21600,
        'client_id' => $partner_id,
        'client_secret' => $partner_key,
        'plataforma' => $plataforma,
        'fornecedor' => $fornecedor
    ]);

    // Marca como processado
    $_SESSION[$sessionKey] = true;
    
    file_put_contents($logFile, date('Y-m-d H:i:s') . " - Integração Bling salva com sucesso!\n", FILE_APPEND);

    echo "<p style='color: green;'>✅ Integração do Bling (Cliente) salva com sucesso!</p>";
    echo "<p>Redirecionando para configurações...</p>";
    // Redireciona para a página de integrações
    header('Location: /dash/integracoes');
    exit;
    
} else {
    echo "<p style='color: orange;'>⚠️ Plataforma não reconhecida: {$plataforma}</p>";
}
