<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Garantir que $_SESSION['usuario'] existe e é um array
if (!isset($_SESSION['usuario']) || !is_array($_SESSION['usuario'])) {
    $_SESSION['usuario'] = [];
}

$plano_id = $_SESSION['usuario']['plano_id'] ?? null;
$blur_cards = (is_null($plano_id) || in_array($plano_id, [0, 1, 2]));
$is_affiliate = isset($_SESSION['usuario']['is_affiliate']) && $_SESSION['usuario']['is_affiliate'] == '1' ? 1 : 0;
$path = __DIR__;
$folderName = '';

if (preg_match('/whitelabels\/([^\/]+)/', $path, $matches)) {
    $folderName = $matches[1];
}

$capitiliezedName = ucfirst(strtolower($folderName));

$usuario_id = $_SESSION['usuario']['id_usuario'] ?? null;

// Verificar se há fornecedores em férias
$whitelabel = Config::get('database.dbname');
$fornecedoresEmFerias = verificarFeriasUsuario($pdo, $usuario_id, $whitelabel);
?>

<!-- Estilo para aplicar blur nos cards -->
<?php if ($blur_cards): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.card').forEach(function(card) {
                // Envolve o conteúdo do card em um wrapper para aplicar o blur
                if (!card.querySelector('.blurred-content')) {
                    var content = Array.from(card.childNodes).filter(function(node) {
                        return !(node.classList && node.classList.contains('blurred-card-overlay'));
                    });
                    var wrapper = document.createElement('div');
                    wrapper.className = 'blurred-content';
                    content.forEach(function(node) {
                        wrapper.appendChild(node);
                    });
                    card.appendChild(wrapper);
                }
                // Adiciona overlay apenas se ainda não existir
                if (!card.querySelector('.blurred-card-overlay')) {
                    var overlay = document.createElement('div');
                    overlay.className = 'blurred-card-overlay';
                    overlay.innerHTML = 'Acesso permitido apenas em planos superiores.';
                    card.appendChild(overlay);
                }
            });
        });
    </script>
<?php endif; ?>


<!-- Include validações saude de integrações -->
<?php include __DIR__ . '/../valid_integ.php'; ?>


<!-- Banner no dashboard -->
<?php
$configsBanner = new GeneralConfigs($pdo);
$valroBanner = $configsBanner->getConfigs('banner');

$banner_active = $valroBanner;

$bannerDir = __DIR__ . '/../../uploads/banners/'; // Caminho absoluto para leitura
$bannerWebDir = '../assets/uploads/banners/'; // Caminho web para exibição


$curl = curl_init();

curl_setopt_array($curl, array(
    CURLOPT_URL => Config::get('api_configs.base_url') . 'query/execute',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => '{
    "table": "banners",
    "global": false,
    "filters": {
        "filename": {
            "operator": "NOT LIKE",
            "value": "catalogo_"
        }
    }
}
',
    CURLOPT_HTTPHEADER => array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . Config::get('api_configs.token')
    ),
));

$response = curl_exec($curl);
curl_close($curl);

// Decodifica a resposta JSON da API
$responseData = json_decode($response, true);

$bannerFiles = [];
$bannerLinks = [];

// Processa os dados da API se a requisição foi bem-sucedida
if ($responseData && isset($responseData['success']) && $responseData['success'] === true) {
    if (isset($responseData['data']['data']) && is_array($responseData['data']['data'])) {
        foreach ($responseData['data']['data'] as $banner) {
            $bannerFiles[] = $banner['filename'];
            $bannerLinks[$banner['filename']] = $banner['link'];
        }
    }
}
$noBannerPath = $bannerDir . 'nobanner.png';
$noBannerWeb = $bannerWebDir . 'nobanner.png';
if ($banner_active == 1) {
?>
    <div class="container-fluid px-0">
        <div class="col-12 mb-3">
                <div class="p-0 card-body text-center">
                    <?php if (count($bannerFiles) > 0) { ?>
                        <div id="bannerCarousel" class="carousel slide" data-bs-ride="carousel">
                            <div class="carousel-inner">
                                <?php foreach ($bannerFiles as $idx => $file):
                                    $active = $idx === 0 ? 'active' : '';
                                    $imgUrl = $bannerWebDir . $file;
                                    $link = htmlspecialchars($bannerLinks[$file]);
                                ?>
                                    <div class="carousel-item <?= $active ?>">
                                        <a href="<?= $link ?>" target="_blank">
                                            <img src="<?= $imgUrl ?>" class="d-block w-100 rounded img-fluid" alt="Banner">
                                        </a>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <button class="carousel-control-prev" type="button" data-bs-target="#bannerCarousel" data-bs-slide="prev">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Previous</span>
                            </button>
                            <button class="carousel-control-next" type="button" data-bs-target="#bannerCarousel" data-bs-slide="next">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Next</span>
                            </button>
                        </div>
                    <?php } elseif (file_exists($noBannerPath)) { ?>
                        <img src="<?= $noBannerWeb ?>" alt="Banner não encontrado" class="rounded img-fluid">
                    <?php } ?>
                </div>
        </div>
    </div>
<?php
    $col1 = 'col-lg-4 col-sm-6';
    $col2 = 'col-lg-8 col-sm-6';
} else {
    $col1 = 'col-12 col-md-6';
    $col2 = 'col-12 col-md-6';
}
?>

<!-- Conteúdo do Dashboard -->
<div class="container-fluid px-0">
    <!-- Aviso de Férias -->
    <?php if (!empty($fornecedoresEmFerias)): ?>
    <div class="row g-4 mb-4">
        <div class="col-12">
            <div class="alert alert-warning alert-dismissible fade show shadow-sm" role="alert">
                <h5 class="alert-heading">
                    <i class="ti ti-beach me-2"></i>
                    <strong>Fornecedor<?php echo count($fornecedoresEmFerias) > 1 ? 'es' : ''; ?> de Férias!</strong>
                </h5>
                <hr>
                <?php foreach ($fornecedoresEmFerias as $fornecedor): ?>
                <div class="mb-2">
                    <strong>🏖️ <?php echo htmlspecialchars($fornecedor['nome']); ?></strong> está de férias no período de 
                    <strong><?php echo $fornecedor['ferias_de']; ?></strong> até <strong><?php echo $fornecedor['ferias_ate']; ?></strong>.
                </div>
                <?php endforeach; ?>
                <hr>
                <p class="mb-0">
                    <i class="ti ti-info-circle me-1"></i>
                    Durante este período, os produtos deste<?php echo count($fornecedoresEmFerias) > 1 ? 's' : ''; ?> fornecedor<?php echo count($fornecedoresEmFerias) > 1 ? 'es' : ''; ?> estarão temporariamente indisponíveis.
                    <strong>Ative o modo férias nos seus marketplaces para evitar vendas.</strong>
                </p>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="row g-4 mb-4">
        <?php if (!isset($ocultar_mural_de_avisos) || $ocultar_mural_de_avisos == false) { ?>

            <!-- Mural de Avisos -->
            <div class="col-12 col-lg-8">
                <div class="card border-1 h-100">
                    <div class="card-header bg-white border-bottom-2 border-primary">
                        <div class="d-flex align-items-center">
                            <i class="ti ti-bell me-2 text-primary"></i>
                            <h5 class="mb-0 fw-semibold text-dark">Mural de Avisos</h5>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="overflow-auto" style="max-height: 300px;">
                            <?php
                            $usuario_email = $_SESSION['usuario']['email'];
                            $whitelabel_atual = trim(strtolower(Config::get('site_configs.name')));

                            // Buscar avisos da API usando query customizada (suporta OR)
                            $curlAvisos = curl_init();

                            if ($is_affiliate == 1) {
                                // Query para afiliados - mostra avisos do whitelabel ou globais
                                $sqlAvisos = "SELECT * FROM drophub_global.avisos 
                                             WHERE status = :status 
                                             AND (whitelabel = :whitelabel1 OR whitelabel = 'all')
                                             ORDER BY id DESC 
                                             LIMIT 50";

                                $paramsAvisos = [
                                    "status" => 1,
                                    "whitelabel1" => $whitelabel_atual
                                ];
                            } else {
                                // Query para usuários normais - lógica completa com OR
                                $sqlAvisos = "SELECT * FROM drophub_global.avisos 
                                             WHERE status = :status 
                                             AND (
                                                 (usuario = 'all' AND whitelabel = 'all')
                                                 OR (usuario = :usuario_email1 AND whitelabel = 'all')
                                                 OR (usuario = :usuario_email2 AND whitelabel = :whitelabel1)
                                                 OR (usuario = 'all' AND whitelabel = :whitelabel2)
                                             )
                                             ORDER BY id DESC 
                                             LIMIT 50";

                                $paramsAvisos = [
                                    "status" => 1,
                                    "usuario_email1" => $usuario_email,
                                    "usuario_email2" => $usuario_email,
                                    "whitelabel1" => $whitelabel_atual,
                                    "whitelabel2" => $whitelabel_atual
                                ];
                            }

                            curl_setopt_array($curlAvisos, array(
                                CURLOPT_URL => Config::get('api_configs.base_url') . 'query/custom',
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => '',
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => 'POST',
                                CURLOPT_POSTFIELDS => json_encode([
                                    "sql" => $sqlAvisos,
                                    "params" => $paramsAvisos
                                ]),
                                CURLOPT_HTTPHEADER => array(
                                    'Content-Type: application/json',
                                    'Authorization: Bearer ' . Config::get('api_configs.token')
                                ),
                            ));

                            $responseAvisos = curl_exec($curlAvisos);
                            curl_close($curlAvisos);

                            // Decodifica a resposta JSON da API
                            $responseDataAvisos = json_decode($responseAvisos, true);

                            $avisos = [];

                            // Processa os dados da API se a requisição foi bem-sucedida
                            if ($responseDataAvisos && isset($responseDataAvisos['success']) && $responseDataAvisos['success'] === true) {
                                if (isset($responseDataAvisos['data']['data']) && is_array($responseDataAvisos['data']['data'])) {
                                    $avisos = $responseDataAvisos['data']['data'];
                                }
                            }
                            $cores = [
                                'info' => 'primary',
                                'alerta' => 'warning',
                                'sucesso' => 'success',
                                'erro' => 'danger',
                                'warning' => 'warning',
                                'importante' => 'dark',
                                'sistema' => 'secondary',
                                'promocao' => 'info',
                                'novidade' => 'success',
                                'personalizado' => 'primary',
                            ];
                            if ($avisos) {
                                echo '<div class="list-group list-group-flush">';
                                $i = 0;
                                foreach ($avisos as $aviso) {
                                    $cor = $cores[$aviso['tipo']] ?? 'primary';
                                    $id = 'aviso' . $i;
                                    $preview = htmlspecialchars(limitarTexto($aviso['aviso'], 60));
                                    $data = isset($aviso['created_at']) ? date('d/m/Y H:i', strtotime($aviso['created_at'])) : '';
                                    $tipo = htmlspecialchars($aviso['tipo']);

                                    echo '<div class="list-group-item border-0 py-3">';
                                    echo '  <div class="d-flex justify-content-between align-items-start">';
                                    echo '    <div class="me-2 flex-grow-1">';
                                    echo '      <div class="d-flex align-items-center mb-2">';
                                    echo '        <span class="badge bg-' . $cor . ' me-2">' . strtoupper($tipo) . '</span>';
                                    echo '        <small class="text-muted">' . $data . '</small>';
                                    echo '      </div>';
                                    echo '      <p class="mb-0 text-dark">' . nl2br(htmlspecialchars($aviso['aviso'])) . '</p>';
                                    echo '    </div>';
                                    echo '  </div>';
                                    if ($i < count($avisos) - 1) echo '<hr class="my-2">';
                                    echo '</div>';
                                    $i++;
                                }
                                echo '</div>';
                            } else {
                                echo '<div class="text-center py-4">';
                                echo '  <i class="ti ti-info-circle text-muted display-6"></i>';
                                echo '  <p class="text-muted mt-2 mb-0">Nenhum aviso disponível no momento</p>';
                                echo '</div>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Cards Laterais -->
            <div class="col-12 col-lg-4">
                <div class="row g-3">
                    <?php if (!isset($ocultar_boas_vindas) || $ocultar_boas_vindas == false) { ?>
                        <div class="col-12">
                            <div class="card border border-success h-100">
                                <div class="card-body text-center py-4">
                                    <?php
                                    $vendaSemana = new Vendas($pdo, Config::get('api_configs.base_url'), Config::get('api_configs.token'));
                                    $whitelabel = Config::get('database.dbname');

                                    if ($is_affiliate == 1) {
                                        $parametrosSemana = $vendaSemana->getQuantiaVendasAffiliate(7, $whitelabel);
                                    } else {
                                        $parametrosSemana = $vendaSemana->getQuantiaVendasByUsuarioTime($_SESSION['usuario']['id_usuario'], 7, $whitelabel);
                                    }
                                    ?>
                                    <div class="mb-3">
                                        <span style="font-size: 2rem;">👋</span>
                                    </div>
                                    <h4 class="mb-2 text-dark">
                                        <?= $parametrosSemana >= 1 ? 'Bom trabalho' : 'Olá' ?>, <?= explode(' ', $_SESSION['usuario']['nome'])[0] ?>!
                                    </h4>
                                    <?php
                                    if ($parametrosSemana == 0) {
                                        $vendaMsg = '<span class="text-secondary fw-bold">nenhuma venda</span>';
                                    } else {
                                        $vendaMsg = '<span class="text-success fw-bold">' . $parametrosSemana . '</span> ' . ($parametrosSemana > 1 ? 'vendas' : 'venda');
                                    }
                                    ?>
                                    <p class="text-muted mb-0">Você realizou <?= $vendaMsg ?> esta semana!</p>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <?php if (!isset($ocultar_card_de_duvidas) || $ocultar_card_de_duvidas == false) { ?>
                        <div class="col-12">
                            <div class="card border border-primary h-100">
                                <div class="card-body text-center py-4">
                                    <i class="ti ti-help-circle text-primary mb-3" style="font-size: 3rem;"></i>
                                    <h6 class="mb-3 text-dark">Tem dúvidas sobre o sistema?</h6>
                                    <a href="/dash/videos" class="btn btn-primary btn-lg w-100">
                                        <i class="ti ti-video me-2"></i>
                                        Ver Tutoriais
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } else { ?>
            <!-- Layout quando mural está oculto -->
            <?php if (!isset($ocultar_boas_vindas) || $ocultar_boas_vindas == false || !isset($ocultar_card_de_duvidas) || $ocultar_card_de_duvidas == false) { ?>
                <?php if (!isset($ocultar_boas_vindas) || $ocultar_boas_vindas == false) { ?>
                    <div class="col-12 col-md-6">
                        <div class="card border-2 border-success h-100">
                            <div class="card-body text-center py-4">
                                <?php
                                $vendaSemana = new Vendas($pdo, Config::get('api_configs.base_url'), Config::get('api_configs.token'));
                                $whitelabel = Config::get('database.dbname');
                                $parametrosSemana = $vendaSemana->getQuantiaVendasByUsuarioTime($_SESSION['usuario']['id_usuario'], 7, $whitelabel);
                                ?>
                                <div class="mb-3">
                                    <span style="font-size: 3rem;">👋</span>
                                </div>
                                <h4 class="mb-2 text-dark">
                                    <?= $parametrosSemana >= 1 ? 'Bom trabalho' : 'Olá' ?>, <?= explode(' ', $_SESSION['usuario']['nome'])[0] ?>!
                                </h4>
                                <?php
                                if ($parametrosSemana == 0) {
                                    $vendaMsg = '<span class="text-secondary fw-bold">nenhuma venda</span>';
                                } else {
                                    $vendaMsg = '<span class="text-success fw-bold">' . $parametrosSemana . '</span> ' . ($parametrosSemana > 1 ? 'vendas' : 'venda');
                                }
                                ?>
                                <p class="text-muted mb-0">Você realizou <?= $vendaMsg ?> esta semana!</p>
                            </div>
                        </div>
                    </div>
                <?php } ?>

                <?php if (!isset($ocultar_card_de_duvidas) || $ocultar_card_de_duvidas == false) { ?>
                    <div class="col-12 <?= (isset($ocultar_boas_vindas) && $ocultar_boas_vindas == true) ? '' : 'col-md-6' ?>">
                        <div class="card border border-primary h-100">
                            <div class="card-body text-center py-4">
                                <i class="ti ti-help-circle text-primary mb-3" style="font-size: 3rem;"></i>
                                <h6 class="mb-3 text-dark">Tem dúvidas sobre o sistema?</h6>
                                <a href="/dash/videos" class="btn btn-primary btn-lg w-100">
                                    <i class="ti ti-video me-2"></i>
                                    Ver Tutoriais
                                </a>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            <?php } ?>
        <?php } ?>
    </div>


    <!-- Seção de Faturamento -->
    <div class="row g-4 mb-4">
        <?php if (!isset($ocultar_card_de_faturamentos) || $ocultar_card_de_faturamentos == false) { ?>
            <div class="col-12 col-xl-6">
                <div class="card border h-100">
                    <div class="card-header bg-white border-bottom-2 border-success">
                        <div class="d-flex align-items-center">
                            <i class="ti ti-currency-dollar me-2 text-success"></i>
                            <h5 class="mb-0 fw-semibold text-dark">Faturamentos</h5>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <?php
                        $vendas = new Vendas($pdo, Config::get('api_configs.base_url'), Config::get('api_configs.token'));
                        $whitelabel = Config::get('database.dbname');
                        if ($is_affiliate == 1) {
                            $parametros = $vendas->getParametrosVendasByWhitelabel($whitelabel);
                        } else {
                            $parametros = $vendas->getParametrosVendasByUsuario($_SESSION['usuario']['id_usuario'], $whitelabel);
                        }
                        if (is_array($parametros)) {
                        ?>
                            <div class="list-group list-group-flush">
                                <div class="list-group-item d-flex justify-content-between align-items-center py-3 border-0">
                                    <div class="d-flex align-items-center">
                                        <div class="rounded-circle bg-primary p-2 me-3">

                                        </div>
                                        <div>
                                            <h6 class="mb-0 text-dark">Hoje</h6>
                                            <small class="text-muted">Vendas de hoje</small>
                                        </div>
                                    </div>
                                    <div class="text-end">
                                        <h5 class="mb-0 text-primary">R$ <?php echo number_format($parametros['vendas_hoje'], 2, ',', '.') ?></h5>
                                    </div>
                                </div>

                                <div class="list-group-item d-flex justify-content-between align-items-center py-3 border-0">
                                    <div class="d-flex align-items-center">
                                        <div class="rounded-circle bg-success p-2 me-3">
                                        </div>
                                        <div>
                                            <h6 class="mb-0 text-dark">7 Dias</h6>
                                            <small class="text-muted">Última semana</small>
                                        </div>
                                    </div>
                                    <div class="text-end">
                                        <h5 class="mb-0 text-success">R$ <?php echo number_format($parametros['vendas_7dias'], 2, ',', '.') ?></h5>
                                    </div>
                                </div>

                                <div class="list-group-item d-flex justify-content-between align-items-center py-3 border-0">
                                    <div class="d-flex align-items-center">
                                        <div class="rounded-circle bg-info p-2 me-3">

                                        </div>
                                        <div>
                                            <h6 class="mb-0 text-dark">30 Dias</h6>
                                            <small class="text-muted">Último mês</small>
                                        </div>
                                    </div>
                                    <div class="text-end">
                                        <h5 class="mb-0 text-info">R$ <?php echo number_format($parametros['vendas_30dias'], 2, ',', '.') ?></h5>
                                    </div>
                                </div>

                                <div class="list-group-item d-flex justify-content-between align-items-center py-3 border-0">
                                    <div class="d-flex align-items-center">
                                        <div class="rounded-circle bg-warning p-2 me-3">
                                        </div>
                                        <div>
                                            <h6 class="mb-0 text-dark">90 Dias</h6>
                                            <small class="text-muted">Trimestre</small>
                                        </div>
                                    </div>
                                    <div class="text-end">
                                        <h5 class="mb-0 text-warning">R$ <?php echo number_format($parametros['vendas_90dias'], 2, ',', '.') ?></h5>
                                    </div>
                                </div>

                                <div class="list-group-item d-flex justify-content-between align-items-center py-3 border-0">
                                    <div class="d-flex align-items-center">
                                        <div class="rounded-circle bg-secondary p-2 me-3">
                                        </div>
                                        <div>
                                            <h6 class="mb-0 text-dark">Total Geral</h6>
                                            <small class="text-muted">Todos os períodos</small>
                                        </div>
                                    </div>
                                    <div class="text-end">
                                        <h5 class="mb-0 text-dark">R$ <?php echo number_format($parametros['vendas_todoPeriodo'], 2, ',', '.') ?></h5>
                                    </div>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="card-body text-center py-4">
                                <i class="ti ti-alert-circle text-danger display-6"></i>
                                <p class="text-danger mt-2 mb-0">Erro ao carregar dados: <?= $parametros ?></p>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (!isset($ocultar_grafico_de_faturamentos) || $ocultar_grafico_de_faturamentos == false) { ?>
            <div class="col-12 col-xl-6">
                <div class="card border h-100">
                    <div class="card-header bg-white border-bottom-2 border-info">
                        <div class="d-flex align-items-center">
                            <i class="ti ti-chart-line me-2 text-info"></i>
                            <h5 class="mb-0 fw-semibold text-dark">Gráfico de Vendas</h5>
                        </div>
                    </div>
                    <div class="card-body mt-3">
                        <?php
                        $whitelabel = Config::get('database.dbname');
                        $vendas = new Vendas($pdo, Config::get('api_configs.base_url'), Config::get('api_configs.token'));
                        if ($is_affiliate == 1) {
                            $parametros = $vendas->getParametrosVendasByWhitelabel($whitelabel);
                        } else {
                            $parametros = $vendas->getParametrosVendasByUsuario($_SESSION['usuario']['id_usuario'], $whitelabel);
                        }
                        $usuario_id = $_SESSION['usuario']['id_usuario'];
                        if ($is_affiliate == 1) {
                            $dados_grafico = [
                                '7dias' => $vendas->getValoresDiariosPorPeriodoWhitelabel($whitelabel, 7),
                                '30dias' => $vendas->getValoresDiariosPorPeriodoWhitelabel($whitelabel, 30),
                                '90dias' => $vendas->getValoresDiariosPorPeriodoWhitelabel($whitelabel, 90),
                                'todoPeriodo' => $vendas->getValoresDiariosPorPeriodoWhitelabel($whitelabel, 365),
                            ];
                        } else {
                            $dados_grafico = [
                                '7dias' => $vendas->getValoresDiariosPorPeriodo($usuario_id, $whitelabel, 7),
                                '30dias' => $vendas->getValoresDiariosPorPeriodo($usuario_id, $whitelabel, 30),
                                '90dias' => $vendas->getValoresDiariosPorPeriodo($usuario_id, $whitelabel, 90),
                                'todoPeriodo' => $vendas->getValoresDiariosPorPeriodo($usuario_id, $whitelabel, 365),
                            ];
                        }
                        ?>
                        <?php if (is_array($parametros)) { ?>
                            <div class="mb-3">
                                <label for="periodoFaturamento" class="form-label">Período de análise:</label>
                                <select id="periodoFaturamento" class="form-select">
                                    <option value="7dias">Últimos 7 dias</option>
                                    <option value="30dias">Últimos 30 dias</option>
                                    <option value="90dias">Últimos 90 dias</option>
                                    <option value="todoPeriodo">Todo Período</option>
                                </select>
                            </div>

                            <div class="text-center mb-3">
                                <h3 id="valorTotalFaturamento" class="text-success mb-0">
                                    R$ <?php echo number_format($parametros['vendas_7dias'], 2, ',', '.'); ?>
                                </h3>
                                <small class="text-muted">Faturamento do período</small>
                            </div>

                            <div class="chart-container">
                                <canvas id="faturamentoChart" style="height: 200px;"></canvas>
                            </div>

                            <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
                            <script>
                                const parametros = {
                                    '7dias': <?php echo json_encode($parametros['vendas_7dias']); ?>,
                                    '30dias': <?php echo json_encode($parametros['vendas_30dias']); ?>,
                                    '90dias': <?php echo json_encode($parametros['vendas_90dias'] ?? $parametros['vendas_30dias']); ?>,
                                    todoPeriodo: <?php echo json_encode($parametros['vendas_todoPeriodo']); ?>
                                };
                                const dadosGrafico = <?php echo json_encode($dados_grafico); ?>;
                                const selectPeriodo = document.getElementById('periodoFaturamento');
                                const valorTotal = document.getElementById('valorTotalFaturamento');
                                const ctx = document.getElementById('faturamentoChart').getContext('2d');
                                let chart;

                                function atualizaGrafico(periodo) {
                                    const labels = Object.keys(dadosGrafico[periodo]);
                                    const data = Object.values(dadosGrafico[periodo]);
                                    if (labels.length === 0 || data.length === 0) {
                                        console.error('No data available for the selected period:', periodo);
                                        return;
                                    }
                                    if (chart) chart.destroy();
                                    chart = new Chart(ctx, {
                                        type: 'line',
                                        data: {
                                            labels: labels,
                                            datasets: [{
                                                label: 'Faturamento',
                                                data: data,
                                                borderColor: '#0d6efd',
                                                backgroundColor: 'rgba(13,110,253,0.1)',
                                                fill: true,
                                                tension: 0.4,
                                                borderWidth: 2,
                                                pointBackgroundColor: '#0d6efd',
                                                pointBorderColor: '#ffffff',
                                                pointBorderWidth: 2,
                                                pointRadius: 4
                                            }]
                                        },
                                        options: {
                                            responsive: true,
                                            maintainAspectRatio: false,
                                            plugins: {
                                                legend: {
                                                    display: false
                                                }
                                            },
                                            scales: {
                                                x: {
                                                    grid: {
                                                        color: 'rgba(0,0,0,0.1)'
                                                    }
                                                },
                                                y: {
                                                    beginAtZero: true,
                                                    grid: {
                                                        color: 'rgba(0,0,0,0.1)'
                                                    },
                                                    ticks: {
                                                        callback: function(value) {
                                                            return 'R$ ' + value.toLocaleString('pt-BR', {
                                                                minimumFractionDigits: 2
                                                            });
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    });
                                }

                                function atualizarValorTotal(periodo) {
                                    valorTotal.textContent = 'R$ ' + Number(parametros[periodo]).toLocaleString('pt-BR', {
                                        minimumFractionDigits: 2
                                    });
                                }

                                selectPeriodo.addEventListener('change', function() {
                                    const periodo = this.value;
                                    atualizarValorTotal(periodo);
                                    atualizaGrafico(periodo);
                                });

                                // Inicialização
                                atualizarValorTotal('7dias');
                                atualizaGrafico('7dias');
                            </script>
                        <?php } else { ?>
                            <div class="text-center py-4">
                                <i class="ti ti-alert-circle text-danger display-6"></i>
                                <p class="text-danger mt-2 mb-0">Erro ao carregar dados: <?= $parametros ?></p>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>

    <!-- Seção de Vendas por Canal e Fornecedores -->
    <div class="row g-4 mb-4">
        <!-- Vendas por Canal -->
        <div class="col-12 col-lg-6">
            <div class="card border h-100">
                <div class="card-header bg-white border-bottom-2 border-warning">
                    <div class="d-flex align-items-center">
                        <i class="ti ti-chart-pie me-2 text-warning"></i>
                        <div>
                            <h5 class="mb-0 fw-semibold text-dark">Vendas por Canal</h5>
                            <small class="text-muted">Distribuição de vendas por integração</small>
                        </div>
                    </div>
                </div>
                <div class="card-body d-flex align-items-center justify-content-center">
                    <div class="chart-container" style="position: relative; height: 300px; width: 100%;">
                        <canvas id="vendasChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Fornecedores -->
        <div class="col-12 col-lg-6" id="fornecedores">
            <div class="card border h-100">
                <div class="card-header bg-white border-bottom-2 border-secondary">
                    <div class="d-flex align-items-center">
                        <i class="ti ti-building-store me-2 text-secondary"></i>
                        <div>
                            <h5 class="mb-0 fw-semibold text-dark">Fornecedores</h5>
                            <small class="text-muted">Lista de fornecedores ativos</small>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="overflow-auto" style="max-height: 350px;">
                        <div class="list-group list-group-flush">
                            <?php
                            // Buscar fornecedores ativos na whitelabel atual usando a função global
                            $fornecedores = getFornecedoresAtivos($pdo, [
                                'order_by' => 'id DESC',
                                'apenas_ativos' => true
                            ]);
                            
                            // Limitar a 10 fornecedores
                            $fornecedores = array_slice($fornecedores, 0, 10);

                            if (count($fornecedores) === 0) { ?>
                                <div class="text-center py-5">
                                    <i class="ti ti-building-store text-muted display-6"></i>
                                    <p class="text-muted mt-2 mb-0">Nenhum fornecedor ativo encontrado</p>
                                </div>
                            <?php } else { ?>
                                <?php foreach ($fornecedores as $index => $fornecedor):
                                    $nicho = trim($fornecedor['nicho']) !== '' ? htmlspecialchars($fornecedor['nicho']) : 'Não informado';
                                    $endereco = trim($fornecedor['endereco']) !== '' ? htmlspecialchars($fornecedor['endereco']) : 'Endereço não cadastrado';
                                    $temEndereco = trim($fornecedor['endereco']) !== '';
                                ?>
                                    <div class="list-group-item border-0 py-3 <?= $index < count($fornecedores) - 1 ? 'border-bottom' : '' ?>">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <h6 class="mb-1 fw-semibold text-dark">
                                                <?= htmlspecialchars($fornecedor['nome']) ?>
                                            </h6>
                                            <span class="badge bg-primary text-white rounded-pill">
                                                <?= $nicho ?>
                                            </span>
                                        </div>

                                        <?php if ($temEndereco) { ?>
                                            <div class="mt-2">
                                                <small class="text-muted d-block mb-1">Endereço (clique para copiar):</small>
                                                <div class="bg-light p-2 rounded cursor-pointer copiar-endereco"
                                                    data-endereco="<?= htmlspecialchars($fornecedor['endereco'], ENT_QUOTES) ?>"
                                                    title="Clique para copiar o endereço">
                                                    <small class="text-dark">
                                                        <i class="ti ti-copy me-1"></i>
                                                        <?= $endereco ?>
                                                    </small>
                                                </div>
                                            </div>
                                        <?php } else { ?>
                                            <small class="text-muted">
                                                <i class="ti ti-map-pin me-1"></i>
                                                Endereço não cadastrado
                                            </small>
                                        <?php } ?>
                                    </div>
                                <?php endforeach; ?>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.copiar-endereco').forEach(function(btn) {
                btn.addEventListener('click', function() {
                    const endereco = this.getAttribute('data-endereco');
                    if (navigator.clipboard) {
                        toastAlert('Endereço copiado com sucesso!', 'success', '2500');
                    } else {
                        toastAlert('Copie manualmente o endereço.', 'error', '2500')
                    }
                });
            });
        });
    </script>

    <!-- Seção de Produtos Mais Vendidos -->
    <div class="row g-4 mb-4">
        <div class="col-12">
            <div class="card border">
                <div class="card-header bg-white border-bottom-2 border-success">
                    <div class="d-flex align-items-center">
                        <i class="ti ti-trophy me-2 text-success"></i>
                        <div>
                            <h5 class="mb-0 fw-semibold text-dark">Mais Vendidos</h5>
                            <small class="text-muted">Lista de produtos com maior volume de vendas</small>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div style="height: max-content;">
                        <div class="row g-3 p-3">
                            <?php
                            $produtos = new Produtos($pdo, Config::get('api_configs.base_url'), Config::get('api_configs.token'));
                            $produtosMaisVendidos = $produtos->getProdutosMaisVendidos(12);

                            // Verificar se $produtosMaisVendidos é um array válido
                            if (is_array($produtosMaisVendidos) && count($produtosMaisVendidos) > 0) {
                                foreach ($produtosMaisVendidos as $produto) {
                                    $img_principal = $produto['imagem_principal'] ?? '';
                                    $img_principal_dir = !empty($img_principal) ? rtrim(dirname($img_principal), '/') . '/thumb.png' : '../../images/produtos_imagens/noimage.jpg';

                                    echo '<div class="col-6 col-md-4 col-lg-3">';
                                    echo '    <div class="card border border-1 shadow-sm h-100">';

                                    // Imagem do produto
                                    echo '        <div class="text-center pt-3 px-3">';
                                    echo '            <img src="' . htmlspecialchars($img_principal_dir) . '" alt="Imagem" class="img-fluid rounded" style="height: 100px; width: 100px; object-fit: cover;">';
                                    echo '        </div>';

                                    // Conteúdo do card
                                    echo '        <div class="card-body text-center p-3">';
                                    echo '            <h6 class="card-title mb-2 fw-semibold" style="font-size: 0.9rem; line-height: 1.3;">' . htmlspecialchars(limitarTexto($produto['titulo'], 45)) . '</h6>';
                                    echo '            <small class="text-primary fw-semibold">' . htmlspecialchars($produto['fornecedor']) . '</small>';
                                    echo '            ';
                                    echo '        </div>';

                                    echo '    </div>';
                                    echo '</div>';
                                }
                            } else {
                                echo '<div class="col-12">';
                                echo '    <div class="text-center py-4">';
                                echo '        <i class="ti ti-package text-muted display-6"></i>';
                                echo '        <p class="text-muted mt-2 mb-0">Nenhum produto mais vendido encontrado</p>';
                                echo '    </div>';
                                echo '</div>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Scripts gerais do dashboard -->
<script>
    <?php
    $vendas = new Vendas($pdo, Config::get('api_configs.base_url'), Config::get('api_configs.token'));

    if ($is_affiliate == 1) {
        $vendasPorIntegracao = $vendas->getVendasPorIntegracaoWhitelabel($whitelabel);
    } else {
        $vendasPorIntegracao = $vendas->getVendasPorIntegracao($_SESSION['usuario']['id_usuario'], $whitelabel);
    }
    ?>
    const vendasData = <?php echo json_encode($vendasPorIntegracao); ?>;

    if (!Array.isArray(vendasData) || vendasData.length === 0) {
        console.error('No data available for the Vendas por canal chart.');
    } else {
        // Mapeamento de cores por integração
        const coresPorIntegracao = {
            "Mercado Livre": "#ffe600",
            "mercado_livre": "#ffe600",
            "shopee": "#ee4d2d",
            "Shopee": "#ee4d2d",
            "Magalu": "#0086ff",
            "Shopify": "#95bf47",
            "Yampi": "#503296",
            "Bling": "#9ebb13",
            "B2W": "#06e3bd",
            "Via Varejo": "#497fec",
            "Nuvemshop": "#004dbd",
            "Americanas": "#ff0000",
            "Amazon": "#ff9900",
            "Elo7": "#ff6f00",
            "Etsy": "#f56400",
            "Outros": "#a4b6dbff"
        };

        // Função para normalizar nomes de integração
        function normalizarIntegracao(integracao) {
            const normalizacoes = {
                "mercado_livre": "Mercado Livre",
                "shopee": "Shopee",
                "magalu": "Magalu",
                "shopify": "Shopify",
                "yampi": "Yampi",
                "bling": "Bling",
                "b2w": "B2W",
                "via_varejo": "Via Varejo",
                "nuvemshop": "Nuvemshop",
                "americanas": "Americanas",
                "amazon": "Amazon",
                "elo7": "Elo7",
                "etsy": "Etsy"
            };
            return normalizacoes[integracao.toLowerCase()] || integracao;
        }

        // Prepara os dados para o gráfico
        const labels = vendasData.map(item => normalizarIntegracao(item.integracao));
        const quantidades = vendasData.map(item => item.total_vendas);
        const valores = vendasData.map(item => item.total_valor);

        // Associa cores com base nos labels
        const backgroundColors = labels.map(label => coresPorIntegracao[label] || '#E7E9ED'); // Cor padrão caso não esteja mapeado

        // Cria o gráfico de pizza
        const ctx = document.getElementById('vendasChart').getContext('2d');
        const vendasChart = new Chart(ctx, {
            type: 'pie',
            data: {
                labels: labels,
                datasets: [{
                    label: 'Dados de Vendas',
                    data: quantidades, // A base do gráfico será a quantidade de vendas
                    backgroundColor: backgroundColors,
                    borderColor: '#FFF',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const index = context.dataIndex;
                                const quantidade = quantidades[index];
                                const valor = valores[index];
                                const integracao = labels[index];
                                return [
                                    `Integração: ${integracao}`,
                                    `Vendas: ${quantidade}`,
                                    `Total: R$ ${valor.toLocaleString('pt-BR', { minimumFractionDigits: 2 })}`
                                ];
                            }
                        }
                    },
                    legend: {
                        position: 'top'
                    }
                }
            }
        });
    }
</script>