<?php
class getStatus
{
    private $pdo;

    public function __construct($pdo)
    {
        $this->pdo = $pdo;
    }

    public function getStatus($pertence)
    {
        try {
            // Permitir array ou string simples
            if (!is_array($pertence)) {
                $pertence = [$pertence];
            }
            // Monta placeholders para IN
            $placeholders = implode(',', array_fill(0, count($pertence), '?'));
            $stmt = $this->pdo->prepare('SELECT * FROM status WHERE pertence IN (' . $placeholders . ')');
            foreach ($pertence as $i => $valor) {
                $stmt->bindValue($i + 1, $valor, PDO::PARAM_STR);
            }
            $stmt->execute();
            $status = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if ($status) {
                return $status;
            } else {
                return [];
            }
        } catch (PDOException $e) {
            return "Erro ao consultar os dados: " . $e->getMessage();
        }
    }
}
?>
