<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

date_default_timezone_set('America/Sao_Paulo');

require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
include_once('../../funcoes/general.php');

// Carrega traduções
$traducao = require '../../custom/translations/pt-br.php';


require '../../class/walletClass.php';
require '../../class/refresh_token_shopee.php';
require '../../class/getPlanosConfig.php';
require '../../class/vendasClass.php';
require '../../class/produtosClass.php';
require '../../class/usuariosApiContas.php';
require '../../class/usuariosApiContasClass.php';


// Verifica se está logado ou não
if (!isset($_SESSION['usuario']['email'])) {
    header('Location: /login');
    exit();
}

$customBase = __DIR__ . '/../../custom/includes/';
if (isset($_SESSION['usuario']['is_adm']) && $_SESSION['usuario']['is_adm'] == 1) {
    $customDir = $customBase . 'admin/';
} else {
    $customDir = $customBase . 'user/';
}

if (is_dir($customDir)) {
    foreach (glob($customDir . '*.php') as $filename) {
        include_once $filename;
    }
}

if ($_SESSION['usuario']['is_adm'] != '1' && $is_supplier != 1) {
    header('Location: /dash/dashboard');
    exit();
}

$is_supplier = $_SESSION['usuario']['is_supplier'];
$id_usuario = $_SESSION['usuario']['id_usuario'];

// Valida Sessoes e atualiza dados
validarSessaoUsuario($pdo, $_SESSION['usuario']['id_usuario']);

?>


<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer-starter">

<head>
    <?php include('../../includes/dashHead.php'); ?>

    <link rel="stylesheet" href="../../assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/swiper/swiper.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/pages/cards-advance.css" />

    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/vendor/js/template-customizer.js"></script>
    <script src="../../assets/js/config.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
    <script src="../../assets/js/funcoes.js"></script>

</head>

<body>

    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo mt-3">
                    <a href="dashboard" class="app-brand-link">

                        <?php
                        if (Config::get('site_configs.text_icon') == true) {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                            <span class="app-brand-text text-body fw-bold ms-1"><?php echo Config::get('site_configs.name'); ?></span>
                        <?php
                        } else {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                        <?php
                        }
                        ?>

                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                        <i class="ti menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
                        <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1">
                    <?php
                    if ($_SESSION['usuario']['n_acesso'] == '0') {
                        include('../../includes/sidebars-menus/sidebar_usuario.php');
                    } else {
                        include('../../includes/sidebars-menus/sidebar_master.php');
                    }
                    ?>

                </ul>
            </aside>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="ti ti-menu-2 ti-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <?php include('../../includes/dashnav.php') ?>

                    </div>
                </nav>

                <!-- / Navbar -->



                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <div class="container-xxl flex-grow-1 container-p-y">
                            <div class="mt-3">
                                <div class="card border-none p-2 shadow-none rounded bg-transparent">

                                    <div class="col-12">
                                        <div class="card mb-2">
                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                <h5 class="mb-0 card-title">Gerenciar Configurações <small class="text-muted">[Do Fornecedor]</small></h5>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="d-flex gap-2 w-100">

                                        <div class="card w-50 mb-2">
                                            <div class="card-header pb-2 h5">
                                                <div class="d-flex flex-row justify-content-between gap-3">
                                                    <div>
                                                        <p class="h5 mb-1">Modo Férias</p>
                                                        <small class="text-muted">Ative aqui o "modo férias" do seu fornecedor!</small>
                                                    </div>
                                                    <div>
                                                        <i class="ti ti-confetti fs-1 text-primary"></i>
                                                    </div>
                                                </div>
                                                <hr class="mx-auto w-100">
                                            </div>

                                            <div class="card-body mt-3 mb-1">
                                                <?php
                                                // Buscar informações de férias do fornecedor - TABELA GLOBAL
                                                $id_fornecedor = pegaPrefixo() . $_SESSION['usuario']['id_usuario'];
                                                
                                                try {
                                                    $stmt = $pdo->prepare("SELECT ferias_ativo, ferias_de, ferias_ate FROM drophub_global.fornecedores WHERE id = ?");
                                                    $stmt->execute([$id_fornecedor]);
                                                    $dadosFerias = $stmt->fetch(PDO::FETCH_ASSOC);
                                                    
                                                    $feriasAtivo = $dadosFerias['ferias_ativo'] ?? 0;
                                                    $feriasDE = $dadosFerias['ferias_de'] ?? null;
                                                    $feriasATE = $dadosFerias['ferias_ate'] ?? null;
                                                } catch (PDOException $e) {
                                                    error_log("Erro ao buscar dados de férias: " . $e->getMessage());
                                                    $feriasAtivo = 0;
                                                    $feriasDE = null;
                                                    $feriasATE = null;
                                                }
                                                ?>
                                                
                                                <div id="statusFeriasContainer">
                                                    <?php if ($feriasAtivo == 1 && $feriasDE && $feriasATE): ?>
                                                        <div class="alert alert-warning">
                                                            <div class="d-flex align-items-center justify-content-between">
                                                                <div>
                                                                    <strong><i class="ti ti-beach me-1"></i> Modo Férias Ativo</strong><br>
                                                                    <small>De: <?= date('d/m/Y', strtotime($feriasDE)) ?> até <?= date('d/m/Y', strtotime($feriasATE)) ?></small>
                                                                </div>
                                                                <button class="btn btn-sm btn-danger" onclick="desativarModoFerias()">
                                                                    <i class="ti ti-x"></i> Desativar
                                                                </button>
                                                            </div>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="alert alert-info">
                                                            <i class="ti ti-info-circle me-1"></i> Modo férias desativado
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                
                                                <button class="btn btn-primary w-100" onclick="abrirModalFerias()">
                                                    <i class="ti ti-calendar me-2"></i>
                                                    <?= $feriasAtivo == 1 ? 'Alterar Período de Férias' : 'Ativar Modo Férias' ?>
                                                </button>
                                            </div>
                                        </div>

                                    </div>


                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                <h5 class="mb-0 card-title">Gerenciar Configurações <small class="text-muted">[De Pagamento]</small></h5>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="d-flex gap-2 w-100">

                                        <?php
                                        if (isset($ativar_mp) && $ativar_mp == true) {
                                        ?>
                                            <!-- Primeiro Card -->
                                            <div class="card w-50 mt-2 p-2">

                                                <?php
                                                if ($is_supplier == 1) {
                                                    // 🔹 Certifique-se de que $id_usuario está definido corretamente
                                                    if (!isset($id_usuario) || empty(pegaPrefixo() . $id_usuario)) {
                                                        echo "<div class='alert alert-danger'>Erro: ID do usuário não encontrado.</div>";
                                                        exit;
                                                    }

                                                    try {
                                                        // 🔹 Busca a conexão do Mercado Pago pelo ID do fornecedor
                                                        $stmt = $pdo->prepare("SELECT access_token FROM fornecedores_tokens WHERE id_fornecedor = ?");
                                                        $stmt->execute([pegaPrefixo() . $id_usuario]);
                                                        $fornecedorToken = $stmt->fetch(PDO::FETCH_ASSOC);
                                                    } catch (PDOException $e) {
                                                        echo "<div class='alert alert-danger'>Erro na conexão com o banco: " . $e->getMessage() . "</div>";
                                                        exit;
                                                    }
                                                ?>
                                                    <div class="card-header pb-2 h5">
                                                        <div class="d-flex flex-row justify-content-between gap-3 ">
                                                            <div>
                                                                <p class="h5 mb-1">Conexão Mercado Pago</p>
                                                                <small class="text-muted"><span class="text-info bold">[Merc Pago]</span> Usado para recebimento de preços de custo.</small><br>
                                                            </div>
                                                            <div class="d-flex flex-row gap-2">
                                                                <img src="../../assets/img/icons/brands/mercado_pago.png" width="auto" height="30" class="rounded object-fit-contain" alt="">
                                                            </div>
                                                        </div>
                                                        <hr class="mx-auto w-100">
                                                    </div>


                                                    <div class="card-body mb-1">
                                                        <?php if ($fornecedorToken && !empty($fornecedorToken['access_token'])) { ?>
                                                            <div class="alert alert-success">
                                                                <strong>Token:</strong> <?= htmlspecialchars($fornecedorToken['access_token']); ?>
                                                            </div>

                                                            <form action="/assets/ajax/conexoes/remover_conexao.php" method="POST">
                                                                <input type="hidden" name="id_fornecedor" value="<?= pegaPrefixo() . $id_usuario ?>">
                                                                <input type="hidden" name="plataforma" value="mercado_pago">
                                                                <button type="submit" class="btn btn-danger w-100">
                                                                    Remover Conexão
                                                                </button>
                                                            </form>
                                                        <?php } else { ?>
                                                            <a href="/assets/ajax/conexoes/mp_oauth.php?id=<?= pegaPrefixo() . $id_usuario ?>" class="btn btn-primary w-100">
                                                                Conectar agora
                                                            </a>
                                                        <?php } ?>
                                                    </div>
                                                <?php
                                                } else {
                                                    echo "<div class='alert alert-warning'>Você não é um fornecedor!</div>";
                                                }
                                                ?>

                                            </div>
                                        <?php } ?>



                                        <?php
                                        if (isset($ativar_shipay) && $ativar_shipay == true) {
                                        ?>
                                            <div class="card w-50 mt-2">
                                                <div class="card-header pb-2 h5">
                                                    <div class="d-flex flex-row justify-content-between gap-3 ">
                                                        <div>
                                                            <p class="h5 mb-1">Conexão Shipay</p>
                                                            <small class="text-muted">Utilize este método para receber os pagamentos de preço de custo</small>
                                                        </div>
                                                        <div>
                                                            <img src="../../assets/img/icons/brands/shipay.png" width="auto" height="30" class="rounded object-fit-contain" alt="Logo Shipay">
                                                        </div>
                                                    </div>
                                                    <hr class="mx-auto w-100">
                                                </div>

                                                <div class="card-body mt-3 mb-1">
                                                    <form id="formFornecedoresShipay">
                                                        <div class="mb-3">
                                                            <label for="client_id" class="form-label">Client ID</label>
                                                            <input type="text" class="form-control" id="client_id" name="client_id" required>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="access_key" class="form-label">Access Key</label>
                                                            <input type="text" class="form-control" id="access_key" name="access_key" required>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="secret_key" class="form-label">Secret Key</label>
                                                            <input type="text" class="form-control" id="secret_key" name="secret_key" required>
                                                        </div>
                                                        <div class="mb-3 d-none">
                                                            <label for="id_fornecedor" class="form-label">ID do Fornecedor</label>
                                                            <input type="text" class="form-control" id="id_fornecedor" value="<?= $_SESSION['usuario']['id_usuario'] ?>" name="id_fornecedor" required>
                                                        </div>
                                                        <button type="submit" class="w-100 btn btn-primary">Salvar Tokens</button>
                                                    </form>

                                                    <div id="fornecedorData">

                                                    </div>
                                                </div>
                                            </div>

                                        <?php
                                        }
                                        ?>

                                        <!-- Card EFI (Gerencianet) -->
                                        <div class="card w-50 mt-2">
                                            <div class="card-header pb-2 h5">
                                                <div class="d-flex flex-row justify-content-between gap-3">
                                                    <div>
                                                        <p class="h5 mb-1">Conexão EFÍ</p>
                                                        <small class="text-muted">Configure suas credenciais da EFI para receber pagamentos via PIX</small>
                                                    </div>
                                                    <div>
                                                        <img src="../../assets/img/icons/brands/efi.png" width="auto" height="30" class="rounded object-fit-contain" alt="Logo EFI" onerror="this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTAwIiBoZWlnaHQ9IjMwIiB2aWV3Qm94PSIwIDAgMTAwIDMwIiBmaWxsPSJub25lIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPjxyZWN0IHdpZHRoPSIxMDAiIGhlaWdodD0iMzAiIGZpbGw9IiMwMDdCRkYiLz48dGV4dCB4PSI1MCIgeT0iMjAiIGZvbnQtZmFtaWx5PSJBcmlhbCIgZm9udC1zaXplPSIxOCIgZm9udC13ZWlnaHQ9ImJvbGQiIGZpbGw9IndoaXRlIiB0ZXh0LWFuY2hvcj0ibWlkZGxlIj5FRkk8L3RleHQ+PC9zdmc+'">
                                                    </div>
                                                </div>
                                                <hr class="mx-auto w-100">
                                            </div>

                                            <div class="card-body mt-3 mb-1">
                                                <form id="formFornecedoresEfi">
                                                    <div class="mb-3">
                                                        <label for="efi_client_id" class="form-label">Client ID <span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="efi_client_id" name="client_id" placeholder="Client_Id_xxxxxxxxxx..." required>
                                                        <small class="text-muted">Obtido no painel da EFI em API → Aplicações</small>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label for="efi_client_secret" class="form-label">Client Secret <span class="text-danger">*</span></label>
                                                        <input type="password" class="form-control" id="efi_client_secret" name="client_secret" placeholder="Client_Secret_yyyyyyyyyy..." required>
                                                        <small class="text-muted">Obtido no painel da EFI em API → Aplicações</small>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label for="efi_pix_key" class="form-label">Chave PIX <span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="efi_pix_key" name="pix_key" placeholder="sua-chave@pix.com" required>
                                                        <small class="text-muted">Chave PIX cadastrada na EFI para receber pagamentos</small>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label for="efi_certificado" class="form-label">Certificado Digital (.p12)</label>
                                                        <input type="file" class="form-control" id="efi_certificado" accept=".p12,.pfx">
                                                        <small class="text-muted">Certificado digital no formato P12/PFX fornecido pela EFI (sem senha)</small>
                                                        <div id="efi_cert_status" class="mt-2"></div>
                                                    </div>
                                                    <div class="mb-3 d-none">
                                                        <label for="efi_environment" class="form-label">Ambiente</label>
                                                        <select class="form-select" id="efi_environment" name="environment">
                                                            <option value="production" selected>Produção</option>
                                                            <option value="sandbox">Sandbox (Testes)</option>
                                                        </select>
                                                        <small class="text-muted">Use Sandbox apenas para testes</small>
                                                    </div>
                                                    <div class="mb-3 d-none">
                                                        <input type="text" class="form-control" id="efi_id_fornecedor" value="<?= Config::get('site_configs.prefixo') . $_SESSION['usuario']['id_usuario'] ?>" name="id_fornecedor" required>
                                                    </div>
                                                    <div class="mb-3 d-none">
                                                        <input type="text" class="form-control" id="whitelabel" value="<?= Config::get('database.dbname') ?>" name="whitelabel" required>
                                                    </div>
                                                    <button type="submit" class="w-100 btn btn-primary" disabled>
                                                        <i class="ti ti-device-floppy me-2"></i>Salvar Configurações
                                                    </button>
                                                </form>

                                                <div id="fornecedorDataEfi" class="mt-3">
                                                    <!-- Dados da configuração EFI aparecem aqui -->
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="col-12 mt-5">
                                        <div class="card">
                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                <h5 class="mb-0 card-title">Gerenciar Configurações <small class="text-muted">[De API's]</small></h5>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 col-12 mb-3">
                                            <div class="card mt-2">
                                                <div class="card-header pb-2 h5">
                                                    <div class="d-flex flex-row justify-content-between gap-3 ">
                                                        <div>
                                                            <p class="h5 mb-1"> Conexão Shopee</p>
                                                            <small class="text-muted">Usado para conectar com a shopee para consumir a API.</small>
                                                        </div>
                                                        <div>
                                                            <img src="../../assets/img/icons/brands/shopee.png" width="auto" height="30" class="rounded object-fit-contain" alt="Logo Shopee">
                                                        </div>
                                                    </div>
                                                    <hr class="mx-auto w-100">
                                                </div>
                                                <div class="card-body mt-3 mb-1">

                                                    <?php
                                                    $user_id = $_SESSION['usuario']['id_usuario'];
                                                    $plataforma = 'fornecedor';

                                                    // Criando instância para contar conexões
                                                    $conexaoContas = new ConexaoContas($pdo);
                                                    $totalConexoes = $conexaoContas->contarConexoes($user_id, $plataforma, Config::get('database.dbname'));

                                                    // Criando instância para buscar as contas
                                                    $UsuarioApiConta = new UsuarioApiConta($pdo);
                                                    $ResultConta = $UsuarioApiConta->buscarUsuariosApiContas($plataforma);

                                                    // Verificando se existe conexão
                                                    if ($totalConexoes == 1 && !empty($ResultConta)) {
                                                    ?>
                                                        <div class="alert alert-success">
                                                            <strong>Token:</strong> <?= $ResultConta[0]['access_token'] ?>
                                                        </div>
                                                        <button class="btn btn-danger w-100 mt-3 remove-integ" data-seller="<?= $ResultConta[0]['seller_id'] ?>">Remover Conexão</button>
                                                    <?php
                                                    } else {
                                                    ?>
                                                        <button class="btn btn-primary w-100 mt-3 integrate-admin-btn" plataforma="fornecedor" data-fornecedor="<?= $_SESSION['usuario']['nome'] ?>" data-loja="0" data-user-id="<?= $_SESSION['usuario']['id_usuario'] ?>">Conectar Agora</button>
                                                    <?php
                                                    }
                                                    ?>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12 mb-3">
                                            <div class="card mt-2">
                                                <div class="card-header pb-2 h5">
                                                    <div class="d-flex flex-row justify-content-between gap-3 ">
                                                        <div>
                                                            <p class="h5 mb-1"> Conexão Mercado Livre</p>
                                                            <small class="text-muted">Usado para conectar com o mercado livre para consumir a API</small>
                                                        </div>
                                                        <div>
                                                            <img src="../../assets/img/icons/brands/mercado_livre.png" width="auto" height="30" class="rounded object-fit-contain" alt="Logo Shopee">
                                                        </div>
                                                    </div>
                                                    <hr class="mx-auto w-100">
                                                </div>

                                                <div class="card-body mt-3 mb-1">

                                                    <?php
                                                    $user_id = $_SESSION['usuario']['id_usuario'];
                                                    $plataforma = 'fornecedor_ml';

                                                    // Criando instância para contar conexões
                                                    $conexaoContas = new ConexaoContas($pdo);
                                                    $totalConexoes = $conexaoContas->contarConexoes($user_id, $plataforma, Config::get('database.dbname'));

                                                    // Criando instância para buscar as contas
                                                    $UsuarioApiConta = new UsuarioApiConta($pdo);
                                                    $ResultConta = $UsuarioApiConta->buscarUsuariosApiContas($plataforma);

                                                    // Verificando se existe conexão
                                                    if ($totalConexoes == 1 && !empty($ResultConta)) {
                                                    ?>
                                                        <div class="alert alert-success">
                                                            <strong>Token:</strong> <?= $ResultConta[0]['access_token'] ?>
                                                        </div>
                                                        <button class="btn btn-danger w-100 mt-3 remove-integ" data-seller="<?= $ResultConta[0]['seller_id'] ?>">Remover Conexão</button>
                                                    <?php
                                                    } else {
                                                    ?>
                                                        <button class="btn btn-primary w-100 mt-3 integrate-admin-btn-ml" plataforma="fornecedor_ml" data-fornecedor="<?= $_SESSION['usuario']['nome'] ?>" data-loja="0" data-user-id="<?= $_SESSION['usuario']['id_usuario'] ?>">Conectar Agora</button>
                                                    <?php
                                                    }
                                                    ?>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12 mb-3">
                                            <div class="card mt-2">
                                                <div class="card-header pb-2 h5">
                                                    <div class="d-flex flex-row justify-content-between gap-3 ">
                                                        <div>
                                                            <p class="h5 mb-1"> Conexão Bling</p>
                                                            <small class="text-muted">Usado para fazer a conexão com o Bling para consumir a API</small>
                                                        </div>
                                                        <div>
                                                            <a href="https://youtu.be/WopIAfnBP7g" target="_blank" rel="noopener noreferrer"><img src="../../assets/img/icons/brands/youtube.png" width="auto" height="30" class="rounded object-fit-contain" alt="Logo YT"></a>
                                                            <img src="../../assets/img/icons/brands/bling.png" width="auto" height="30" class="rounded object-fit-contain" alt="Logo Bling">
                                                        </div>
                                                    </div>
                                                    <hr class="mx-auto w-100">
                                                </div>

                                                <div class="card-body mt-3 mb-1">
                                                    <div class="alert alert-primary p-2 px-3">
                                                        <div class="input-group d-flex align-items-center justify-content-between mb-0">
                                                            <span id="endpointBlingText" class="me-2 mb-0" style="user-select:all;word-break:break-all;max-width:100%;display:inline-block;vertical-align:middle;">
                                                                <strong>Endpoint:</strong><?= limitarTexto('https://api-hom.codefly.site/api/v1/alteracao/produtos_bling.php', 33) ?></span>
                                                            <button class="btn mb-0 btn-outline-danger btn-sm align-middle rounded float-end d-flex align-items-center gap-1" type="button" id="copyEndpointBtn" title="Copiar Endpoint"
                                                                data-full-endpoint="https://api-hom.codefly.site/api/v1/alteracao/produtos_bling.php">
                                                                <i class="ti ti-copy"></i> <span class="text-danger"></span>
                                                            </button>
                                                        </div>
                                                    </div>

                                                    <?php
                                                    $user_id = $_SESSION['usuario']['id_usuario'];
                                                    $plataforma = 'fornecedor_bling';

                                                    // Criando instância para contar conexões
                                                    $conexaoContas = new ConexaoContas($pdo);
                                                    $totalConexoes = $conexaoContas->contarConexoes($user_id, $plataforma, Config::get('database.dbname'));

                                                    // Criando instância para buscar as contas
                                                    $UsuarioApiConta = new UsuarioApiConta($pdo);
                                                    $ResultConta = $UsuarioApiConta->buscarUsuariosApiContas($plataforma);

                                                    // Verificando se existe conexão
                                                    if ($totalConexoes == 1 && !empty($ResultConta)) {
                                                    ?>
                                                        <div class="alert alert-success">
                                                            <strong>Token:</strong> <?= $ResultConta[0]['access_token'] ?>
                                                        </div>
                                                        <button class="btn btn-danger w-100 mt-3 remove-integ" data-seller="<?= $ResultConta[0]['seller_id'] ?>">Remover Conexão</button>
                                                    <?php
                                                    } else {
                                                    ?>
                                                        <button class="btn btn-primary w-100 mt-3 integrate-admin-btn-bling" plataforma="fornecedor_bling" data-fornecedor="<?= $_SESSION['usuario']['nome'] ?>" data-loja="0" data-user-id="<?= $_SESSION['usuario']['id_usuario'] ?>">Conectar Agora</button>
                                                    <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <div class="layout-overlay layout-menu-toggle"></div>

        <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->


    <script>
        function logout() {
            Swal.fire({
                toast: true,
                position: "top-end",
                icon: 'success',
                title: 'Você se desconectou com sucesso! Até logo. 😉',
                showConfirmButton: false,
                timer: 2000,
            }).then(function() {
                window.location.href = '/logout';
            });
        }
    </script>

    <script src="../../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../../assets/vendor/libs/popper/popper.js"></script>
    <script src="../../assets/vendor/js/bootstrap.js"></script>
    <script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="../../assets/vendor/libs/hammer/hammer.js"></script>
    <script src="../../assets/vendor/libs/i18n/i18n.js"></script>
    <script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="../../assets/vendor/js/menu.js"></script>
    <script src="../../assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="../../assets/vendor/libs/swiper/swiper.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/dashboards-analytics.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/ui-modals.js"></script>
    <script src="../../assets/js/depositar_saldo.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        $(document).on('click', '.remove-integ', function() {
            const sellerId = $(this).data('seller');

            Swal.fire({
                title: 'Tem certeza?',
                text: 'Você deseja realmente remover esta integração?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sim, remover!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '../../assets/ajax/integracao/remove_conexao.php',
                        type: 'POST',
                        data: {
                            seller_id: sellerId
                        },
                        success: function(response) {
                            Swal.fire({
                                title: 'Removido!',
                                text: 'A integração foi removida com sucesso.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                            }).then(() => {
                                window.location.href = '/dash/configuracoes';
                            });
                        },
                        error: function(xhr, status, error) {
                            Swal.fire(
                                'Erro!',
                                'Ocorreu um erro ao tentar remover a integração.',
                                'error'
                            );
                        }
                    });
                }
            });
        });

        const integrateButtons = document.querySelectorAll('.integrate-admin-btn');
        const integrateButtonsMl = document.querySelectorAll('.integrate-admin-btn-ml');
        const integrateButtonsBling = document.querySelectorAll('.integrate-admin-btn-bling');

        integrateButtons.forEach(button => {
            button.addEventListener('click', function() {
                const plataforma = button.getAttribute('plataforma');
                const fornecedor = button.dataset.fornecedor;
                const loja = button.dataset.loja;
                const userId = button.dataset.userId;

                if (plataforma && fornecedor && loja && userId) {
                    const url = `/assets/ajax/plataformas/shopee/integrar.php?plataforma=${plataforma}&fornecedor=${fornecedor}&loja=${encodeURIComponent(loja)}&user_id=${encodeURIComponent(userId)}`;
                    window.location.href = url;
                } else {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Atenção!',
                        text: 'Por favor, selecione um fornecedor e digite o nome da loja antes de integrar.',
                        confirmButtonText: 'OK'
                    });
                }
            });
        });

        integrateButtonsMl.forEach(button => {
            button.addEventListener('click', function() {
                const plataforma = button.getAttribute('plataforma');
                const fornecedor = button.dataset.fornecedor;
                const loja = button.dataset.loja;
                const userId = button.dataset.userId;

                if (plataforma && fornecedor && loja && userId) {
                    const url = `/assets/ajax/plataformas/mercado_livre/integrar.php?plataforma=${plataforma}&fornecedor=${fornecedor}&loja=${encodeURIComponent(loja)}&user_id=${encodeURIComponent(userId)}`;
                    window.location.href = url;
                } else {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Atenção!',
                        text: 'Por favor, selecione um fornecedor e digite o nome da loja antes de integrar.',
                        confirmButtonText: 'OK'
                    });
                }
            });
        });


        integrateButtonsBling.forEach(button => {
            button.addEventListener('click', function() {
                const plataforma = button.getAttribute('plataforma');
                const fornecedor = button.dataset.fornecedor;
                const loja = button.dataset.loja;
                const userId = button.dataset.userId;

                if (plataforma && fornecedor && loja && userId) {
                    const url = `/assets/ajax/plataformas/bling/integrar.php?plataforma=${plataforma}&fornecedor=${fornecedor}&loja=${encodeURIComponent(loja)}&user_id=${encodeURIComponent(userId)}`;
                    window.location.href = url;
                } else {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Atenção!',
                        text: 'Por favor, selecione um fornecedor e digite o nome da loja antes de integrar.',
                        confirmButtonText: 'OK'
                    });
                }
            });
        });
    </script>
    <script>
        document.getElementById('formFornecedoresPix').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = new FormData(this);
            const fornecedorId = formData.get('id_fornecedor');

            // Enviar via AJAX
            fetch('../../assets/ajax/fornecedores/processar_fornecedores_pix.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Exibe SweetAlert para sucesso
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            text: data.message,
                            confirmButtonText: 'Ok'
                        });
                        loadFornecedorData(fornecedorId); // Recarrega os dados
                    } else {
                        // Exibe SweetAlert para erro
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: data.message,
                            confirmButtonText: 'Ok'
                        });
                    }
                })
                .catch(error => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'Ocorreu um erro ao processar a solicitação.',
                        confirmButtonText: 'Ok'
                    });
                    console.error('Erro:', error);
                });
        });

        // Função para carregar os dados do fornecedor
        function loadFornecedorData(fornecedorId) {
            fetch(`../../assets/ajax/fornecedores/buscar_fornecedores_pix.php?id_fornecedor=${fornecedorId}`)
                .then(response => response.json())
                .then(data => {
                    const fornecedorDataDiv = document.getElementById('fornecedorData');
                    const formFornecedoresPix = document.getElementById('formFornecedoresPix');
                    fornecedorDataDiv.innerHTML = ''; // Limpa a área

                    if (data.exists) {
                        fornecedorDataDiv.innerHTML = `
                            <div class="alert alert-success">
                                <strong>Favorecido:</strong> ${data.favorecido} <br>
                                <strong>Chave PIX:</strong> ${data.chave_pix} - <strong>(${data.tipo_chave.toUpperCase()})</strong>
                            </div>
                            <button class="btn btn-danger w-100" onclick="removeFornecedorPix(${fornecedorId})">Remover Chave PIX</button>
                        `;
                        formFornecedoresPix.classList.add('d-none'); // Esconde o formulário quando existe uma chave
                    } else {
                        formFornecedoresPix.classList.remove('d-none'); // Mostra o formulário quando não existe chave
                    }
                })
                .catch(error => console.error('Erro:', error));
        }

        // Função para remover o fornecedor
        function removeFornecedorPix(fornecedorId) {
            Swal.fire({
                title: 'Você tem certeza?',
                text: "Essa ação irá remover a chave PIX deste fornecedor.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Sim, remover',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch('../../assets/ajax/fornecedores/remover_fornecedor_pix.php', {
                            method: 'POST',
                            body: JSON.stringify({
                                id_fornecedor: fornecedorId
                            })
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Chave PIX Removida!',
                                    text: data.message,
                                    confirmButtonText: 'Ok'
                                });
                                loadFornecedorData(fornecedorId); // Recarrega os dados
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Erro!',
                                    text: data.message,
                                    confirmButtonText: 'Ok'
                                });
                            }
                        })
                        .catch(error => {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: 'Ocorreu um erro ao remover a chave PIX.',
                                confirmButtonText: 'Ok'
                            });
                            console.error('Erro:', error);
                        });
                }
            });
        }

        // Carregar dados do fornecedor automaticamente ao carregar a página
        loadFornecedorData(document.getElementById('id_fornecedor').value);
    </script>

    <script>
        document.getElementById('formFornecedoresShipay').addEventListener('submit', function(e) {
            e.preventDefault();
            const form = e.target;
            const formData = new FormData(form);
            const btn = form.querySelector('button[type="submit"]');
            const originalBtnHtml = btn.innerHTML;

            // Validação dos tokens Shipay
            const clientId = formData.get('client_id').trim();
            const accessKey = formData.get('access_key').trim();
            const secretKey = formData.get('secret_key').trim();

            // Regex baseados nos exemplos fornecidos
            const clientIdRegex = /^[A-Za-z0-9_-]{80,120}$/;
            const accessKeyRegex = /^[A-Za-z0-9_-]{20,30}$/;
            const secretKeyRegex = /^[A-Za-z0-9_-]{50,80}$/;



            btn.disabled = true;
            btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Processando...';
            fetch('../../assets/ajax/plataformas/shipay/salvar_token.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    let msg = document.createElement('div');
                    msg.className = 'mt-3 alert ' + (data.success ? 'alert-success' : 'alert-danger');
                    msg.innerText = data.message || 'Tokens processados.';
                    const container = document.getElementById('fornecedorData');
                    container.innerHTML = '';
                    container.appendChild(msg);
                    loadShipayToken();
                })
                .catch(() => {
                    let msg = document.createElement('div');
                    msg.className = 'mt-3 alert alert-danger';
                    msg.innerText = 'Erro ao salvar os tokens.';
                    const container = document.getElementById('fornecedorData');
                    container.innerHTML = '';
                    container.appendChild(msg);
                })
                .finally(() => {
                    btn.disabled = false;
                    btn.innerHTML = originalBtnHtml;
                });
        });

        function loadShipayToken() {
            const id_fornecedor = document.getElementById('id_fornecedor').value;
            fetch('../../assets/ajax/plataformas/shipay/buscar_token.php?id_fornecedor=' + id_fornecedor)
                .then(response => response.json())
                .then((data) => {
                    const container = document.getElementById('fornecedorData');
                    container.innerHTML = '';
                    if (data.success && data.access_token) {
                        container.innerHTML = `
                    <div class="alert alert-success mt-3">
                        <strong>Access Token cadastrado:</strong><br>
                        <span style="word-break:break-all;">${data.access_token}</span>
                    </div>
                    <button id="removerShipayBtn" class="btn btn-danger w-100 mt-2">Remover Conexão</button>
                `;
                        document.getElementById('formFornecedoresShipay').classList.add('d-none');
                        document.getElementById('removerShipayBtn').onclick = function() {
                            const btn = document.getElementById('removerShipayBtn');
                            const originalBtnHtml = btn.innerHTML;
                            btn.disabled = true;
                            btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Removendo...';
                            Swal.fire({
                                title: 'Tem certeza?',
                                text: 'Deseja remover a conexão Shipay?',
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonText: 'Sim, remover',
                                cancelButtonText: 'Cancelar'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    fetch('../../assets/ajax/plataformas/shipay/remover_token.php', {
                                            method: 'POST',
                                            headers: {
                                                'Content-Type': 'application/x-www-form-urlencoded'
                                            },
                                            body: 'id_fornecedor=' + encodeURIComponent(id_fornecedor)
                                        })
                                        .then(response => response.json())
                                        .then(data => {
                                            if (data.success) {
                                                Swal.fire('Removido!', data.message, 'success').then(() => {
                                                    window.location.reload();
                                                });
                                                document.getElementById('formFornecedoresShipay').reset();
                                                document.getElementById('formFornecedoresShipay').classList.remove('d-none');
                                                container.innerHTML = '';
                                            } else {
                                                Swal.fire('Erro!', data.message, 'error');
                                            }
                                            btn.disabled = false;
                                            btn.innerHTML = originalBtnHtml;
                                        });
                                } else {
                                    btn.disabled = false;
                                    btn.innerHTML = originalBtnHtml;
                                }
                            });
                        };
                    } else {
                        document.getElementById('formFornecedoresShipay').classList.remove('d-none');
                    }
                });
        }

        document.addEventListener('DOMContentLoaded', loadShipayToken);
        document.getElementById('formFornecedoresShipay').addEventListener('submit', function(e) {
            e.preventDefault();
            const form = e.target;
            const formData = new FormData(form);
            const btn = form.querySelector('button[type="submit"]');
            const originalBtnHtml = btn.innerHTML;
            btn.disabled = true;
            btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Processando...';
            fetch('../../assets/ajax/plataformas/shipay/salvar_token.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    let msg = document.createElement('div');
                    msg.className = 'mt-3 alert ' + (data.success ? 'alert-success' : 'alert-danger');
                    msg.innerText = data.message || 'Tokens processados.';
                    const container = document.getElementById('fornecedorData');
                    container.innerHTML = '';
                    container.appendChild(msg);
                    loadShipayToken();
                })
                .catch(() => {
                    let msg = document.createElement('div');
                    msg.className = 'mt-3 alert alert-danger';
                    msg.innerText = 'Erro ao salvar os tokens.';
                    const container = document.getElementById('fornecedorData');
                    container.innerHTML = '';
                    container.appendChild(msg);
                })
                .finally(() => {
                    btn.disabled = false;
                    btn.innerHTML = originalBtnHtml;
                });
        });

        $(function() {
            function validateShipayFields() {
                let valid = true;
                const clientId = $('#client_id').val().trim();
                const accessKey = $('#access_key').val().trim();
                const secretKey = $('#secret_key').val().trim();

                // Regex ajustadas para aceitar padrões reais
                const clientIdRegex = /^[A-Za-z0-9_.-]{40,200}$/;
                const accessKeyRegex = /^[A-Za-z0-9_.-]{10,50}$/;
                const secretKeyRegex = /^[A-Za-z0-9_.-]{30,120}$/;

                // Limpa mensagens anteriores
                $('#client_id').removeClass('is-invalid');
                $('#access_key').removeClass('is-invalid');
                $('#secret_key').removeClass('is-invalid');
                $('.invalid-feedback-shipay').remove();

                if (clientId && !clientIdRegex.test(clientId)) {
                    $('#client_id').addClass('is-invalid')
                        .after('<div class="invalid-feedback-shipay text-danger">Client ID inválido.</div>');
                    valid = false;
                }
                if (accessKey && !accessKeyRegex.test(accessKey)) {
                    $('#access_key').addClass('is-invalid')
                        .after('<div class="invalid-feedback-shipay text-danger">Access Key inválida.</div>');
                    valid = false;
                }
                if (secretKey && !secretKeyRegex.test(secretKey)) {
                    $('#secret_key').addClass('is-invalid')
                        .after('<div class="invalid-feedback-shipay text-danger">Secret Key inválida.</div>');
                    valid = false;
                }
                // Só habilita o botão se todos os campos estiverem preenchidos e válidos
                const allFilled = clientId && accessKey && secretKey;
                $('#formFornecedoresShipay button[type="submit"]').prop('disabled', !(valid && allFilled));
                return valid && allFilled;
            }

            $('#client_id, #access_key, #secret_key').on('input change', validateShipayFields);
            // Validação inicial ao carregar
            validateShipayFields();

            // No submit, só deixa enviar se estiver válido
            $('#formFornecedoresShipay').on('submit', function(e) {
                if (!validateShipayFields()) {
                    e.preventDefault();
                    return false;
                }
            });
        });
    </script>


    <script>
        $(document).on('click', '#copyEndpointBtn', function() {
            const text = $(this).data('full-endpoint');
            if (navigator.clipboard) {
                navigator.clipboard.writeText(text).then(() => {
                    $('#copyEndpointBtn i').removeClass('ti-copy').addClass('ti-check');
                    setTimeout(() => {
                        $('#copyEndpointBtn i').removeClass('ti-check').addClass('ti-copy');
                    }, 1500);
                });
            } else {
                // Fallback para navegadores antigos
                const tempInput = document.createElement('input');
                tempInput.value = text;
                document.body.appendChild(tempInput);
                tempInput.select();
                document.execCommand('copy');
                document.body.removeChild(tempInput);
                $('#copyEndpointBtn i').removeClass('ti-copy').addClass('ti-check');
                setTimeout(() => {
                    $('#copyEndpointBtn i').removeClass('ti-check').addClass('ti-copy');
                }, 1500);
            }
        });
    </script>

    <!-- Scripts para EFI -->
    <script>
        // Carregar configuração EFI ao carregar a página
        document.addEventListener('DOMContentLoaded', loadEfiToken);

        // Submit do formulário EFI
        document.getElementById('formFornecedoresEfi').addEventListener('submit', async function(e) {
            e.preventDefault();
            const form = e.target;
            const formData = new FormData(form);
            const btn = form.querySelector('button[type="submit"]');
            const originalBtnHtml = btn.innerHTML;

            btn.disabled = true;
            btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Salvando...';

            try {
                console.log('🔍 Verificando certificado...');
                const fileInput = document.getElementById('efi_certificado');
                const hasCertificate = fileInput && fileInput.files && fileInput.files[0];

                console.log('   fileInput:', fileInput);
                console.log('   hasCertificate:', hasCertificate);

                if (hasCertificate) {
                    console.log('   Arquivo:', fileInput.files[0].name);
                    console.log('   Tamanho:', fileInput.files[0].size);
                }

                // PRIMEIRO: Salvar as credenciais EFI
                console.log('� Salvando credenciais EFI...');
                const tokenResponse = await fetch('../../assets/ajax/plataformas/efi/salvar_token.php', {
                    method: 'POST',
                    body: formData
                });

                const tokenData = await tokenResponse.json();

                if (!tokenData.success) {
                    throw new Error(tokenData.message);
                }

                console.log('✅ Credenciais EFI salvas com sucesso!');

                // SEGUNDO: Fazer upload do certificado se houver
                if (hasCertificate) {
                    console.log('📤 Fazendo upload do certificado...');

                    const certFormData = new FormData();
                    certFormData.append('certificado', fileInput.files[0]);
                    certFormData.append('id_fornecedor', document.getElementById('efi_id_fornecedor').value);
                    certFormData.append('senha_certificado', ''); // Sem senha

                    console.log('   ID Fornecedor:', document.getElementById('efi_id_fornecedor').value);
                    console.log('   Enviando para upload_certificado.php...');

                    const certResponse = await fetch('../../assets/ajax/plataformas/efi/upload_certificado.php', {
                        method: 'POST',
                        body: certFormData
                    });

                    console.log('   Response status:', certResponse.status);
                    const certData = await certResponse.json();
                    console.log('   Response data:', certData);

                    // Mostrar debug do certificado
                    if (certData.debug) {
                        console.log('=== DEBUG UPLOAD CERTIFICADO ===');
                        certData.debug.forEach(msg => console.log(msg));
                        console.log('================================');
                    }

                    if (!certData.success) {
                        console.warn('⚠️ Erro ao fazer upload do certificado:', certData.message);
                        // Não bloqueia o sucesso das credenciais, apenas avisa
                        $('#efi_cert_status').html(`
                            <div class="alert alert-warning">
                                <i class="ti ti-alert-triangle me-2"></i>
                                Credenciais salvas, mas houve erro no certificado: ${certData.message}
                            </div>
                        `);
                    } else {
                        console.log('✅ Certificado enviado com sucesso!');

                        // Mostrar mensagem de sucesso do certificado
                        $('#efi_cert_status').html(`
                            <div class="alert alert-success">
                                <i class="ti ti-check me-2"></i>
                                Certificado salvo: ${certData.file_name}
                            </div>
                        `);

                        // Limpar campo de certificado
                        fileInput.value = '';
                    }
                } else {
                    console.log('⚠️ Nenhum certificado selecionado.');
                }

                // Mostrar mensagem de sucesso geral
                Swal.fire({
                    icon: 'success',
                    title: 'Sucesso!',
                    text: tokenData.message,
                    confirmButtonText: 'OK'
                });

                loadEfiToken(); // Recarregar dados

            } catch (error) {
                console.error('Erro:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: error.message || 'Erro ao salvar configurações EFI',
                    confirmButtonText: 'OK'
                });
            } finally {
                btn.disabled = false;
                btn.innerHTML = originalBtnHtml;
            }
        });

        // Função para carregar tokens EFI
        function loadEfiToken() {
            const id_fornecedor = document.getElementById('efi_id_fornecedor').value;

            fetch('../../assets/ajax/plataformas/efi/buscar_token.php?id_fornecedor=' + id_fornecedor)
                .then(response => response.json())
                .then((data) => {
                    const container = document.getElementById('fornecedorDataEfi');
                    const form = document.getElementById('formFornecedoresEfi');

                    container.innerHTML = '';

                    if (data.success && data.exists) {
                        // Ocultar formulário e mostrar dados
                        form.classList.add('d-none');

                        const configData = data.data;
                        container.innerHTML = `
                            <div class="alert alert-success">
                                <div class="d-flex justify-content-between align-items-start mb-2">
                                    <div>
                                        <strong><i class="ti ti-check-circle me-1"></i>Configuração Ativa</strong>
                                    </div>
                                    <span class="badge bg-label-${configData.environment === 'production' ? 'success' : 'warning'}">
                                        ${configData.environment_label}
                                    </span>
                                </div>
                                <hr class="my-2">
                                <p class="mb-1"><strong>Client ID:</strong> <code>${configData.client_id}</code></p>
                                <p class="mb-1"><strong>Chave PIX:</strong> <code>${configData.pix_key}</code></p>
                                ${configData.cert_exists ? 
                                    `<p class="mb-1"><strong>Certificado:</strong> <span class="text-success"><i class="ti ti-check"></i> ${configData.cert_file_name}</span></p>` : 
                                    `<p class="mb-1"><strong>Certificado:</strong> <span class="text-warning"><i class="ti ti-alert-triangle"></i> Não configurado</span></p>`
                                }
                                <p class="mb-1"><small class="text-muted">Última atualização: ${configData.updated_at}</small></p>
                            </div>
                            <div class="d-flex gap-2">
                                <button id="editarEfiBtn" class="btn btn-warning w-50">
                                    <i class="ti ti-edit me-1"></i>Editar
                                </button>
                                <button id="removerEfiBtn" class="btn btn-danger w-50">
                                    <i class="ti ti-trash me-1"></i>Remover
                                </button>
                            </div>
                        `;

                        // Botão Editar
                        document.getElementById('editarEfiBtn').onclick = function() {
                            form.classList.remove('d-none');
                            container.innerHTML = '';

                            // Preencher formulário com dados atuais
                            document.getElementById('efi_client_id').value = configData.client_id_full;
                            document.getElementById('efi_pix_key').value = configData.pix_key;
                            document.getElementById('efi_environment').value = configData.environment;

                            // Mostrar status do certificado
                            if (configData.cert_exists) {
                                document.getElementById('efi_cert_status').innerHTML = `
                                    <div class="alert alert-success d-flex align-items-center">
                                        <i class="ti ti-file-certificate me-2"></i>
                                        <div class="flex-grow-1">
                                            <strong>Certificado configurado:</strong> ${configData.cert_file_name}
                                            <br><small class="text-muted">Caminho: ${configData.cert_path}</small>
                                        </div>
                                    </div>
                                `;
                            } else {
                                document.getElementById('efi_cert_status').innerHTML = `
                                    <div class="alert alert-warning">
                                        <i class="ti ti-alert-triangle me-2"></i>
                                        Nenhum certificado configurado - é necessário fazer upload do arquivo .p12
                                    </div>
                                `;
                            }

                            validateEfiFields(); // Validar campos
                        };

                        // Botão Remover
                        document.getElementById('removerEfiBtn').onclick = function() {
                            Swal.fire({
                                title: 'Tem certeza?',
                                text: 'Você deseja remover a configuração da EFI?',
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#d33',
                                cancelButtonColor: '#3085d6',
                                confirmButtonText: 'Sim, remover!',
                                cancelButtonText: 'Cancelar'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    fetch('../../assets/ajax/plataformas/efi/remover_token.php', {
                                            method: 'POST',
                                            headers: {
                                                'Content-Type': 'application/json'
                                            },
                                            body: JSON.stringify({
                                                id_fornecedor: id_fornecedor
                                            })
                                        })
                                        .then(response => response.json())
                                        .then(data => {
                                            if (data.success) {
                                                Swal.fire({
                                                    icon: 'success',
                                                    title: 'Removido!',
                                                    text: data.message,
                                                    confirmButtonText: 'OK'
                                                });
                                                form.classList.remove('d-none');
                                                form.reset();
                                                container.innerHTML = '';
                                                validateEfiFields();
                                            } else {
                                                Swal.fire({
                                                    icon: 'error',
                                                    title: 'Erro!',
                                                    text: data.message,
                                                    confirmButtonText: 'OK'
                                                });
                                            }
                                        });
                                }
                            });
                        };
                    } else {
                        // Mostrar formulário
                        form.classList.remove('d-none');
                    }
                })
                .catch(error => console.error('Erro ao carregar EFI:', error));
        }

        // Validação dos campos EFI
        function validateEfiFields() {
            const clientId = $('#efi_client_id').val().trim();
            const clientSecret = $('#efi_client_secret').val().trim();
            const pixKey = $('#efi_pix_key').val().trim();

            // Limpar erros anteriores
            $('#efi_client_id, #efi_client_secret, #efi_pix_key').removeClass('is-invalid');
            $('.invalid-feedback-efi').remove();

            let valid = true;

            // Validar Client ID (mínimo 40 caracteres)
            if (clientId && clientId.length < 40) {
                $('#efi_client_id').addClass('is-invalid')
                    .after('<div class="invalid-feedback-efi text-danger d-block">Client ID muito curto (mínimo 40 caracteres)</div>');
                valid = false;
            }

            // Validar Client Secret (mínimo 40 caracteres)
            if (clientSecret && clientSecret.length < 40) {
                $('#efi_client_secret').addClass('is-invalid')
                    .after('<div class="invalid-feedback-efi text-danger d-block">Client Secret muito curto (mínimo 40 caracteres)</div>');
                valid = false;
            }

            // Validar Chave PIX (mínimo 5 caracteres)
            if (pixKey && pixKey.length < 5) {
                $('#efi_pix_key').addClass('is-invalid')
                    .after('<div class="invalid-feedback-efi text-danger d-block">Chave PIX inválida</div>');
                valid = false;
            }

            // Habilitar/desabilitar botão
            const allFilled = clientId && clientSecret && pixKey;
            $('#formFornecedoresEfi button[type="submit"]').prop('disabled', !(valid && allFilled));

            return valid && allFilled;
        }

        // Validação em tempo real
        $(function() {
            $('#efi_client_id, #efi_client_secret, #efi_pix_key').on('input change', validateEfiFields);
            validateEfiFields(); // Validação inicial

            // Handler para seleção de arquivo de certificado
            $('#efi_certificado').on('change', function() {
                const file = this.files[0];

                if (file) {
                    // Validar extensão
                    const fileName = file.name.toLowerCase();
                    if (!fileName.endsWith('.p12') && !fileName.endsWith('.pfx')) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Arquivo inválido',
                            text: 'Por favor, selecione um arquivo .p12 ou .pfx'
                        });
                        this.value = '';
                        return;
                    }

                    // Validar tamanho (máximo 5MB)
                    if (file.size > 5 * 1024 * 1024) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Arquivo muito grande',
                            text: 'O arquivo deve ter no máximo 5MB'
                        });
                        this.value = '';
                        return;
                    }

                    // Mostrar mensagem de pronto
                    $('#efi_cert_status').html(`
                        <div class="alert alert-info">
                            <i class="ti ti-info-circle me-2"></i>
                            Certificado pronto para envio. Clique em "Salvar Configurações" para finalizar.
                        </div>
                    `);
                } else {
                    $('#efi_cert_status').html('');
                }
            });
        });
    </script>

    <!-- Scripts Modo Férias -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/pt.js"></script>
    
    <script>
        // Função para abrir modal de configuração de férias
        function abrirModalFerias() {
            Swal.fire({
                title: '<i class="ti ti-beach"></i> Configurar Modo Férias',
                html: `
                    <div class="text-start">
                        <div class="mb-3">
                            <label for="periodo_ferias" class="form-label">Selecione o período de férias:</label>
                            <input type="text" id="periodo_ferias" class="form-control" placeholder="Selecione a data inicial e final" readonly>
                            <small class="text-muted">As datas devem ser iguais ou posteriores à data atual.</small>
                        </div>
                        <div class="alert alert-info">
                            <small><i class="ti ti-info-circle me-1"></i> Durante o modo férias, seus produtos ficarão inativos temporariamente em nossa plataforma, oriente aos clientes a ativar o modo férias nos marketplaces também.</small>
                        </div>
                    </div>
                `,
                showCancelButton: true,
                confirmButtonText: '<i class="ti ti-check me-1"></i> Ativar Férias',
                cancelButtonText: '<i class="ti ti-x me-1"></i> Cancelar',
                width: '600px',
                didOpen: () => {
                    // Inicializar Flatpickr para seleção de período
                    flatpickr("#periodo_ferias", {
                        mode: "range",
                        dateFormat: "d/m/Y",
                        minDate: "today",
                        locale: "pt",
                        disable: [
                            function(date) {
                                // Desabilitar datas anteriores a hoje
                                return date < new Date().setHours(0, 0, 0, 0);
                            }
                        ],
                        onChange: function(selectedDates, dateStr, instance) {
                            if (selectedDates.length === 2) {
                                console.log('Período selecionado:', selectedDates);
                            }
                        }
                    });
                },
                preConfirm: () => {
                    const periodoInput = document.getElementById('periodo_ferias');
                    const periodo = periodoInput.value;

                    if (!periodo || !periodo.includes('até')) {
                        Swal.showValidationMessage('Por favor, selecione um período válido (data inicial e final)');
                        return false;
                    }

                    // Extrair datas do período
                    const datas = periodo.split(' até ').map(d => d.trim());
                    
                    if (datas.length !== 2) {
                        Swal.showValidationMessage('Por favor, selecione uma data inicial e uma data final');
                        return false;
                    }

                    // Converter para formato YYYY-MM-DD
                    const dataInicial = datas[0].split('/').reverse().join('-');
                    const dataFinal = datas[1].split('/').reverse().join('-');

                    // Validar se as datas não são anteriores à data atual
                    const hoje = new Date();
                    hoje.setHours(0, 0, 0, 0);
                    
                    const dataInicialObj = new Date(dataInicial);
                    const dataFinalObj = new Date(dataFinal);

                    if (dataInicialObj < hoje) {
                        Swal.showValidationMessage('A data inicial não pode ser anterior à data atual');
                        return false;
                    }

                    if (dataFinalObj < dataInicialObj) {
                        Swal.showValidationMessage('A data final não pode ser anterior à data inicial');
                        return false;
                    }

                    return {
                        dataInicial: dataInicial,
                        dataFinal: dataFinal
                    };
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    salvarModoFerias(result.value.dataInicial, result.value.dataFinal);
                }
            });
        }

        // Função para salvar modo férias
        function salvarModoFerias(dataInicial, dataFinal) {
            Swal.fire({
                title: 'Salvando...',
                text: 'Ativando modo férias',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            fetch('../../assets/ajax/fornecedores/salvar_modo_ferias.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `acao=ativar&data_inicial=${dataInicial}&data_final=${dataFinal}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Modo Férias Ativado!',
                        text: data.message,
                        confirmButtonText: 'OK'
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: data.message || 'Erro ao ativar modo férias',
                        confirmButtonText: 'OK'
                    });
                }
            })
            .catch(error => {
                console.error('Erro:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: 'Erro ao processar a solicitação',
                    confirmButtonText: 'OK'
                });
            });
        }

        // Função para desativar modo férias
        function desativarModoFerias() {
            Swal.fire({
                title: 'Desativar Modo Férias?',
                text: 'Seus produtos voltarão a ficar ativos.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: '<i class="ti ti-check me-1"></i> Sim, desativar',
                cancelButtonText: '<i class="ti ti-x me-1"></i> Cancelar',
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: 'Desativando...',
                        text: 'Aguarde',
                        allowOutsideClick: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });

                    fetch('../../assets/ajax/fornecedores/salvar_modo_ferias.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: 'acao=desativar'
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Modo Férias Desativado!',
                                text: data.message,
                                confirmButtonText: 'OK'
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: data.message || 'Erro ao desativar modo férias',
                                confirmButtonText: 'OK'
                            });
                        }
                    })
                    .catch(error => {
                        console.error('Erro:', error);
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: 'Erro ao processar a solicitação',
                            confirmButtonText: 'OK'
                        });
                    });
                }
            });
        }
    </script>

</body>

</html>