<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require '../../../class/configClass.php';
Config::load('../../../config/config.php');
include_once('../../../conexao/conexao.php'); // Inclui a conexão PDO
require '../../../class/user_refresh_token_shopee.php';
require '../../../class/getTokens.php';
require '../../../class/usuariosApiContasbyUser.php';

$user_id = $_SESSION['usuario']['id_usuario'];
$tokenFetcher = new TokenFetcher($pdo);
$dados = $tokenFetcher->getTokenByPlataforma('shopee', ['partner_id', 'partner_key']);

$partner_id = null;
$partner_key = null;
if ($dados) {
    $partner_id = $dados['partner_id'];
    $partner_key = $dados['partner_key'];
}

$usuarioApiConta = new UsuarioApiConta($pdo);
$resultados_tokens = $usuarioApiConta->buscarUsuariosApiContas($user_id, 'fornecedor');

$access_token = null;
$shop_id = null;
$refresh_token = null;
if (!empty($resultados_tokens)) {
    // Assuming one relevant account per user for this context, adjust if needed
    $conta = $resultados_tokens[0];
    $access_token = $conta['access_token'];
    $shop_id = $conta['seller_id'];
    $refresh_token = $conta['refresh_token'];

    // Refresh token if necessary
    $tokenUpdater = new ShopeeTokenUpdaterUser($pdo, (int) $partner_id, $partner_key, (int) $shop_id, $refresh_token);
    $new_access_token = $tokenUpdater->getAccessToken(); // This method likely updates the DB and returns the new token
    if ($new_access_token) {
        $access_token = $new_access_token; // Use the potentially refreshed token
    }
} else {
    echo "<span style='color:red; margin-left:-3.5vh;'>[Fornecedor] Conecte uma conta da shopee.</span>";
    exit;
}

// Re-fetch token details after potential refresh, although getAccessToken might already update the instance variables or DB
$stmt = $pdo->prepare("SELECT access_token, code FROM drophub_global.usuarios_api_contas WHERE seller_id = :seller_id");
$stmt->execute([':seller_id' => $shop_id]);
$result = $stmt->fetch(PDO::FETCH_ASSOC);
$access_token = $result ? $result['access_token'] : $access_token; // Prefer freshly fetched token
// $r_token = $result ? $result['code'] : null; // 'code' might be the authorization code, refresh_token is usually needed

if (!$access_token || !$shop_id || !$partner_id || !$partner_key) {
    echo "<h4 style='color:red'>Credenciais da API Shopee ausentes ou inválidas.</h4>";
    exit;
}

// --- Adicionar Funções da API (copiadas de fetch_attributes.php) ---
function gerarAssinaturaShopee(string $path, int $timestamp, string $accessToken, int $shopId, int $partnerId, string $partnerKey): string
{
    $baseString = sprintf("%d%s%d%s%d", $partnerId, $path, $timestamp, $accessToken, $shopId);
    return hash_hmac('sha256', $baseString, $partnerKey);
}

function fazerChamadaApiShopeeGet(string $endpoint, int $partnerId, string $partnerKey, string $accessToken, int $shopId, string $baseUrl, array $apiParams = []): array
{
    $timestamp = time();
    $sign = gerarAssinaturaShopee($endpoint, $timestamp, $accessToken, $shopId, $partnerId, $partnerKey);
    $authParams = [
        'partner_id' => $partnerId,
        'timestamp' => $timestamp,
        'access_token' => $accessToken,
        'shop_id' => $shopId,
        'sign' => $sign
    ];
    $queryParams = http_build_query(array_merge($apiParams, $authParams));
    $url = $baseUrl . $endpoint . '?' . $queryParams;
    $curl = curl_init();
    $options = [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_SSL_VERIFYPEER => false, // Desabilita verificação SSL
        CURLOPT_SSL_VERIFYHOST => 0,     // Desabilita verificação do host SSL
        CURLOPT_FAILONERROR => false
    ];
    curl_setopt_array($curl, $options);
    $response = curl_exec($curl);
    $err_no = curl_errno($curl);
    $err_msg = curl_error($curl);
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    if ($err_no) {
        return [
            'error' => 'curl_error',
            'message' => "Erro na chamada cURL: (#{$err_no}) {$err_msg}",
            'http_code' => $http_code
        ];
    }
    $decodedResponse = json_decode($response, true);
    if ($http_code >= 400) {
        return [
            'error' => $decodedResponse['error'] ?? 'http_error',
            'message' => $decodedResponse['message'] ?? "Erro HTTP {$http_code}",
            'http_code' => $http_code,
            'request_id' => $decodedResponse['request_id'] ?? 'N/A'
        ];
    }
    if (json_last_error() !== JSON_ERROR_NONE) {
        return [
            'error' => 'json_decode_error',
            'message' => "Erro ao decodificar resposta JSON da Shopee. HTTP Code: {$http_code}. Resposta: " . $response,
            'http_code' => $http_code
        ];
    }
    // Não adicionamos http_code aqui, pois a função original não fazia, mas podemos adicionar se necessário
    // $decodedResponse['http_code'] = $http_code;
    return $decodedResponse;
}
// --- Fim Funções Copiadas ---

if (isset($_POST['category_id']) && isset($_POST['produto_id'])) {
    $categoryId = $_POST['category_id'];
    $produtoId = $_POST['produto_id'];

    // Carrega os atributos já salvos para o produto
    $stmtAttr = $pdo->prepare("SELECT attribute_id, value_id, attribute_value, original_value_name, value_unit FROM produtos_atributos_shopee WHERE id_produto = ?");
    $stmtAttr->execute([$produtoId]);
    $atributosSalvos = [];
    while ($row = $stmtAttr->fetch(PDO::FETCH_ASSOC)) {
        $atributosSalvos[$row['attribute_id']] = $row; // Store the whole row keyed by attribute_id
    }

    // Define baseUrl (pode vir da config ou ser fixo)
    $baseUrl = 'https://partner.shopeemobile.com';

    // Parâmetros para a API get_attributes
    $apiParams = [
        'language' => 'pt-br',
        'category_id_list' => (int)$categoryId
    ];

    // --- SUBSTITUIR chamada cURL manual pela função fazerChamadaApiShopeeGet ---
    try {
        $data = fazerChamadaApiShopeeGet(
            '/api/v2/product/get_attribute_tree',
            (int)$partner_id,
            $partner_key,
            $access_token,
            (int)$shop_id,
            $baseUrl,
            $apiParams
        );
    } catch (Exception $e) {
        // Log e trata exceção na chamada da função
        logResponse("Erro ao chamar fazerChamadaApiShopeeGet: " . $e->getMessage());
        echo "<h4 style='color:red'>Erro interno ao conectar com a API Shopee.</h4>";
        exit;
    }
    // --- FIM SUBSTITUIÇÃO ---
    // Verifica se há erro relacionado a leaf category
    if (isset($data['error']) && $data['error'] === 'product.error_param' && strpos($data['message'], 'leaf category') !== false) {
        echo "Não há atributos obrigatórios para a categoria.";
        exit;
    }

    // Check for Shopee API errors IN THE RETURNED ARRAY from the function
    if (isset($data['error']) && !empty($data['error'])) {
        echo "<h4 style='color:red'>Erro da API Shopee: " . htmlspecialchars($data['error']) . " - " . htmlspecialchars($data['message'] ?? 'Sem mensagem adicional.') . " (Req ID: " . htmlspecialchars($data['request_id'] ?? 'N/A') . ")</h4>";
        // Log error and response if needed
        logResponse("Erro API Shopee get_attributes (Cat: $categoryId): " . json_encode($data));
        exit;
    }

    

if (
    isset($data['response']['list'][0]['attribute_tree']) &&
    is_array($data['response']['list'][0]['attribute_tree'])
) {
    $attributes = $data['response']['list'][0]['attribute_tree'];
        // --- Tratamento específico para Registration ID --- 
        $registrationIdAttribute = null;
        $registrationIdKey = null;
        foreach ($attributes as $key => $attribute) {
            if (isset($attribute['attribute_id']) && $attribute['attribute_id'] === 101197) {
                $registrationIdAttribute = $attribute;
                $registrationIdKey = $key;
                break;
            }
        }

        if ($registrationIdAttribute !== null) {
            $attribute = $registrationIdAttribute;
            $idAtributo = $attribute['attribute_id'];
            $valorSalvo = $atributosSalvos[$idAtributo] ?? null;
            $isMandatory = isset($attribute['mandatory']) && $attribute['mandatory'] == 1;

            $main_input_name = "attributes[{$idAtributo}]";
            $meta_base_name = "attributes_meta[{$idAtributo}]";
            $displayName = $attribute['display_attribute_name'] ?? $attribute['name'] ?? (isset($attribute['multi_lang'][0]['value']) ? $attribute['multi_lang'][0]['value'] : 'Registration ID');
            $attribute_name_for_meta = $displayName;

            $required_attr = $isMandatory ? ' required' : '';

            $savedValue = '';
            if ($valorSalvo) {
                $savedValue = $valorSalvo['original_value_name'] ?? $valorSalvo['attribute_value'] ?? '';
            }
            $savedValue = htmlspecialchars($savedValue, ENT_QUOTES);

            echo "<div class='mb-3'>";
            echo "<label class='form-label' for='attribute_{$idAtributo}'>" . $displayName . ($isMandatory ? " <span style='color:red;'>*</span>" : "") . ":</label>";
            echo "<input type='text' class='form-control' id='attribute_{$idAtributo}' name='{$main_input_name}' value='{$savedValue}'{$required_attr}>";
            echo "<input type='hidden' name='{$meta_base_name}[name]' value='" . htmlspecialchars($attribute_name_for_meta, ENT_QUOTES) . "'>";
            echo "</div>";

            if ($registrationIdKey !== null) {
                unset($attributes[$registrationIdKey]);
                $attributes = array_values($attributes);
            }
        }
        // --- Fim Tratamento Registration ID ---

        // --- Tratamento específico para Manufacturer ---
        $manufacturerAttribute = null;
        $manufacturerKey = null;
        foreach ($attributes as $key => $attribute) {
            if (isset($attribute['attribute_id']) && $attribute['attribute_id'] === 101237) {
                $manufacturerAttribute = $attribute;
                $manufacturerKey = $key;
                break;
            }
        }

        if ($manufacturerAttribute !== null) {
            $attribute = $manufacturerAttribute;
            $idAtributo = $attribute['attribute_id'];
            $valorSalvo = $atributosSalvos[$idAtributo] ?? null;
            $isMandatory = isset($attribute['mandatory']) && $attribute['mandatory'] == 1;
            $base_name = "attributes[{$idAtributo}]";
            $meta_base_name = "attributes_meta[{$idAtributo}]";

            $valorFinal = addslashes(Config::get('site_configs.name'));

            echo "<input type='hidden' id='attribute_{$idAtributo}' name='{$base_name}' value='" . htmlspecialchars($valorFinal, ENT_QUOTES) . "'>";

            $attr_name = $attribute['display_attribute_name'] ?? $attribute['name'] ?? (isset($attribute['multi_lang'][0]['value']) ? $attribute['multi_lang'][0]['value'] : 'Manufacturer');
            echo "<input type='hidden' name='{$meta_base_name}[name]' value='" . htmlspecialchars($attr_name, ENT_QUOTES) . "'>";

            if ($manufacturerKey !== null) {
                unset($attributes[$manufacturerKey]);
                $attributes = array_values($attributes);
            }
        }
        // --- Fim Tratamento Manufacturer ---

        // Filtra apenas os atributos obrigatórios
        $mandatoryAttributes = array_filter($attributes, function ($attribute) {
            return isset($attribute['mandatory']) && $attribute['mandatory'] == 1;
        });

        // Exibe apenas os atributos obrigatórios
        if (!empty($mandatoryAttributes)) {
            foreach ($mandatoryAttributes as $attribute) {
                $idAtributo = $attribute['attribute_id'];
                $valorSalvo = $atributosSalvos[$idAtributo] ?? null; // Obtém dados salvos para este atributo
                $isMandatory = true; // Já sabemos que é obrigatório

                // ---- NOVA NOMENCLATURA ----
                $main_input_name = "attributes[{$idAtributo}]";
                $meta_base_name = "attributes_meta[{$idAtributo}]";
            $displayName = $attribute['display_attribute_name'] ?? $attribute['name'] ?? (isset($attribute['multi_lang'][0]['value']) ? $attribute['multi_lang'][0]['value'] : ('Attr ' . $idAtributo));
            $attribute_name_for_meta = $displayName;
                // ---- FIM NOVA NOMENCLATURA ----

                echo "<div class='mb-3'>"; // Usa Bootstrap's mb-3 para margem inferior
                echo "<label class='form-label' for='attribute_{$idAtributo}'>" . $displayName . " <span style='color:red;'>*</span>:</label>"; // Adiciona asterisco para obrigatório

                // Input hidden para attribute_name (usando a nova nomenclatura meta)
                echo "<input type='hidden' name='{$meta_base_name}[name]' value='" . htmlspecialchars($attribute_name_for_meta, ENT_QUOTES) . "'>";

                if (isset($attribute['attribute_value_list']) && !empty($attribute['attribute_value_list'])) {
                    // SELECT input
                    echo "<select class='form-select dynamic-select' id='attribute_{$idAtributo}' name='{$main_input_name}' required>";
                    echo "<option value='' disabled selected>Selecione</option>";

                    foreach ($attribute['attribute_value_list'] as $value) {
                        $optionLabel = $value['display_value_name'] ?? $value['original_value_name'] ?? $value['name'] ?? $value['value_id'];
                        echo "<option value='{$value['value_id']}' data-original-name='" . htmlspecialchars($value['original_value_name'] ?? ($value['name'] ?? $value['value_id']), ENT_QUOTES) . "'";
                        if ($valorSalvo && isset($valorSalvo['value_id']) && $valorSalvo['value_id'] == $value['value_id']) {
                            echo " selected";
                        }
                        echo ">";
                        echo htmlspecialchars($optionLabel, ENT_QUOTES);
                        echo "</option>";
                    }
                    echo "</select>";
                } else {
                    // TEXT input
                    $savedValue = '';
                    if ($valorSalvo) {
                        $savedValue = $valorSalvo['original_value_name'] ?? $valorSalvo['attribute_value'] ?? '';
                    }
                    $savedValue = htmlspecialchars($savedValue, ENT_QUOTES);
                    echo "<input type='text' class='form-control' id='attribute_{$idAtributo}' name='{$main_input_name}' value='{$savedValue}' required>";
                }
                echo "</div>"; // Fecha div mb-3
            }
        } else {
            echo "Não há atributos obrigatórios para a categoria.";
        }
    } elseif (isset($data['response']) && empty($data['response'])) {
        echo "<h4 style='color:grey'>Não foram encontrados atributos para a categoria {$categoryId}.</h4>";
    } else {
        // Log the unexpected response structure
        echo "<h4 style='color:red'>Erro ao processar a resposta da API Shopee. Tente novamente.</h4>";
    }
} else {
    echo "<h4 style='color:red'>ID da categoria ou ID do produto não fornecido.</h4>";
}

function pegarRaiz()
{
    $dir = __DIR__;
    while ($dir !== '/' && !file_exists($dir . '/index.php')) {
        $dir = dirname($dir) . '/';
    }
    return $dir;
}

function logResponse($message)
{
    $currentDate = date('Y-m-d H:i:s');

    $logMessage = "[$currentDate] - $message" . PHP_EOL;
    // echo $logMessage; // Para depuração, pode ser redirecionado para um arquivo de log
}
