<?php
session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
require '../../../class/configClass.php';
Config::load('../../../config/config.php');
include_once('../../../conexao/conexao.php'); // Inclui a conexÃ£o PDO
require '../../../class/user_refresh_token_shopee.php';
require '../../../class/getTokens.php';
require '../../../class/usuariosApiContasbyUser.php';

// Pega os tokens da DB Tokens Sistema
$user_id = $_SESSION['usuario']['id_usuario'];
$tokenFetcher = new TokenFetcher($pdo);
$dados = $tokenFetcher->getTokenByPlataforma('shopee', ['partner_id', 'partner_key']);

if ($dados) {
    $partner_id = $dados['partner_id'];
    $partner_key = $dados['partner_key'];
}

// Pega os tokens do usuario da tabela usuarios api contas
$usuarioApiConta = new UsuarioApiConta($pdo);
$resultados_tokens = $usuarioApiConta->buscarUsuariosApiContas($user_id, 'fornecedor');

if (!empty($resultados_tokens)) {
    foreach ($resultados_tokens as $conta) {
        $access_token = $conta['access_token'];
        $shop_id = $conta['seller_id'];
        $refresh_token = $conta['refresh_token'];
    }
}

// Atualiza o token do usuario
$tokenUpdater = new ShopeeTokenUpdaterUser($pdo, (int) $partner_id, $partner_key, (int) $shop_id, $refresh_token);
$tokenUpdater->getAccessToken();

// Exibe novamente os tokens do usuario da tabela usuarios api contas
$stmt = $pdo->prepare("SELECT access_token, code FROM drophub_global.usuarios_api_contas WHERE seller_id = :seller_id");
$stmt->execute([':seller_id' => $shop_id]);
$result = $stmt->fetch(PDO::FETCH_ASSOC);
$access_token = $result ? $result['access_token'] : null;
$r_token = $result ? $result['code'] : null;

// --- Configuração (COPIADO - Mantenha Sincronizado ou Refatore) ---
// --- ALERTA DE SEGURANÇA ---
$partnerId = $partner_id;
$partnerKey = $partner_key;
$accessToken = $access_token;
$shopId = $shop_id;
$baseUrl = 'https://partner.shopeemobile.com';
// --- Fim da Configuração Copiada ---

// --- Funções da API (COPIADAS - Mantenha Sincronizado ou Refatore) ---
function gerarAssinaturaShopee(string $path, int $timestamp, string $accessToken, int $shopId, int $partnerId, string $partnerKey): string
{
    $baseString = sprintf("%d%s%d%s%d", $partnerId, $path, $timestamp, $accessToken, $shopId);
    return hash_hmac('sha256', $baseString, $partnerKey);
}

function fazerChamadaApiShopeeGet(string $endpoint, int $partnerId, string $partnerKey, string $accessToken, int $shopId, string $baseUrl, array $apiParams = []): array
{
    $timestamp = time();
    $sign = gerarAssinaturaShopee($endpoint, $timestamp, $accessToken, $shopId, $partnerId, $partnerKey);
    $authParams = [
        'partner_id' => $partnerId,
        'timestamp' => $timestamp,
        'access_token' => $accessToken,
        'shop_id' => $shopId,
        'sign' => $sign
    ];
    $queryParams = http_build_query(array_merge($apiParams, $authParams));
    $url = $baseUrl . $endpoint . '?' . $queryParams;
    $curl = curl_init();
    $options = [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_SSL_VERIFYPEER => false, // Desabilita verificação SSL
        CURLOPT_SSL_VERIFYHOST => 0,     // Desabilita verificação do host SSL
        CURLOPT_FAILONERROR => false
    ];
    curl_setopt_array($curl, $options);
    $response = curl_exec($curl);
    $err_no = curl_errno($curl);
    $err_msg = curl_error($curl);
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    if ($err_no) {
        return [
            'error' => 'curl_error',
            'message' => "Erro na chamada cURL: (#{$err_no}) {$err_msg}",
            'http_code' => $http_code
        ];
    }
    $decodedResponse = json_decode($response, true);
    if ($http_code >= 400) {
        return [
            'error' => $decodedResponse['error'] ?? 'http_error',
            'message' => $decodedResponse['message'] ?? "Erro HTTP {$http_code}",
            'http_code' => $http_code,
            'request_id' => $decodedResponse['request_id'] ?? 'N/A'
        ];
    }
    if (json_last_error() !== JSON_ERROR_NONE) {
        return [
            'error' => 'json_decode_error',
            'message' => "Erro ao decodificar resposta JSON da Shopee. HTTP Code: {$http_code}. Resposta: " . $response,
            'http_code' => $http_code
        ];
    }
    $decodedResponse['http_code'] = $http_code;
    return $decodedResponse;
}
// --- Fim das Funções Copiadas ---

// --- Lógica Principal ---
// Pega o category_id do POST (como no original fetch_attributes) ou GET (como no buscar_atributos)
$categoryId = isset($_POST['category_id']) ? filter_var($_POST['category_id'], FILTER_VALIDATE_INT) : (isset($_GET['category_id']) ? filter_var($_GET['category_id'], FILTER_VALIDATE_INT) : null);

if ($categoryId === null || $categoryId === false) {
    echo json_encode(['error' => 'bad_request', 'message' => 'ID da Categoria (category_id) inválido ou não fornecido.']);
    exit;
}

// Verificar se o Access Token foi substituído (manter a verificação)
if ($accessToken === 'COLOQUE_SEU_ACCESS_TOKEN_VALIDO_AQUI') { // Mude isso se o token for dinâmico
    echo json_encode(['error' => 'config_error', 'message' => 'Access Token não configurado no servidor.']);
    exit;
}

try {
    // Parâmetros para a API get_attributes
    $apiParams = [
        'language' => 'pt-br',
        'category_id_list' => $categoryId
    ];

    // Chamar a API para obter os atributos da categoria
    $resultadoApi = fazerChamadaApiShopeeGet(
        '/api/v2/product/get_attribute_tree',
        $partnerId,
        $partnerKey,
        $accessToken,
        $shopId,
        $baseUrl,
        $apiParams
    );

    // Retornar a resposta da API diretamente (o JS vai processar)
    echo json_encode($resultadoApi);
} catch (Exception $e) {
    http_response_code(500); // Internal Server Error
    echo json_encode(['error' => 'server_exception', 'message' => 'Erro interno no servidor: ' . $e->getMessage()]);
}
