<?php
// LOG GLOBAL DE DEBUG (NO TOPO ABSOLUTO)
// if ($_SERVER['REQUEST_METHOD'] == 'POST') {
//     $logFileGlobal = __DIR__ . '/estoque_debug.log';
//     $date = date('Y-m-d H:i:s');
//     $postData = print_r($_POST, true);
//     // Tenta criar se não existir
//     if (!file_exists($logFileGlobal)) {
//         @touch($logFileGlobal);
//         @chmod($logFileGlobal, 0666);
//     }
//     file_put_contents($logFileGlobal, "[$date] [GLOBAL_POST_TOP] Recebido POST. Dados: $postData" . PHP_EOL, FILE_APPEND);
// }

error_log("========== GERENCIAR PRODUTOS INICIADO ========== REQUEST_URI: " . ($_SERVER['REQUEST_URI'] ?? 'N/A') . " | METHOD: " . ($_SERVER['REQUEST_METHOD'] ?? 'N/A') . " | GET: " . json_encode($_GET));

// Desabilitar exibição de erros para requisições AJAX (retornar JSON limpo)
if (isset($_GET['page']) || isset($_GET['search']) || isset($_GET['buscar_produtos_bling']) || isset($_GET['carregar_depositos_bling'])) {
    error_reporting(0);
    ini_set('display_errors', 0);
} else {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
}

session_start();
date_default_timezone_set('America/Sao_Paulo');

require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
include_once('../../funcoes/general.php');

// Carrega traduções
$traducao = require '../../custom/translations/pt-br.php';


require '../../class/walletClass.php';
require '../../class/getPlanosConfig.php';
require '../../class/vendasClass.php';
require '../../class/produtosClass.php';

// Incluir funções do Bling
include_once('../../ajax/plataformas/bling/bling_api_functions.php');
include_once('../../ajax/plataformas/bling/database_functions.php');
include_once('../../ajax/plataformas/bling/bling_auth_functions.php');

// ===== VERIFICAÇÃO E REFRESH AUTOMÁTICO DO TOKEN DO BLING =====
// Verifica se o token está válido e renova SOMENTE se necessário
$debugTokenRefresh = [];
try {
    $tokensDB = obterTokensDoDB($pdo);
    if ($tokensDB && !empty($tokensDB['access_token'])) {
        $debugTokenRefresh['status'] = 'Token encontrado';
        $debugTokenRefresh['expires_at'] = $tokensDB['expires_at'] ?? 'N/A';

        // Verifica se o token está próximo de expirar (menos de 1 hora)
        $expiresAt = strtotime($tokensDB['expires_at'] ?? '');
        $tempoRestante = $expiresAt - time();

        if ($tempoRestante < 3600) { // Menos de 1 hora
            error_log("[BLING TOKEN] Token expirando em " . ($tempoRestante / 60) . " minutos, renovando...");
            $debugTokenRefresh['acao'] = 'Token próximo de expirar - Renovando';

            // Tenta renovar o token usando o refresh token
            if (solicitarNovoTokenComRefreshToken($pdo, $tokensDB['client_id'], $tokensDB['client_secret'])) {
                error_log("[BLING TOKEN] Token renovado com sucesso!");
                $debugTokenRefresh['resultado'] = 'Token renovado com sucesso!';

                // Recarrega os tokens após renovação
                $tokensDB = obterTokensDoDB($pdo);
                $debugTokenRefresh['novo_expires_at'] = $tokensDB['expires_at'] ?? 'N/A';
            } else {
                error_log("[BLING TOKEN] Falha ao renovar token. Usuário precisará reconectar.");
                $debugTokenRefresh['resultado'] = 'Falha ao renovar - Reconectar necessário';
            }
        } else {
            error_log("[BLING TOKEN] Token válido (expira em " . ($tempoRestante / 60) . " minutos)");
            $debugTokenRefresh['acao'] = 'Token válido';
            $debugTokenRefresh['resultado'] = 'Funcionando normalmente (' . round($tempoRestante / 60) . ' min restantes)';
        }
    } else {
        error_log("[BLING TOKEN] Nenhum token encontrado no banco de dados.");
        $debugTokenRefresh['status'] = 'Nenhum token encontrado';
    }
} catch (Exception $e) {
    error_log("[BLING TOKEN] Erro ao verificar/renovar token: " . $e->getMessage());
    $debugTokenRefresh['erro'] = $e->getMessage();
}
// ===== FIM DA VERIFICAÇÃO DO TOKEN =====

// Verificar se está conectado ao Bling (sem carregar produtos)
$conectadoAoBling = false;

try {
    $token = obterTokensDoDB($pdo);
    if ($token && !empty($token['access_token'])) {
        $conectadoAoBling = true;
    }
} catch (Exception $e) {
    error_log("Erro ao verificar conexão Bling: " . $e->getMessage());
}

// Produtos locais serão carregados via AJAX quando necessário

// ================= AJAX: Carregar Depósitos do Bling =================
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['carregar_depositos_bling'])) {
    header('Content-Type: application/json; charset=utf-8');

    $depositosBling = [];

    try {
        $token = obterTokensDoDB($pdo);
        if ($token && !empty($token['access_token'])) {
            // Buscar depósitos do Bling
            $depositosResponse = chamarApiBling($pdo, '/depositos', 'GET');
            if ($depositosResponse && isset($depositosResponse['data'])) {
                foreach ($depositosResponse['data'] as $deposito) {
                    $depositosBling[] = [
                        'id' => $deposito['id'] ?? '',
                        'descricao' => $deposito['descricao'] ?? ''
                    ];
                }
            }

            echo json_encode([
                'success' => true,
                'depositos' => $depositosBling
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Token do Bling não encontrado']);
        }
    } catch (Exception $e) {
        error_log("Erro ao carregar depósitos do Bling via AJAX: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
    exit;
}

// ================= AJAX: Buscar Produtos do Bling por Nome/SKU =================
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['buscar_produtos_bling'])) {
    // Log direto em arquivo dedicado
    $logFile = '/var/www/whitelabels/stage/logs/bling_debug.log';
    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] ===== ENDPOINT ATINGIDO =====\n", FILE_APPEND);
    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] GET params: " . print_r($_GET, true) . "\n", FILE_APPEND);

    header('Content-Type: application/json; charset=utf-8');

    $termo = isset($_GET['termo']) ? trim($_GET['termo']) : '';
    $produtosBlingParaDropdown = [];

    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] Termo recebido: '{$termo}'\n", FILE_APPEND);

    try {
        $token = obterTokensDoDB($pdo);
        if ($token && !empty($token['access_token'])) {
            // Buscar produtos locais já vinculados
            $skusVinculados = [];
            $stmt = $pdo->query("SELECT sku_bling FROM drophub_global.produtos WHERE sku_bling IS NOT NULL");
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                if (!empty($row['sku_bling'])) {
                    $skusVinculados[] = $row['sku_bling'];
                }
            }

            // Buscar produtos do Bling com filtro de pesquisa
            $pagina = 1;
            $limite = 100;

            file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] Iniciando busca com termo: '{$termo}'\n", FILE_APPEND);

            // Se não há termo de busca, retorna vazio (não carrega todos os produtos)
            if (empty($termo)) {
                file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] Nenhum termo de busca fornecido, retornando vazio\n", FILE_APPEND);
                echo json_encode([
                    'success' => true,
                    'produtos' => []
                ]);
                exit;
            }

            // Buscar produtos do tipo P (Produto) e V (Variação)
            $tiposBusca = ['P', 'V'];

            foreach ($tiposBusca as $tipoProduto) {
                $pagina = 1;
                file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] Buscando produtos do tipo: {$tipoProduto}\n", FILE_APPEND);

                do {
                    // Busca por SKU (codigo) para cada tipo
                    $urlBusca = "/produtos?pagina={$pagina}&limite={$limite}&tipo={$tipoProduto}&codigo=" . urlencode($termo);

                    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] Requisição tipo {$tipoProduto} página {$pagina} - URL: {$urlBusca}\n", FILE_APPEND);
                    $produtosBling = chamarApiBling($pdo, $urlBusca, 'GET');

                    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] Resposta recebida: " . ($produtosBling ? 'OK - ' . json_encode($produtosBling) : 'NULL') . "\n", FILE_APPEND);

                    if ($produtosBling && isset($produtosBling['data'])) {
                        $qtdPagina = count($produtosBling['data']);
                        file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] Produtos tipo {$tipoProduto} retornados na página {$pagina}: {$qtdPagina}\n", FILE_APPEND);

                        foreach ($produtosBling['data'] as $produto) {
                            $sku = $produto['codigo'] ?? '';
                            $nome = $produto['nome'] ?? '';
                            $tipo = $produto['tipo'] ?? '';
                            $jaVinculado = in_array($sku, $skusVinculados);

                            // Adiciona indicador de variação ao nome se for do tipo V
                            $nomeExibicao = $nome;
                            if ($tipo === 'V') {
                                $nomeExibicao = $nome . ' (Variação)';
                            }

                            // Adiciona produto encontrado pela API
                            $produtosBlingParaDropdown[] = [
                                'id' => $produto['id'] ?? '',
                                'nome' => $nomeExibicao,
                                'sku' => $sku,
                                'tipo' => $tipo,
                                'vinculado' => $jaVinculado
                            ];

                            file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] ✓ PRODUTO ENCONTRADO: ID={$produto['id']}, TIPO={$tipo}, SKU={$sku}, Nome=" . substr($nome, 0, 50) . "\n", FILE_APPEND);
                        }

                        $temMaisPaginas = count($produtosBling['data']) >= $limite;
                        $pagina++;

                        // Limitar a 5 páginas (500 produtos) de resultados filtrados
                        if ($pagina > 5) {
                            file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] Limite de 5 páginas atingido para tipo {$tipoProduto}, parando busca\n", FILE_APPEND);
                            break;
                        }

                        // Se encontrou poucos resultados (menos que o limite), não há mais páginas
                        if ($qtdPagina < $limite) {
                            file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] Última página alcançada para tipo {$tipoProduto} (apenas {$qtdPagina} produtos)\n", FILE_APPEND);
                            break;
                        }
                    } else {
                        file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] Nenhum dado retornado para tipo {$tipoProduto} na página {$pagina}\n", FILE_APPEND);
                        break;
                    }
                } while ($temMaisPaginas);
            }

            file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] Busca finalizada. Total de produtos encontrados: " . count($produtosBlingParaDropdown) . "\n", FILE_APPEND);

            echo json_encode([
                'success' => true,
                'produtos' => $produtosBlingParaDropdown
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Token do Bling não encontrado']);
        }
    } catch (Exception $e) {
        error_log("Erro ao buscar produtos do Bling via AJAX: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
    exit;
}

// ================= AJAX: Buscar Variações do Produto =================
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['get_variacoes']) && isset($_GET['produto_id'])) {
    header('Content-Type: application/json; charset=utf-8');

    $produtoId = $_GET['produto_id'];

    try {
        // Buscar variações
        $query = "
            SELECT 
                p.*, 
                pi.imagem_url 
            FROM 
                drophub_global.produtos p
            LEFT JOIN 
                (SELECT produto_id, MIN(imagem_url) AS imagem_url FROM drophub_global.produtos_imagens GROUP BY produto_id) pi
            ON 
                p.id = pi.produto_id
            WHERE 
                p.produto_pai = :produto_pai
            ORDER BY p.id ASC
        ";

        $stmt = $pdo->prepare($query);
        $stmt->bindValue(':produto_pai', $produtoId, PDO::PARAM_STR);
        $stmt->execute();
        $variacoes = $stmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($variacoes as &$variacao) {
            if (empty($variacao['imagem_url'])) {
                $variacao['imagem_url'] = '/images/produtos_imagens/noimage.jpg';
            }
            // Formatar preço
            $variacao['preco_formatado'] = number_format($variacao['preco_custo'], 2, ',', '.');
        }

        echo json_encode([
            'success' => true,
            'variacoes' => $variacoes
        ]);
    } catch (Exception $e) {
        error_log("Erro ao buscar variações: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
    exit;
}

// ================= HELPER LOG =================
$logFile = __DIR__ . '/estoque_debug.log';
// if (!file_exists($logFile)) {
//     @touch($logFile);
//     @chmod($logFile, 0666);
// }

if (!function_exists('writeEstoqueLog')) {
    function writeEstoqueLog($msg, $file)
    {
        // $date = date('Y-m-d H:i:s');
        // file_put_contents($file, "[$date] $msg" . PHP_EOL, FILE_APPEND);
    }
}

// Processar vinculação se formulário foi enviado
// Processar alteração de estoque (AJAX)
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['alterar_estoque'])) {
    header('Content-Type: application/json; charset=utf-8');

    // Log de debug completo
    writeEstoqueLog('[ALTERAR_ESTOQUE] POST bruto: ' . print_r($_POST, true), $logFile);
    // Captura bruto possível identificador enviado (pode ser ID numérico interno ou SKU)
    $produtoId = '';          // ID interno (string pode ter prefixo)
    $produtoIdRaw = null;    // Valor bruto recebido (string)
    $possiveisChavesId = ['produto_id', 'produtoId', 'id_produto', 'id'];
    foreach ($possiveisChavesId as $ch) {
        if (isset($_POST[$ch]) && $_POST[$ch] !== '') {
            $produtoIdRaw = trim($_POST[$ch]);
            break;
        }
    }
    // Se veio algo, tenta interpretar
    if ($produtoIdRaw !== null) {
        if (ctype_digit($produtoIdRaw)) {
            $produtoId = $produtoIdRaw; // numérico simples preservado como string
        } else {
            // Se já vem no formato PREFIXO_NUMERO mantemos exatamente assim
            if (preg_match('/^[A-Za-z]{2,10}_\d{1,10}$/', $produtoIdRaw)) {
                $produtoId = $produtoIdRaw; // mantém prefixo
                writeEstoqueLog('[ALTERAR_ESTOQUE] ID com prefixo mantido: ' . $produtoId, $logFile);
            } else {
                // Tentar mapear como SKU para ID interno numérico (que convertemos para string)
                try {
                    $sqlLookup = "SELECT id FROM drophub_global.produtos WHERE sku = :sku OR sku_for = :sku OR sku_ml = :sku OR codigo_universal = :sku LIMIT 1";
                    $stmtLookup = $pdo->prepare($sqlLookup);
                    $stmtLookup->bindValue(':sku', $produtoIdRaw, PDO::PARAM_STR);
                    $stmtLookup->execute();
                    $found = $stmtLookup->fetch(PDO::FETCH_ASSOC);
                    if ($found && isset($found['id'])) {
                        $produtoId = (string)$found['id'];
                        writeEstoqueLog('[ALTERAR_ESTOQUE] SKU/identificador "' . $produtoIdRaw . '" mapeado para ID interno ' . $produtoId, $logFile);
                    } else {
                        $produtoId = $produtoIdRaw; // usa bruto mesmo assim
                        writeEstoqueLog('[ALTERAR_ESTOQUE] Identificador "' . $produtoIdRaw . '" não mapeado, usando bruto.', $logFile);
                    }
                } catch (Exception $e) {
                    $produtoId = $produtoIdRaw;
                    writeEstoqueLog('[ALTERAR_ESTOQUE] Falha lookup SKU -> ID, usando bruto: ' . $e->getMessage(), $logFile);
                }
            }
        }
    }

    $novoEstoqueRaw = isset($_POST['novo_estoque']) ? trim($_POST['novo_estoque']) : null;
    $novoEstoque = ($novoEstoqueRaw === '' || $novoEstoqueRaw === null) ? null : (int)$novoEstoqueRaw;

    writeEstoqueLog('[ALTERAR_ESTOQUE] Normalizado produtoId (string)="' . $produtoId . '" raw="' . $produtoIdRaw . '"', $logFile);

    if ($produtoId === '' || $produtoId === null) {
        writeEstoqueLog('[ALTERAR_ESTOQUE] ID vazio após tentativa de mapear. bruto="' . $produtoIdRaw . '"', $logFile);
        echo json_encode([
            'success' => false,
            'message' => 'ID/SKU do produto inválido ou vazio.',
            'post_keys' => array_keys($_POST),
            'post_debug' => $_POST,
            'produto_id_raw' => $produtoIdRaw,
            'hint' => 'Verifique se #editarEstoqueProdutoId está populado.'
        ]);
        exit;
    }
    if ($novoEstoque === null) {
        echo json_encode(['success' => false, 'message' => 'Valor de estoque ausente.']);
        exit;
    }
    if (!is_numeric($novoEstoqueRaw) || $novoEstoque < 0) {
        echo json_encode(['success' => false, 'message' => 'Valor de estoque deve ser número >= 0.']);
        exit;
    }
    if ($novoEstoque > 1000000) { // limite de segurança
        echo json_encode(['success' => false, 'message' => 'Valor de estoque muito alto.']);
        exit;
    }

    try {
        // Verifica se ID existe exatamente (numérico) antes de atualizar
        $stmtCheck = $pdo->prepare('SELECT id FROM drophub_global.produtos WHERE id = :id LIMIT 1');
        $stmtCheck->bindValue(':id', $produtoId, PDO::PARAM_STR);
        $stmtCheck->execute();
        $row = $stmtCheck->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            writeEstoqueLog('[ALTERAR_ESTOQUE] ID não encontrado na tabela produtos id=' . $produtoId . ' raw=' . $produtoIdRaw, $logFile);
            echo json_encode([
                'success' => false,
                'message' => 'Produto não encontrado.',
                'produto_id' => $produtoId,
                'produto_id_raw' => $produtoIdRaw,
                'debug_step' => 'not_found_before_update'
            ]);
            exit;
        }

        $stmt = $pdo->prepare('update drophub_global.produtos SET estoque = :estoque WHERE id = :id');
        $stmt->bindValue(':estoque', $novoEstoque, PDO::PARAM_INT);
        $stmt->bindValue(':id', $produtoId, PDO::PARAM_STR);
        writeEstoqueLog('[ALTERAR_ESTOQUE] Executando UPDATE id=' . $produtoId . ' estoque=' . $novoEstoque . ' (raw="' . $produtoIdRaw . '")', $logFile);
        $ok = $stmt->execute();
        if ($ok) {
            writeEstoqueLog('[ALTERAR_ESTOQUE] Sucesso produto ' . $produtoId . ' novo estoque ' . $novoEstoque, $logFile);

            // Verifica se o produto está vinculado ao Bling e atualiza o estoque lá também
            $stmtBling = $pdo->prepare('SELECT id_bling, id_deposito_bling, sku_bling FROM drophub_global.produtos WHERE id = :id LIMIT 1');
            $stmtBling->bindValue(':id', $produtoId, PDO::PARAM_STR);
            $stmtBling->execute();
            $produtoBling = $stmtBling->fetch(PDO::FETCH_ASSOC);

            $blingAtualizado = false;
            if ($produtoBling && !empty($produtoBling['id_bling']) && !empty($produtoBling['id_deposito_bling'])) {
                // Produto vinculado ao Bling - atualizar estoque
                writeEstoqueLog('[ALTERAR_ESTOQUE] Produto vinculado ao Bling ID=' . $produtoBling['id_bling'] . ' Depósito=' . $produtoBling['id_deposito_bling'], $logFile);

                try {
                    // Atualiza estoque no Bling via API
                    $dadosEstoque = [
                        'operacao' => 'B', // B = Balanço (define estoque absoluto)
                        'preco' => 0, // Não altera preço
                        'custo' => 0, // Não altera custo
                        'deposito' => [
                            'id' => (int)$produtoBling['id_deposito_bling']
                        ],
                        'observacoes' => 'Atualização automática via sistema',
                        'produto' => [
                            'id' => (int)$produtoBling['id_bling']
                        ],
                        'quantidade' => (float)$novoEstoque
                    ];

                    $responseBling = chamarApiBling($pdo, '/estoques', 'POST', $dadosEstoque);

                    if ($responseBling && isset($responseBling['data'])) {
                        writeEstoqueLog('[ALTERAR_ESTOQUE] Estoque atualizado no Bling com sucesso!', $logFile);
                        $blingAtualizado = true;
                    } else {
                        writeEstoqueLog('[ALTERAR_ESTOQUE] Falha ao atualizar estoque no Bling: ' . json_encode($responseBling), $logFile);
                    }
                } catch (Exception $eBling) {
                    writeEstoqueLog('[ALTERAR_ESTOQUE] Erro ao atualizar Bling: ' . $eBling->getMessage(), $logFile);
                }
            }


            // ============================================================
            // Sincronização com Marketplaces (zera_estoque2.php)
            // ============================================================
            try {
                writeEstoqueLog("[ALTERAR_ESTOQUE] Iniciando sincronização de marketplaces para produto ID: $produtoId", $logFile);

                // 1. Obter ID do fornecedor do produto
                $stmtForn = $pdo->prepare("SELECT fornecedor FROM drophub_global.produtos WHERE id = :id LIMIT 1");
                $stmtForn->bindValue(':id', $produtoId);
                $stmtForn->execute();
                $rowForn = $stmtForn->fetch(PDO::FETCH_ASSOC);
                $id_fornecedor = $rowForn['fornecedor'] ?? null;

                writeEstoqueLog("[ALTERAR_ESTOQUE] Fornecedor encontrado: " . ($id_fornecedor ?? 'NENHUM'), $logFile);

                if ($id_fornecedor) {
                    // 2. Obter Whitelabel do fornecedor
                    $stmt_wl = $pdo->prepare("SELECT whitelabel FROM drophub_global.fornecedores WHERE id = :id_fornecedor");
                    $stmt_wl->execute([':id_fornecedor' => $id_fornecedor]);
                    $res_wl = $stmt_wl->fetch(PDO::FETCH_ASSOC);
                    $whitelabel = $res_wl['whitelabel'] ?? null;

                    writeEstoqueLog("[ALTERAR_ESTOQUE] Whitelabel encontrada: " . ($whitelabel ?? 'NENHUMA'), $logFile);

                    if ($whitelabel) {
                        // 3. Obter URL Base da Whitelabel
                        $stmt_url = $pdo->prepare("SELECT url_base FROM drophub_global.whitelabels WHERE database_name = :whitelabel");
                        $stmt_url->execute([':whitelabel' => $whitelabel]);
                        $res_url = $stmt_url->fetch(PDO::FETCH_ASSOC);
                        $url_base = $res_url['url_base'] ?? null;

                        writeEstoqueLog("[ALTERAR_ESTOQUE] URL Base encontrada: " . ($url_base ?? 'NENHUMA'), $logFile);

                        if ($url_base) {
                            // Ensure protocol
                            $url_base = rtrim($url_base, '/');
                            if (!preg_match("~^(?:f|ht)tps?://~i", $url_base)) {
                                $url_base = "https://" . $url_base;
                            }

                            // 4. Chamar zera_estoque2.php
                            // Nota: Usamos force_refresh=1 para garantir tokens atualizados
                            $syncUrl = "{$url_base}/assets/validations/zera_estoque2.php?etapa=1&auto=1&auto_locked_after=10&debug=1&pid={$produtoId}&force_refresh=1";
                            writeEstoqueLog("[ALTERAR_ESTOQUE] Chamando Sync URL: $syncUrl", $logFile);

                            $ch = curl_init();
                            curl_setopt($ch, CURLOPT_URL, $syncUrl);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_TIMEOUT, 5); // Timeout curto para não travar a UI
                            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                            $response = curl_exec($ch);
                            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                            $curlError = curl_error($ch);
                            curl_close($ch);

                            writeEstoqueLog("[ALTERAR_ESTOQUE] Sync Response: HTTP $httpCode, Error: $curlError", $logFile);
                            writeEstoqueLog("[ALTERAR_ESTOQUE] Sync Body Preview: " . substr($response, 0, 200), $logFile);
                        } else {
                            writeEstoqueLog("[ALTERAR_ESTOQUE] ERRO: URL base não encontrada para whitelabel '$whitelabel'", $logFile);
                        }
                    } else {
                        writeEstoqueLog("[ALTERAR_ESTOQUE] ERRO: Whitelabel não encontrada para fornecedor '$id_fornecedor'", $logFile);
                    }
                } else {
                    writeEstoqueLog("[ALTERAR_ESTOQUE] ERRO: Fornecedor não encontrado para produto '$produtoId'", $logFile);
                }
            } catch (Exception $eSync) {
                writeEstoqueLog("[ALTERAR_ESTOQUE] Erro CRÍTICO na sincronização de marketplaces: " . $eSync->getMessage(), $logFile);
            }


            echo json_encode([
                'success' => true,
                'message' => 'Estoque atualizado com sucesso.' . ($blingAtualizado ? ' (Bling sincronizado)' : ''),
                'estoque' => $novoEstoque,
                'produto_id' => $produtoId,
                'produto_id_raw' => $produtoIdRaw,
                'bling_atualizado' => $blingAtualizado
            ]);
        } else {
            $errInfo = $stmt->errorInfo();
            writeEstoqueLog('[ALTERAR_ESTOQUE] Falha execute produto ' . $produtoId . ' errorInfo=' . json_encode($errInfo), $logFile);
            echo json_encode([
                'success' => false,
                'message' => 'Falha ao atualizar estoque.',
                'error_info' => $errInfo,
                'produto_id' => $produtoId,
                'produto_id_raw' => $produtoIdRaw
            ]);
        }
    } catch (Exception $e) {
        $errExtra = [];
        if ($e instanceof PDOException) {
            $errExtra = $e->errorInfo ?: [];
        }
        writeEstoqueLog('Erro ao atualizar estoque: ' . $e->getMessage() . ' (produto_id_raw=' . $produtoIdRaw . ' id=' . $produtoId . ') info=' . json_encode($errExtra), $logFile);
        echo json_encode([
            'success' => false,
            'message' => 'Erro interno ao atualizar.',
            'detalhe' => $e->getMessage(),
            'produto_id' => $produtoId,
            'produto_id_raw' => $produtoIdRaw,
            'trace_line' => $e->getLine(),
            'trace_file' => basename($e->getFile()),
            'error_info' => $errExtra
        ]);
    }
    exit;
}
// Processar alteração de preço (AJAX)
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['alterar_preco'])) {
    header('Content-Type: application/json; charset=utf-8');
    error_log('[ALTERAR_PRECO] POST bruto: ' . print_r($_POST, true));
    $produtoId = '';
    $produtoIdRaw = null;
    $possiveisChavesId = ['produto_id', 'produtoId', 'id_produto', 'id'];
    foreach ($possiveisChavesId as $ch) {
        if (isset($_POST[$ch]) && $_POST[$ch] !== '') {
            $produtoIdRaw = trim($_POST[$ch]);
            break;
        }
    }
    if ($produtoIdRaw !== null) {
        if (ctype_digit($produtoIdRaw)) {
            $produtoId = $produtoIdRaw;
        } else if (preg_match('/^[A-Za-z]{2,10}_\d{1,10}$/', $produtoIdRaw)) {
            $produtoId = $produtoIdRaw;
            error_log('[ALTERAR_PRECO] ID com prefixo mantido: ' . $produtoId);
        } else {
            try {
                $sqlLookup = "SELECT id FROM drophub_global.produtos WHERE sku = :sku OR sku_for = :sku OR sku_ml = :sku OR codigo_universal = :sku LIMIT 1";
                $stmtLookup = $pdo->prepare($sqlLookup);
                $stmtLookup->bindValue(':sku', $produtoIdRaw, PDO::PARAM_STR);
                $stmtLookup->execute();
                $found = $stmtLookup->fetch(PDO::FETCH_ASSOC);
                if ($found && isset($found['id'])) {
                    $produtoId = (string)$found['id'];
                    error_log('[ALTERAR_PRECO] SKU "' . $produtoIdRaw . '" => ID ' . $produtoId);
                } else {
                    $produtoId = $produtoIdRaw;
                    error_log('[ALTERAR_PRECO] Identificador "' . $produtoIdRaw . '" usado bruto.');
                }
            } catch (Exception $e) {
                $produtoId = $produtoIdRaw;
                error_log('[ALTERAR_PRECO] Falha lookup: ' . $e->getMessage());
            }
        }
    }
    $novoPrecoRaw = isset($_POST['novo_preco']) ? trim($_POST['novo_preco']) : null;
    if ($produtoId === '' || $produtoId === null) {
        echo json_encode(['success' => false, 'message' => 'ID inválido.', 'produto_id_raw' => $produtoIdRaw]);
        exit;
    }
    if ($novoPrecoRaw === null || $novoPrecoRaw === '') {
        echo json_encode(['success' => false, 'message' => 'Preço ausente.']);
        exit;
    }
    // Normalização robusta pt-BR / en-US
    $normInput = str_replace(' ', '', $novoPrecoRaw);
    $temVirg = strpos($normInput, ',') !== false;
    $temPonto = strpos($normInput, '.') !== false;
    if ($temVirg && $temPonto) {
        // Formato provável pt-BR: 1.234,56 -> remove pontos (milhar) e troca vírgula por ponto
        $normInput = str_replace('.', '', $normInput);
        $normInput = str_replace(',', '.', $normInput);
    } elseif ($temVirg) {
        // Apenas vírgula: tratar como decimal
        $normInput = str_replace(',', '.', $normInput);
    } elseif ($temPonto) {
        // Apenas ponto: decidir se é decimal ou milhar
        if (preg_match('/^\d+\.\d{1,2}$/', $normInput)) {
            // Parece decimal (ex: 26.00) -> mantém
        } else {
            // Considera pontos como milhar
            $normInput = str_replace('.', '', $normInput);
        }
    }
    if (!is_numeric($normInput)) {
        echo json_encode(['success' => false, 'message' => 'Preço inválido.', 'debug_raw' => $novoPrecoRaw, 'debug_normalizado' => $normInput]);
        exit;
    }
    $novoPreco = (float)$normInput;
    if ($novoPreco < 0) {
        echo json_encode(['success' => false, 'message' => 'Preço não pode ser negativo.']);
        exit;
    }
    if ($novoPreco > 100000000) {
        echo json_encode(['success' => false, 'message' => 'Preço muito alto.']);
        exit;
    }
    try {
        $stmtCheck = $pdo->prepare('SELECT id FROM drophub_global.produtos WHERE id = :id LIMIT 1');
        $stmtCheck->bindValue(':id', $produtoId, PDO::PARAM_STR);
        $stmtCheck->execute();
        if (!$stmtCheck->fetch(PDO::FETCH_ASSOC)) {
            error_log('[ALTERAR_PRECO] ID não encontrado id=' . $produtoId . ' raw=' . $produtoIdRaw);
            echo json_encode(['success' => false, 'message' => 'Produto não encontrado.', 'produto_id' => $produtoId, 'produto_id_raw' => $produtoIdRaw]);
            exit;
        }
        $stmt = $pdo->prepare('update drophub_global.produtos SET preco_custo = :preco WHERE id = :id');
        $stmt->bindValue(':preco', $novoPreco, PDO::PARAM_STR);
        $stmt->bindValue(':id', $produtoId, PDO::PARAM_STR);
        error_log('[ALTERAR_PRECO] Executando UPDATE id=' . $produtoId . ' preco=' . $novoPreco . ' (raw="' . $produtoIdRaw . '")');
        $ok = $stmt->execute();
        if ($ok) {
            echo json_encode(['success' => true, 'message' => 'Preço atualizado.', 'preco' => $novoPreco, 'preco_formatado' => number_format($novoPreco, 2, ',', '.'), 'produto_id' => $produtoId, 'produto_id_raw' => $produtoIdRaw]);
        } else {
            $errInfo = $stmt->errorInfo();
            error_log('[ALTERAR_PRECO] Falha execute errorInfo=' . json_encode($errInfo));
            echo json_encode(['success' => false, 'message' => 'Falha ao atualizar preço.', 'error_info' => $errInfo]);
        }
    } catch (Exception $e) {
        error_log('Erro ao atualizar preço: ' . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Erro interno ao atualizar preço.', 'detalhe' => $e->getMessage(), 'produto_id' => $produtoId, 'produto_id_raw' => $produtoIdRaw]);
    }
    exit;
}
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['vincular_produto'])) {
    // Debug: Log dos dados recebidos
    error_log("POST recebido para vincular_produto: " . print_r($_POST, true));

    $produtoId = $_POST['produto_id'] ?? '';
    $dadosBlingJson = $_POST['select_sku_bling_para_vincular'] ?? '';
    $depositoBling = $_POST['select_deposito_bling'] ?? '';

    error_log("Dados extraídos - Produto ID: $produtoId, Bling JSON: $dadosBlingJson, Depósito: $depositoBling");

    if ($produtoId && $dadosBlingJson && $depositoBling) {
        // Decodificar os dados do produto Bling
        $dadosBling = json_decode($dadosBlingJson, true);
        if ($dadosBling && isset($dadosBling['id']) && isset($dadosBling['sku'])) {
            $idBling = $dadosBling['id'];
            $skuBling = $dadosBling['sku'];

            error_log("Dados decodificados - ID Bling: $idBling, SKU Bling: $skuBling");

            try {
                // Buscar estoque do produto no Bling
                $estoqueBling = 0;
                try {
                    $produtoBlingAPI = chamarApiBling($pdo, "/produtos/{$idBling}", 'GET');
                    if ($produtoBlingAPI && isset($produtoBlingAPI['data'])) {
                        // Buscar estoque do depósito específico
                        if (isset($produtoBlingAPI['data']['estoques'])) {
                            foreach ($produtoBlingAPI['data']['estoques'] as $estoque) {
                                if (isset($estoque['deposito']['id']) && $estoque['deposito']['id'] == $depositoBling) {
                                    $estoqueBling = $estoque['saldoVirtualTotal'] ?? 0;
                                    break;
                                }
                            }
                        }
                        // Se não encontrou nos estoques, tenta pegar do campo estoque geral
                        if ($estoqueBling == 0 && isset($produtoBlingAPI['data']['estoque']['saldoVirtualTotal'])) {
                            $estoqueBling = $produtoBlingAPI['data']['estoque']['saldoVirtualTotal'];
                        }
                    }
                    error_log("Estoque obtido do Bling para produto {$idBling}: {$estoqueBling}");
                } catch (Exception $e) {
                    error_log("Erro ao buscar estoque do Bling: " . $e->getMessage());
                    // Continua mesmo se falhar ao buscar estoque
                }

                $stmt = $pdo->prepare("UPDATE drophub_global.produtos SET sku_bling = :sku_bling, id_bling = :id_bling, id_deposito_bling = :deposito_bling, estoque = :estoque WHERE id = :produto_id");
                $stmt->bindParam(':sku_bling', $skuBling);
                $stmt->bindParam(':id_bling', $idBling);
                $stmt->bindParam(':deposito_bling', $depositoBling);
                $stmt->bindParam(':estoque', $estoqueBling, PDO::PARAM_INT);
                $stmt->bindParam(':produto_id', $produtoId);

                if ($stmt->execute()) {
                    $url = "https://api-hom.codefly.site/api/v1/alteracao/produtos.php";

                    $data = json_encode([
                        "id" => $produtoId,
                        "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                        'sku_bling' => $skuBling,
                        'id_bling' => $idBling,
                        'id_deposito_bling' => $depositoBling,
                        'estoque' => $estoqueBling
                    ]);

                    $ch = curl_init($url);
                    curl_setopt_array($ch, [
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_POST => true,
                        CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                        CURLOPT_POSTFIELDS => $data,
                        CURLOPT_TIMEOUT => 10
                    ]);

                    $api_response = curl_exec($ch);
                    $curl_error = curl_error($ch);
                    curl_close($ch);

                    error_log("UPDATE executado com sucesso para produto ID: $produtoId - Estoque sincronizado: {$estoqueBling}");
                    $_SESSION['sweet_alert'] = ['type' => 'success', 'title' => 'Sucesso!', 'text' => "Produto vinculado com sucesso! Estoque atualizado para {$estoqueBling} unidades."];


                    // ============================================================
                    // Sincronização com Marketplaces (zera_estoque2.php)
                    // ============================================================
                    try {
                        writeEstoqueLog("[ALTERAR_ESTOQUE] Iniciando sincronização de marketplaces para produto ID: $produtoId", $logFile);

                        // 1. Obter ID do fornecedor do produto
                        $stmtForn = $pdo->prepare("SELECT fornecedor FROM drophub_global.produtos WHERE id = :id LIMIT 1");
                        $stmtForn->bindValue(':id', $produtoId);
                        $stmtForn->execute();
                        $rowForn = $stmtForn->fetch(PDO::FETCH_ASSOC);
                        $id_fornecedor = $rowForn['fornecedor'] ?? null;


                        writeEstoqueLog("[ALTERAR_ESTOQUE] Fornecedor encontrado: " . ($id_fornecedor ?? 'NENHUM'), $logFile);

                        if ($id_fornecedor) {
                            // 2. Obter Whitelabel do fornecedor
                            $stmt_wl = $pdo->prepare("SELECT whitelabel FROM drophub_global.fornecedores WHERE id = :id_fornecedor");
                            $stmt_wl->execute([':id_fornecedor' => $id_fornecedor]);
                            $res_wl = $stmt_wl->fetch(PDO::FETCH_ASSOC);
                            $whitelabel = $res_wl['whitelabel'] ?? null;

                            writeEstoqueLog("[ALTERAR_ESTOQUE] Whitelabel encontrada: " . ($whitelabel ?? 'NENHUMA'), $logFile);

                            if ($whitelabel) {
                                // 3. Obter URL Base da Whitelabel
                                $stmt_url = $pdo->prepare("SELECT url_base FROM drophub_global.whitelabels WHERE database_name = :whitelabel");
                                $stmt_url->execute([':whitelabel' => $whitelabel]);
                                $res_url = $stmt_url->fetch(PDO::FETCH_ASSOC);
                                $url_base = $res_url['url_base'] ?? null;

                                writeEstoqueLog("[ALTERAR_ESTOQUE] URL Base encontrada: " . ($url_base ?? 'NENHUMA'), $logFile);

                                if ($url_base) {
                                    // Ensure protocol
                                    $url_base = rtrim($url_base, '/');
                                    if (!preg_match("~^(?:f|ht)tps?://~i", $url_base)) {
                                        $url_base = "https://" . $url_base;
                                    }

                                    // 4. Chamar zera_estoque2.php
                                    // Nota: Usamos force_refresh=1 para garantir tokens atualizados
                                    $syncUrl = "{$url_base}/assets/validations/zera_estoque2.php?etapa=1&auto=1&auto_locked_after=10&debug=1&pid={$produtoId}&force_refresh=1";
                                    writeEstoqueLog("[ALTERAR_ESTOQUE] Chamando Sync URL: $syncUrl", $logFile);

                                    $ch = curl_init();
                                    curl_setopt($ch, CURLOPT_URL, $syncUrl);
                                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                                    curl_setopt($ch, CURLOPT_TIMEOUT, 5); // Timeout curto para não travar a UI
                                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                                    $response = curl_exec($ch);
                                    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                                    $curlError = curl_error($ch);
                                    curl_close($ch);

                                    writeEstoqueLog("[ALTERAR_ESTOQUE] Sync Response: HTTP $httpCode, Error: $curlError", $logFile);
                                    writeEstoqueLog("[ALTERAR_ESTOQUE] Sync Body Preview: " . substr($response, 0, 200), $logFile);
                                } else {
                                    writeEstoqueLog("[ALTERAR_ESTOQUE] ERRO: URL base não encontrada para whitelabel '$whitelabel'", $logFile);
                                }
                            } else {
                                writeEstoqueLog("[ALTERAR_ESTOQUE] ERRO: Whitelabel não encontrada para fornecedor '$id_fornecedor'", $logFile);
                            }
                        } else {
                            writeEstoqueLog("[ALTERAR_ESTOQUE] ERRO: Fornecedor não encontrado para produto '$produtoId'", $logFile);
                        }
                    } catch (Exception $eSync) {
                        writeEstoqueLog("[ALTERAR_ESTOQUE] Erro CRÍTICO na sincronização de marketplaces: " . $eSync->getMessage(), $logFile);
                    }
                } else {
                    error_log("Falha na execução do UPDATE para produto ID: $produtoId");
                    $_SESSION['sweet_alert'] = ['type' => 'error', 'title' => 'Erro!', 'text' => 'Erro ao vincular produto.'];
                }
            } catch (Exception $e) {
                error_log("Erro ao vincular produto: " . $e->getMessage());
                $_SESSION['sweet_alert'] = ['type' => 'error', 'title' => 'Erro!', 'text' => 'Erro ao vincular produto.'];
            }
        } else {
            error_log("Erro: Dados do produto Bling inválidos - JSON: $dadosBlingJson");
            $_SESSION['sweet_alert'] = ['type' => 'error', 'title' => 'Erro!', 'text' => 'Dados do produto Bling inválidos.'];
        }
    } else {
        error_log("Erro: Dados obrigatórios faltando - Produto: $produtoId, Bling: $dadosBlingJson, Depósito: $depositoBling");
        $_SESSION['sweet_alert'] = ['type' => 'error', 'title' => 'Erro!', 'text' => 'Dados obrigatórios não foram preenchidos.'];
    }
    header('Location: ' . strtok($_SERVER["REQUEST_URI"], '?'));
    exit;
}

// Processar remoção de vinculação se formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['remover_vinculacao'])) {
    $produtoId = $_POST['produto_id_remover'] ?? '';

    if ($produtoId) {
        try {
            $stmt = $pdo->prepare("update drophub_global.produtos SET sku_bling = NULL, id_bling = NULL, id_deposito_bling = NULL WHERE id = :produto_id");
            $stmt->bindParam(':produto_id', $produtoId);

            if ($stmt->execute()) {
                $url = "https://api-hom.codefly.site/api/v1/alteracao/produtos.php"; // Use a constant or config variable for the URL

                $data = json_encode([
                    "id" => $produtoId,
                    "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed", // Consider storing token securely
                    'sku_bling' => NULL,
                    'id_bling' => NULL,
                    'id_deposito_bling' => NULL
                ]);

                $ch = curl_init($url);
                curl_setopt_array($ch, [
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_POST => true,
                    CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                    CURLOPT_POSTFIELDS => $data,
                    CURLOPT_TIMEOUT => 10 // Add a timeout for the API call
                ]);

                $api_response = curl_exec($ch);
                $curl_error = curl_error($ch);
                curl_close($ch);

                $_SESSION['sweet_alert'] = ['type' => 'success', 'title' => 'Sucesso!', 'text' => 'Vinculação removida com sucesso!'];
            } else {
                $_SESSION['sweet_alert'] = ['type' => 'error', 'title' => 'Erro!', 'text' => 'Erro ao remover vinculação.'];
            }
        } catch (Exception $e) {
            error_log("Erro ao remover vinculação: " . $e->getMessage());
            $_SESSION['sweet_alert'] = ['type' => 'error', 'title' => 'Erro!', 'text' => 'Erro ao remover vinculação.'];
        }
    }
    header('Location: ' . strtok($_SERVER["REQUEST_URI"], '?'));
    exit;
}

// ================= Forçar Zerar Estoque (manual) =================
// Cooldown: 30 minutos entre usos por produto
$forceCooldownMin = 30;
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['get_force_status']) && isset($_GET['produto_id'])) {
    header('Content-Type: application/json; charset=utf-8');
    $pid = trim($_GET['produto_id']);
    $can = true;
    $wait = 0;
    $lastManual = null;
    try {
        // garante tabela/coluna na base global
        $pdo->exec("CREATE TABLE IF NOT EXISTS drophub_global.zera_estoque_status (produto_id BIGINT PRIMARY KEY, locked TINYINT(1) NOT NULL DEFAULT 0, last_zero_at DATETIME NULL, last_restore_at DATETIME NULL, last_unlock_at DATETIME NULL, restore_done TINYINT(1) NOT NULL DEFAULT 0, partial_success TINYINT(1) NULL DEFAULT NULL, updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP)");
        try {
            $pdo->exec("ALTER TABLE drophub_global.zera_estoque_status ADD COLUMN last_manual_force_at DATETIME NULL");
        } catch (Throwable $e) { /* ignore */
        }
        $stFM = $pdo->prepare("SELECT last_manual_force_at, TIMESTAMPDIFF(MINUTE,last_manual_force_at,NOW()) AS diff FROM drophub_global.zera_estoque_status WHERE produto_id = :pid LIMIT 1");
        $stFM->bindValue(':pid', $pid);
        $stFM->execute();
        $rowFM = $stFM->fetch(PDO::FETCH_ASSOC);
        if ($rowFM && $rowFM['last_manual_force_at']) {
            $lastManual = $rowFM['last_manual_force_at'];
            $diff = is_null($rowFM['diff']) ? null : (int)$rowFM['diff'];
            if ($diff !== null && $diff < $forceCooldownMin) {
                $can = false;
                $wait = $forceCooldownMin - $diff;
            }
        }
    } catch (Throwable $e) {
        echo json_encode(['success' => false, 'error' => 'db_error', 'message' => $e->getMessage()]);
        exit;
    }
    echo json_encode(['success' => true, 'can_force' => $can, 'wait_minutes' => $wait, 'cooldown_min' => $forceCooldownMin, 'last_manual_force_at' => $lastManual]);
    exit;
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['force_zero']) && isset($_POST['produto_id'])) {
    header('Content-Type: application/json; charset=utf-8');
    $pid = trim($_POST['produto_id']);
    if ($pid === '') {
        echo json_encode(['success' => false, 'message' => 'produto_id vazio']);
        exit;
    }
    try {
        $pdo->exec("CREATE TABLE IF NOT EXISTS drophub_global.zera_estoque_status (produto_id BIGINT PRIMARY KEY, locked TINYINT(1) NOT NULL DEFAULT 0, last_zero_at DATETIME NULL, last_restore_at DATETIME NULL, last_unlock_at DATETIME NULL, restore_done TINYINT(1) NOT NULL DEFAULT 0, partial_success TINYINT(1) NULL DEFAULT NULL, updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP)");
        try {
            $pdo->exec("ALTER TABLE drophub_global.zera_estoque_status ADD COLUMN last_manual_force_at DATETIME NULL");
        } catch (Throwable $e) { /* ignore */
        }
        // Verifica cooldown
        $stChk = $pdo->prepare("SELECT TIMESTAMPDIFF(MINUTE,last_manual_force_at,NOW()) AS diff FROM drophub_global.zera_estoque_status WHERE produto_id=:pid LIMIT 1");
        $stChk->bindValue(':pid', $pid);
        $stChk->execute();
        $row = $stChk->fetch(PDO::FETCH_ASSOC);
        if ($row && $row['diff'] !== null && (int)$row['diff'] < $forceCooldownMin) {
            $wait = $forceCooldownMin - (int)$row['diff'];
            echo json_encode(['success' => false, 'message' => 'Aguarde ' . $wait . ' min para usar novamente.', 'wait_minutes' => $wait]);
            exit;
        }
        // Upsert timestamp
        $stUp = $pdo->prepare("INSERT INTO drophub_global.zera_estoque_status (produto_id,last_manual_force_at) VALUES (:pid,NOW()) ON DUPLICATE KEY UPDATE last_manual_force_at=NOW()");
        $stUp->bindValue(':pid', $pid);
        $stUp->execute();
        // Dispara processamento assíncrono
        $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
        $url = $scheme . '://' . $host . '/assets/validations/zera_estoque2.php?pid=' . urlencode($pid) . '&auto=1';
        // Tentativa de chamada não bloqueante
        try {
            $ch = curl_init($url);
            curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 2, CURLOPT_CONNECTTIMEOUT => 2]);
            curl_exec($ch); // ignorar resposta
            curl_close($ch);
        } catch (Throwable $e) { /* ignore network errors */
        }
        echo json_encode(['success' => true, 'message' => 'Processo iniciado para produto ' . $pid, 'pid' => $pid, 'url' => $url]);
    } catch (Throwable $e) {
        echo json_encode(['success' => false, 'message' => 'Erro ao iniciar: ' . $e->getMessage()]);
    }
    exit;
}

// Verifica se está logado ou não
if (!isset($_SESSION['usuario']['email'])) {
    header('Location: /login');
    exit();
}

$customBase = __DIR__ . '/../../custom/includes/';
if (isset($_SESSION['usuario']['is_adm']) && $_SESSION['usuario']['is_adm'] == 1) {
    $customDir = $customBase . 'admin/';
} else {
    $customDir = $customBase . 'user/';
}

if (is_dir($customDir)) {
    foreach (glob($customDir . '*.php') as $filename) {
        include_once $filename;
    }
}

if ($_SESSION['usuario']['is_adm'] != '1') {
    header('Location: /dash/dashboard');
    exit();
}

$is_supplier = $_SESSION['usuario']['is_supplier'];
$user_id = $_SESSION['usuario']['id_usuario'];
// Variáveis para controle de paginação e pesquisa
$limit = 30; // Número de resultados por página (alterado para 2)
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
// Pesquisa pode ser por nome, id ou sku
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
// Detecta se é ID numérico
$isIdSearch = ctype_digit($search);
// Detecta se é SKU (alfanumérico, pode conter hífen, underline, etc)
$isSkuSearch = preg_match('/^[A-Za-z0-9\-_]+$/', $search);
$categoriaInterna = isset($_GET['categoria_interna']) ? $_GET['categoria_interna'] : '';

// Calcula o deslocamento para a consulta
$offset = ($page - 1) * $limit;

$whereClause = "(titulo LIKE :search OR id = :id_search1 OR sku = :sku_search1 OR sku_for = :sku_search2 OR sku_ml = :sku_search3 OR codigo_universal = :sku_search4)";

if (!empty($categoriaInterna)) {
    if ($categoriaInterna === 'Sem Estoque') {
        $whereClause .= " AND estoque <= 0";
    } else {
        $whereClause .= " AND categoria_interna = :categoriaInterna";
    }
}

// Prepara a consulta para contar o total de produtos
if ($is_supplier == 1) {
    $totalQuery = "SELECT COUNT(*) FROM drophub_global.produtos WHERE $whereClause AND fornecedor = :fornecedor_id";
} else {
    $totalQuery = "SELECT COUNT(*) FROM drophub_global.produtos WHERE $whereClause";
}

$stmt = $pdo->prepare($totalQuery);
$stmt->bindValue(':search', '%' . $search . '%', PDO::PARAM_STR);
$stmt->bindValue(':id_search1', $search, PDO::PARAM_STR);
$stmt->bindValue(':sku_search1', $search, PDO::PARAM_STR);
$stmt->bindValue(':sku_search2', $search, PDO::PARAM_STR);
$stmt->bindValue(':sku_search3', $search, PDO::PARAM_STR);
$stmt->bindValue(':sku_search4', $search, PDO::PARAM_STR);
if (!empty($categoriaInterna) && $categoriaInterna !== 'Sem Estoque') {
    $stmt->bindValue(':categoriaInterna', $categoriaInterna);
}
if ($is_supplier == 1) {
    $stmt->bindValue(':fornecedor_id', pegaPrefixo() . $user_id, PDO::PARAM_STR);
}
$stmt->execute();
$totalProducts = $stmt->fetchColumn();
$totalPages = ceil($totalProducts / $limit);

$whereClauseWithAlias = "(p.titulo LIKE :search OR p.id = :id_search1 OR p.sku = :sku_search1 OR p.sku_for = :sku_search2 OR p.sku_ml = :sku_search3 OR p.codigo_universal = :sku_search4)";

if (!empty($categoriaInterna)) {
    if ($categoriaInterna === 'Sem Estoque') {
        $whereClauseWithAlias .= " AND p.estoque <= 0";
    } else {
        $whereClauseWithAlias .= " AND p.categoria_interna = :categoriaInterna";
    }
}

if ($is_supplier == 1) {
    $query = "
        SELECT 
            p.*, 
            pi.imagem_url,
            (SELECT COUNT(*) FROM drophub_global.produtos WHERE produto_pai = p.id) as total_variacoes
        FROM 
            drophub_global.produtos p
        LEFT JOIN 
            (SELECT produto_id, MIN(imagem_url) AS imagem_url FROM drophub_global.produtos_imagens GROUP BY produto_id) pi
        ON 
            p.id = pi.produto_id
        WHERE 
            $whereClauseWithAlias
            AND p.fornecedor = :fornecedor_id
        AND is_filho = 0
        ORDER BY p.add_data desc
        LIMIT :limit OFFSET :offset
    ";
} else {
    $query = "
        SELECT 
            p.*, 
            pi.imagem_url,
            (SELECT COUNT(*) FROM drophub_global.produtos WHERE produto_pai = p.id) as total_variacoes
        FROM 
            drophub_global.produtos p
        LEFT JOIN 
            (SELECT produto_id, MIN(imagem_url) AS imagem_url FROM drophub_global.produtos_imagens GROUP BY produto_id) pi
        ON 
            p.id = pi.produto_id
        WHERE 
            $whereClauseWithAlias
        AND is_filho = 0
        ORDER BY p.add_data desc
        LIMIT :limit OFFSET :offset
    ";
}


$stmt = $pdo->prepare($query);
$stmt->bindValue(':search', '%' . $search . '%', PDO::PARAM_STR);
$stmt->bindValue(':id_search1', $search, PDO::PARAM_STR);
$stmt->bindValue(':sku_search1', $search, PDO::PARAM_STR);
$stmt->bindValue(':sku_search2', $search, PDO::PARAM_STR);
$stmt->bindValue(':sku_search3', $search, PDO::PARAM_STR);
$stmt->bindValue(':sku_search4', $search, PDO::PARAM_STR);
if (!empty($categoriaInterna) && $categoriaInterna !== 'Sem Estoque') {
    $stmt->bindValue(':categoriaInterna', $categoriaInterna);
}
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
if ($is_supplier == 1) {
    $stmt->bindValue(':fornecedor_id', pegaPrefixo() . $user_id, PDO::PARAM_STR);
}
$stmt->execute();
$products = $stmt->fetchAll();


foreach ($products as &$product) {
    $product['can_edit'] = checkPermissionAdmin('produtos', 'editar', $dataAdmin) == 'true';
    if (empty($product['imagem_url'])) {
        $product['imagem_url'] = '/images/produtos_imagens/noimage.jpg';
    }
}
$response = [
    'total_pages' => $totalPages,
    'products' => $products,
];

// IMPORTANTE: Não interceptar requisições de busca do Bling ou carregamento de depósitos
if ($_SERVER['REQUEST_METHOD'] == 'GET' && !isset($_GET['buscar_produtos_bling']) && !isset($_GET['carregar_depositos_bling']) && (isset($_GET['search']) || isset($_GET['page']))) {
    // Limpar qualquer output buffer que possa ter sido iniciado
    while (ob_get_level()) {
        ob_end_clean();
    }

    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($response);
    exit;
}

// Buscar categorias internas para o filtro
$categoriasSql = "SELECT DISTINCT p.categoria_interna 
                  FROM drophub_global.produtos p
                  WHERE p.categoria_interna IS NOT NULL AND p.categoria_interna != ''";

if ($is_supplier == 1) {
    $categoriasSql .= " AND p.fornecedor = :fornecedor_id";
}

$categoriasSql .= " ORDER BY p.categoria_interna";

$categoriasStmt = $pdo->prepare($categoriasSql);

if ($is_supplier == 1) {
    $categoriasStmt->bindValue(':fornecedor_id', pegaPrefixo() . $user_id, PDO::PARAM_STR);
}

$categoriasStmt->execute();
$categorias = $categoriasStmt->fetchAll(PDO::FETCH_ASSOC);

// Valida Sessoes e atualiza dados
validarSessaoUsuario($pdo, $_SESSION['usuario']['id_usuario']);
?>


<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer-starter">

<head>

    <?php include('../../includes/dashHead.php'); ?>
    <link rel="stylesheet" href="../../assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/swiper/swiper.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/pages/cards-advance.css" />
    <!-- Custom CSS for product cards -->
    <link rel="stylesheet" href="../../assets/css/gerenciar_produtos.css" />
    <link rel="stylesheet" href="../../assets/css/gerenciar_produtos_cards.css" />

    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@1.5.2/dist/select2-bootstrap4.min.css" rel="stylesheet" />

    <!-- Custom CSS para corrigir z-index do Sweet Alert -->
    <style>
        .swal2-container {
            z-index: 9999 !important;
        }

        .swal2-popup {
            z-index: 10000 !important;
        }

        /* Gradiente no header do modal */
        .bg-gradient-primary {
            background: linear-gradient(135deg, #696cff 0%, #5f63f2 100%);
        }

        /* Avatar customizado */
        .avatar-lg {
            width: 48px;
            height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Badge de passo numerado */
        .badge.rounded-circle {
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
        }

        /* Select2 customizations */
        .select2-container .select2-selection--single {
            height: 48px !important;
            border: 2px solid #d9dee3;
            border-radius: 0.5rem;
            transition: all 0.2s ease;
        }

        .select2-container .select2-selection--single:hover {
            border-color: #696cff;
        }

        /* Fix para centralizar texto e placeholder no Select2 (Default e Bootstrap4) */
        .select2-container .select2-selection--single .select2-selection__rendered {
            line-height: 44px !important;
            padding-left: 16px;
            color: #697a8d;
            font-size: 15px;
            display: flex !important;
            align-items: center !important;
            height: 100% !important;
        }

        .select2-container--default .select2-selection--single .select2-arrow {
            height: 44px;
        }

        .select2-dropdown {
            border-radius: 0.5rem;
            border: 2px solid #d9dee3;
            z-index: 9999;
            box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
        }

        .select2-container--default .select2-search--dropdown .select2-search__field {
            border: 2px solid #d9dee3;
            border-radius: 0.5rem;
            padding: 8px 12px;
            font-size: 14px;
        }

        .select2-container--default .select2-results__option--highlighted[aria-selected] {
            background-color: #696cff;
        }

        .select2-container--default .select2-results__option[aria-selected=true] {
            background-color: #696cff;
        }

        .select2-results__option {
            padding: 10px 12px;
            font-size: 14px;
        }

        /* Badge "JÁ VINCULADO" */
        .select2-results__option .badge {
            float: right;
            margin-left: 8px;
        }

        /* Espaçamento no modal */
        #vincularProdutoModal .select2-container {
            margin-bottom: 0;
        }

        /* Modal melhorado */
        #vincularProdutoModal .modal-content {
            border-radius: 1rem;
            overflow: hidden;
        }

        #vincularProdutoModal .modal-header {
            padding: 1.5rem;
        }

        /* Card do produto */
        #vincularProdutoModal .card {
            transition: all 0.2s ease;
        }

        #vincularProdutoModal .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        }

        /* Alert informativo */
        #vincularProdutoModal .alert {
            border-left: 4px solid #17a2b8;
        }

        /* Estilos da barra de progresso */
        #progressoEstoque {
            margin-top: 20px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 8px;
            border: 1px solid #e0e0e0;
        }

        #progressoEstoque .progress {
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }

        #progressoEstoque .progress-bar {
            background: linear-gradient(90deg, #696cff 0%, #5f63f2 100%);
            font-weight: 600;
            transition: width 0.6s ease;
        }

        #progressoEstoque .alert {
            animation: fadeIn 0.5s;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Loading state nos selects */
        .select2-container--default.select2-container--disabled .select2-selection--single {
            background-color: #f8f9fa;
            cursor: not-allowed;
            opacity: 0.6;
        }

        /* Estilos específicos para esta página foram movidos para gerenciar_produtos_cards.css */
    </style>

    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/vendor/js/template-customizer.js"></script>
    <script src="../../assets/js/config.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
    <script src="../../assets/js/funcoes.js"></script>

</head>

<body>

    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo mt-3">
                    <a href="dashboard" class="app-brand-link">

                        <?php
                        if (Config::get('site_configs.text_icon') == true) {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                            <span class="app-brand-text text-body fw-bold ms-1"><?php echo Config::get('site_configs.name'); ?></span>
                        <?php
                        } else {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                        <?php
                        }
                        ?>

                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                        <i class="ti menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
                        <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1">
                    <?php
                    if ($_SESSION['usuario']['n_acesso'] == '0') {
                        include('../../includes/sidebars-menus/sidebar_usuario.php');
                    } else {
                        include('../../includes/sidebars-menus/sidebar_master.php');
                    }
                    ?>

                </ul>
            </aside>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="ti ti-menu-2 ti-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <?php include('../../includes/dashnav.php') ?>

                    </div>
                </nav>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <div class="mt-3">



                            <?php
                            if (checkPermissionAdmin('produtos', 'ver', $dataAdmin) == 'true') {
                            ?>
                                <div class="container mt-5">
                                    <div class="p-4 mb-3 shadow-lg card border-rounded">
                                        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
                                            <div class="flex-shrink-0">
                                                <?php
                                                if (checkPermissionAdmin('produtos', 'editar', $dataAdmin) == 'true') {
                                                    echo '<a href="/dash/adicionar_produtos" class="btn btn-success">
                                                                    <i class="ti ti-plus me-1"></i>
                                                                    <span class="d-none d-sm-inline">Adicionar </span>Produto
                                                                </a>';
                                                } else {
                                                    echo '<a class="btn btn-success disabled" disabled>
                                                                    <i class="ti ti-plus me-1"></i>
                                                                    <span class="d-none d-sm-inline">Adicionar </span>Produto
                                                                </a>';
                                                }
                                                ?>
                                            </div>

                                            <div class="flex-grow-1">
                                                <div class="d-flex justify-content-end gap-2">
                                                    <div class="w-50">
                                                        <select id="categoria_interna" class="form-select select2">
                                                            <option value="">Todas as categorias</option>
                                                            <option value="Sem Estoque">Sem Estoque</option>
                                                            <?php
                                                            foreach ($categorias as $categoria) {
                                                                echo '<option value="' . htmlspecialchars($categoria['categoria_interna'], ENT_QUOTES, 'UTF-8') . '">' . htmlspecialchars($categoria['categoria_interna'], ENT_QUOTES, 'UTF-8') . '</option>';
                                                            }
                                                            ?>
                                                        </select>
                                                    </div>
                                                    <div class="input-group w-50">
                                                        <input type="text" id="search" class="form-control" placeholder="Pesquisar produtos...">
                                                        <button class="btn btn-primary" type="button" id="btnPesquisar">
                                                            <i class="ti ti-search"></i>
                                                            <span class="d-none d-sm-inline ms-1">Pesquisar</span>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>

                                    <div class="p-4 mb-3 shadow-lg card border-rounded">
                                        <div id="results"></div>
                                        <div class="w-100 d-flex flex-wrap justify-content-center mt-3" id="pagination"></div>
                                    </div>

                                </div>
                            <?php
                            } else {
                                echo 'Você não tem permissão para visualizar o conteúdo da página!';
                            }
                            ?>

                        </div>
                    </div>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <div class="layout-overlay layout-menu-toggle"></div>

        <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->

    <script src="../../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../../assets/vendor/libs/popper/popper.js"></script>
    <script src="../../assets/vendor/js/bootstrap.js"></script>
    <script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="../../assets/vendor/libs/hammer/hammer.js"></script>
    <script src="../../assets/vendor/libs/i18n/i18n.js"></script>
    <script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="../../assets/vendor/js/menu.js"></script>
    <script src="../../assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="../../assets/vendor/libs/swiper/swiper.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/dashboards-analytics.js"></script>
    <script src="../../assets/js/ui-modals.js"></script>
    <script src="../../assets/js/depositar_saldo.js"></script>

    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <!-- Sweet Alert para feedback de ações -->
    <!-- ESTE BLOCO DEVE FICAR ANTES DO </body> PARA GARANTIR QUE O ALERTA APAREÇA APÓS O RELOAD, MESMO COM PROBLEMAS DE SESSÃO -->
    <?php if (isset($_SESSION['sweet_alert'])): ?>
        <script>
            // Salva alerta em localStorage como redundância
            localStorage.setItem('sweet_alert', JSON.stringify({
                icon: '<?php echo $_SESSION['sweet_alert']['type']; ?>',
                title: '<?php echo $_SESSION['sweet_alert']['title']; ?>',
                text: '<?php echo $_SESSION['sweet_alert']['text']; ?>'
            }));
            setTimeout(function() {
                const alertData = JSON.parse(localStorage.getItem('sweet_alert') || 'null');
                if (alertData) {
                    Swal.fire({
                        icon: alertData.icon,
                        title: alertData.title,
                        text: alertData.text,
                        timer: 3000,
                        showConfirmButton: false
                    });
                    // Limpa imediatamente após mostrar
                    localStorage.removeItem('sweet_alert');
                }
            }, 250);
        </script>
        <?php unset($_SESSION['sweet_alert']); ?>
    <?php endif; ?>
    <script>
        // Fallback: sempre verifica se existe alerta sobrando no localStorage, para garantir robustez
        document.addEventListener('DOMContentLoaded', function() {
            const alertData = JSON.parse(localStorage.getItem('sweet_alert') || 'null');
            if (alertData) {
                Swal.fire({
                    icon: alertData.icon,
                    title: alertData.title,
                    text: alertData.text,
                    timer: 3000,
                    showConfirmButton: false
                });
                localStorage.removeItem('sweet_alert');
            }
        });
    </script>

    <script>
        // Variáveis para controle de busca e carregamento
        let searchTimeout;
        let isLoading = false;
        const conectadoAoBling = <?php echo $conectadoAoBling ? 'true' : 'false'; ?>;

        // Função para carregar produtos
        function loadProducts(page = 1) {
            // Evitar múltiplas requisições simultâneas
            if (isLoading) {
                return;
            }

            isLoading = true;
            const searchQuery = $('#search').val(); // Obtém o valor da pesquisa
            const categoriaInterna = $('#categoria_interna').val(); // Obtém a categoria

            // Adicionar indicador de carregamento
            const loadingHtml = `
                <div class="loading-spinner">
                    <div class="text-center">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Carregando...</span>
                        </div>
                        <p class="loading-text">Carregando produtos...</p>
                    </div>
                </div>
            `;

            // Mostrar loading apenas se não houver conteúdo ou se for uma nova busca
            if ($('#results').children().length === 0 || page === 1) {
                $('#results').html(loadingHtml);
            }

            // Desabilitar botões durante o carregamento
            $('#btnPesquisar, #btnLimpar').prop('disabled', true);
            $('#btnPesquisar').html('<span class="spinner-border spinner-border-sm me-1"></span>Buscando...');

            $.ajax({
                url: '', // A requisição é feita para a própria página
                method: 'GET',
                data: {
                    page: page,
                    search: searchQuery,
                    categoria_interna: categoriaInterna
                },
                dataType: 'json',
                success: function(response) {
                    // Limpar resultados apenas após sucesso da requisição
                    $('#results').empty();

                    if (response.products.length > 0) {
                        let grid = '<div class="row g-3 w-100 justify-content-start" style="margin-left:0;margin-right:0;">';
                        response.products.forEach(product => {
                            const preco = parseFloat(product.preco_custo).toLocaleString('pt-BR', {
                                style: 'currency',
                                currency: 'BRL'
                            });
                            const estoqueBadgeClass = product.estoque > 10 ? 'bg-success' : (product.estoque > 0 ? 'bg-warning text-dark' : 'bg-danger');
                            const vinculoBtn = product.sku_bling == null ?
                                `<button type="button" class="btn btn-sm btn-outline-success w-100 vincular-btn" data-product-id="${product.id}" data-product-name="${encodeHtml(product.titulo)}" <?php echo !$conectadoAoBling ? 'disabled title="Conecte-se ao Bling primeiro"' : ''; ?>><i class="ti ti-link"></i> Vincular</button>` :
                                `<button type="button" class="btn btn-sm btn-outline-danger w-100 remover-btn" data-product-id="${product.id}" data-product-name="${encodeHtml(product.titulo)}"><i class="ti ti-unlink"></i> Remover</button>`;
                            const editarBtn = product.can_edit ?
                                `<a href="/dash/editar_prod?id=${product.id}" class="btn btn-sm btn-primary w-100"><i class="ti ti-edit"></i> Editar</a>` :
                                `<button class="btn btn-sm btn-primary w-100" disabled><i class="ti ti-edit"></i> Editar</button>`;

                            // Transformar URL da imagem para usar thumb.png
                            let imagemUrl = product.imagem_url;
                            if (imagemUrl && imagemUrl.includes('/')) {
                                const lastSlashIndex = imagemUrl.lastIndexOf('/');
                                imagemUrl = imagemUrl.substring(0, lastSlashIndex + 1) + 'thumb.png';
                            }

                            // Ajuste: 4 produtos por linha
                            grid += `
                            <div class="col-12 col-md-4 p-2">
                                <div class="card border product-card w-100">
                                    <div class="card-body">
                                        <div class="product-header">
                                            <div class="d-flex justify-content-between align-items-start w-100 mb-2">
                                                <div class="d-flex">
                                                    ${product.sku_bling ? '<div class="me-2"><span class="badge bg-primary rounded-2 d-flex align-items-center justify-content-center remover-btn" style="width: 28px; height: 28px; padding: 0; cursor: pointer;" title="Clique para remover vínculo" data-product-id="' + product.id + '" data-product-name="' + encodeHtml(product.titulo) + '"><i class="ti ti-link" style="font-size: 14px;"></i></span></div>' : '<div class="me-2" style="width: 28px;"></div>'}
                                                </div>
                                                <div class="product-menu">
                                                    <div class="dropdown">
                                                        <button class="product-menu-btn rounded shadow-sm border" type="button" data-bs-toggle="dropdown">
                                                            <i class="ti ti-dots-vertical"></i>
                                                        </button>
                                                        <ul class="dropdown-menu dropdown-menu-end product-dropdown">
                                                            <li><a class="dropdown-item" href="/dash/editar_prod?id=${product.id}"><i class="ti ti-edit me-2"></i>Editar</a></li>
                                                            <li><button class="dropdown-item ${product.sku_bling ? 'remover-btn' : 'vincular-btn'}" data-product-id="${product.id}" data-product-name="${encodeHtml(product.titulo)}" ${!product.sku_bling && '<?php echo !$conectadoAoBling ? "disabled" : ""; ?>' === 'disabled' ? 'disabled title="Conecte-se ao Bling primeiro"' : ''}>
                                                                <i class="ti ${product.sku_bling ? 'ti-unlink' : 'ti-link'} me-2"></i>${product.sku_bling ? 'Remover Vínculo' : 'Vincular'}</button></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="product-avatar-container position-relative">
                                                <img src="${imagemUrl}" class="product-avatar" alt="${encodeHtml(product.titulo)}">
                                            </div>
                                            <div class="product-info-text">
                                                <h6 class="product-title" title="${encodeHtml(product.titulo)}">${limitarTexto(encodeHtml(product.titulo), 35)}</h6>
                                                <p class="product-id">ID: ${product.id}</p>
                                            </div>
                                        </div>
                                        
                                        <div class="product-info">
                                            <div class="row g-2 w-100 justify-content-center align-items-center text-center">
                                                <div class="col-6 text-center">
                                                    <div class="info-card preco-badge cursor-pointer" data-product-id="${product.id}" data-preco="${product.preco_custo}" 
                                                             data-product-name="${encodeHtml(product.titulo)}">
                                                        <div class="info-value preco text-center">${preco}</div>
                                                        <small class="info-label text-center">Preço</small>
                                                    </div>
                                                </div>
                                                <div class="col-6 text-center">
                                                    <div class="info-card estoque-card" style="cursor: pointer;" 
                                                         data-product-id="${product.id}" data-estoque="${product.estoque}" 
                                                         data-product-name="${encodeHtml(product.titulo)}">
                                                        <div class="info-value estoque-badge text-center ${product.estoque > 10 ? 'estoque-alto' : (product.estoque > 0 ? 'estoque-medio' : 'estoque-baixo')}">${product.estoque}</div>
                                                        <small class="info-label text-center">Estoque</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="product-action">
                                            <div class="d-grid gap-2">
                                                ${product.total_variacoes > 0 
                                                    ? `<button type="button" class="btn btn-outline-info btn-sm" onclick="abrirModalVariacoes('${product.id}', '${encodeHtml(product.titulo).replace(/'/g, "\\'")}')">
                                                         <i class="ti ti-versions me-1"></i>Ver Variações
                                                       </button>`
                                                    : ''
                                                }
                                                ${product.can_edit 
                                                    ? `<a href="/dash/editar_prod?id=${product.id}" class="btn btn-outline-primary btn-sm">
                                                         <i class="ti ti-edit me-1"></i>Editar Produto
                                                       </a>`
                                                    : `<button class="btn btn-outline-secondary btn-sm" disabled>
                                                         <i class="ti ti-edit me-1"></i>Sem Permissão
                                                       </button>`
                                                }
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>`;
                        });
                        grid += '</div>';
                        $('#results').html(grid); // Atualiza a lista de produtos com cards
                    } else {
                        $('#results').html(`
                            <div class="empty-state">
                                <i class="ti ti-search-off"></i>
                                <h5>Nenhum produto encontrado</h5>
                                <p>Tente ajustar os termos da pesquisa</p>
                            </div>
                        `);
                    }

                    // Atualiza a navegação de páginas
                    let pagination = '';
                    if (response.total_pages > 1) {
                        // Botão anterior
                        const prevDisabled = page === 1 ? 'disabled' : '';
                        pagination += `<button class="btn btn-outline-primary btn-sm me-1 ${prevDisabled}" onclick="loadProducts(${page - 1})" ${prevDisabled}>
                            <i class="ti ti-chevron-left"></i>
                        </button>`;

                        // Páginas
                        for (let i = 1; i <= response.total_pages; i++) {
                            pagination += `<button class="btn ${i === page ? 'btn-primary' : 'btn-outline-primary'} btn-sm ms-1" onclick="loadProducts(${i})">${i}</button>`;
                        }

                        // Botão próximo
                        const nextDisabled = page === response.total_pages ? 'disabled' : '';
                        pagination += `<button class="btn btn-outline-primary btn-sm ms-1 ${nextDisabled}" onclick="loadProducts(${page + 1})" ${nextDisabled}>
                            <i class="ti ti-chevron-right"></i>
                        </button>`;
                    }
                    $('#pagination').html(pagination);
                },
                error: function(xhr, status, error) {
                    let errorDetails = error;

                    // Tentar obter mais informações do erro
                    try {
                        if (xhr.responseText) {
                            console.error('Response Text:', xhr.responseText.substring(0, 500));
                            errorDetails = 'Resposta inválida do servidor. Verifique o console para detalhes.';
                        }
                    } catch (e) {
                        console.error('Erro ao processar resposta:', e);
                    }

                    $('#results').html(`
                    <div class="error-state">
                        <i class="ti ti-alert-circle"></i>
                        <h5>Erro ao carregar produtos</h5>
                        <p>Erro: ${errorDetails}</p>
                        <button class="btn btn-primary" onclick="loadProducts(${page})">
                            <i class="ti ti-refresh me-1"></i>Tentar novamente
                        </button>
                    </div>
                `);
                    $('#pagination').empty();
                    console.error('Erro AJAX:', {
                        xhr,
                        status,
                        error
                    });
                },
                complete: function() {
                    // Sempre executado, sucesso ou erro
                    isLoading = false;

                    // Reabilitar botões
                    $('#btnPesquisar, #btnLimpar').prop('disabled', false);
                    $('#btnPesquisar').html(`
                    <i class="ti ti-search"></i>
                    <span class="d-none d-sm-inline ms-1">Pesquisar</span>
                `);
                }
            });

        }

        $(document).ready(function() {
            // Inicializar Select2 para categoria
            $('#categoria_interna').select2({
                theme: 'bootstrap4',
                placeholder: "Filtrar por categoria",
                allowClear: true
            });

            // Listener para mudança na categoria
            $('#categoria_interna').on('change', function() {
                loadProducts(1);
            });

            loadProducts();

            // Removido o keyup automático - pesquisa só com botão ou Enter

            // Botão de pesquisar
            $('#btnPesquisar').on('click', function() {
                if (!isLoading) {
                    loadProducts();
                }
            });

            // Botão de limpar pesquisa
            $('#btnLimpar').on('click', function() {
                $('#search').val('').focus();
                if (!isLoading) {
                    loadProducts();
                }
            });

            // Enter no campo de pesquisa
            $('#search').on('keypress', function(e) {
                if (e.which === 13) { // Enter
                    e.preventDefault();
                    if (!isLoading) {
                        loadProducts();
                    }
                }
            });

            // Carregar depósitos quando o modal for mostrado
            $('#vincularProdutoModal').on('shown.bs.modal', function() {
                carregarDepositosBling();
            });
        });

        // Variável para controlar se os depósitos já foram carregados
        let depositosBlingCarregados = false;

        function carregarDepositosBling() {
            // Se já carregou, apenas inicializa o Select2
            if (depositosBlingCarregados) {
                inicializarSelect2Produtos();
                return;
            }

            // Mostrar loading
            $('#contadorProdutosBling').html('<span class="spinner-border spinner-border-sm me-2"></span>Carregando depósitos...');

            $.ajax({
                url: '',
                method: 'GET',
                data: {
                    carregar_depositos_bling: 1
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        // Limpar container de cards
                        $('#depositos_cards_container').empty();

                        // Criar cards para cada depósito
                        if (response.depositos.length === 0) {
                            $('#depositos_cards_container').html('<div class="col-12"><div class="alert alert-warning">Nenhum depósito encontrado</div></div>');
                        } else {
                            response.depositos.forEach(function(deposito) {
                                const card = `
                                    <div class="col-md-6">
                                        <div class="card deposito-card" data-deposito-id="${deposito.id}" style="cursor: pointer; transition: all 0.2s;">
                                            <div class="card-body p-3">
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar avatar-sm bg-label-primary rounded me-2">
                                                        <i class="ti ti-warehouse"></i>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <h6 class="mb-0">${deposito.descricao}</h6>
                                                        <small class="text-muted">ID: ${deposito.id}</small>
                                                    </div>
                                                    <i class="ti ti-check deposito-check text-success" style="display: none; font-size: 1.5rem;"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                `;
                                $('#depositos_cards_container').append(card);
                            });

                            // Adicionar evento de clique nos cards
                            $('.deposito-card').on('click', function() {
                                // Remover seleção de todos os cards
                                $('.deposito-card').removeClass('border-primary').css('box-shadow', '');
                                $('.deposito-check').hide();

                                // Adicionar seleção no card clicado
                                $(this).addClass('border-primary').css('box-shadow', '0 0 0 2px rgba(105, 108, 255, 0.2)');
                                $(this).find('.deposito-check').show();

                                // Atualizar hidden input
                                const depositoId = $(this).data('deposito-id');
                                $('#select_deposito_bling').val(depositoId);
                            });
                        }

                        // Atualizar contador com ícone de sucesso
                        $('#contadorProdutosBling').html('<i class="ti ti-check-circle me-1 text-success"></i>Pronto! Digite para buscar');

                        // Marcar como carregado
                        depositosBlingCarregados = true;

                        // Inicializar apenas produtos (não precisa mais do Select2 para depósitos)
                        inicializarSelect2Produtos();
                    } else {
                        $('#contadorProdutosBling').text('Erro ao carregar depósitos');
                        $('#depositos_cards_container').html('<div class="col-12"><div class="alert alert-danger">Erro ao carregar depósitos</div></div>');
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: response.message || 'Erro ao carregar depósitos do Bling'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    $('#contadorProdutosBling').text('Erro ao carregar depósitos');
                    $('#depositos_cards_container').html('<div class="col-12"><div class="alert alert-danger">Erro na comunicação com o servidor</div></div>');
                    console.error('Erro ao carregar depósitos do Bling:', error);
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'Erro na comunicação com o servidor'
                    });
                }
            });
        }

        // Função removida - não precisa mais do Select2 para depósitos

        function inicializarSelect2Produtos() {
            // Não precisa mais do Select2, agora é input com busca manual
            $('#btn_buscar_bling').off('click').on('click', function() {
                buscarProdutosBling();
            });

            $('#input_busca_bling').off('keypress').on('keypress', function(e) {
                if (e.which === 13) { // Enter
                    e.preventDefault();
                    buscarProdutosBling();
                }
            });
        }

        function buscarProdutosBling() {
            const termo = $('#input_busca_bling').val().trim();

            console.log('[BUSCA BLING] Termo digitado:', termo);

            if (termo.length < 2) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Digite pelo menos 2 caracteres para buscar'
                });
                return;
            }

            // Mostrar loading
            $('#btn_buscar_bling').prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-1"></span>Buscando...');
            $('#resultados_busca_bling').html('<div class="text-center p-4"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Carregando...</span></div></div>').show();

            console.log('[BUSCA BLING] Iniciando requisição AJAX...');

            $.ajax({
                url: '',
                method: 'GET',
                data: {
                    buscar_produtos_bling: 1,
                    termo: termo
                },
                dataType: 'json',
                success: function(response) {
                    console.log('[BUSCA BLING] Resposta recebida:', response);

                    if (response.success && response.produtos.length > 0) {
                        let html = '<div class="list-group list-group-flush">';

                        response.produtos.forEach(function(produto) {
                            const badgeVinculado = produto.vinculado ?
                                '<span class="badge bg-warning ms-2">JÁ VINCULADO</span>' : '';

                            const itemClass = produto.vinculado ?
                                'list-group-item list-group-item-action produto-bling-item disabled' :
                                'list-group-item list-group-item-action produto-bling-item';

                            const cursorStyle = produto.vinculado ? 'cursor: not-allowed; opacity: 0.6;' : 'cursor: pointer;';

                            html += `
                                <a href="#" class="${itemClass}" 
                                   data-produto='${JSON.stringify(produto)}'
                                   data-vinculado="${produto.vinculado ? 'true' : 'false'}"
                                   style="${cursorStyle}">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div>
                                            <strong>${produto.nome}</strong>
                                            <br>
                                            <small class="text-muted">SKU: ${produto.sku}</small>
                                        </div>
                                        ${badgeVinculado}
                                    </div>
                                </a>
                            `;
                        });

                        html += '</div>';
                        $('#resultados_busca_bling').html(html);
                        $('#contadorProdutosBling').html(`<i class="ti ti-check-circle me-1 text-success"></i>${response.produtos.length} produto(s) encontrado(s)`);

                        // Click em um produto
                        $('.produto-bling-item').on('click', function(e) {
                            e.preventDefault();

                            // Verificar se está vinculado
                            if ($(this).data('vinculado') === 'true') {
                                Swal.fire({
                                    icon: 'warning',
                                    title: 'Produto já vinculado',
                                    text: 'Este produto já está vinculado a outro produto local.'
                                });
                                return;
                            }

                            const produtoData = $(this).data('produto');
                            selecionarProdutoBling(produtoData);
                        });
                    } else {
                        console.log('[BUSCA BLING] Nenhum produto encontrado ou erro');
                        $('#resultados_busca_bling').html('<div class="alert alert-warning m-2"><i class="ti ti-alert-circle me-2"></i>Nenhum produto encontrado</div>');
                        $('#contadorProdutosBling').html('<i class="ti ti-info-circle me-1"></i>Nenhum produto encontrado');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('[BUSCA BLING] Erro na requisição:', {
                        xhr,
                        status,
                        error
                    });
                    console.error('[BUSCA BLING] Response Text:', xhr.responseText);
                    $('#resultados_busca_bling').html('<div class="alert alert-danger m-2"><i class="ti ti-alert-circle me-2"></i>Erro ao buscar produtos</div>');
                    $('#contadorProdutosBling').html('<i class="ti ti-x-circle me-1 text-danger"></i>Erro ao buscar');
                },
                complete: function() {
                    $('#btn_buscar_bling').prop('disabled', false).html('<i class="ti ti-search me-1"></i>Buscar');
                }
            });
        }

        function selecionarProdutoBling(produto) {
            // Salvar dados do produto selecionado
            const dados = {
                id: produto.id,
                sku: produto.sku,
                nome: produto.nome
            };

            $('#select_sku_bling_para_vincular').val(JSON.stringify(dados));
            $('#nome_produto_selecionado').text(produto.nome + ' (SKU: ' + produto.sku + ')');
            $('#produto_selecionado_preview').removeClass('d-none');
            $('#resultados_busca_bling').hide();

            console.log('Produto selecionado:', dados);
        }

        function limitarTexto(texto, limite) {
            if (!texto) return '';
            return texto.length > limite ? texto.substring(0, limite) + '…' : texto;
        }

        function encodeHtml(str) {
            if (!str) return '';
            return String(str)
                .replace(/&/g, '&amp;')
                .replace(/</g, '&lt;')
                .replace(/>/g, '&gt;')
                .replace(/"/g, '&quot;')
                .replace(/'/g, '&#039;');
        }

        // Event listeners para os botões usando delegação de eventos
        $(document).on('click', '.vincular-btn', function(e) {
            e.preventDefault();
            const produtoId = $(this).data('product-id');
            const produtoNome = $(this).data('product-name');
            abrirModalVincular(produtoId, produtoNome);
        });

        $(document).on('click', '.remover-btn', function(e) {
            e.preventDefault();
            // Se o modal de variações estiver aberto, fecha ele
            if ($('#modalVariacoes').hasClass('show')) {
                $('#modalVariacoes').modal('hide');
            }
            const produtoId = $(this).data('product-id');
            const produtoNome = $(this).data('product-name');
            confirmarRemocao(produtoId, produtoNome);
        });

        // Função para abrir modal de vincular com Sweet Alert
        function abrirModalVincular(produtoId, produtoNome) {
            // Se o modal de variações estiver aberto, fecha ele
            if ($('#modalVariacoes').hasClass('show')) {
                $('#modalVariacoes').modal('hide');
            }

            $('#produtoIdSelecionado').val(produtoId);
            $('#produtoNomeSelecionado').text(produtoNome);

            // Resetar os campos
            $('#input_busca_bling').val('');
            $('#select_sku_bling_para_vincular').val('');
            $('#select_deposito_bling').val('').trigger('change');
            $('#resultados_busca_bling').hide().empty();
            $('#produto_selecionado_preview').addClass('d-none');
            $('#contadorProdutosBling').html('<i class="ti ti-info-circle me-1"></i>Digite o SKU para buscar');

            $('#vincularProdutoModal').modal('show');
        }

        // Função para confirmar vinculação com Sweet Alert melhorado
        function confirmarVinculacao() {
            const produtoNome = $('#produtoNomeSelecionado').text();
            const produtoSelecionadoJson = $('#select_sku_bling_para_vincular').val();
            const depositoBling = $('#select_deposito_bling').val();

            // Validação com feedback visual
            if (!produtoSelecionadoJson || !depositoBling) {
                let mensagemErro = 'Preencha todos os campos obrigatórios:';
                let detalhes = [];

                if (!produtoSelecionadoJson) {
                    detalhes.push('• Produto no Bling');
                }

                if (!depositoBling) {
                    detalhes.push('• Depósito no Bling');
                }

                Swal.fire({
                    icon: 'warning',
                    title: 'Campos Obrigatórios',
                    html: `<p class="mb-2">${mensagemErro}</p><div class="text-start">${detalhes.join('<br>')}</div>`,
                    confirmButtonText: 'Entendi',
                    confirmButtonColor: '#696cff'
                });
                return;
            }

            // Fazer parse do JSON do produto selecionado
            const produtoSelecionado = JSON.parse(produtoSelecionadoJson);
            const depositoSelecionado = $('#select_deposito_bling option:selected').text();

            // Fechar o modal antes de mostrar o Sweet Alert
            $('#vincularProdutoModal').modal('hide');

            // Aguardar o modal fechar completamente antes de mostrar o Sweet Alert
            setTimeout(() => {
                Swal.fire({
                    title: '<strong>Confirmar Vinculação</strong>',
                    icon: 'question',
                    html: `
                        <div class="text-start">
                            <div class="alert alert-light mb-3">
                                <small class="text-muted d-block mb-1">Produto Local</small>
                                <strong>${produtoNome}</strong>
                            </div>
                            <div class="d-flex align-items-center justify-content-center mb-3">
                                <i class="ti ti-arrow-down ti-lg text-primary"></i>
                            </div>
                            <div class="alert alert-light mb-3">
                                <small class="text-muted d-block mb-1">Produto Bling</small>
                                <strong>${produtoSelecionado.nome} (SKU: ${produtoSelecionado.sku})</strong>
                            </div>
                            <div class="alert alert-light">
                                <small><i class="ti ti-info-circle me-1"></i>O estoque será sincronizado automaticamente</small>
                            </div>
                        </div>
                        <p class="text-muted mt-3 mb-0"><i class="ti ti-info-circle me-1"></i>O processo pode demorar alguns instantes. Não feche esta página.</p>
                    `,
                    showCancelButton: true,
                    confirmButtonColor: '#696cff',
                    cancelButtonColor: '#8592a3',
                    confirmButtonText: '<i class="ti ti-link me-1"></i>Sim, vincular!',
                    cancelButtonText: '<i class="ti ti-x me-1"></i>Cancelar',
                    reverseButtons: true,
                    customClass: {
                        confirmButton: 'btn btn-primary px-4',
                        cancelButton: 'btn btn-label-secondary px-4'
                    },
                    buttonsStyling: false
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Mostrar loading
                        Swal.fire({
                            title: 'Vinculando...',
                            html: '<div class="spinner-border text-primary" role="status"><span class="visually-hidden">Carregando...</span></div><p class="mt-3 mb-0">Aguarde, estamos processando a vinculação</p>',
                            showConfirmButton: false,
                            allowOutsideClick: false,
                            allowEscapeKey: false
                        });

                        // Submeter o formulário
                        document.getElementById('vincularForm').submit();
                    }
                });
            }, 300);
        }

        // Função para confirmar remoção com Sweet Alert melhorado
        function confirmarRemocao(produtoId, produtoNome) {
            Swal.fire({
                title: '<strong>Remover Vinculação</strong>',
                icon: 'warning',
                html: `
                    <div class="text-start">
                        <p class="mb-3">Tem certeza que deseja desvincular este produto do Bling?</p>
                        <div class="alert alert-warning border-0 mb-3">
                            <div class="d-flex align-items-start">
                                <i class="ti ti-alert-triangle me-2 mt-1"></i>
                                <div>
                                    <strong class="d-block mb-1">${produtoNome}</strong>
                                    <small class="text-muted">A sincronização automática de estoque será interrompida</small>
                                </div>
                            </div>
                        </div>
                        <div class="alert alert-light border-0">
                            <small><i class="ti ti-info-circle me-1"></i>Você poderá vincular novamente a qualquer momento</small>
                        </div>
                    </div>
                `,
                showCancelButton: true,
                confirmButtonColor: '#ff3e1d',
                cancelButtonColor: '#8592a3',
                confirmButtonText: '<i class="ti ti-unlink me-1"></i>Sim, remover vinculação',
                cancelButtonText: '<i class="ti ti-x me-1"></i>Cancelar',
                reverseButtons: true,
                customClass: {
                    confirmButton: 'btn btn-danger px-4',
                    cancelButton: 'btn btn-label-secondary px-4'
                },
                buttonsStyling: false
            }).then((result) => {
                if (result.isConfirmed) {
                    // Mostrar loading
                    Swal.fire({
                        title: 'Removendo...',
                        html: '<div class="spinner-border text-danger" role="status"><span class="visually-hidden">Carregando...</span></div><p class="mt-3 mb-0">Aguarde, estamos processando a remoção</p>',
                        showConfirmButton: false,
                        allowOutsideClick: false,
                        allowEscapeKey: false
                    });

                    // Criar e enviar formulário dinamicamente
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = window.location.href.split('?')[0];

                    const inputProdutoId = document.createElement('input');
                    inputProdutoId.type = 'hidden';
                    inputProdutoId.name = 'produto_id_remover';
                    inputProdutoId.value = produtoId;

                    const inputAction = document.createElement('input');
                    inputAction.type = 'hidden';
                    inputAction.name = 'remover_vinculacao';
                    inputAction.value = '1';

                    form.appendChild(inputProdutoId);
                    form.appendChild(inputAction);
                    document.body.appendChild(form);
                    form.submit();
                }
            });
        }
        // Clique no info-card de estoque para abrir modal
        $(document).on('click', '.estoque-card', function() {
            // Se o modal de variações estiver aberto, fecha ele
            if ($('#modalVariacoes').hasClass('show')) {
                $('#modalVariacoes').modal('hide');
            }
            const produtoId = $(this).data('product-id');
            const produtoNome = $(this).data('product-name');
            const estoqueAtual = $(this).data('estoque');
            $('#editarEstoqueProdutoId').val(produtoId);
            $('#editarEstoqueProdutoNome').text(produtoNome);
            $('#editarEstoqueValor').val(estoqueAtual);

            // Resetar área de progresso
            $('#progressoEstoque').addClass('d-none');
            $('#progressoBar').css('width', '0%').attr('aria-valuenow', 0);
            $('#progressoPorcentagem').text('0%');
            $('#progressoTexto').text('Iniciando...');
            $('#btnSalvarEstoque').prop('disabled', false).html('Salvar');
            $('#btnCancelarEstoque').prop('disabled', false);

            $('#editarEstoqueModal').modal('show');
        });

        // Clique no preço para abrir modal de preço
        $(document).on('click', '.preco-badge', function() {
            // Se o modal de variações estiver aberto, fecha ele
            if ($('#modalVariacoes').hasClass('show')) {
                $('#modalVariacoes').modal('hide');
            }
            const produtoId = $(this).data('product-id');
            const produtoNome = $(this).data('product-name');
            const precoAtual = $(this).data('preco');
            $('#editarPrecoProdutoId').val(produtoId);
            $('#editarPrecoProdutoNome').text(produtoNome);
            $('#editarPrecoValor').val(precoAtual);
            $('#editarPrecoModal').modal('show');
        });

        // Variáveis globais para controle de retry
        let tentativasRestantes = 3;
        let zeraEstoqueUrlGlobal = '';
        let produtoIdGlobal = '';

        // Função para sincronizar estoque com marketplaces (com retry)
        function sincronizarEstoqueMarketplaces(zeraEstoqueUrl, produtoId, tentativa = 1) {
            const maxTentativas = 3;

            // Atualiza texto com número da tentativa
            let textoTentativa = tentativa > 1 ? ` (Tentativa ${tentativa}/${maxTentativas})` : '';

            function atualizarProgresso(porcentagem, texto) {
                $('#progressoBar').css('width', porcentagem + '%').attr('aria-valuenow', porcentagem);
                $('#progressoPorcentagem').text(porcentagem + '%');
                $('#progressoTexto').text(texto + textoTentativa);
            }

            atualizarProgresso(50, 'Sincronizando com os marketplaces...');

            $.ajax({
                url: zeraEstoqueUrl,
                method: 'GET',
                timeout: 60000, // 60 segundos de timeout
                success: function(zeraResp) {
                    atualizarProgresso(100, 'Processo concluído com sucesso!');

                    setTimeout(() => {
                        // Reabilita botões
                        $('#btnSalvarEstoque').prop('disabled', false).html('Salvar');
                        $('#btnCancelarEstoque').prop('disabled', false);
                        $('#progressoEstoque').addClass('d-none');

                        Swal.fire({
                            icon: 'success',
                            title: 'Concluído!',
                            text: 'Estoque atualizado e sincronizado com sucesso nos marketplaces.',
                            timer: 3000,
                            showConfirmButton: false
                        });

                        // Fecha o modal após sucesso
                        setTimeout(() => {
                            $('#editarEstoqueModal').modal('hide');
                            // Reset tentativas
                            tentativasRestantes = 3;
                        }, 3000);
                    }, 1000);
                },
                error: function(xhr, status, error) {
                    console.log('[SYNC ERROR] tentativa:', tentativa, 'status:', status, 'error:', error);

                    if (tentativa < maxTentativas) {
                        // Ainda há tentativas restantes - mostrar botão para continuar
                        atualizarProgresso(70, 'Erro na sincronização - aguardando ação');

                        // Armazena dados para retry
                        zeraEstoqueUrlGlobal = zeraEstoqueUrl;
                        produtoIdGlobal = produtoId;
                        tentativasRestantes = maxTentativas - tentativa;

                        Swal.fire({
                            icon: 'warning',
                            title: 'Timeout na Sincronização',
                            html: `
                                <p>Estoque salvo no sistema, mas houve timeout ao sincronizar com os marketplaces.</p>
                                <p><strong>Tentativa ${tentativa} de ${maxTentativas}</strong></p>
                                <p class="text-muted mt-2">Erro: ${status === 'timeout' ? 'Tempo esgotado (60s)' : error}</p>
                                <div class="alert alert-info mt-3">
                                    <i class="ti ti-info-circle me-2"></i>
                                    <strong>Não feche esta página!</strong> O processo pode estar em execução.
                                </div>
                            `,
                            showCancelButton: true,
                            confirmButtonText: '<i class="ti ti-refresh me-1"></i> Continuar Sincronização',
                            cancelButtonText: 'Cancelar',
                            confirmButtonColor: '#696cff',
                            cancelButtonColor: '#8592a3',
                            allowOutsideClick: false,
                            allowEscapeKey: false
                        }).then((result) => {
                            if (result.isConfirmed) {
                                // Usuário clicou em continuar - faz nova tentativa
                                $('#progressoEstoque').removeClass('d-none');
                                $('#btnSalvarEstoque').prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-1"></span>Tentando novamente...');
                                $('#btnCancelarEstoque').prop('disabled', true);

                                setTimeout(() => {
                                    sincronizarEstoqueMarketplaces(zeraEstoqueUrl, produtoId, tentativa + 1);
                                }, 1000);
                            } else {
                                // Usuário cancelou
                                $('#btnSalvarEstoque').prop('disabled', false).html('Salvar');
                                $('#btnCancelarEstoque').prop('disabled', false);
                                $('#progressoEstoque').addClass('d-none');
                                tentativasRestantes = 3; // Reset
                            }
                        });
                    } else {
                        // Esgotou todas as tentativas
                        atualizarProgresso(70, 'Sincronização falhou após ' + maxTentativas + ' tentativas');

                        setTimeout(() => {
                            $('#btnSalvarEstoque').prop('disabled', false).html('Salvar');
                            $('#btnCancelarEstoque').prop('disabled', false);
                            $('#progressoEstoque').addClass('d-none');

                            Swal.fire({
                                icon: 'error',
                                title: 'Falha na Sincronização',
                                html: `
                                    <p>Estoque salvo no sistema, mas não foi possível sincronizar com os marketplaces após ${maxTentativas} tentativas.</p>
                                    <p class="text-muted mt-2">Último erro: ${status === 'timeout' ? 'Timeout (60s)' : error}</p>
                                    <div class="alert alert-warning mt-3">
                                        <i class="ti ti-alert-triangle me-2"></i>
                                        O processo pode estar em execução no servidor. Aguarde alguns minutos e verifique os anúncios.
                                    </div>
                                `,
                                confirmButtonText: 'Entendi',
                                confirmButtonColor: '#696cff'
                            });

                            // Fecha o modal
                            setTimeout(() => {
                                $('#editarEstoqueModal').modal('hide');
                                tentativasRestantes = 3; // Reset
                            }, 2000);
                        }, 1000);
                    }
                }
            });
        }

        // Submeter formulário de edição de estoque
        $(document).on('submit', '#formEditarEstoque', function(e) {
            e.preventDefault();
            const produtoId = $('#editarEstoqueProdutoId').val();
            const novoEstoque = $('#editarEstoqueValor').val();

            console.log('[DEBUG ESTOQUE SUBMIT] produtoId=', produtoId, 'novoEstoque=', novoEstoque);

            if (!produtoId || parseInt(produtoId) <= 0) {
                console.error('[DEBUG ESTOQUE] produtoId ausente antes do submit.');
                const ultimoBadge = $('.estoque-badge[data-product-id]').first();
                if (ultimoBadge.length && !produtoId) {
                    const recovered = ultimoBadge.data('product-id');
                    $('#editarEstoqueProdutoId').val(recovered);
                    console.log('[DEBUG ESTOQUE] ID recuperado heurística:', recovered);
                }
            }

            if (novoEstoque === '' || parseInt(novoEstoque) < 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Informe um valor de estoque válido (>=0).'
                });
                return;
            }

            // Reset tentativas ao iniciar novo processo
            tentativasRestantes = 3;

            // Mostra a área de progresso e desabilita os botões
            $('#progressoEstoque').removeClass('d-none');
            $('#btnSalvarEstoque').prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-1"></span>Processando...');
            $('#btnCancelarEstoque').prop('disabled', true);

            // Função para atualizar a barra de progresso
            function atualizarProgresso(porcentagem, texto) {
                $('#progressoBar').css('width', porcentagem + '%').attr('aria-valuenow', porcentagem);
                $('#progressoPorcentagem').text(porcentagem + '%');
                $('#progressoTexto').text(texto);
            }

            // Inicia progresso
            atualizarProgresso(10, 'Salvando estoque no banco de dados...');

            console.log('[DEBUG ESTOQUE] Enviando AJAX para salvar estoque...');

            // Passo 1: Salvar o novo estoque na DB
            $.ajax({
                url: '',
                method: 'POST',
                dataType: 'json',
                data: {
                    alterar_estoque: 1,
                    produto_id: produtoId,
                    novo_estoque: novoEstoque
                },
                success: function(resp) {
                    console.log('[DEBUG ESTOQUE RESPOSTA]', resp);
                    if (resp.success) {
                        // Atualiza progresso
                        atualizarProgresso(40, 'Estoque salvo! Atualizando interface...');

                        // Atualiza o badge de estoque
                        const badge = $(".estoque-badge[data-product-id='" + produtoId + "']");
                        badge.data('estoque', resp.estoque);
                        badge.text('Estoque: ' + resp.estoque);
                        badge.removeClass('bg-success bg-warning text-dark bg-danger');
                        if (resp.estoque > 10) {
                            badge.addClass('bg-success');
                        } else if (resp.estoque > 0) {
                            badge.addClass('bg-warning text-dark');
                        } else {
                            badge.addClass('bg-danger');
                        }

                        // Passo 2: Chamar sincronização com retry
                        const baseUrl = '<?php echo Config::get('site_configs.website_url'); ?>';
                        const zeraEstoqueUrl = baseUrl + '/assets/validations/zera_estoque2.php?etapa=1&auto=1&auto_locked_after=10&debug=1&pid=' + produtoId;

                        setTimeout(() => {
                            sincronizarEstoqueMarketplaces(zeraEstoqueUrl, produtoId, 1);
                        }, 1000);
                    } else {
                        console.error('[DEBUG ESTOQUE] Erro na resposta:', resp);
                        atualizarProgresso(0, 'Erro ao salvar estoque');

                        setTimeout(() => {
                            // Reabilita botões
                            $('#btnSalvarEstoque').prop('disabled', false).html('Salvar');
                            $('#btnCancelarEstoque').prop('disabled', false);
                            $('#progressoEstoque').addClass('d-none');

                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: resp.message || 'Falha ao atualizar estoque.'
                            });
                        }, 1000);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('[DEBUG ESTOQUE] Erro AJAX:', {
                        xhr,
                        status,
                        error
                    });
                    atualizarProgresso(0, 'Erro na comunicação com o servidor');

                    setTimeout(() => {
                        // Reabilita botões
                        $('#btnSalvarEstoque').prop('disabled', false).html('Salvar');
                        $('#btnCancelarEstoque').prop('disabled', false);
                        $('#progressoEstoque').addClass('d-none');

                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: 'Erro ao salvar estoque: ' + error
                        });
                    }, 1000);
                }
            });
        });

        // Botão para zerar rapidamente
        $(document).on('click', '#btnZerarEstoque', function() {
            $('#editarEstoqueValor').val(0).focus();
        });

        // Submit alteração de preço
        $(document).on('submit', '#formEditarPreco', function(e) {
            e.preventDefault();
            const produtoId = $('#editarPrecoProdutoId').val();
            let novoPreco = $('#editarPrecoValor').val();
            if (novoPreco === '' || parseFloat(novoPreco) < 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Informe um preço válido (>=0).'
                });
                return;
            }
            $.ajax({
                url: '',
                method: 'POST',
                dataType: 'json',
                data: {
                    alterar_preco: 1,
                    produto_id: produtoId,
                    novo_preco: novoPreco
                },
                success: function(resp) {
                    if (resp.success) {
                        $('#editarPrecoModal').modal('hide');
                        const spanPreco = $(".preco-badge[data-product-id='" + produtoId + "']");
                        if (resp.preco) {
                            spanPreco.data('preco', resp.preco);
                            spanPreco.text(resp.preco_formatado ? resp.preco_formatado : parseFloat(resp.preco).toLocaleString('pt-BR', {
                                style: 'currency',
                                currency: 'BRL'
                            }));
                        }
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso',
                            text: resp.message,
                            timer: 2000,
                            showConfirmButton: false
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: resp.message || 'Falha ao atualizar preço.'
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Erro na requisição.'
                    });
                }
            });
        });

        // Função para abrir modal de variações
        function abrirModalVariacoes(produtoId, produtoNome) {
            $('#modalVariacoesLabel').text('Variações de: ' + produtoNome);
            $('#listaVariacoes').html('<div class="text-center p-4"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Carregando...</span></div></div>');
            $('#modalVariacoes').modal('show');

            $.ajax({
                url: '',
                method: 'GET',
                data: {
                    get_variacoes: 1,
                    produto_id: produtoId
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success && response.variacoes.length > 0) {
                        let html = '<div class="row">';

                        response.variacoes.forEach(function(v) {
                            // Transformar URL da imagem para usar thumb.png se possível
                            let imagemUrl = v.imagem_url;
                            if (imagemUrl && imagemUrl.includes('/')) {
                                const lastSlashIndex = imagemUrl.lastIndexOf('/');
                                imagemUrl = imagemUrl.substring(0, lastSlashIndex + 1) + 'thumb.png';
                            }

                            const isLinked = v.sku_bling != null;
                            // Ícone do header: Unlink se não vinculado (para vincular), Link se vinculado
                            const headerIcon = isLinked ? 'ti-link' : 'ti-unlink';
                            const headerBadgeClass = isLinked ? 'bg-primary remover-btn' : 'bg-secondary vincular-btn';
                            const headerTitle = isLinked ? 'Clique para remover vínculo' : 'Clique para vincular';

                            // Botão do footer
                            const footerBtnClass = isLinked ? 'btn-outline-danger remover-btn' : 'btn-outline-success vincular-btn';
                            const footerBtnIcon = isLinked ? 'ti-unlink' : 'ti-link'; // Ícones de ação padrão
                            const footerBtnText = isLinked ? 'Remover' : 'Vincular';
                            const disabledAttr = !isLinked && !conectadoAoBling ? 'disabled title="Conecte-se ao Bling primeiro"' : '';

                            html += `
                            <div class="col-12 col-md-6 p-2">
                                <div class="card border product-card w-100 h-100">
                                    <div class="card-body d-flex flex-column">
                                        <div class="product-header mb-3">
                                            <div class="d-flex justify-content-between w-100 position-absolute top-0 start-0 p-3" style="z-index: 10;">
                                                <div>
                                                    <span class="badge ${headerBadgeClass} rounded-2 d-flex align-items-center justify-content-center" 
                                                          style="width: 28px; height: 28px; padding: 0; cursor: pointer;" 
                                                          title="${headerTitle}" 
                                                          data-product-id="${v.id}" 
                                                          data-product-name="${encodeHtml(v.titulo)}"
                                                          ${disabledAttr}>
                                                        <i class="ti ${headerIcon}" style="font-size: 14px;"></i>
                                                    </span>
                                                </div>
                                            </div>
                                            
                                            <div class="product-avatar-container position-relative mx-auto mb-2 mt-2">
                                                <img src="${imagemUrl}" class="product-avatar" alt="${encodeHtml(v.titulo)}">
                                            </div>
                                            <div class="product-info-text text-center">
                                                <h6 class="product-title mb-1" title="${encodeHtml(v.titulo)}">${limitarTexto(encodeHtml(v.titulo), 40)}</h6>
                                                <p class="product-id text-muted mb-0">SKU: ${v.sku || '-'}</p>
                                            </div>
                                        </div>
                                        
                                        <div class="product-info mb-3 flex-grow-1">
                                            <div class="row g-2 w-100 justify-content-center align-items-center text-center mx-0">
                                                <div class="col-6 text-center px-1">
                                                    <div class="info-card preco-badge cursor-pointer" 
                                                         data-product-id="${v.id}" 
                                                         data-preco="${v.preco_custo}" 
                                                         data-product-name="${encodeHtml(v.titulo)}">
                                                        <div class="info-value preco text-center fw-bold text-primary">R$ ${v.preco_formatado}</div>
                                                        <small class="info-label text-center text-muted" style="font-size: 0.75rem;">Preço</small>
                                                    </div>
                                                </div>
                                                <div class="col-6 text-center px-1">
                                                    <div class="info-card estoque-card cursor-pointer" 
                                                         data-product-id="${v.id}" 
                                                         data-estoque="${v.estoque}" 
                                                         data-product-name="${encodeHtml(v.titulo)}">
                                                        <div class="info-value estoque-badge text-center fw-bold ${v.estoque > 10 ? 'text-success' : (v.estoque > 0 ? 'text-warning' : 'text-danger')}">${v.estoque}</div>
                                                        <small class="info-label text-center text-muted" style="font-size: 0.75rem;">Estoque</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="product-action mt-auto">
                                            <div class="d-grid gap-2">
                                                <button type="button" class="btn ${footerBtnClass} btn-sm" 
                                                        data-product-id="${v.id}" 
                                                        data-product-name="${encodeHtml(v.titulo)}"
                                                        ${disabledAttr}>
                                                    <i class="ti ${footerBtnIcon} me-1"></i>${footerBtnText}
                                                </button>
                                                <a href="/dash/editar_prod?id=${v.id}" class="btn btn-outline-primary btn-sm" target="_blank">
                                                    <i class="ti ti-edit me-1"></i>Editar
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>`;
                        });

                        html += '</div>';
                        $('#listaVariacoes').html(html);
                    } else {
                        $('#listaVariacoes').html('<div class="alert alert-info">Nenhuma variação encontrada.</div>');
                    }
                },
                error: function() {
                    $('#listaVariacoes').html('<div class="alert alert-danger">Erro ao carregar variações.</div>');
                }
            });
        }
    </script>

    <!-- Modal Vincular Produto - Design Renovado -->
    <div class="modal fade" id="vincularProdutoModal" tabindex="-1" aria-labelledby="vincularProdutoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header border-0">
                    <div>
                        <h5 class="modal-title mb-1" id="vincularProdutoModalLabel">
                            <i class="ti ti-link me-2"></i>Vincular Produto ao Bling
                        </h5>
                        <small class="text-muted">Conecte seu produto local com o Bling ERP</small>
                    </div>
                </div>
                <div class="modal-body p-4">
                    <form method="POST" action="<?php echo strtok($_SERVER["REQUEST_URI"], '?'); ?>" id="vincularForm">
                        <input type="hidden" name="produto_id" id="produtoIdSelecionado" value="">
                        <input type="hidden" name="vincular_produto" value="1">

                        <!-- Card do Produto Local -->
                        <div class="card bg-light border-0 mb-4">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-lg bg-label-primary rounded me-3">
                                        <i class="ti ti-package ti-lg"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <small class="text-muted d-block mb-1">Produto Local</small>
                                        <h6 class="mb-0" id="produtoNomeSelecionado"></h6>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Passo 1: Buscar Produto no Bling -->
                        <div class="mb-4">
                            <div class="d-flex align-items-center mb-3">
                                <div class="badge bg-label-primary rounded-circle p-2 me-2">
                                    <span class="fw-bold">1</span>
                                </div>
                                <div class="flex-grow-1">
                                    <label for="input_busca_bling" class="form-label mb-0 fw-semibold">
                                        Buscar Produto no Bling
                                    </label>
                                    <small class="text-muted d-block" id="contadorProdutosBling">
                                        <i class="ti ti-info-circle me-1"></i>Digite o SKU para buscar
                                    </small>
                                </div>
                            </div>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text"
                                    id="input_busca_bling"
                                    class="form-control"
                                    placeholder="Digite o SKU do produto..."
                                    autocomplete="off">
                                <button type="button"
                                    id="btn_buscar_bling"
                                    class="btn btn-primary">
                                    <i class="ti ti-search me-1"></i>Buscar
                                </button>
                            </div>

                            <!-- Produto Selecionado (hidden input) -->
                            <input type="hidden" name="select_sku_bling_para_vincular" id="select_sku_bling_para_vincular" required>

                            <!-- Lista de Resultados -->
                            <div id="resultados_busca_bling" class="border rounded" style="max-height: 300px; overflow-y: auto; display: none;">
                            </div>

                            <!-- Produto Selecionado Preview -->
                            <div id="produto_selecionado_preview" class="alert alert-success d-none mt-2">
                                <i class="ti ti-check-circle me-2"></i>
                                <strong>Produto selecionado:</strong> <span id="nome_produto_selecionado"></span>
                            </div>
                        </div>

                        <!-- Passo 2: Selecionar Depósito -->
                        <div class="mb-3">
                            <div class="d-flex align-items-center mb-3">
                                <div class="badge bg-label-primary rounded-circle p-2 me-2">
                                    <span class="fw-bold">2</span>
                                </div>
                                <div class="flex-grow-1">
                                    <label class="form-label mb-0 fw-semibold">
                                        Selecionar Depósito
                                    </label>
                                    <small class="text-muted d-block">
                                        <i class="ti ti-warehouse me-1"></i>Escolha o depósito de estoque do Bling
                                    </small>
                                </div>
                            </div>

                            <!-- Hidden input para armazenar o depósito selecionado -->
                            <input type="hidden" name="select_deposito_bling" id="select_deposito_bling" required>

                            <!-- Cards de depósitos -->
                            <div id="depositos_cards_container" class="row g-3">
                                <div class="col-12 text-center py-3">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="visually-hidden">Carregando...</span>
                                    </div>
                                    <p class="text-muted mt-2 mb-0">Carregando depósitos...</p>
                                </div>
                            </div>
                        </div>

                        <!-- Alert Informativo -->
                        <div class="alert alert-info d-flex align-items-start border-0" role="alert">
                            <i class="ti ti-info-circle me-2 mt-1"></i>
                            <div class="flex-grow-1">
                                <strong>Dica:</strong> A vinculação permite sincronizar automaticamente o estoque entre sua loja e o Bling ERP.
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer bg-light border-0">
                    <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
                        <i class="ti ti-x me-1"></i>Cancelar
                    </button>
                    <button type="button" class="btn btn-primary" onclick="confirmarVinculacao()">
                        <i class="ti ti-link me-1"></i>Vincular Produto
                    </button>
                </div>
            </div>
        </div>
    </div>

</body>

<!-- Modal Editar Estoque -->
<div class="modal fade" id="editarEstoqueModal" tabindex="-1" aria-labelledby="editarEstoqueModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editarEstoqueModalLabel">Editar Estoque</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="formEditarEstoque">
                <div class="modal-body">
                    <div class="d-none" id="debugEstoqueId"></div>
                    <input type="hidden" name="produto_id" id="editarEstoqueProdutoId" value="">
                    <div class="mb-2"><strong>Produto:</strong> <span id="editarEstoqueProdutoNome"></span></div>
                    <div class="mb-3">
                        <label for="editarEstoqueValor" class="form-label">Novo Estoque</label>
                        <div class="input-group">
                            <input type="number" min="0" class="form-control" id="editarEstoqueValor" name="novo_estoque" required>
                        </div>
                        <div class="form-text">Defina um valor >= 0. Ao salvar, o estoque será atualizado e sincronizado automaticamente com os marketplaces.</div>
                    </div>

                    <!-- Área de progresso (inicialmente oculta) -->
                    <div id="progressoEstoque" class="d-none">
                        <div class="alert alert-info mb-3" role="alert">
                            <i class="ti ti-info-circle me-2"></i>
                            <strong>Aguarde!</strong> O processo pode demorar alguns instantes. <strong>Não feche esta página</strong> até a conclusão.
                        </div>
                        <div class="mb-2">
                            <small class="text-muted"><span id="progressoTexto">Iniciando...</span></small>
                        </div>
                        <div class="progress" style="height: 25px;">
                            <div id="progressoBar" class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar"
                                style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                                <span id="progressoPorcentagem">0%</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" id="btnCancelarEstoque">Cancelar</button>
                    <button type="submit" class="btn btn-primary" id="btnSalvarEstoque">Salvar</button>
                </div>
                <input type="hidden" name="alterar_estoque" value="1">
            </form>
        </div>
    </div>
</div>

<!-- Modal Editar Preço -->
<div class="modal fade" id="editarPrecoModal" tabindex="-1" aria-labelledby="editarPrecoModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editarPrecoModalLabel">Editar Preço</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="formEditarPreco">
                <div class="modal-body">
                    <input type="hidden" name="produto_id" id="editarPrecoProdutoId" value="">
                    <div class="mb-2"><strong>Produto:</strong> <span id="editarPrecoProdutoNome"></span></div>
                    <div class="mb-3">
                        <label for="editarPrecoValor" class="form-label">Novo Preço (R$)</label>
                        <input type="text" class="form-control" id="editarPrecoValor" name="novo_preco" required>
                        <div class="form-text">Use vírgula ou ponto para decimais. Ex: 199,90</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
                <input type="hidden" name="alterar_preco" value="1">
            </form>
        </div>
    </div>
</div>

<!-- Modal Debug Token -->
<div class="modal fade" id="debugTokenModal" tabindex="-1" aria-labelledby="debugTokenModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info">
                <h5 class="modal-title text-white" id="debugTokenModalLabel">
                    <i class="ti ti-bug me-2"></i>Debug - Refresh Token Bling
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info border-0">
                    <i class="ti ti-info-circle me-2"></i>
                    <strong>Informações do último ciclo de verificação de token</strong>
                </div>

                <?php if (!empty($debugTokenRefresh)): ?>
                    <table class="table table-sm table-bordered">
                        <tbody>
                            <?php foreach ($debugTokenRefresh as $key => $value): ?>
                                <tr>
                                    <td class="fw-bold" style="width: 40%;"><?php echo htmlspecialchars(ucfirst(str_replace('_', ' ', $key))); ?></td>
                                    <td>
                                        <?php
                                        if ($key === 'expires_at' || $key === 'novo_expires_at') {
                                            echo '<code>' . htmlspecialchars($value) . '</code>';
                                        } elseif ($key === 'resultado') {
                                            $badgeClass = strpos($value, 'sucesso') !== false ? 'bg-success' : (strpos($value, 'Falha') !== false ? 'bg-danger' : 'bg-warning');
                                            echo '<span class="badge ' . $badgeClass . '">' . htmlspecialchars($value) . '</span>';
                                        } else {
                                            echo htmlspecialchars($value);
                                        }
                                        ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                    <div class="alert alert-light border mt-3">
                        <small class="text-muted">
                            <i class="ti ti-clock me-1"></i>
                            Verificado em: <?php echo date('d/m/Y H:i:s'); ?>
                        </small>
                    </div>
                <?php else: ?>
                    <div class="alert alert-warning">
                        <i class="ti ti-alert-circle me-2"></i>
                        Nenhuma informação de debug disponível
                    </div>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Variações -->
<div class="modal fade" id="modalVariacoes" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalVariacoesLabel">Variações</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="listaVariacoes">
                <!-- Conteúdo carregado via AJAX -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>