<?php
session_start();

require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
include_once('../../funcoes/general.php');

// Carrega traduções
$traducao = require '../../custom/translations/pt-br.php';

include_once('../../funcoes/users.php');

require '../../class/walletClass.php';
require '../../class/getPlanosConfig.php';
require '../../class/getProductsClass.php';
require '../../class/vendasClass.php';
require '../../class/produtosClass.php';
require '../../class/validaAssinatura.php';

// Verifica se está logado ou não
if (!isset($_SESSION['usuario']['email'])) {
    header('Location: /login');
    exit();
}

$customBase = __DIR__ . '/../../custom/includes/';
if (isset($_SESSION['usuario']['is_adm']) && $_SESSION['usuario']['is_adm'] == 1) {
    $customDir = $customBase . 'admin/';
} else {
    $customDir = $customBase . 'user/';
}

if (is_dir($customDir)) {
    foreach (glob($customDir . '*.php') as $filename) {
        include_once $filename;
    }
}

// Valida Sessoes e atualiza dados
validarSessaoUsuario($pdo, $_SESSION['usuario']['id_usuario']);

// Verificar se há fornecedores em férias
$user_id = $_SESSION['usuario']['id_usuario'];
$whitelabel = Config::get('database.dbname');
$fornecedoresEmFerias = verificarFeriasUsuario($pdo, $user_id, $whitelabel);

// Save selected category in session if provided
if (isset($_GET['categoria_interna'])) {
    $_SESSION['filtro_categoria_interna'] = $_GET['categoria_interna'];
}

// Retrieve category from session if available
$categoriaInternaSessao = $_SESSION['filtro_categoria_interna'] ?? '';
?>


<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer-starter" >
<head>
<?php include('../../includes/dashHead.php'); ?>

    <link rel="stylesheet" href="../../assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/swiper/swiper.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/pages/cards-advance.css" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />

    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/vendor/js/template-customizer.js"></script>
    <script src="../../assets/js/config.js"></script>



<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
    <script src="../../assets/js/funcoes.js"></script>

</head>

<body>

    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo mt-3">
                    <a href="dashboard" class="app-brand-link">

                        <?php
                        if (Config::get('site_configs.text_icon') == true) {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                            <span class="app-brand-text text-body fw-bold ms-1"><?php echo Config::get('site_configs.name'); ?></span>
                        <?php
                        } else {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                        <?php
                        }
                        ?>

                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                        <i class="ti menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
                        <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1">
                    <?php
                    if ($_SESSION['usuario']['n_acesso'] == '0') {
                        include('../../includes/sidebars-menus/sidebar_usuario.php');
                    } else {
                        include('../../includes/sidebars-menus/sidebar_master.php');
                    }
                    ?>

                </ul>
            </aside>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="ti ti-menu-2 ti-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <?php include('../../includes/dashnav.php') ?>

                    </div>
                </nav>

                <!-- / Navbar -->

                
                
                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <div class="container-xxl flex-grow-1 container-p-y">
                            <div class="container-xxl flex-grow-1 container-p-y">
                                <!-- Filtros -->
                                <div class="mt-3">
                                    <div class="card rounded shadow">
                                        <div class="card-header d-flex justify-content-between align-items-center">
                                            <h5 class="card-title mb-1">Filtros</h5>
                                        </div>

                                        <div class="card-body mt-3 d-flex flex-row gap-2">
                                            <!-- Filtro de Fornecedores -->
                                            <div class="max-content">
                                                <label for="fornecedor" class="mb-2">Fornecedor</label>
                                                <select id="fornecedor" class="form-select">
                                                    <option value="Selecione um fornecedor...">Selecione um fornecedor...</option>
                                                    <?php
                                                    // Busca fornecedores ativos na whitelabel atual usando a função global
                                                    $fornecedores = getFornecedoresAtivos($pdo);
                                                    
                                                    // Prioriza o valor da sessão
                                                    $fornecedor = $_SESSION['filtro_fornecedor'] ?? ($_GET['fornecedor'] ?? '');
                                                    
                                                    // Preencher o select com os fornecedores
                                                    foreach ($fornecedores as $fornecedorItem) {
                                                        $selected = ($fornecedorItem['nome'] == $fornecedor) ? 'selected' : '';
                                                        echo '<option value="' . htmlspecialchars($fornecedorItem['nome']) . '" ' . $selected . '>' . htmlspecialchars($fornecedorItem['nome']) . '</option>';
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                            <!-- Filtro por Nome -->
                                            <div class="flex-grow-1">
                                                <label for="nomeProduto" class="mb-2">Nome do Produto / SKU</label>
                                                <input type="text" id="nomeProduto" class="form-control" placeholder="Pesquisar por nome ou sku..." value="<?php echo htmlspecialchars($nomeProduto); ?>">
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <!-- Aviso de Férias -->
                                <?php if (!empty($fornecedoresEmFerias)): ?>
                                <div class="mt-3">
                                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                        <h5 class="alert-heading">
                                            <i class="ti ti-beach me-2"></i>
                                            <strong>⚠️ Alerta de Férias!</strong>
                                        </h5>
                                        <hr>
                                        <?php foreach ($fornecedoresEmFerias as $fornecedor): ?>
                                        <div class="mb-2">
                                            <?php if (isset($fornecedor['ja_comecou']) && !$fornecedor['ja_comecou']): ?>
                                                <strong>📅 <?php echo htmlspecialchars($fornecedor['nome']); ?></strong> entrará de férias em 
                                                <strong><?php echo $fornecedor['ferias_de']; ?></strong> 
                                                (faltam <?php echo $fornecedor['dias_ate_ferias']; ?> dias).
                                            <?php else: ?>
                                                <strong>🏖️ <?php echo htmlspecialchars($fornecedor['nome']); ?></strong> está de férias até 
                                                <strong><?php echo $fornecedor['ferias_ate']; ?></strong>.
                                            <?php endif; ?>
                                        </div>
                                        <?php endforeach; ?>
                                        <hr>
                                        <p class="mb-0">
                                            <i class="ti ti-alert-triangle me-1"></i>
                                            <strong>Ative o modo férias nos seus marketplaces AGORA para evitar vendas!</strong>
                                            Durante o período de férias, os produtos estarão temporariamente indisponíveis.
                                        </p>
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <!-- Catálogo de Produtos -->
                                <div class="mt-3">
                                    <div class="card p-2 rounded shadow">
                                        <div class="card-body" id="produtoCatalogo">
                                            <p class="text-muted mb-0">Selecione um fornecedor...</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>


                    </div>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <div class="layout-overlay layout-menu-toggle"></div>

        <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->


    <script>
        function logout() {
            Swal.fire({
                toast: true,
                position: "top-end",
                icon: 'success',
                title: 'Você se desconectou com sucesso! Até logo. 😉',
                showConfirmButton: false,
                timer: 2000,
            }).then(function() {
                window.location.href = '/logout';
            });
        }
    </script>

    <script src="../../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../../assets/vendor/libs/popper/popper.js"></script>
    <script src="../../assets/vendor/js/bootstrap.js"></script>
    <script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="../../assets/vendor/libs/hammer/hammer.js"></script>
    <script src="../../assets/vendor/libs/i18n/i18n.js"></script>
    <script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="../../assets/vendor/js/menu.js"></script>
    <script src="../../assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="../../assets/vendor/libs/swiper/swiper.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/dashboards-analytics.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/ui-modals.js"></script>
    <script src="../../assets/js/depositar_saldo.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />

    <script>
        $(document).ready(function() {
            $('#vendas').DataTable({
                "language": {
                    "url": "https://cdn.datatables.net/plug-ins/1.10.25/i18n/Portuguese.json"
                },
                "paging": false,
                "responsive": true,
                "searching": false
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            const fornecedorSelect = document.getElementById('fornecedor');
            const nomeProdutoInput = document.getElementById('nomeProduto');
            const produtoCatalogo = document.getElementById('produtoCatalogo');
            const avisoFerias = document.getElementById('avisoFerias');

            <?php echo generateDebounceFunction(); ?>

            // Função para verificar e exibir aviso de férias
            function verificarFerias(fornecedor) {
                if (fornecedor === 'Selecione um fornecedor...') {
                    avisoFerias.style.display = 'none';
                    avisoFerias.innerHTML = '';
                    return;
                }

                $.ajax({
                    url: '../../assets/ajax/produtos/buscar_ferias_fornecedor.php',
                    method: 'GET',
                    data: { fornecedor: fornecedor },
                    success: function(response) {
                        console.log('Dados de férias:', response);
                        
                        if (response.em_ferias) {
                            // Fornecedor em férias agora
                            avisoFerias.innerHTML = `
                                <div class="alert alert-warning d-flex align-items-center" role="alert">
                                    <i class="ti ti-alert-triangle fs-2 me-3"></i>
                                    <div>
                                        <h5 class="alert-heading mb-1">
                                            <i class="ti ti-confetti me-1"></i>
                                            Fornecedor em Modo Férias
                                        </h5>
                                        <p class="mb-2">
                                            ${response.mensagem}
                                        </p>
                                        <hr class="my-2">
                                        <p class="mb-0 small">
                                            <strong>⚠️ Importante:</strong> Ative o modo férias nos seus marketplaces (Shopee, Mercado Livre, etc.) para evitar vendas durante este período.
                                        </p>
                                    </div>
                                </div>
                            `;
                            avisoFerias.style.display = 'block';
                        } else if (response.aviso_previo) {
                            // Aviso prévio: férias em até 7 dias
                            avisoFerias.innerHTML = `
                                <div class="alert alert-info d-flex align-items-center" role="alert">
                                    <i class="ti ti-info-circle fs-2 me-3"></i>
                                    <div>
                                        <h5 class="alert-heading mb-1">
                                            <i class="ti ti-calendar-event me-1"></i>
                                            Férias Programadas
                                        </h5>
                                        <p class="mb-2">
                                            ${response.mensagem}
                                        </p>
                                        <hr class="my-2">
                                        <p class="mb-0 small">
                                            <strong>💡 Dica:</strong> Prepare-se com antecedência e ative o modo férias nos seus marketplaces quando chegar a data.
                                        </p>
                                    </div>
                                </div>
                            `;
                            avisoFerias.style.display = 'block';
                        } else {
                            // Sem férias ativas ou programadas
                            avisoFerias.style.display = 'none';
                            avisoFerias.innerHTML = '';
                        }
                    },
                    error: function() {
                        console.log('Erro ao buscar dados de férias do fornecedor');
                        avisoFerias.style.display = 'none';
                        avisoFerias.innerHTML = '';
                    }
                });
            }

            // Função para carregar produtos via Ajax
            function carregarProdutos(page = null, categoriaInterna = null) {
                // Recupera filtros da sessão se não informados
                let fornecedor = fornecedorSelect.value;
                let nomeProduto = nomeProdutoInput.value;
                if (categoriaInterna === null) categoriaInterna = $('#categoria_interna').val() || '<?php echo $_SESSION['filtro_categoria_interna'] ?? '' ?>';
                if (page === null) page = '<?php echo $_SESSION['filtro_page'] ?? 1 ?>';

                // Não chama a função se o fornecedor for inválido
                if (fornecedor === 'Selecione um fornecedor...') {
                    produtoCatalogo.innerHTML = '<p class="text-muted">Selecione um fornecedor...</p>';
                    return; // Interrompe a execução
                }

                // Exibe o spinner e o texto "Carregando..."
                produtoCatalogo.innerHTML = `
                    <div class="produto-spinner">
                        <div class="spinner-border me-2" role="status" aria-hidden="true"></div>
                        <span>Carregando...</span>
                    </div>
                `;

                // Salva filtros na sessão
                $.post('../../../update_filtros_sessao.php', {
                    fornecedor: fornecedor,
                    nomeProduto: nomeProduto,
                    categoria_interna: categoriaInterna,
                    page: page
                });

                $.ajax({
                    url: '../../../assets/ajax/produtos/carregar_produtos.php',
                    method: 'GET',
                    data: {
                        fornecedor: fornecedor,
                        nomeProduto: nomeProduto,
                        categoria_interna: categoriaInterna,
                        page: page
                    },
                    success: function(response) {
                        produtoCatalogo.innerHTML = response;
                        // Reinitialize Select2 for dynamically loaded content
                        if ($('#categoria_interna').length) {
                            $('#categoria_interna').select2({
                                theme: 'bootstrap-5',
                                placeholder: "Selecione uma categoria interna...",
                                allowClear: true,
                                dropdownParent: $('#produtoCatalogo'),
                                width: '100%'
                            });
                            // Adiciona classes Bootstrap ao input do Select2
                            $('#categoria_interna').next('.select2-container').find('.select2-selection').addClass('pe-5 me-2');
                            // Impede que o dropdown abra ao remover seleção
                            $('#categoria_interna').on('select2:unselect', function(e) {
                                $(this).select2('close');
                            });
                            // Set the current category as selected
                            if (typeof categoriaInterna !== 'undefined') {
                                $('#categoria_interna').val(categoriaInterna || '').trigger('change.select2');
                            }
                        }
                        // Reassign event handlers for pagination links
                        $('.page-link').on('click', function(event) {
                            event.preventDefault(); // Prevent page reload
                            const urlParams = new URLSearchParams($(this).attr('href'));
                            const page = urlParams.get('page'); // Extract page number
                            carregarProdutos(page, categoriaInterna); // Load the requested page with filters
                        });
                        // Reassign event handler for the filter button
                        $('#filtrar_categoria').off('click').on('click', function() {
                            carregarProdutos(1, $('#categoria_interna').val()); // Reload products when the filter button is clicked
                        });
                    },
                    error: function() {
                        produtoCatalogo.innerHTML = '<p class="text-danger">Erro ao carregar produtos.</p>';
                    }
                });
            }

            // Preencher campos com valores da sessão ao carregar a página
            $(function() {
                const fornecedorSessao = '<?php echo $_SESSION['filtro_fornecedor'] ?? '' ?>';
                const nomeProdutoSessao = '<?php echo $_SESSION['filtro_nomeProduto'] ?? '' ?>';
                if (fornecedorSessao) {
                    fornecedorSelect.value = fornecedorSessao;
                    // Verifica férias do fornecedor ao carregar
                    verificarFerias(fornecedorSessao);
                }
                if (nomeProdutoSessao) nomeProdutoInput.value = nomeProdutoSessao;

                // Quando a categoria interna for alterada, recarrega produtos mantendo o fornecedor atual
                $(document).on('change', '#categoria_interna', function() {
                    const value = $(this).val() || '';
                    carregarProdutos(1, value);
                });
            });

            // Eventos de mudança no filtro
            fornecedorSelect.addEventListener('change', function() {
                // Limpa a categoria selecionada quando o fornecedor muda
                if ($('#categoria_interna').length) {
                    $('#categoria_interna').val('').trigger('change.select2');
                }
                // Verifica férias do fornecedor
                verificarFerias(this.value);
                // Recarrega produtos ao selecionar fornecedor
                carregarProdutos(1);
            });

            // Usa a função de debounce para o campo de nome do produto
            const debouncedSearch = debounce(function() {
                carregarProdutos(); // Recarrega produtos após parar de digitar
            }, 800);

            nomeProdutoInput.addEventListener('keyup', debouncedSearch);

            // Também permite pesquisar ao pressionar Enter
            nomeProdutoInput.addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    carregarProdutos();
                }
            });

            $(document).on('click', '#filtrar_categoria', function() {
                carregarProdutos(1, $('#categoria_interna').val()); // Recarrega produtos ao clicar no botão de lupa
            });

            // Initial load with session data
            carregarProdutos();
        });
    </script>

    <script>
        function cadastrarProduto(produto, botao) {
            botao.disabled = true;
            let textoOriginal = botao.innerHTML;

            // Adiciona o spinner e o texto "Processando..."
            botao.innerHTML = `<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span> Processando...`;

            // Cria um formulário dinamicamente
            var form = document.createElement("form");
            form.method = "POST";
            
            // Define a action baseada na configuração do site
            var siteName = "<?php echo Config::get('site_configs.name'); ?>";
            if (siteName === 'Homolog' || siteName === 'stage') {
                form.action = "/dash/cadastrar_produtos"; // A página para onde será enviado
            } else {
                form.action = "/dash/cadastrar_produtos"; // A página para onde será enviado
            }

            // Cria um campo de input escondido para os dados do produto
            var input = document.createElement("input");
            input.type = "hidden";
            input.name = "produto";
            input.value = JSON.stringify(produto);

            // Adiciona o campo ao formulário e envia
            form.appendChild(input);
            document.body.appendChild(form);
            form.submit();
        }
    </script>

</body>

</html>