<?php
session_start();

require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');

// ============================================
// 🔧 CONFIGURAÇÕES DE DESENVOLVIMENTO
// ============================================
// Ativar/Desativar validações automáticas na página de vendas
// true = ATIVO (produção) | false = DESATIVADO (testes/desenvolvimento)
$ENABLE_PAGE_VALIDATION = false; // Altere para false durante testes
// ============================================

// Criar conexão específica para drophub_global
try {
    $host = Config::get('database.host');
    $username = Config::get('database.user');
    $password = Config::get('database.password');

    $pdoGlobal = new PDO("mysql:host=$host;dbname=drophub_global;charset=utf8mb4", $username, $password);
    $pdoGlobal->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdoGlobal->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    $pdoGlobal->exec("SET NAMES utf8mb4 COLLATE utf8mb4_general_ci");
} catch (PDOException $e) {
    die('Erro na conexão com drophub_global: ' . $e->getMessage());
}

include_once('../../funcoes/general.php');

// Carrega traduções
$traducao = require '../../custom/translations/pt-br.php';

include_once('../../funcoes/users.php');

// Classes
require '../../class/walletClass.php';
require '../../class/cryptohelper.php';
require '../../class/getPlanosConfig.php';
require '../../class/chamadosClass.php';
require '../../class/vendasClass.php';
require '../../class/statusClass.php';
require '../../class/topicoClass.php';
require '../../class/getEtiquetasClass.php';
require '../../class/GenerateEtiquetasClass.php';
require '../../class/getProdutosVendas.php';
require '../../class/pagarVendaUsuarioClass.php';
require '../../class/validaAssinatura.php';


// Verifica se está logado ou não
if (!isset($_SESSION['usuario']['email'])) {
    header('Location: /login');
    exit();
}

$customBase = __DIR__ . '/../../custom/includes/';
if (isset($_SESSION['usuario']['is_adm']) && $_SESSION['usuario']['is_adm'] == 1) {
    $customDir = $customBase . 'admin/';
} else {
    $customDir = $customBase . 'user/';
}

if (is_dir($customDir)) {
    foreach (glob($customDir . '*.php') as $filename) {
        include_once $filename;
    }
}

// Valida Sessoes e atualiza dados
validarSessaoUsuario($pdo, $_SESSION['usuario']['id_usuario']);
$is_affiliate = $_SESSION['usuario']['is_affiliate'] == '1' ? 1 : 0;

// Array de marketplaces onde é possível reprocessar etiqueta
$marketplaces = [
    'shopee',
    'Shopee',
    'mercado_livre',
    'mercado livre'
];

// Array de ecommerces onde é possível comprar etiqueta
$ecommerces = [
    'ecommerce',
    'loja_virtual',
    'site',
    'wordpress',
    'woocommerce',
    'magento',
    'shopify',
    'yampi',
    'vtex'
];

?>



<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr"
    data-theme="theme-default" data-assets-path="../../assets/"
    data-template="vertical-menu-template-no-customizer-starter">

<head>
    <?php include('../../includes/dashHead.php'); ?>


    <link rel="stylesheet" href="../../assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/swiper/swiper.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/pages/cards-advance.css" />
    <link rel="stylesheet" href="../../assets/css/sales-collector.css" />
    <link rel="stylesheet" href="../../assets/css/vendas.css" />

    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/vendor/js/template-customizer.js"></script>
    <script src="../../assets/js/config.js"></script>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
    <script src="../../assets/js/funcoes.js"></script>

    <!-- Estilos para destacar upload obrigatório de etiqueta PolicyAgent -->
    <style>
        @keyframes pulseUploadObrigatorio {

            0%,
            100% {
                transform: scale(1);
                box-shadow: 0 2px 8px rgba(255, 193, 7, 0.3);
            }

            50% {
                transform: scale(1.05);
                box-shadow: 0 4px 16px rgba(255, 193, 7, 0.6);
            }
        }

        .badge.shadow {
            animation: pulseUploadObrigatorio 2s ease-in-out infinite;
        }

        .badge.shadow:hover {
            animation: none;
            transform: scale(1.08);
            box-shadow: 0 6px 20px rgba(255, 193, 7, 0.8) !important;
        }

        /* ============================================
           🎨 ESTILOS MOBILE-FIRST PARA PRODUTOS
           ============================================ */

        /* Card de Produto - Design Limpo */
        #etq_produtos_container .card {
            transition: all 0.3s ease;
        }

        #etq_produtos_container .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
        }

        /* Header do Accordion de Produto */
        #etq_produtos_container .card-header {
            border-radius: 0.375rem 0.375rem 0 0 !important;
        }

        #etq_produtos_container .card-header button {
            background: none;
            border: none;
            font-size: 0.95rem;
            padding: 0.75rem 1rem;
            transition: all 0.2s ease;
        }

        #etq_produtos_container .card-header button:focus {
            box-shadow: none;
            outline: none;
        }

        /* Seções de Informações */
        #etq_produtos_container h6.text-muted {
            font-size: 0.85rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border-bottom: 2px solid #e9ecef;
            padding-bottom: 0.5rem;
        }

        /* Inputs Responsivos */
        #etq_produtos_container .form-control-sm {
            font-size: 0.875rem;
            padding: 0.5rem 0.75rem;
        }

        #etq_produtos_container .input-group-text {
            font-size: 0.875rem;
            background-color: #f8f9fa;
            border-color: #dee2e6;
        }

        /* Labels Compactos */
        #etq_produtos_container .form-label {
            margin-bottom: 0.25rem;
            font-weight: 500;
            color: #495057;
        }

        #etq_produtos_container .form-label.small {
            font-size: 0.813rem;
        }

        /* Accordion de Informações Adicionais */
        #etq_produtos_container .accordion-button {
            font-size: 0.875rem;
            font-weight: 500;
            color: #6c757d;
            border-radius: 0.375rem !important;
        }

        #etq_produtos_container .accordion-button:not(.collapsed) {
            background-color: #e7f1ff;
            color: #0d6efd;
        }

        /* Campos readonly */
        #etq_produtos_container .form-control[readonly] {
            background-color: #f8f9fa;
            border-color: #e9ecef;
            color: #6c757d;
            cursor: not-allowed;
        }

        /* Badge de Quantidade */
        #etq_produtos_container .badge.bg-light {
            font-size: 0.875rem;
            font-weight: 600;
            padding: 0.5rem 0.75rem;
        }

        /* Ícones */
        #etq_produtos_container .ti {
            font-size: 1rem;
        }

        /* Responsividade Mobile */
        @media (max-width: 576px) {
            #etq_produtos_container .card-body {
                padding: 0.75rem !important;
            }

            #etq_produtos_container h6.text-muted {
                font-size: 0.75rem;
                margin-bottom: 0.5rem;
            }

            #etq_produtos_container .form-label.small {
                font-size: 0.75rem;
            }

            #etq_produtos_container .form-control-sm,
            #etq_produtos_container .input-group-text {
                font-size: 0.813rem;
                padding: 0.375rem 0.5rem;
            }

            #etq_produtos_container .card-header button {
                font-size: 0.875rem;
                padding: 0.625rem 0.75rem;
            }

            #etq_produtos_container .badge.bg-light {
                font-size: 0.75rem;
                padding: 0.375rem 0.625rem;
            }

            /* Espaçamento reduzido em mobile */
            #etq_produtos_container .mb-3 {
                margin-bottom: 0.75rem !important;
            }

            #etq_produtos_container .row.g-2 {
                --bs-gutter-x: 0.5rem;
                --bs-gutter-y: 0.5rem;
            }
        }

        /* Animação de Entrada */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        #etq_produtos_container .card {
            animation: fadeInUp 0.3s ease-out;
        }

        /* Melhorar visual de campos obrigatórios */
        #etq_produtos_container .text-danger {
            font-size: 0.75rem;
            font-weight: 700;
        }

        /* Hover em inputs */
        #etq_produtos_container .form-control:focus,
        #etq_produtos_container .form-select:focus {
            border-color: #0d6efd;
            box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.15);
        }

        /* ============================================ */
        /* CARDS DE VENDAS - DESIGN MODERNO BS5 */
        /* ============================================ */

        /* Apenas ajustes mínimos - Bootstrap 5.3 faz o resto */
        #vendasCards .card {
            border: 0;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        #vendasCards .card:hover {
            transform: translateY(-4px);
            box-shadow: 0 .5rem 1rem rgba(0, 0, 0, .15) !important;
        }

        /* ============================================ */
        /* TABS DE NAVEGAÇÃO */
        /* ============================================ */

        /* Quando o tab está ativo, o badge fica semi-transparente branco */
        #statusTabs .nav-link.active .badge {
            background-color: rgba(255, 255, 255, 0.3) !important;
            color: #fff !important;
            border: 1px solid rgba(255, 255, 255, 0.5);
        }

        /* Garantir que badges sempre apareçam */
        #statusTabs .badge {
            display: inline-block !important;
            min-width: 20px;
            font-weight: 600;
        }

        /* ============================================ */
        /* BOTÃO FLUTUANTE IMPORTAR VENDAS */
        /* ============================================ */

        /* Botão flutuante (mesmo estilo do baixar_etiquetas.php) */
        .floating-import-btn {
            position: fixed !important;
            bottom: 20px !important;
            right: 20px !important;
            z-index: 9999 !important;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3) !important;
            animation: slideUp 0.3s ease-out;
            border-radius: 50px !important;
            padding: 12px 24px !important;
            font-weight: bold !important;
        }

        @keyframes slideUp {
            from {
                transform: translateY(50px);
                opacity: 0;
            }

            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        /* ============================================ */
        /* IMPORTAÇÃO DE VENDAS - VISUAL MODERNO */
        /* ============================================ */
        
        /* Cards de produtos com hover suave */
        #importResult .card {
            transition: all 0.2s ease;
        }
        
        #importResult .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1) !important;
        }
        
        /* Imagens de produtos com borda suave */
        #importResult img {
            border: 1px solid #e0e0e0;
        }
        
        /* Badges personalizados */
        #importResult .badge {
            padding: 0.35em 0.65em;
            font-weight: 500;
        }
        
        /* Texto truncado com tooltip */
        #importResult .text-truncate {
            cursor: help;
        }
        
        /* Card de total com destaque */
        #importResult .bg-light {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%) !important;
        }
        
        /* Responsividade para mobile */
        @media (max-width: 768px) {
            #importResult h6 {
                font-size: 0.9rem;
            }
            
            #importResult .card-body {
                padding: 0.75rem !important;
            }
            
            #importResult img {
                width: 50px !important;
                height: 50px !important;
            }
        }
        
        /* ============================================ */
    </style>

</head>

<body>

    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo mt-3">
                    <a href="dashboard" class="app-brand-link">

                        <?php
                        if (Config::get('site_configs.text_icon') == true) {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>"
                                    width="<?php echo Config::get('site_configs.icon_width'); ?>"
                                    height="<?php echo Config::get('site_configs.icon_height'); ?>"
                                    style="object-fit: contain;">
                            </span>
                            <span
                                class="app-brand-text text-body fw-bold ms-1"><?php echo Config::get('database.dbname'); ?></span>
                        <?php
                        } else {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>"
                                    width="<?php echo Config::get('site_configs.icon_width'); ?>"
                                    height="<?php echo Config::get('site_configs.icon_height'); ?>"
                                    style="object-fit: contain;">
                            </span>
                        <?php
                        }
                        ?>

                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                        <i class="ti menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
                        <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1">
                    <?php
                    if ($_SESSION['usuario']['n_acesso'] == '0') {
                        include('../../includes/sidebars-menus/sidebar_usuario.php');
                    } else {
                        include('../../includes/sidebars-menus/sidebar_master.php');
                    }
                    ?>

                </ul>
            </aside>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme"
                    id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="ti ti-menu-2 ti-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <?php include('../../includes/dashnav.php') ?>

                    </div>
                </nav>

                <!-- / Navbar -->

                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">

                        <div class="container-fluid px-2 mt-3">
                            <div class="row">
                                <div class="col-12">
                                    <?php
                                    // Verifica se o formulário foi enviado
                                    if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                                        $whereClauses = [];
                                        $params = [];

                                        // Detecta se há QUALQUER filtro do usuário (além de paginação / tab)
                                        $filterKeys = [
                                            'order_id',
                                            'integracao',
                                            'fornecedor',
                                            'dta_venda_de',
                                            'dta_venda_ate',
                                            'anexado_nf',
                                            'preco_custo',
                                            'status_venda'
                                        ];
                                        $hasUserFilters = false;
                                        foreach ($filterKeys as $k) {
                                            if (isset($_GET[$k]) && $_GET[$k] !== '') {
                                                $hasUserFilters = true;
                                                break;
                                            }
                                        }

                                        // Filtros básicos
                                        if (!empty($_GET['order_id'])) {
                                            $whereClauses[] = 'mv.order_id = :order_id';
                                            $params[':order_id'] = $_GET['order_id'];
                                        }
                                        if (!empty($_GET['integracao'])) {
                                            $whereClauses[] = 'mv.integracao = :integracao';
                                            $params[':integracao'] = $_GET['integracao'];
                                        }
                                        if (!empty($_GET['fornecedor'])) {
                                            $whereClauses[] = 'mv.fornecedor = :fornecedor';
                                            $params[':fornecedor'] = $_GET['fornecedor'];
                                        }

                                        // Intervalo de datas explícito (só aplica se ambos os campos estiverem preenchidos)
                                        if (!empty($_GET['dta_venda_de']) && !empty($_GET['dta_venda_ate'])) {
                                            $whereClauses[] = 'mv.vendido_dia BETWEEN :dta_venda_de AND :dta_venda_ate';
                                            $params[':dta_venda_de'] = $_GET['dta_venda_de'];
                                            $params[':dta_venda_ate'] = $_GET['dta_venda_ate'];
                                        }

                                        // preco_custo
                                        if (!empty($_GET['preco_custo'])) {
                                            if ($_GET['preco_custo'] === 'pago') {
                                                $whereClauses[] = 'mv.vlr_custo_pago = :vlr_custo_pago';
                                                $params[':vlr_custo_pago'] = 1;
                                            } elseif ($_GET['preco_custo'] === 'pendente') {
                                                $whereClauses[] = 'mv.vlr_custo_pago = :vlr_custo_pago';
                                                $params[':vlr_custo_pago'] = 0;
                                            }
                                        }

                                        // NF
                                        if (!empty($_GET['anexado_nf'])) {
                                            if ($_GET['anexado_nf'] === 'anexado') {
                                                $whereClauses[] = 'mv.anexado_nf = :anexado_nf';
                                                $params[':anexado_nf'] = 1;
                                            } elseif ($_GET['anexado_nf'] === 'pendente') {
                                                $whereClauses[] = '(mv.anexado_nf IS NULL OR mv.anexado_nf = 0)';
                                            }
                                        }

                                        // Status da Venda (select único)
                                        if (!empty($_GET['status_venda'])) {
                                            switch ($_GET['status_venda']) {
                                                case 'cancelada':
                                                    $whereClauses[] = 'mv.cancelado = 1';
                                                    break;
                                                case 'enviada':
                                                    $whereClauses[] = 'mv.enviado = 1';
                                                    break;
                                                case 'reembolsada':
                                                    $whereClauses[] = 'mv.reembolsado = 1';
                                                    break;
                                            }
                                        }

                                        // Determina se temos intervalo de datas explícito
                                        $hasExplicitDateRange = (!empty($_GET['dta_venda_de']) && !empty($_GET['dta_venda_ate']));
                                        // Aplica limites históricos (30 dias / 15 dias) somente se não houver NENHUM filtro do usuário
                                        $applyHistoricalLimits = !$hasUserFilters && !$hasExplicitDateRange;

                                        if ($applyHistoricalLimits) {
                                            // Limite padrão de 30 dias (somente quando sem filtros)
                                            $whereClauses[] = 'mv.vendido_dia >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)';
                                            // Mantém regra de mostrar pagos apenas últimos 15 dias
                                            $whereClauses[] = '(mv.vlr_custo_pago = 0 OR (mv.vlr_custo_pago = 1 AND mv.dta_vl_pago >= DATE_SUB(CURDATE(), INTERVAL 15 DAY)))';
                                            // Opcional: ocultar enviados muito antigos (descomentear se desejado)
                                            // $whereClauses[] = 'NOT (mv.enviado = 1 AND mv.dta_enviado < DATE_SUB(CURDATE(), INTERVAL 30 DAY))';
                                        } else {
                                            // Quando há filtros (ex: período junho-julho), NÃO restringe por 30/15 dias
                                            // Porém, se quiser ainda impedir blow-up de resultados, pode inserir um limite hard aqui.
                                            // (Deixado vazio propositalmente)
                                        }

                                        // Escopo whitelabel / usuário
                                        if ($is_affiliate == 1) {
                                            $whereClauses[] = 'mv.whitelabel LIKE :whitelabel COLLATE utf8_general_ci';
                                            $params[':whitelabel'] = Config::get('database.dbname');
                                        } else {
                                            $whereClauses[] = 'mv.usuario_id = :usuario_id AND mv.whitelabel LIKE :whitelabel COLLATE utf8_general_ci';
                                            $params[':usuario_id'] = $_SESSION['usuario']['id_usuario'];
                                            $params[':whitelabel'] = Config::get('database.dbname');
                                        }

                                        // Subquery reembolso (mantida, mas corrigindo GROUP BY faltante)
                                        $subSr = '(
                                            SELECT s1.*
                                            FROM drophub_global.solicitacoes_reembolso s1
                                            INNER JOIN (
                                                SELECT numero_do_pedido, MAX(id) AS max_id
                                                FROM drophub_global.solicitacoes_reembolso
                                                GROUP BY numero_do_pedido
                                            ) s2 ON s1.id = s2.max_id
                                        ) sr';

                                        $sql = 'SELECT mv.saleTitle, mv.id_pagamento, mv.enviado, mv.dta_enviado, mv.fornecedor, mv.vlr_custo_pago, mv.vlr_custo, mv.dta_vl_pago, mv.order_id, mv.saleId, mv.codigo_rastreio, mv.etiqueta_ml, mv.vlr_total, mv.anexado_nf, mv.dta_anexado_nf, mv.anexado_etiqueta, mv.vendido_dia, mv.integracao, mv.loja_nome, mv.infos_comprador, mv.shipping_id, mv.cancelado, mv.reembolsado, mv.observacoes, mv.status_venda, mv.status_complementar, mv.pedido_manual,
                                 COALESCE(f.nome, CONCAT("", mv.fornecedor)) as fornecedor_nome,
                                 f.ferias_ativo, f.ferias_de, f.ferias_ate,
                                 sr.dta_devolucao, sr.status as sr_status
                                            FROM drophub_global.minhas_vendas mv
                                            LEFT JOIN drophub_global.fornecedores f ON mv.fornecedor = f.id
                                            LEFT JOIN ' . $subSr . ' ON mv.saleId = sr.numero_do_pedido';

                                        if (!empty($whereClauses)) {
                                            $sql .= ' WHERE ' . implode(' AND ', $whereClauses);
                                        }

                                        // Ordenação: canceladas no final, depois vendas mais recentes primeiro
                                        $orderBy = ' ORDER BY 
                                            CASE WHEN mv.cancelado = 1 THEN 1 ELSE 0 END ASC,
                                            mv.vendido_dia DESC, 
                                            mv.vlr_custo_pago ASC, 
                                            mv.integracao ASC';

                                        // Configuração da paginação
                                        $itensPorPagina = isset($_GET['itens_por_pagina']) ? (int)$_GET['itens_por_pagina'] : 10;
                                        $itensPorPagina = in_array($itensPorPagina, [10, 20, 50, 100]) ? $itensPorPagina : 10; // Validação
                                        $paginaAtual = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;
                                        $paginaAtual = max(1, $paginaAtual); // Garante que seja pelo menos 1
                                        $offset = ($paginaAtual - 1) * $itensPorPagina;

                                        // Primeiro, contar o total de registros
                                        // Query de contagem corrigida para não inflar resultados por múltiplas solicitações: COUNT DISTINCT saleId
                                        $sqlCount = 'SELECT COUNT(DISTINCT mv.saleId) FROM drophub_global.minhas_vendas mv LEFT JOIN drophub_global.fornecedores f ON mv.fornecedor = f.id LEFT JOIN ' . $subSr . ' ON mv.saleId = sr.numero_do_pedido';
                                        if (!empty($whereClauses)) {
                                            $sqlCount .= ' WHERE ' . implode(' AND ', $whereClauses);
                                        }

                                        try {
                                            $stmtCount = $pdo->prepare($sqlCount);
                                            $stmtCount->execute($params);
                                            $totalVendas = $stmtCount->fetchColumn();
                                        } catch (PDOException $e) {
                                            $totalVendas = 0;
                                        }

                                        // Agora fazer a consulta com paginação
                                        $sql .= $orderBy . ' LIMIT :limit OFFSET :offset';

                                        // Executar a consulta
                                        try {
                                            $stmt = $pdo->prepare($sql);
                                            // Bind dos parâmetros existentes
                                            foreach ($params as $key => $value) {
                                                $stmt->bindValue($key, $value);
                                            }
                                            // Bind dos parâmetros de paginação
                                            $stmt->bindValue(':limit', $itensPorPagina, PDO::PARAM_INT);
                                            $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
                                            $stmt->execute();
                                            $vendas = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                        } catch (PDOException $e) {
                                            echo "Erro ao consultar as vendas: " . $e->getMessage();
                                            $vendas = [];
                                            $totalVendas = 0;
                                        }
                                    } else {
                                        $vendas = [];
                                        $totalVendas = 0;
                                    }

                                    // Buscar integrações únicas para o filtro
                                    $integracoesDisponiveis = [];
                                    try {
                                        $sqlIntegracoes = "SELECT DISTINCT integracao FROM drophub_global.minhas_vendas WHERE ";
                                        if ($is_affiliate == 1) {
                                            $sqlIntegracoes .= "whitelabel LIKE :whitelabel COLLATE utf8_general_ci";
                                        } else {
                                            $sqlIntegracoes .= "usuario_id = :usuario_id AND whitelabel LIKE :whitelabel COLLATE utf8_general_ci";
                                        }
                                        $sqlIntegracoes .= " ORDER BY integracao ASC";

                                        $stmtIntegracoes = $pdo->prepare($sqlIntegracoes);
                                        $stmtIntegracoes->bindValue(':whitelabel', Config::get('database.dbname'));
                                        if ($is_affiliate != 1) {
                                            $stmtIntegracoes->bindValue(':usuario_id', $_SESSION['usuario']['id_usuario'], PDO::PARAM_INT);
                                        }
                                        $stmtIntegracoes->execute();
                                        $integracoesDisponiveis = $stmtIntegracoes->fetchAll(PDO::FETCH_COLUMN);
                                    } catch (PDOException $e) {
                                        $integracoesDisponiveis = [];
                                    }

                                    // Buscar fornecedores únicos para o filtro
                                    $fornecedoresDisponiveis = [];
                                    try {
                                        $sqlFornecedores = "SELECT DISTINCT mv.fornecedor, COALESCE(f.nome, CONCAT('Fornecedor ', mv.fornecedor)) as fornecedor_nome 
                                                           FROM drophub_global.minhas_vendas mv 
                                                           LEFT JOIN drophub_global.fornecedores f ON mv.fornecedor = f.id 
                                                           WHERE ";
                                        if ($is_affiliate == 1) {
                                            $sqlFornecedores .= "mv.whitelabel LIKE :whitelabel COLLATE utf8_general_ci";
                                        } else {
                                            $sqlFornecedores .= "mv.usuario_id = :usuario_id AND mv.whitelabel LIKE :whitelabel COLLATE utf8_general_ci";
                                        }
                                        $sqlFornecedores .= " AND mv.fornecedor IS NOT NULL ORDER BY fornecedor_nome ASC";

                                        $stmtFornecedores = $pdo->prepare($sqlFornecedores);
                                        $stmtFornecedores->bindValue(':whitelabel', Config::get('database.dbname'));
                                        if ($is_affiliate != 1) {
                                            $stmtFornecedores->bindValue(':usuario_id', $_SESSION['usuario']['id_usuario'], PDO::PARAM_INT);
                                        }
                                        $stmtFornecedores->execute();
                                        $fornecedoresDisponiveis = $stmtFornecedores->fetchAll(PDO::FETCH_ASSOC);
                                    } catch (PDOException $e) {
                                        $fornecedoresDisponiveis = [];
                                    }

                                    // Calcular informações da paginação se há registros
                                    if (isset($totalVendas)) {
                                        $totalPaginas = $totalVendas > 0 ? ceil($totalVendas / $itensPorPagina) : 1;
                                        $paginaAtual = min($paginaAtual, $totalPaginas); // Garante que não exceda o total
                                    }

                                    // Calcular contadores por status para as tabs
                                    $statusCounts = [
                                        'todas' => 0,
                                        'pendentes' => 0,
                                        'pagas' => 0,
                                        'enviadas' => 0,
                                        'canceladas' => 0,
                                        'reembolsadas' => 0,
                                        'problema_pagamento' => 0,
                                        'problema_etiqueta' => 0
                                    ];

                                    if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                                        // Construir consulta base para contadores (sem paginação)
                                        $baseWhereClausesForCounts = [];
                                        $baseParamsForCounts = [];

                                        // Aplicar apenas filtros básicos (não de status)
                                        if (!empty($_GET['order_id'])) {
                                            $baseWhereClausesForCounts[] = 'mv.order_id = :order_id';
                                            $baseParamsForCounts[':order_id'] = $_GET['order_id'];
                                        }

                                        if (!empty($_GET['integracao'])) {
                                            $baseWhereClausesForCounts[] = 'mv.integracao = :integracao';
                                            $baseParamsForCounts[':integracao'] = $_GET['integracao'];
                                        }

                                        if (!empty($_GET['fornecedor'])) {
                                            $baseWhereClausesForCounts[] = 'mv.fornecedor = :fornecedor';
                                            $baseParamsForCounts[':fornecedor'] = $_GET['fornecedor'];
                                        }

                                        if (!empty($_GET['dta_venda_de']) && !empty($_GET['dta_venda_ate'])) {
                                            $baseWhereClausesForCounts[] = 'mv.vendido_dia BETWEEN :dta_venda_de AND :dta_venda_ate';
                                            $baseParamsForCounts[':dta_venda_de'] = $_GET['dta_venda_de'];
                                            $baseParamsForCounts[':dta_venda_ate'] = $_GET['dta_venda_ate'];
                                        }

                                        if (!empty($_GET['preco_custo'])) {
                                            if ($_GET['preco_custo'] === 'pago') {
                                                $baseWhereClausesForCounts[] = 'mv.vlr_custo_pago = :vlr_custo_pago';
                                                $baseParamsForCounts[':vlr_custo_pago'] = 1;
                                            } elseif ($_GET['preco_custo'] === 'pendente') {
                                                $baseWhereClausesForCounts[] = 'mv.vlr_custo_pago = :vlr_custo_pago';
                                                $baseParamsForCounts[':vlr_custo_pago'] = 0;
                                            }
                                        }

                                        if (!empty($_GET['anexado_nf'])) {
                                            if ($_GET['anexado_nf'] === 'anexado') {
                                                $baseWhereClausesForCounts[] = 'mv.anexado_nf = :anexado_nf';
                                                $baseParamsForCounts[':anexado_nf'] = 1;
                                            } elseif ($_GET['anexado_nf'] === 'pendente') {
                                                $baseWhereClausesForCounts[] = '(mv.anexado_nf IS NULL OR mv.anexado_nf = 0)';
                                            }
                                        }

                                        // Filtros de usuário/whitelabel
                                        // ✅ IMPORTANTE: Sempre filtra por usuário/whitelabel atual
                                        // Isso garante que as tabs mostrem apenas vendas do usuário logado
                                        if ($is_affiliate == 1) {
                                            $baseWhereClausesForCounts[] = 'mv.whitelabel LIKE :whitelabel COLLATE utf8_general_ci';
                                            $baseParamsForCounts[':whitelabel'] = Config::get('database.dbname');
                                        } else {
                                            $baseWhereClausesForCounts[] = 'mv.usuario_id = :usuario_id and mv.whitelabel LIKE :whitelabel COLLATE utf8_general_ci';
                                            $baseParamsForCounts[':usuario_id'] = $_SESSION['usuario']['id_usuario'];
                                            $baseParamsForCounts[':whitelabel'] = Config::get('database.dbname');
                                        }

                                        // Repete detecção de filtros para contadores
                                        // ✅ Verifica se há filtro de período de venda ativo
                                        $filterKeysCounts = ['order_id', 'integracao', 'fornecedor', 'dta_venda_de', 'dta_venda_ate', 'anexado_nf', 'preco_custo', 'status_cancelada', 'status_enviada', 'status_reembolsada'];
                                        $hasUserFiltersCounts = false;
                                        foreach ($filterKeysCounts as $kcf) {
                                            if (isset($_GET[$kcf]) && $_GET[$kcf] !== '') {
                                                $hasUserFiltersCounts = true;
                                                break;
                                            }
                                        }
                                        $hasExplicitDateRangeCounts = (!empty($_GET['dta_venda_de']) && !empty($_GET['dta_venda_ate']));
                                        $applyHistoricalLimitsCounts = !$hasUserFiltersCounts && !$hasExplicitDateRangeCounts;

                                        // ✅ Se NÃO tem filtro de período: aplica limite histórico padrão (30 dias)
                                        // ✅ Se TEM filtro de período: usa o período escolhido pelo usuário
                                        if ($applyHistoricalLimitsCounts) {
                                            $baseWhereClausesForCounts[] = 'mv.vendido_dia >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)';
                                            $baseWhereClausesForCounts[] = '(vlr_custo_pago = 0 OR (vlr_custo_pago = 1 AND dta_vl_pago >= DATE_SUB(CURDATE(), INTERVAL 15 DAY)))';
                                        }

                                        $baseWhere = !empty($baseWhereClausesForCounts) ? 'WHERE ' . implode(' AND ', $baseWhereClausesForCounts) : '';

                                        // ✅ QUERIES OTIMIZADAS COM LÓGICA CORRETA
                                        // Contar por cada status com condições precisas
                                        $statusQueries = [
                                            'todas' => "SELECT COUNT(*) FROM drophub_global.minhas_vendas mv $baseWhere",

                                            // Pendentes: não pago, não cancelado, não reembolsado
                                            'pendentes' => "SELECT COUNT(*) FROM drophub_global.minhas_vendas mv $baseWhere 
                                                AND (cancelado IS NULL OR cancelado = 0) 
                                                AND (reembolsado IS NULL OR reembolsado = 0)
                                                AND vlr_custo_pago = 0",

                                            // Pagas: valor pago = 1
                                            'pagas' => "SELECT COUNT(*) FROM drophub_global.minhas_vendas mv $baseWhere 
                                                AND vlr_custo_pago = 1
                                                AND (cancelado IS NULL OR cancelado = 0)
                                                AND (reembolsado IS NULL OR reembolsado = 0)",

                                            // Enviadas: enviado = 1
                                            'enviadas' => "SELECT COUNT(*) FROM drophub_global.minhas_vendas mv $baseWhere 
                                                AND enviado = 1
                                                AND (cancelado IS NULL OR cancelado = 0)
                                                AND (reembolsado IS NULL OR reembolsado = 0)",

                                            // Canceladas: cancelado = 1
                                            'canceladas' => "SELECT COUNT(*) FROM drophub_global.minhas_vendas mv $baseWhere 
                                                AND cancelado = 1",

                                            // Reembolsadas: reembolsado = 1
                                            'reembolsadas' => "SELECT COUNT(*) FROM drophub_global.minhas_vendas mv $baseWhere 
                                                AND reembolsado = 1",

                                            // Problema Pagamento: não pago mas tem ID de pagamento
                                            'problema_pagamento' => "SELECT COUNT(*) FROM drophub_global.minhas_vendas mv $baseWhere 
                                                AND vlr_custo_pago = 0 
                                                AND id_pagamento IS NOT NULL 
                                                AND id_pagamento != ''
                                                AND (cancelado IS NULL OR cancelado = 0)
                                                AND (reembolsado IS NULL OR reembolsado = 0)",

                                            // Problema Etiqueta: etiqueta vazia ou nula (exceto processing_label)
                                            'problema_etiqueta' => "SELECT COUNT(*) FROM drophub_global.minhas_vendas mv $baseWhere 
                                                AND (etiqueta_ml IS NULL OR etiqueta_ml = '') 
                                                AND (etiqueta_ml != 'processing_label' OR etiqueta_ml IS NULL)
                                                AND (cancelado IS NULL OR cancelado = 0)
                                                AND (reembolsado IS NULL OR reembolsado = 0)"
                                        ];

                                        try {
                                            foreach ($statusQueries as $status => $query) {
                                                $stmtCount = $pdoGlobal->prepare($query);
                                                $stmtCount->execute($baseParamsForCounts);
                                                $statusCounts[$status] = (int)$stmtCount->fetchColumn();
                                            }

                                            // Debug: Log dos contadores e filtros aplicados
                                            error_log("📊 Status Counts: " . json_encode($statusCounts));
                                            error_log("🔍 Filtros ativos - Usuario: " . $_SESSION['usuario']['id_usuario'] .
                                                " | Whitelabel: " . Config::get('database.dbname') .
                                                " | Período: " . (isset($_GET['dta_venda_de']) ? $_GET['dta_venda_de'] . ' a ' . $_GET['dta_venda_ate'] : 'padrão 30 dias'));
                                        } catch (PDOException $e) {
                                            // Log do erro para debug
                                            error_log("❌ Erro ao contar status: " . $e->getMessage());
                                            // Em caso de erro, manter zeros
                                        }
                                    }

                                    // Determinar a tab ativa baseada nos filtros (não usado mais, mas mantido para compatibilidade)
                                    $activeTab = 'todas';
                                    if (isset($_GET['status_cancelada']) && !isset($_GET['status_enviada']) && !isset($_GET['status_reembolsada'])) {
                                        $activeTab = 'canceladas';
                                    } elseif (isset($_GET['status_enviada']) && !isset($_GET['status_cancelada']) && !isset($_GET['status_reembolsada'])) {
                                        $activeTab = 'enviadas';
                                    } elseif (isset($_GET['status_reembolsada']) && !isset($_GET['status_cancelada']) && !isset($_GET['status_enviada'])) {
                                        $activeTab = 'reembolsadas';
                                    } elseif (!empty($_GET['preco_custo']) && $_GET['preco_custo'] === 'pago') {
                                        $activeTab = 'pagas';
                                    } elseif (!empty($_GET['preco_custo']) && $_GET['preco_custo'] === 'pendente') {
                                        $activeTab = 'pendentes';
                                    }
                                    ?>

                                    <!-- Botão Importar Vendas -->
                                    <div class="container mb-3">
                                        <div class="text-end">
                                            <button type="button" class="btn btn-primary" id="btnImportarVendas" data-bs-toggle="modal" data-bs-target="#modalImportarVendas">
                                                <i class="ti ti-upload me-1"></i> Importar Vendas
                                            </button>
                                        </div>
                                    </div>

                                    <!-- Content Area -->

                                    <!-- Info de Paginação -->
                                    <div class="tab-content" id="statusTabsContent">
                                        <?php if (isset($totalVendas) && $totalVendas > 0): ?>
                                            <div class="d-flex justify-content-between flex-wrap align-items-center mb-3">
                                                <div class="text-muted">
                                                    <small>
                                                        Mostrando <?= ($offset + 1) ?> a <?= min($offset + $itensPorPagina, $totalVendas) ?>
                                                        de <?= $totalVendas ?> vendas
                                                        <?php if ($totalPaginas > 1): ?>
                                                            (Página <?= $paginaAtual ?> de <?= $totalPaginas ?>)
                                                        <?php endif; ?>
                                                    </small>
                                                </div>
                                                <div>
                                                    <small class="text-muted">
                                                        <?= $itensPorPagina ?> vendas por página
                                                    </small>
                                                </div>
                                            </div>
                                        <?php endif; ?>


                                        <div class="d-flex flex-wrap gap-2 mb-3">
                                            <!-- Botões de Ação -->
                                            <button type="button" class="btn btn-outline-primary btn-sm" id="selectAllBtn">
                                                Selecionar Todos
                                            </button>
                                            <button type="button" class="btn btn-outline-secondary btn-sm" id="clearSelectionBtn">
                                                Limpar Seleção
                                            </button>
                                            <button type="button" class="btn btn-outline-info btn-sm" id="btnVerificarPagamentos" onclick="verificarPagamentosPendentes()">
                                                <span class="spinner-border spinner-border-sm me-1 d-none" role="status" aria-hidden="true"></span>
                                                <span class="btn-text">Verificar Pagamentos</span>
                                            </button>
                                        </div>

                                        <!-- Pagamento em Massa -->
                                        <div id="batchPaymentContainer" style="display: none;" class="w-100">
                                            <div class="alert alert-info d-flex align-items-center justify-content-between flex-wrap gap-2 mb-0">
                                                <div class="d-flex gap-2 flex-wrap">
                                                    <span class="badge text-bg-primary" id="selectedCount">0 selecionadas</span>
                                                    <span class="badge text-bg-success" id="totalValue">Total: R$ 0,00</span>
                                                </div>
                                                <button type="button" class="btn btn-success btn-sm" id="batchPaymentBtn">
                                                    Pagar Selecionadas
                                                </button>
                                            </div>
                                        </div>



                                        <!-- Formulário de Filtros -->
                                        <div class="card shadow-sm mb-4 mt-4" id="filtersContainer">
                                            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                                <h6 class="mb-0 fw-semibold">Filtros de Vendas</h6>
                                                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="limparFiltros()">
                                                    Limpar Filtros
                                                </button>
                                            </div>
                                            <div class="card-body">
                                                <form method="GET" action="">
                                                    <div class="row p-3 mt-3 g-3">
                                                        <div class="col-md-4">
                                                            <label class="form-label">Período de Venda</label>
                                                            <input type="text" id="dateRange" class="form-control" placeholder="Selecione o período" autocomplete="off">
                                                            <input type="hidden" name="dta_venda_de" id="dta_venda_de_hidden" value="<?= htmlspecialchars($_GET['dta_venda_de'] ?? '') ?>">
                                                            <input type="hidden" name="dta_venda_ate" id="dta_venda_ate_hidden" value="<?= htmlspecialchars($_GET['dta_venda_ate'] ?? '') ?>">
                                                        </div>

                                                        <div class="col-md-4">
                                                            <label class="form-label">Order ID</label>
                                                            <input type="text" class="form-control" name="order_id"
                                                                value="<?= htmlspecialchars($_GET['order_id'] ?? '') ?>"
                                                                placeholder="Digite o Order ID">
                                                        </div>

                                                        <div class="col-md-4">
                                                            <label class="form-label">Integração</label>
                                                            <select class="form-select" name="integracao">
                                                                <option value="">-- Todas --</option>
                                                                <?php foreach ($integracoesDisponiveis as $integ): ?>
                                                                    <?php
                                                                    $integNome = ucwords(str_replace('_', ' ', $integ));
                                                                    ?>
                                                                    <option value="<?= htmlspecialchars($integ) ?>"
                                                                        <?= (isset($_GET['integracao']) && $_GET['integracao'] == $integ) ? 'selected' : '' ?>>
                                                                        <?= htmlspecialchars($integNome) ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <label class="form-label">Fornecedor</label>
                                                            <select class="form-select" name="fornecedor">
                                                                <option value="">-- Todos --</option>
                                                                <?php foreach ($fornecedoresDisponiveis as $forn): ?>
                                                                    <option value="<?= htmlspecialchars($forn['fornecedor']) ?>"
                                                                        <?= (isset($_GET['fornecedor']) && $_GET['fornecedor'] == $forn['fornecedor']) ? 'selected' : '' ?>>
                                                                        <?= htmlspecialchars($forn['fornecedor_nome']) ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <label class="form-label">Pagamento</label>
                                                            <select class="form-select" name="preco_custo">
                                                                <option value="">-- Todos --</option>
                                                                <option value="pago"
                                                                    <?= (isset($_GET['preco_custo']) && $_GET['preco_custo'] == 'pago') ? 'selected' : '' ?>>
                                                                    Pago</option>
                                                                <option value="pendente"
                                                                    <?= (isset($_GET['preco_custo']) && $_GET['preco_custo'] == 'pendente') ? 'selected' : '' ?>>
                                                                    Pendente</option>
                                                            </select>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <label class="form-label">Nota Fiscal</label>
                                                            <select class="form-select" name="anexado_nf">
                                                                <option value="">-- Todos --</option>
                                                                <option value="anexado"
                                                                    <?= (isset($_GET['anexado_nf']) && $_GET['anexado_nf'] == 'anexado') ? 'selected' : '' ?>>
                                                                    Anexado</option>
                                                                <option value="pendente"
                                                                    <?= (isset($_GET['anexado_nf']) && $_GET['anexado_nf'] == 'pendente') ? 'selected' : '' ?>>
                                                                    Pendente</option>
                                                            </select>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <label class="form-label">Status da Venda</label>
                                                            <select class="form-select" name="status_venda">
                                                                <option value="">-- Todos --</option>
                                                                <option value="cancelada" <?= (isset($_GET['status_venda']) && $_GET['status_venda'] == 'cancelada') ? 'selected' : '' ?>>
                                                                    Cancelada
                                                                </option>
                                                                <option value="enviada" <?= (isset($_GET['status_venda']) && $_GET['status_venda'] == 'enviada') ? 'selected' : '' ?>>
                                                                    Enviada
                                                                </option>
                                                                <option value="reembolsada" <?= (isset($_GET['status_venda']) && $_GET['status_venda'] == 'reembolsada') ? 'selected' : '' ?>>
                                                                    Reembolsada
                                                                </option>
                                                            </select>
                                                        </div>

                                                        <div class="col-md-8">
                                                        </div>

                                                        <div class="col-md-12 d-flex justify-content-end gap-2">
                                                            <button type="submit" class="btn btn-primary">
                                                                <i class="ti ti-search me-1"></i>Aplicar Filtros
                                                            </button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>



                                        <script>
                                            function limparFiltros() {
                                                window.location.href = window.location.pathname;
                                            }
                                        </script>

                                        <!-- Cards de Estatísticas -->
                                        <div class="row g-3 mb-4">
                                            <!-- Card: Total de Vendas -->
                                            <div class="col-lg-3 col-md-6">
                                                <div class="card shadow-sm border-0 h-100">
                                                    <div class="card-body p-3">
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <div>
                                                                <p class="text-muted mb-1 small">Total de Vendas</p>
                                                                <h3 class="mb-0 fw-bold"><?= number_format($statusCounts['todas'] ?? 0, 0, ',', '.') ?></h3>
                                                            </div>
                                                            <div class="avatar avatar-md bg-label-primary rounded d-flex align-items-center justify-content-center">
                                                                <i class="ti ti-shopping-cart"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Card: Vendas Pendentes -->
                                            <div class="col-lg-3 col-md-6">
                                                <div class="card shadow-sm border-0 h-100">
                                                    <div class="card-body p-3">
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <div>
                                                                <p class="text-muted mb-1 small">Pendentes</p>
                                                                <h3 class="mb-0 fw-bold text-warning"><?= number_format($statusCounts['pendentes'] ?? 0, 0, ',', '.') ?></h3>
                                                            </div>
                                                            <div class="avatar avatar-md bg-label-warning rounded d-flex align-items-center justify-content-center">
                                                                <i class="ti ti-clock"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Card: Vendas Pagas -->
                                            <div class="col-lg-3 col-md-6">
                                                <div class="card shadow-sm border-0 h-100">
                                                    <div class="card-body p-3">
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <div>
                                                                <p class="text-muted mb-1 small">Pagas</p>
                                                                <h3 class="mb-0 fw-bold text-success"><?= number_format($statusCounts['pagas'] ?? 0, 0, ',', '.') ?></h3>
                                                            </div>
                                                            <div class="avatar avatar-md bg-label-success rounded d-flex align-items-center justify-content-center">
                                                                <i class="ti ti-check"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Card: Vendas Enviadas -->
                                            <div class="col-lg-3 col-md-6">
                                                <div class="card shadow-sm border-0 h-100">
                                                    <div class="card-body p-3">
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <div>
                                                                <p class="text-muted mb-1 small">Enviadas</p>
                                                                <h3 class="mb-0 fw-bold text-primary"><?= number_format($statusCounts['enviadas'] ?? 0, 0, ',', '.') ?></h3>
                                                            </div>
                                                            <div class="avatar avatar-md bg-label-primary rounded d-flex align-items-center justify-content-center">
                                                                <i class="ti ti-truck-delivery"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Card: Vendas Canceladas -->
                                            <div class="col-lg-3 col-md-6">
                                                <div class="card shadow-sm border-0 h-100">
                                                    <div class="card-body p-3">
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <div>
                                                                <p class="text-muted mb-1 small">Canceladas</p>
                                                                <h3 class="mb-0 fw-bold text-danger"><?= number_format($statusCounts['canceladas'] ?? 0, 0, ',', '.') ?></h3>
                                                            </div>
                                                            <div class="avatar avatar-md bg-label-danger rounded d-flex align-items-center justify-content-center">
                                                                <i class="ti ti-x"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Card: Vendas Reembolsadas -->
                                            <div class="col-lg-3 col-md-6">
                                                <div class="card shadow-sm border-0 h-100">
                                                    <div class="card-body p-3">
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <div>
                                                                <p class="text-muted mb-1 small">Reembolsadas</p>
                                                                <h3 class="mb-0 fw-bold text-info"><?= number_format($statusCounts['reembolsadas'] ?? 0, 0, ',', '.') ?></h3>
                                                            </div>
                                                            <div class="avatar avatar-md bg-label-info rounded d-flex align-items-center justify-content-center">
                                                                <i class="ti ti-arrow-back-up"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Card: Problema Pagamento -->
                                            <div class="col-lg-3 col-md-6">
                                                <div class="card shadow-sm border-0 h-100">
                                                    <div class="card-body p-3">
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <div>
                                                                <p class="text-muted mb-1 small">Problema Pagamento</p>
                                                                <h3 class="mb-0 fw-bold text-secondary"><?= number_format($statusCounts['problema_pagamento'] ?? 0, 0, ',', '.') ?></h3>
                                                            </div>
                                                            <div class="avatar avatar-md bg-label-secondary rounded d-flex align-items-center justify-content-center">
                                                                <i class="ti ti-alert-circle"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Card: Problema Etiqueta -->
                                            <div class="col-lg-3 col-md-6">
                                                <div class="card shadow-sm border-0 h-100">
                                                    <div class="card-body p-3">
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <div>
                                                                <p class="text-muted mb-1 small">Problema Etiqueta</p>
                                                                <h3 class="mb-0 fw-bold text-dark"><?= number_format($statusCounts['problema_etiqueta'] ?? 0, 0, ',', '.') ?></h3>
                                                            </div>
                                                            <div class="avatar avatar-md bg-label-dark rounded d-flex align-items-center justify-content-center">
                                                                <i class="ti ti-tag-off"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Cards de Vendas -->
                                        <div class="mt-4">
                                            <div class="row g-3" id="vendasCards">
                                                <?php if (!empty($vendas)): ?>
                                                    <?php foreach ($vendas as $index => $venda): ?>

                                                        <?php
                                                        // ============================================================
                                                        // REGRAS DE NEGÓCIO - SISTEMA NOVO
                                                        // ============================================================
                                                        
                                                        $integracao = strtolower($venda['integracao']);
                                                        if ($integracao === 'mercado livre') {
                                                            $integracao = 'mercado_livre';
                                                        }
                                                        
                                                        // Status principal da venda (coluna status_venda)
                                                        // Valores possíveis: payment_pending, payment_paid, payment_refund, partial_refund, shipped, canceled
                                                        $statusVenda = $venda['status_venda'] ?? 'payment_pending';
                                                        
                                                        if($statusVenda == 'paid') {
                                                            $statusVenda = 'payment_pending';
                                                        }

                                                        if($statusVenda == '') {
                                                            $statusVenda = 'payment_pending';
                                                        }

                                                        if($statusVenda == null) {
                                                            $statusVenda = 'payment_pending';
                                                        }

                                                        if($statusVenda == 'READY_TO_SHIP') {
                                                            $statusVenda = 'payment_pending';
                                                        }
                                                        
                                                        // Status complementares (coluna status_complementar - JSON)
                                                        $statusComplementarJSON = $venda['status_complementar'] ?? '[]';
                                                        $statusComplementarData = json_decode($statusComplementarJSON, true) ?: [];
                                                        
                                                        // Processar status_complementar para extrair valores
                                                        $statusComplementares = [];
                                                        if (is_array($statusComplementarData)) {
                                                            // Caso 1: Array de objetos [{"conteudo": "valor1"}, {"conteudo": "valor2"}]
                                                            if (isset($statusComplementarData[0]) && is_array($statusComplementarData[0])) {
                                                                foreach ($statusComplementarData as $item) {
                                                                    if (isset($item['conteudo']) && !empty($item['conteudo'])) {
                                                                        $statusComplementares[] = $item['conteudo'];
                                                                    }
                                                                }
                                                            }
                                                            // Caso 2: Objeto com múltiplas chaves (conteudo, conteudo1, conteudo2, etc)
                                                            elseif (isset($statusComplementarData['conteudo']) || 
                                                                    isset($statusComplementarData['conteudo1']) || 
                                                                    isset($statusComplementarData['conteudo2'])) {
                                                                ksort($statusComplementarData);
                                                                foreach ($statusComplementarData as $key => $value) {
                                                                    if (strpos($key, 'conteudo') === 0 && !empty($value)) {
                                                                        $statusComplementares[] = $value;
                                                                    }
                                                                }
                                                            }
                                                            // Caso 3: Array simples ["buffering", "outro_status"] (formato antigo)
                                                            else {
                                                                $statusComplementares = $statusComplementarData;
                                                            }
                                                        }
                                                        
                                                        $hasBuffering = in_array('buffering', $statusComplementares);
                                                        
                                                        $isPago = $venda['vlr_custo_pago'] ? true : false;
                                                        $problemPag = $venda['vlr_custo_pago'] == 0 && !empty($venda['id_pagamento']) ? true : false;
                                                        $isEnviado = $venda['enviado'] ? true : false;
                                                        $isReembolsado = isset($venda['reembolsado']) && $venda['reembolsado'] == 1;
                                                        $srStatus = isset($venda['sr_status']) ? (int)$venda['sr_status'] : null;
                                                        $isReembolsoParcial = ($srStatus === 2);
                                                        $isCancelado = isset($venda['cancelado']) && $venda['cancelado'] == 1;

                                                        $problema_etiqueta = false;
                                                        $processando_etiqueta = false;
                                                        $buffering = false;

                                                        if ($venda['etiqueta_ml'] === 'processing_label') {
                                                            $processando_etiqueta = true;
                                                        }

                                                        $saleIdString = (string)$venda['saleId'];
                                                        $isManualOrder = ctype_digit($saleIdString) && substr($saleIdString, 0, 4) !== '2000';

                                                        $semEtiquetaShipping = false;
                                                        if ((empty($venda['shipping_id']) || $venda['shipping_id'] == 0 || trim($venda['shipping_id']) == '') && !$isManualOrder) {
                                                            $semEtiquetaShipping = true;
                                                            $processando_etiqueta = false;

                                                            // Texto a ser adicionado
                                                            $obsAdicional = "Esta venda está para combinar o envio com o fornecedor, envie a etiqueta manualmente.";

                                                            // Verifica se já possui a observação para evitar updates infinitos
                                                            if (strpos(($venda['observacoes'] ?? ''), $obsAdicional) === false) {
                                                                try {
                                                                    // Atualiza o banco de dados
                                                                    $sqlUpd = "UPDATE drophub_global.minhas_vendas SET observacoes = CONCAT(COALESCE(observacoes, ''), ' ', :obs) WHERE saleId = :saleId AND whitelabel = :whitelabel";
                                                                    $stmtUpd = $pdoGlobal->prepare($sqlUpd);
                                                                    $stmtUpd->execute([
                                                                        ':obs' => $obsAdicional,
                                                                        ':saleId' => $venda['saleId'],
                                                                        ':whitelabel' => Config::get('database.dbname')
                                                                    ]);

                                                                    // Atualiza a variável local para refletir na tela imediatamente
                                                                    $venda['observacoes'] = ($venda['observacoes'] ?? '') . ' ' . $obsAdicional;
                                                                } catch (Exception $e) {
                                                                    // Silencia erro de update para não quebrar a tela
                                                                }
                                                            }
                                                        }

                                                        if ($venda['etiqueta_ml'] === 'buffering') {
                                                            $buffering = true;
                                                        }

                                                        // Verifica apenas se a etiqueta está vazia/null
                                                        elseif (empty($venda['etiqueta_ml']) || $venda['etiqueta_ml'] == null || trim($venda['etiqueta_ml']) == '') {
                                                            $problema_etiqueta = true;
                                                        }

                                                        // REMOVIDO: Validação com get_headers() - causa lentidão extrema
                                                        // Se precisar validar URL, faça via AJAX/background ou cache no banco

                                                        // Define a data de pagamento antes da lógica dos badges
                                                        if ($is_affiliate == 1) {
                                                            $dta_pgto = $venda['vendido_dia'];
                                                        } else {
                                                            $dta_pgto = $venda['dta_vl_pago'];
                                                        }

                                                        // Definição das cores dos status e badge principal
                                                        // Prioridade: Reembolsado > Cancelado > Enviado > Pago > Problema Pagamento > Pendente
                                                        if ($isReembolsoParcial) {
                                                            $badgeStatus = [
                                                                'label' => 'Reembolso Parcial',
                                                                'class' => 'bg-warning',
                                                                'popover' => false
                                                            ];
                                                        } elseif ($isReembolsado && $isCancelado) {
                                                            $badgeStatus = [
                                                                'label' => 'Reembolsado',
                                                                'class' => 'bg-info',
                                                                'popover' => false
                                                            ];
                                                        } elseif ($isReembolsado) {
                                                            $badgeStatus = [
                                                                'label' => 'Reembolsado',
                                                                'class' => 'bg-info',
                                                                'popover' => false
                                                            ];
                                                        } elseif ($isCancelado) {
                                                            $badgeStatus = [
                                                                'label' => 'Cancelado',
                                                                'class' => 'bg-label-danger',
                                                                'popover' => false
                                                            ];
                                                        } elseif ($isEnviado && !$isReembolsado) {
                                                            // "Enviado" tem prioridade sobre "Pago"
                                                            $badgeStatus = [
                                                                'label' => 'Enviado',
                                                                'class' => 'bg-primary',
                                                                'popover' => 'Enviado em: ' . date('d/m/Y à\s\ H:i', strtotime($venda['dta_enviado']))
                                                            ];
                                                        } elseif ($isPago) {
                                                            $badgeStatus = [
                                                                'label' => 'Pago',
                                                                'class' => 'bg-success',
                                                                'popover' => 'Pago em: ' . date('d/m/Y à\s\ H:i', strtotime($dta_pgto))
                                                            ];
                                                        } elseif ($problemPag) {
                                                            $badgeStatus = [
                                                                'label' => 'Problema no pagamento',
                                                                'class' => 'bg-info-2',
                                                                'popover' => false
                                                            ];
                                                        } else {
                                                            $badgeStatus = false;
                                                        }

                                                        // Função para retornar cor do status (deve ficar fora do foreach)
                                                        if (!function_exists('getStatusColor')) {
                                                            function getStatusColor($status)
                                                            {
                                                                switch ($status) {
                                                                    case 'reembolsado':
                                                                        return '#d1ecf1'; // azul clarinho
                                                                    case 'reembolso_parcial':
                                                                        return '#fff3cd'; // amarelo claro
                                                                    case 'cancelado':
                                                                        return '#f8d7da'; // vermelho clarinho
                                                                    case 'pago':
                                                                        return '#d4edda'; // verde clarinho
                                                                    case 'problema_pagamento':
                                                                        return '#fff3cd'; // amarelo clarinho
                                                                    case 'enviado':
                                                                        return '#cce5ff'; // azul clarinho
                                                                    case 'processando_etiqueta':
                                                                        return '#d1ecf1'; // azul info clarinho
                                                                    case 'pendente':
                                                                        return '#ffe5b4'; // laranja clarinho
                                                                    default:
                                                                        return '#ffffff';
                                                                }
                                                            }
                                                        }

                                                        $fornecedorEmFerias = false;
                                                        $feriasInfo = null;

                                                        if (
                                                            isset($venda['ferias_ativo']) && $venda['ferias_ativo'] == 1 &&
                                                            isset($venda['ferias_de']) && !empty($venda['ferias_de']) &&
                                                            isset($venda['ferias_ate']) && !empty($venda['ferias_ate'])
                                                        ) {
                                                            try {
                                                                $dataAtual = new DateTime();
                                                                $feriasDe = new DateTime($venda['ferias_de']);
                                                                $feriasAte = new DateTime($venda['ferias_ate']);

                                                                if ($dataAtual >= $feriasDe && $dataAtual <= $feriasAte) {
                                                                    $fornecedorEmFerias = true;
                                                                    $feriasInfo = [
                                                                        'fornecedor' => $venda['fornecedor_nome'],
                                                                        'ferias_de' => date('d/m/Y', strtotime($venda['ferias_de'])),
                                                                        'ferias_ate' => date('d/m/Y', strtotime($venda['ferias_ate']))
                                                                    ];
                                                                }
                                                            } catch (Exception $e) {
                                                            }
                                                        }

                                                        $temErroBloqueio = !empty($venda['observacoes']) && (
                                                            strpos($venda['observacoes'], 'Erro 338A') !== false ||
                                                            strpos($venda['observacoes'], 'HTTP 200: Erro 338A') !== false ||
                                                            strpos($venda['observacoes'], 'ERRO POLICY AGENT') !== false ||
                                                            strpos($venda['observacoes'], 'PA_UNAUTHORIZED') !== false ||
                                                            strpos($venda['observacoes'], 'Política do ML bloqueou a geração da etiqueta.') !== false ||
                                                            strpos($venda['observacoes'], 'PolicyAgent') !== false
                                                        );

                                                        // Verificar se é erro de Shipping ID não encontrado (combinar envio com fornecedor)
                                                        $temErroShippingID = !empty($venda['observacoes']) && (
                                                            strpos($venda['observacoes'], 'Esta venda está para combinar o envio com o fornecedor') !== false ||
                                                            strpos($venda['observacoes'], 'combinar o envio com o fornecedor') !== false
                                                        );

                                                        // Verificar se é erro Shopee Cancelled
                                                        $temErroShopeeCancelled = !empty($venda['observacoes']) && (
                                                            strpos($venda['observacoes'], 'SHOPEE: Pedido já enviado/finalizado') !== false ||
                                                            strpos($venda['observacoes'], 'Status: CANCELLED') !== false
                                                        );
                                                        ?>
                                                        <div class="col-12 col-md-6 mb-4"
                                                            data-status-pago="<?= $isPago ? '1' : '0' ?>"
                                                            data-status-enviado="<?= $isEnviado ? '1' : '0' ?>"
                                                            data-status-cancelado="<?= $isCancelado ? '1' : '0' ?>"
                                                            data-status-reembolsado="<?= $isReembolsado ? '1' : '0' ?>"
                                                            data-problema-pagamento="<?= $problemPag ? '1' : '0' ?>"
                                                            data-problema-etiqueta="<?= $problema_etiqueta ? '1' : '0' ?>"
                                                            data-processando-etiqueta="<?= $processando_etiqueta ? '1' : '0' ?>"
                                                            data-buffering="<?= $buffering ? '1' : '0' ?>"
                                                            data-venda-id="<?= htmlspecialchars($venda['saleId']) ?>"
                                                            data-integracao="<?= htmlspecialchars($integracao) ?>"
                                                            data-observacoes="<?= htmlspecialchars($venda['observacoes'] ?? '') ?>"
                                                            data-valor="<?= $venda['vlr_custo'] ?>">

                                                            <div class="card h-100 shadow-sm <?= (!empty($venda['observacoes']) && !$isReembolsado && !$isCancelado) ? 'border-danger' : '' ?>">
                                                                <div class="card-body">

                                                                    <!-- HEADER: Imagem + Título + ID -->
                                                                    <div class="d-flex align-items-start gap-3 mb-3">
                                                                        <?php if (!$isPago && !$isCancelado && !$isReembolsado): ?>
                                                                            <div class="form-check">
                                                                                <input class="form-check-input venda-checkbox" type="checkbox"
                                                                                    data-sale-id="<?= htmlspecialchars($venda['saleId']) ?>"
                                                                                    data-fornecedor="<?= htmlspecialchars($venda['fornecedor']) ?>"
                                                                                    data-valor="<?= $venda['vlr_custo'] ?>"
                                                                                    data-sale-title="<?= htmlspecialchars($venda['saleTitle']) ?>"
                                                                                    id="checkbox_<?= $index ?>">
                                                                            </div>
                                                                        <?php endif; ?>

                                                                        <?php
                                                                        $imgPath = "../../assets/img/icons/brands/{$integracao}.png";
                                                                        if (!file_exists(pegarRaiz() . "assets/img/icons/brands/{$integracao}.png")) {
                                                                            $imgPath = "../images/produtos_imagens/noimage.jpg";
                                                                        }
                                                                        ?>
                                                                        <img src="<?= $imgPath ?>" alt="<?= htmlspecialchars($integracao) ?>"
                                                                            class="rounded bg-light p-1" width="48" height="48" style="object-fit:contain;">

                                                                        <div class="flex-grow-1 min-w-0">
                                                                            <h6 class="mb-1 fw-semibold text-muted"><?= htmlspecialchars($venda['saleTitle']) ?></h6>
                                                                            <div class="d-flex gap-2 flex-wrap">
                                                                                <span class="badge text-bg-primary"><?= htmlspecialchars(ucfirst($integracao)) ?></span>
                                                                                <?php if (isset($venda['pedido_manual']) && $venda['pedido_manual'] == 1): ?>
                                                                                    <span class="badge text-bg-info">
                                                                                        Pedido Manual
                                                                                    </span>
                                                                                <?php endif; ?>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <!-- BODY: Status -->
                                                                    <div class="mb-3">
                                                                        <div class="d-flex gap-1 flex-wrap">
                                                                            <?php if ($fornecedorEmFerias): ?>
                                                                                <span class="badge text-bg-warning">
                                                                                    <i class="ti ti-confetti me-1"></i>Em Férias
                                                                                </span>
                                                                            <?php endif; ?>

                                                                            <?php if (!empty($venda['observacoes'])): ?>
                                                                                <span class="badge text-bg-danger" role="button"
                                                                                    data-bs-toggle="modal"
                                                                                    data-bs-target="#modalObservacoes<?= htmlspecialchars($venda['saleId']) ?>">
                                                                                    Observações
                                                                                </span>
                                                                            <?php endif; ?>

                                                                            <!-- BADGE STATUS PRINCIPAL -->
                                                                            <?php if ($statusVenda === 'payment_pending'): ?>
                                                                                <span class="badge text-bg-warning">
                                                                                    <i class="ti ti-clock me-1"></i>Pagamento Pendente
                                                                                </span>
                                                                            <?php elseif ($statusVenda === 'payment_paid'): ?>
                                                                                <span class="badge text-bg-success">
                                                                                    <i class="ti ti-check me-1"></i>Pago
                                                                                </span>
                                                                            <?php elseif ($statusVenda === 'payment_refund'): ?>
                                                                                <span class="badge text-bg-info">
                                                                                    <i class="ti ti-arrow-back me-1"></i>Reembolsado
                                                                                </span>
                                                                            <?php elseif ($statusVenda === 'partial_refund'): ?>
                                                                                <span class="badge text-bg-warning">
                                                                                    <i class="ti ti-arrow-back-up me-1"></i>Parcialmente Reembolsado
                                                                                </span>
                                                                            <?php elseif ($statusVenda === 'shipped'): ?>
                                                                                <span class="badge text-bg-primary">
                                                                                    <i class="ti ti-truck me-1"></i>Enviado
                                                                                </span>
                                                                            <?php elseif ($statusVenda === 'canceled'): ?>
                                                                                <span class="badge text-bg-danger">
                                                                                    <i class="ti ti-x me-1"></i>Cancelado
                                                                                </span>
                                                                            <?php endif; ?>

                                                                            <!-- BADGES STATUS COMPLEMENTARES (um por linha) -->
                                                                            <?php if (!empty($statusComplementares)): ?>
                                                                                <?php foreach ($statusComplementares as $complementar): ?>
                                                                                    <?php
                                                                                    // Traduzir status complementares
                                                                                    $labelComplementar = $complementar;
                                                                                    $classComplementar = 'text-bg-secondary';
                                                                                    
                                                                                    if ($complementar === 'buffering') {
                                                                                        $labelComplementar = 'Aguardando Liberação';
                                                                                        $classComplementar = 'text-bg-warning';
                                                                                    }
                                                                                    ?>
                                                                                    <span class="badge <?= $classComplementar ?>">
                                                                                        <?= htmlspecialchars($labelComplementar) ?>
                                                                                    </span>
                                                                                <?php endforeach; ?>
                                                                            <?php endif; ?>
                                                                            
                                                                            <?php if ($isReembolsado && $isCancelado): ?>
                                                                                <span class="badge text-bg-danger">Cancelado</span>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>

                                                                    <!-- Info: Data e Fornecedor -->
                                                                    <div class="mb-3">
                                                                        <div class="row g-3">
                                                                            <div class="col-6">
                                                                                <small class="text-muted d-block mb-1">Data</small>
                                                                                <div class="fw-semibold"><?= date('d/m/Y', strtotime($venda['vendido_dia'])) ?></div>
                                                                            </div>
                                                                            <div class="col-6">
                                                                                <small class="text-muted d-block mb-1">Fornecedor</small>
                                                                                <div class="fw-semibold text-truncate"><?= htmlspecialchars($venda['fornecedor_nome']) ?></div>
                                                                            </div>
                                                                            <?php if (!empty($venda['loja_nome']) && $is_affiliate != 1): ?>
                                                                                <div class="col-12">
                                                                                    <small class="text-muted d-block mb-1">Loja</small>
                                                                                    <div class="fw-semibold"><?= htmlspecialchars($venda['loja_nome']) ?></div>
                                                                                </div>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>

                                                                    <!-- Alertas -->
                                                                    <?php if ($isPago): ?>
                                                                        <div class="alert alert-success py-2 mb-3">
                                                                            <i class="ti ti-check me-1"></i>
                                                                            <strong>Pago em <?= date('d/m/Y', strtotime($dta_pgto)) ?></strong>
                                                                        </div>
                                                                    <?php endif; ?>

                                                                    <?php if ($fornecedorEmFerias): ?>
                                                                        <div class="alert alert-warning py-2 mb-3">
                                                                            <i class="ti ti-alert-triangle me-1"></i>
                                                                            <strong>Fornecedor em Férias</strong><br>
                                                                            <small><?= $feriasInfo['ferias_de'] ?> até <?= $feriasInfo['ferias_ate'] ?></small>
                                                                        </div>
                                                                    <?php endif; ?>

                                                                    <!-- Valor -->
                                                                    <div class="d-flex align-items-center justify-content-between p-3 bg-light rounded mb-3">
                                                                        <span class="text-muted">Valor a Pagar</span>
                                                                        <span class="fs-4 fw-bold text-success">R$ <?= number_format($venda['vlr_custo'], 2, ',', '.') ?></span>
                                                                    </div>

                                                                    <!-- FOOTER: Botões -->
                                                                    <div class="d-grid gap-2">
                                                                        <?php if ($statusVenda === 'canceled'): ?>
                                                                            <!-- Para vendas canceladas, mostrar apenas o botão Detalhes -->
                                                                            <a href="venda_detalhes?i=<?= base64_encode($venda['saleId']) ?>"
                                                                                class="btn btn-outline-info w-100">
                                                                                <i class="ti ti-info-circle me-1"></i> Ver Detalhes
                                                                            </a>
                                                                        <?php else: ?>
                                                                            <!-- BOTÕES DE AÇÃO PRINCIPAL -->
                                                                            <div class="d-flex flex-column gap-2">
                                                                                <!-- Botão Pagar -->
                                                                                <?php if ($statusVenda === 'payment_pending'): ?>
                                                                                    <button type="button" class="btn btn-primary w-100"
                                                                                        data-bs-toggle="modal"
                                                                                        data-bs-target="#modalPagamentos<?= $venda['saleId'] ?>"
                                                                                        <?= $hasBuffering ? 'disabled' : '' ?>>
                                                                                        <i class="ti ti-credit-card me-1"></i> Pagar
                                                                                    </button>
                                                                                <?php endif; ?>

                                                                                <!-- Botão Reembolso -->
                                                                                <?php if (in_array($statusVenda, ['payment_paid', 'shipped'])): ?>
                                                                                    <?php
                                                                                    $solicStatus = isset($venda['sr_status']) ? (int)$venda['sr_status'] : null;
                                                                                    ?>
                                                                                    <button type="button" class="btn btn-outline-warning w-100 btn-solicitar-reembolso-venda"
                                                                                        data-saleid="<?= htmlspecialchars($venda['saleId']) ?>"
                                                                                        data-orderid="<?= htmlspecialchars($venda['order_id']) ?>"
                                                                                        data-fornecedor="<?= htmlspecialchars($venda['fornecedor']) ?>"
                                                                                        data-valor="<?= htmlspecialchars(number_format($venda['vlr_custo'], 2, '.', '')) ?>"
                                                                                        data-integracao="<?= htmlspecialchars($integracao) ?>"
                                                                                        data-whitelabel="<?= Config::get('database.dbname'); ?>"
                                                                                        data-sr-status="<?= htmlspecialchars($solicStatus === null ? '' : $solicStatus) ?>"
                                                                                        data-vlr-custo-pago="<?= (int)$venda['vlr_custo_pago'] ?>"
                                                                                        data-reembolsado="<?= (int)$venda['reembolsado'] ?>"
                                                                                        data-cancelado="<?= (int)$venda['cancelado'] ?>">
                                                                                        <i class="ti ti-arrow-back me-1"></i> Solicitar Reembolso
                                                                                    </button>
                                                                                <?php endif; ?>

                                                                                <!-- Botão Ver Etiqueta -->
                                                                                <?php 
                                                                                // Mostrar botão se: está pago E tem etiqueta válida (não vazia, não processing, não buffering)
                                                                                $temEtiquetaValida = !empty($venda['etiqueta_ml']) 
                                                                                    && $venda['etiqueta_ml'] !== 'processing_label' 
                                                                                    && $venda['etiqueta_ml'] !== 'buffering';
                                                                                $vendaPaga = (int)$venda['vlr_custo_pago'] === 1;
                                                                                
                                                                                if ($vendaPaga && $temEtiquetaValida): 
                                                                                ?>
                                                                                    <div class="d-flex gap-2">
                                                                                        <a href="<?= htmlspecialchars($venda['etiqueta_ml']) ?>"
                                                                                            target="_blank"
                                                                                            class="btn btn-outline-success flex-grow-1 btn-ver-etiqueta"
                                                                                            data-etiqueta-url="<?= htmlspecialchars($venda['etiqueta_ml']) ?>"
                                                                                            data-saletitle="<?= htmlspecialchars($venda['saleTitle']) ?>"
                                                                                            data-saleid="<?= htmlspecialchars($venda['saleId']) ?>">
                                                                                            <i class="ti ti-eye me-1"></i> Ver Etiqueta
                                                                                        </a>
                                                                                        <!-- Botão para reprocessar caso a URL esteja com 404 -->
                                                                                        <button type="button" 
                                                                                            class="btn btn-outline-primary btn-reprocessar-etiqueta-404"
                                                                                            data-saletitle="<?= htmlspecialchars($venda['saleTitle']) ?>"
                                                                                            data-saleid="<?= htmlspecialchars($venda['saleId']) ?>"
                                                                                            style="display: none;"
                                                                                            title="Reprocessar etiqueta">
                                                                                            <i class="ti ti-refresh"></i>
                                                                                        </button>
                                                                                    </div>
                                                                                <?php endif; ?>

                                                                                <!-- Botão Reprocessar Etiqueta -->
                                                                                <?php 
                                                                                // Mostrar botão se a etiqueta está em estado que precisa reprocessamento
                                                                                $precisaReprocessar = $vendaPaga && (
                                                                                    $venda['etiqueta_ml'] === 'processing_label' ||
                                                                                    $venda['etiqueta_ml'] === 'buffering' ||
                                                                                    empty($venda['etiqueta_ml']) ||
                                                                                    $venda['etiqueta_ml'] === null ||
                                                                                    trim($venda['etiqueta_ml']) === ''
                                                                                );
                                                                                
                                                                                if ($precisaReprocessar): 
                                                                                ?>
                                                                                    <button type="button" 
                                                                                        class="btn btn-outline-primary w-100 btn-reprocessar-etiqueta"
                                                                                        data-saletitle="<?= htmlspecialchars($venda['saleTitle']) ?>"
                                                                                        data-saleid="<?= htmlspecialchars($venda['saleId']) ?>">
                                                                                        <i class="ti ti-refresh me-1"></i> Reprocessar Etiqueta
                                                                                    </button>
                                                                                <?php endif; ?>

                                                                                <!-- Botão Aguardando Liberação (disabled) -->
                                                                                <?php if ($hasBuffering): ?>
                                                                                    <button class="btn btn-warning w-100" disabled
                                                                                        title="Etiqueta em buffering - Aguardando liberação do Mercado Livre">
                                                                                        <i class="ti ti-alarm me-1"></i> Aguardando Liberação
                                                                                    </button>
                                                                                <?php endif; ?>
                                                                            </div>

                                                                            <!-- DIVISOR -->
                                                                            <hr class="my-2">

                                                                            <!-- BOTÕES SECUNDÁRIOS -->
                                                                            <div class="d-flex gap-2">
                                                                                <!-- Botão Detalhes -->
                                                                                <a href="venda_detalhes?i=<?= base64_encode($venda['saleId']) ?>"
                                                                                    class="btn btn-sm btn-outline-info flex-fill">
                                                                                    <i class="ti ti-info-circle me-1"></i> Detalhes
                                                                                </a>
                                                                                
                                                                                <!-- Botão Cancelar Venda -->
                                                                                <button type="button" class="btn btn-sm btn-outline-danger flex-fill btn-cancelar-reserva"
                                                                                    data-saleid="<?= htmlspecialchars($venda['saleId']) ?>">
                                                                                    <i class="ti ti-x me-1"></i> Cancelar
                                                                                </button>
                                                                            </div>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <!-- Modal Produtos -->
                                                        <div class="modal fade"
                                                            id="prods<?= htmlspecialchars($venda['saleId']) ?>" tabindex="-1"
                                                            aria-labelledby="modalProds<?= htmlspecialchars($venda['saleId']) ?>"
                                                            aria-hidden="true">
                                                            <div class="modal-dialog modal-lg modal-dialog-centered">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h1 class="modal-title fs-5"
                                                                            id="modalProds<?= htmlspecialchars($venda['saleId']) ?>">
                                                                            Detalhes da Venda -
                                                                            <?= htmlspecialchars($venda['saleId']) ?></h1>
                                                                        <button type="button" class="btn-close"
                                                                            data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        <div class="px-3 py-2" style="max-width: 100%;">
                                                                            <!-- Cabeçalho dos títulos -->
                                                                            <div class="row border rounded p-2">
                                                                                <div
                                                                                    class="col-md-1 border-end text-center d-flex align-items-center justify-content-center">
                                                                                    <strong>#</strong>
                                                                                </div>
                                                                                <div
                                                                                    class="col-md-8 border-end text-center d-flex align-items-center justify-content-center">
                                                                                    <strong>Título do produto</strong>
                                                                                </div>
                                                                                <div
                                                                                    class="col-md-3 text-center d-flex align-items-center justify-content-center">
                                                                                    <strong>Quantidade</strong>
                                                                                </div>
                                                                            </div>

                                                                            <?php
                                                                            $vendas = new getVendas($pdo);
                                                                            $id_venda = $venda['saleId'];
                                                                            $produtos = $vendas->getProdutosPorVenda($id_venda);

                                                                            if (is_array($produtos)) {
                                                                                if (!empty($produtos)) {
                                                                                    echo '<div class="row mt-2">';

                                                                                    foreach ($produtos as $produto) {
                                                                                        $imagem = !empty($produto['imagem_url']) ? $produto['imagem_url'] : '../../../images/produtos_imagens/noimage.jpg';

                                                                                        echo '<div class="card mb-3 border rounded" style="max-width: 100%;">';
                                                                                        echo '  <div class="row g-0 align-items-center">';
                                                                                        echo '      <div class="col-md-1 border-end pe-3 d-flex align-items-center justify-content-center">';
                                                                                        echo '          <img src="' . htmlspecialchars($imagem) . '" class="img-fluid rounded-start" alt="Imagem do Produto">';
                                                                                        echo '      </div>';
                                                                                        echo '      <div class="col-md-8 border-end d-flex align-items-center justify-content-center">';
                                                                                        echo '          <div class="card-body">';
                                                                                        echo '              <h6 class="mb-0 text-center">' . htmlspecialchars($produto['product_title']) . '</h6>';
                                                                                        echo '          </div>';
                                                                                        echo '      </div>';
                                                                                        echo '      <div class="col-md-3 d-flex align-items-center justify-content-center">';
                                                                                        echo '          <p class="card-text mb-0 text-center">' . htmlspecialchars($produto['quantidade']) . '</p>';
                                                                                        echo '      </div>';
                                                                                        echo '  </div>';
                                                                                        echo '</div>';
                                                                                    }

                                                                                    echo '</div>';
                                                                                } else {
                                                                                    echo '<p>Nenhum produto encontrado para essa venda.</p>';
                                                                                }
                                                                            } else {
                                                                                echo '<p>Erro ao buscar produtos: ' . htmlspecialchars($produtos) . '</p>';
                                                                            }
                                                                            ?>

                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary"
                                                                                data-bs-dismiss="modal">Fechar</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <!-- Modal Pagamentos -->
                                                        <div class="modal fade" id="modalPagamentos<?= $venda['saleId'] ?>"
                                                            tabindex="-1" aria-labelledby="modalPagamentosLabel"
                                                            aria-hidden="true">
                                                            <div class="modal-dialog modal-dialog-centered">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h1 class="modal-title fs-5" id="modalPagamentosLabel">
                                                                            Formas de pagamento</h1>
                                                                        <button type="button" class="btn-close"
                                                                            data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <div class="modal-body">

                                                                        <?php
                                                                        $vlr_custo_pago = $venda['vlr_custo_pago'];
                                                                        $fornecedor = $venda['fornecedor'];
                                                                        $id_usuario = $_SESSION['usuario']['id_usuario'];

                                                                        $nome_usuario = $_SESSION['usuario']['nome'];
                                                                        $email_usuario = $_SESSION['usuario']['email'];

                                                                        $enviado = $venda['enviado'];
                                                                        $dta_enviado = $venda['dta_enviado'];

                                                                        $sql_forn = "select * from drophub_global.fornecedores WHERE id = :fornecedor";
                                                                        $stmt_forn = $pdoGlobal->prepare($sql_forn);
                                                                        $stmt_forn->bindParam(':fornecedor', $fornecedor, PDO::PARAM_INT);
                                                                        $stmt_forn->execute();

                                                                        $dados_forn = $stmt_forn->fetch(PDO::FETCH_ASSOC);

                                                                        $formas_pagamento = json_decode($dados_forn['formas_pagamento'], true);

                                                                        // Validação de Estoque
                                                                        $estoqueZerado = false;
                                                                        $id_venda_check = $venda['saleId'];

                                                                        $sql_prod_check = "SELECT product_id FROM drophub_global.minhas_vendas_dados WHERE id_venda = :id_venda";
                                                                        $stmt_prod_check = $pdo->prepare($sql_prod_check);
                                                                        $stmt_prod_check->bindParam(':id_venda', $id_venda_check, PDO::PARAM_STR);
                                                                        $stmt_prod_check->execute();
                                                                        $produtos_ids = $stmt_prod_check->fetchAll(PDO::FETCH_COLUMN);

                                                                        if (!empty($produtos_ids)) {
                                                                            foreach ($produtos_ids as $prod_id) {
                                                                                $sql_estoque = "SELECT estoque FROM drophub_global.produtos WHERE id = :id";
                                                                                $stmt_estoque = $pdo->prepare($sql_estoque);
                                                                                $stmt_estoque->bindParam(':id', $prod_id, PDO::PARAM_INT);
                                                                                $stmt_estoque->execute();
                                                                                $estoque = $stmt_estoque->fetchColumn();

                                                                                if ($estoque !== false && $estoque <= 0) {
                                                                                    $estoqueZerado = true;
                                                                                    break;
                                                                                }
                                                                            }
                                                                        }

                                                                        $secKey = "codefly_pagamento";
                                                                        $secIv = "1996";
                                                                        $crypto = new CryptoHelper($secKey, $secIv);

                                                                        $dados = 'usuario_email=' . $email_usuario . '&usuario_nome=' . $nome_usuario . '&usuario_id=' . $id_usuario . '&id_venda=' . $id_venda . '&fornecedor=' . $fornecedor . '&tipo=pagamento_custo&valor=' . $venda['vlr_custo'];
                                                                        $dadosCriptografados = $crypto->process("encode", $dados);

                                                                        if (!empty($formas_pagamento) && is_array($formas_pagamento)) {
                                                                            if ($estoqueZerado) {
                                                                        ?>
                                                                                <div class="alert alert-danger" role="alert">
                                                                                    Esta venda tem produtos sem estoque, diante disso não é permitido fazer pagamentos! Sugerimos que cancele esta venda!
                                                                                </div>
                                                                            <?php
                                                                            } else {

                                                                            ?>
                                                                                <div class="alert alert-primary" role="alert">
                                                                                    <ul class="w-100 text-wrap taxt-start">
                                                                                        <li class="text-start"><b>Pagamento
                                                                                                Automático:</b> Validação de pagamento
                                                                                            automatico, processo mais rápido.</li>
                                                                                    </ul>
                                                                                </div>

                                                                                <div>

                                                                                    <div class="auto-payment p-3 border rounded mb-3">
                                                                                        <h6>Pagamentos Automático: </h6>

                                                                                        <div class="d-flex flex-wrap gap-2 align-items-center justify-content-start">

                                                                                            <?php

                                                                                            $sql = "SELECT COUNT(*) FROM drophub_global.fornecedores_tokens WHERE id_fornecedor = :id_fornecedor";
                                                                                            $stmt = $pdo->prepare($sql);
                                                                                            $stmt->bindParam(':id_fornecedor', $fornecedor, PDO::PARAM_STR);
                                                                                            $stmt->execute();
                                                                                            $temToken = $stmt->fetchColumn() > 0;

                                                                                            $sql_efi = "SELECT COUNT(*) FROM drophub_global.fornecedores_efi_tokens WHERE id_fornecedor = :id_fornecedor";
                                                                                            $stmt_efi = $pdo->prepare($sql_efi);
                                                                                            $stmt_efi->bindParam(':id_fornecedor', $fornecedor, PDO::PARAM_STR);
                                                                                            $stmt_efi->execute();
                                                                                            $temTokenEfi = $stmt_efi->fetchColumn() > 0;

                                                                                            if ($temToken) {
                                                                                                if ($formas_pagamento['pagamento_automatico'] != false) {
                                                                                                    if (isset($ativar_shipay) && $ativar_shipay == true) {
                                                                                                        if ($formas_pagamento['pagamento_shipay'] == true) {
                                                                                            ?>
                                                                                                            <a href="/dash/v2.checkout?d=<?php echo  $dadosCriptografados ?>"
                                                                                                                type="button"
                                                                                                                class="btn-outline-primary btn btn-sm px-2 rounded-pill p-1 small waves-effect waves-light">
                                                                                                                <i class="ti ti-cash me-2"></i> Método 1
                                                                                                            </a>
                                                                                                <?php
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }

                                                                                            if ($temTokenEfi) {
                                                                                                ?>
                                                                                                <a href="/dash/v3.checkout?d=<?php echo  $dadosCriptografados ?>"
                                                                                                    type="button"
                                                                                                    class="btn-outline-dark btn btn-sm px-2 rounded-pill p-1 small waves-effect waves-light">
                                                                                                    <i class="ti ti-cash me-2"></i> Método 2
                                                                                                </a>
                                                                                                <?php
                                                                                            }

                                                                                            if ($temToken) {
                                                                                                if ($formas_pagamento['pagamento_automatico'] != false) {
                                                                                                    if (isset($ativar_mp) && $ativar_mp == true) {
                                                                                                        if ($formas_pagamento['pagamento_mercadoPago'] == true) {
                                                                                                ?>
                                                                                                            <a href="/dash/checkout/gravar?<?php echo  $dadosCriptografados ?>"
                                                                                                                type="button"
                                                                                                                class="btn-warning btn btn-sm px-2 rounded-pill p-1 small waves-effect waves-light">
                                                                                                                <i class="ti ti-cash me-2"></i> Pagar agora
                                                                                                            </a>
                                                                                            <?php
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                            ?>
                                                                                        </div>
                                                                                    </div>

                                                                                    <!-- <div class="manual-payment p-3 border rounded" style="background-color: #f7f7f7;">
                                                                                    <h6>Pagamento Manual: </h6>
                                                                                    <div class="d-flex flex-wrap  gap-2 align-items-center justify-content-start">

                                                                                        <?php
                                                                                        $sql_forn_pix = "SELECT COUNT(*) FROM drophub_global.fornecedores_pix WHERE id_fornecedor = :id_fornecedor";
                                                                                        $stmt_forn_pix = $pdo->prepare($sql_forn_pix);
                                                                                        $stmt_forn_pix->bindParam(':id_fornecedor', $fornecedor, PDO::PARAM_STR);
                                                                                        $stmt_forn_pix->execute();

                                                                                        $temPix = $stmt_forn_pix->fetchColumn() > 0;

                                                                                        if ($temPix) {
                                                                                            if ($formas_pagamento['pagamento_manual'] != false) {
                                                                                        ?>

                                                                                                <a href="javascript:void(0);"
                                                                                                    type="button"
                                                                                                    class="btn-light btn btn-sm px-2 rounded-pill p-1 small waves-effect waves-light" disabled>
                                                                                                    <i class="ti ti-cash me-2"></i> Pagamento Manual
                                                                                                </a>

                                                                                        <?php
                                                                                            }
                                                                                        }
                                                                                        ?>
                                                                                    </div>
                                                                                </div> -->
                                                                                </div>
                                                                        <?php
                                                                            }
                                                                        }
                                                                        ?>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>

                                                        <!-- Modal Observações -->
                                                        <?php if (!empty($venda['observacoes'])): ?>
                                                            <div class="modal fade" id="modalObservacoes<?= htmlspecialchars($venda['saleId']) ?>"
                                                                tabindex="-1" aria-labelledby="modalObservacoesLabel<?= htmlspecialchars($venda['saleId']) ?>"
                                                                aria-hidden="true">
                                                                <div class="modal-dialog modal-dialog-centered modal-lg">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h1 class="modal-title p-3 fs-5" id="modalObservacoesLabel<?= htmlspecialchars($venda['saleId']) ?>">
                                                                                Observações da Venda #<?= htmlspecialchars($venda['saleId']) ?>
                                                                            </h1>
                                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            <div class="alert alert-dark mb-0" role="alert">
                                                                                <div class="d-flex align-items-start">
                                                                                    <div class="flex-grow-1">
                                                                                        <h6 class="alert-heading mb-2">Detalhes da Observação:</h6>
                                                                                        <div class="text-wrap" style="white-space: pre-wrap; word-break: break-word;">
                                                                                            <?= nl2br(htmlspecialchars($venda['observacoes'])) ?>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>

                                                        <!-- Modal de Upload da Etiqueta -->
                                                        <div class="modal fade uploadEtiquetaModal"
                                                            id="uploadEtiquetaModal<?= htmlspecialchars($venda['saleId']) ?>"
                                                            tabindex="-1"
                                                            aria-labelledby="uploadEtiquetaModalLabel<?= htmlspecialchars($venda['saleId']) ?>"
                                                            aria-hidden="true">
                                                            <div class="modal-dialog modal-lg modal-dialog-scrollable">
                                                                <form class="uploadEtiquetaForm"
                                                                    enctype="multipart/form-data"
                                                                    method="post"
                                                                    data-saleid="<?= htmlspecialchars($venda['saleId']) ?>">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h5 class="modal-title"
                                                                                id="uploadEtiquetaModalLabel<?= htmlspecialchars($venda['saleId']) ?>">
                                                                                Enviar Etiqueta Manualmente</h5>
                                                                            <button type="button"
                                                                                class="btn-close"
                                                                                data-bs-dismiss="modal"
                                                                                aria-label="Fechar"></button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            <input type="hidden"
                                                                                name="sale_id"
                                                                                value="<?= htmlspecialchars($venda['saleId']) ?>">

                                                                            <input type="file"
                                                                                id="pdfInput"
                                                                                accept="application/pdf"
                                                                                class="form-control mb-3">
                                                                            <div id="pdfViewer"></div>
                                                                            <div id="cropContainer"
                                                                                style="display: none; max-height: 90vh; overflow: auto;">
                                                                                <canvas id="pdfCanvas"
                                                                                    style="border: 1px solid #ccc; width: 100%; height: auto; max-height: 90vh;"></canvas>
                                                                            </div>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button"
                                                                                class="btn btn-primary"
                                                                                id="cropButton"
                                                                                style="display: none;">Recortar</button>
                                                                            <button type="button"
                                                                                class="btn btn-secondary"
                                                                                data-bs-dismiss="modal">Cancelar</button>
                                                                        </div>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; ?>
                                                <?php else: ?>
                                                    <div class="text-center py-5">
                                                        <p class="fs-5 text-muted">Nenhuma venda encontrada.</p>
                                                    </div>
                                                <?php endif; ?>
                                            </div>

                                            <!-- Navegação da Paginação -->
                                            <?php if (isset($totalVendas) && $totalVendas > 0 && $totalPaginas > 1): ?>
                                                <div class="row mt-4">
                                                    <div class="col-12">
                                                        <nav aria-label="Navegação da paginação">
                                                            <ul class="pagination justify-content-center flex-wrap">
                                                                <!-- Botão Anterior -->
                                                                <?php if ($paginaAtual > 1): ?>
                                                                    <li class="page-item">
                                                                        <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['pagina' => $paginaAtual - 1])) ?>">
                                                                            <i class="ti ti-chevron-left d-md-none"></i>
                                                                            <span class="d-none d-md-inline"><i class="ti ti-chevron-left"></i> Anterior</span>
                                                                        </a>
                                                                    </li>
                                                                <?php else: ?>
                                                                    <li class="page-item disabled">
                                                                        <span class="page-link">
                                                                            <i class="ti ti-chevron-left d-md-none"></i>
                                                                            <span class="d-none d-md-inline"><i class="ti ti-chevron-left"></i> Anterior</span>
                                                                        </span>
                                                                    </li>
                                                                <?php endif; ?>

                                                                <!-- Números das páginas -->
                                                                <?php
                                                                // Para mobile, mostrar menos páginas
                                                                $inicioRange = max(1, $paginaAtual - 1);
                                                                $fimRange = min($totalPaginas, $paginaAtual + 1);

                                                                // Para desktop, mostrar mais páginas
                                                                $inicioRangeDesktop = max(1, $paginaAtual - 2);
                                                                $fimRangeDesktop = min($totalPaginas, $paginaAtual + 2);

                                                                // Se estamos no início, mostra mais páginas à frente (desktop)
                                                                if ($paginaAtual <= 3) {
                                                                    $fimRangeDesktop = min($totalPaginas, 5);
                                                                }

                                                                // Se estamos no final, mostra mais páginas atrás (desktop)
                                                                if ($paginaAtual >= $totalPaginas - 2) {
                                                                    $inicioRangeDesktop = max(1, $totalPaginas - 4);
                                                                }
                                                                ?>

                                                                <!-- Primeira página (desktop) -->
                                                                <?php if ($inicioRangeDesktop > 1): ?>
                                                                    <li class="page-item d-none d-md-block">
                                                                        <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['pagina' => 1])) ?>">1</a>
                                                                    </li>
                                                                    <?php if ($inicioRangeDesktop > 2): ?>
                                                                        <li class="page-item disabled d-none d-md-block">
                                                                            <span class="page-link">...</span>
                                                                        </li>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>

                                                                <!-- Range de páginas para mobile -->
                                                                <?php for ($i = $inicioRange; $i <= $fimRange; $i++): ?>
                                                                    <li class="page-item d-block d-md-none <?= ($i == $paginaAtual) ? 'active' : '' ?>">
                                                                        <?php if ($i == $paginaAtual): ?>
                                                                            <span class="page-link"><?= $i ?></span>
                                                                        <?php else: ?>
                                                                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['pagina' => $i])) ?>"><?= $i ?></a>
                                                                        <?php endif; ?>
                                                                    </li>
                                                                <?php endfor; ?>

                                                                <!-- Range de páginas para desktop -->
                                                                <?php for ($i = $inicioRangeDesktop; $i <= $fimRangeDesktop; $i++): ?>
                                                                    <li class="page-item d-none d-md-block <?= ($i == $paginaAtual) ? 'active' : '' ?>">
                                                                        <?php if ($i == $paginaAtual): ?>
                                                                            <span class="page-link"><?= $i ?></span>
                                                                        <?php else: ?>
                                                                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['pagina' => $i])) ?>"><?= $i ?></a>
                                                                        <?php endif; ?>
                                                                    </li>
                                                                <?php endfor; ?>

                                                                <!-- Última página (desktop) -->
                                                                <?php if ($fimRangeDesktop < $totalPaginas): ?>
                                                                    <?php if ($fimRangeDesktop < $totalPaginas - 1): ?>
                                                                        <li class="page-item disabled d-none d-md-block">
                                                                            <span class="page-link">...</span>
                                                                        </li>
                                                                    <?php endif; ?>
                                                                    <li class="page-item d-none d-md-block">
                                                                        <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['pagina' => $totalPaginas])) ?>"><?= $totalPaginas ?></a>
                                                                    </li>
                                                                <?php endif; ?>

                                                                <!-- Botão Próximo -->
                                                                <?php if ($paginaAtual < $totalPaginas): ?>
                                                                    <li class="page-item">
                                                                        <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['pagina' => $paginaAtual + 1])) ?>">
                                                                            <i class="ti ti-chevron-right d-md-none"></i>
                                                                            <span class="d-none d-md-inline">Próximo <i class="ti ti-chevron-right"></i></span>
                                                                        </a>
                                                                    </li>
                                                                <?php else: ?>
                                                                    <li class="page-item disabled">
                                                                        <span class="page-link">
                                                                            <i class="ti ti-chevron-right d-md-none"></i>
                                                                            <span class="d-none d-md-inline">Próximo <i class="ti ti-chevron-right"></i></span>
                                                                        </span>
                                                                    </li>
                                                                <?php endif; ?>
                                                            </ul>
                                                        </nav>

                                                        <!-- Informações de paginação e controle "Ir para página" -->
                                                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between mt-3">
                                                            <!-- Informações de página -->
                                                            <div class="mb-2 mb-md-0">
                                                                <small class="text-muted">
                                                                    Página <?= $paginaAtual ?> de <?= $totalPaginas ?>
                                                                    <span class="d-none d-sm-inline">
                                                                        (<?= ($offset + 1) ?> a <?= min($offset + $itensPorPagina, $totalVendas) ?> de <?= $totalVendas ?> vendas)
                                                                    </span>
                                                                </small>
                                                            </div>


                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>


                                </div>
                            </div>



                        </div>
                        <!-- / Content -->

                    </div>
                    <!-- / Content -->



                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <div class="layout-overlay layout-menu-toggle"></div>

    </div>
    <!-- / Layout wrapper -->




    <script>
        // ========================================
        // CONFIGURAÇÃO GLOBAL
        // ========================================

        // Array de marketplaces onde é possível reprocessar etiqueta
        const marketplaces = ['shopee', 'Shopee', 'mercado_livre', 'mercado livre'];

        // Array de ecommerces onde é possível comprar etiqueta
        const ecommerces = ['ecommerce', 'loja_virtual', 'site', 'wordpress', 'woocommerce', 'magento', 'shopify', 'vtex', 'nuvemshop', 'yampi', 'shopify'];

        // Função utilitária para fechar menu mobile
        function closeMobileMenu() {
            const layoutWrapper = document.querySelector('.layout-wrapper');
            if (layoutWrapper && layoutWrapper.classList.contains('layout-menu-expanded')) {
                layoutWrapper.classList.remove('layout-menu-expanded');
            }
        }

        // ========================================
        // SISTEMA DE TABS REMOVIDO
        // ========================================
        // As tabs agora funcionam com links normais (anchor tags)
        // Não é mais necessário JavaScript para filtrar
        // O backend PHP faz toda a filtragem via URL
        // ========================================
    </script>
    <script>
        // Função de logout
        if (activeTab) {
            // ========================================
    </script>
    <script>
        // Função de logout
        Swal.fire({
            toast: true,
            position: "top-end",
            icon: 'success',
            title: 'Você se desconectou com sucesso! Até logo. 😉',
            showConfirmButton: false,
            timer: 2000,
        }).then(function() {
            window.location.href = '/logout';
        });
        }
    </script>

    <script src="../../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../../assets/vendor/libs/popper/popper.js"></script>
    <script src="../../assets/vendor/js/bootstrap.js"></script>
    <script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="../../assets/vendor/libs/hammer/hammer.js"></script>
    <script src="../../assets/vendor/libs/i18n/i18n.js"></script>
    <script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="../../assets/vendor/js/menu.js"></script>
    <script src="../../assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="../../assets/vendor/libs/swiper/swiper.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/dashboards-analytics.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/ui-modals.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Scripts de validação automática -->
    <script src="../../assets/js/payment-recovery-simple.js"></script>

    <script>
        // Configurações globais do usuário e sistema
        window.userConfig = {
            isAffiliate: <?= $is_affiliate ?>,
            userId: <?= $_SESSION['usuario']['id_usuario'] ?>,
            userEmail: '<?= $_SESSION['usuario']['email'] ?>',
            userName: '<?= $_SESSION['usuario']['nome'] ?>',
            // 🔧 Controle de validações automáticas (true = ativo, false = desativado)
            enablePageValidation: <?= $ENABLE_PAGE_VALIDATION ? 'true' : 'false' ?>
        };

        // Log de configuração para debug
        console.log('🔧 Validações de página:', window.userConfig.enablePageValidation ? '✅ ATIVAS' : '⛔ DESATIVADAS');


        // Função para copiar o código QR para a área de transferência
        function copyToClipboard() {
            var copyText = document.getElementById("qrCodeText");
            copyText.select();
            document.execCommand("copy");
        }


        function exibirMensagem(titulo, mensagem, tipo) {
            Swal.fire({
                title: titulo,
                text: mensagem,
                icon: tipo,
                confirmButtonText: 'Ok'
            });
        }

        $(document).on('submit', '.uploadNFForm', function(event) {
            event.preventDefault(); // Previne o comportamento padrão do formulário

            var formData = new FormData(this);

            $.ajax({
                url: '../../assets/ajax/nf/enviar_nf.php', // Endereço do PHP para processamento
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                dataType: 'text', // Importante: tratar a resposta como texto simples
                success: function(response) {
                    // Exibe a mensagem de sucesso usando SweetAlert
                    Swal.fire({
                        title: 'Sucesso!',
                        text: response,
                        icon: 'success',
                        confirmButtonText: 'OK'
                    }).then((result) => {
                        $('.uploadNFFormodal').modal('hide'); // Fecha o modal

                        if (result.isConfirmed) { // Verifica se o botão OK foi clicado
                            location.reload(); // Recarrega a página
                        }
                    });
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Exibe a mensagem de erro usando SweetAlert
                    Swal.fire({
                        title: 'Erro!',
                        text: 'Erro ao enviar a Nota Fiscal: ' + textStatus,
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                }
            });
        });


        $('.enviar_nf').on('click', function() {
            $('#uploadNFForm').submit();

            setTimeout(function() {
                $('.uploadNFFormodal').modal('hide');
            }, 500);
        });

        document.addEventListener("DOMContentLoaded", function() {
            // Popovers removidos - as informações agora aparecem dentro do accordion
        });

        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.btn-primary[data-fornecedor][data-venda][data-pagamento]').forEach(function(
                button) {
                button.addEventListener('click', function() {
                    const fornecedor = this.getAttribute('data-fornecedor');
                    const venda = this.getAttribute('data-venda');
                    const pagamento = this.getAttribute('data-pagamento');

                    this.disabled = true;
                    const originalText = this.innerHTML;
                    this.innerHTML =
                        '<span class="spinner-border me-2 spinner-border-sm" role="status" aria-hidden="true"></span> Processando...';

                    fetch('/assets/ajax/pagamento/reprocessar_pagamento.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            body: JSON.stringify({
                                fornecedor,
                                venda,
                                pagamento
                            })
                        })
                        .then(response => response.json())
                        .then(data => {
                            button.disabled = false;
                            button.innerHTML = originalText;

                            // Fechar o modal
                            const modal = bootstrap.Modal.getInstance(button.closest('.modal'));
                            if (modal) {
                                modal.hide();
                            }

                            // Exibir SweetAlert com o retorno do JSON
                            Swal.fire({
                                title: data.success == 'success' ? 'Sucesso!' : 'Erro!',
                                text: data.message,
                                icon: data.success == 'success' ? 'success' : 'error',
                                confirmButtonText: 'OK'
                            }).then((result) => {
                                if (result.isConfirmed || result.dismiss === Swal
                                    .DismissReason.close) {
                                    if (data.redirect) {
                                        window.location.href = data.redirect;
                                    }
                                }
                            });
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            button.disabled = false;
                            button.innerHTML = originalText;

                            // Exibir SweetAlert em caso de erro
                            Swal.fire({
                                title: 'Erro!',
                                text: 'Ocorreu um erro ao processar o pagamento.',
                                icon: 'error',
                                confirmButtonText: 'OK'
                            });
                        });
                });
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.modal').forEach(function(modal) {
                modal.addEventListener('hidden.bs.modal', function() {
                    // Limpa o input de seleção de arquivo
                    const pdfInput = modal.querySelector('#pdfInput');
                    if (pdfInput) {
                        pdfInput.value = '';
                    }

                    // Limpa o canvas e esconde o container de crop
                    const pdfCanvas = modal.querySelector('#pdfCanvas');
                    const cropContainer = modal.querySelector('#cropContainer');
                    const cropButton = modal.querySelector('#cropButton');

                    if (pdfCanvas) {
                        const context = pdfCanvas.getContext('2d');
                        context.clearRect(0, 0, pdfCanvas.width, pdfCanvas.height);
                    }

                    if (cropContainer) {
                        cropContainer.style.display = 'none';
                    }

                    if (cropButton) {
                        cropButton.style.display = 'none';
                    }
                });
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.btn-cancelar-reserva').forEach(function(btn) {
                btn.addEventListener('click', function() {
                    const saleId = this.getAttribute('data-saleid');
                    Swal.fire({
                        title: 'cancelar venda',
                        input: 'textarea',
                        inputLabel: 'Motivo do cancelamento',
                        inputPlaceholder: 'Descreva o motivo...',
                        inputAttributes: {
                            'aria-label': 'Motivo do cancelamento'
                        },
                        showCancelButton: true,
                        confirmButtonText: 'cancelar venda',
                        cancelButtonText: 'Fechar',
                        inputValidator: (value) => {
                            if (!value) {
                                return 'O motivo é obrigatório!';
                            }
                        }
                    }).then((result) => {
                        if (result.isConfirmed && result.value) {

                            fetch('/assets/ajax/vendas/cancelar_reserva.php', {
                                    method: 'POST',
                                    headers: {
                                        'Content-Type': 'application/x-www-form-urlencoded'
                                    },
                                    body: 'saleId=' + encodeURIComponent(saleId) +
                                        '&motivo=' + encodeURIComponent(result.value)
                                })
                                .then(res => res.json())
                                .then(data => {
                                    if (data.success) {
                                        Swal.fire('Cancelado!',
                                            'Venda cancelada com sucesso.',
                                            'success').then(() => location.reload());
                                    } else {
                                        Swal.fire('Erro', data.message ||
                                            'Erro ao cancelar venda.', 'error');
                                    }
                                })
                                .catch(() => Swal.fire('Erro', 'Erro ao cancelar venda.',
                                    'error'));
                        }
                    });
                });
            });
        });

        // Event listener para o botão de reprocessar etiqueta
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.btn-reprocessar-etiqueta').forEach(function(btn) {
                btn.addEventListener('click', function() {
                    const saleTitle = this.getAttribute('data-saletitle');
                    const saleId = this.getAttribute('data-saleid');
                    
                    if (!saleTitle) {
                        Swal.fire('Erro', 'Sale Title não encontrado.', 'error');
                        return;
                    }

                    Swal.fire({
                        title: 'Reprocessar Etiqueta',
                        html: `Deseja reprocessar a etiqueta da venda?<br><br><code>${saleTitle}</code>`,
                        icon: 'question',
                        showCancelButton: true,
                        confirmButtonText: 'Sim, reprocessar!',
                        cancelButtonText: 'Cancelar',
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Iniciar reprocessamento com modal de progresso
                            iniciarReprocessamentoComModal(saleTitle, btn);
                        }
                    });
                });
            });
        });

        // Event listener para verificar URLs 404 e mostrar botão de reprocessar
        document.addEventListener('DOMContentLoaded', function() {
            // Verificar todas as etiquetas ao carregar a página
            document.querySelectorAll('.btn-ver-etiqueta').forEach(function(btn) {
                const url = btn.getAttribute('data-etiqueta-url');
                const btnReprocessar = btn.parentElement.querySelector('.btn-reprocessar-etiqueta-404');
                
                if (!url || !btnReprocessar) return;

                // Fazer requisição HEAD para verificar se a URL existe
                fetch(url, { 
                    method: 'HEAD',
                    cache: 'no-cache'
                })
                .then(response => {
                    // Se retornar 404 ou qualquer erro, mostrar botão de reprocessar
                    if (response.status === 404 || !response.ok) {
                        btnReprocessar.style.display = 'block';
                        btn.classList.add('text-decoration-line-through');
                        btn.title = 'Etiqueta não encontrada (404) - Clique em reprocessar';
                    } else {
                        // URL OK - garantir que o botão de reprocessar esteja escondido
                        btnReprocessar.style.display = 'none';
                        btn.classList.remove('text-decoration-line-through');
                        btn.title = 'Ver Etiqueta';
                    }
                })
                .catch(() => {
                    // Em caso de erro na verificação (CORS, timeout, etc), NÃO mostrar o botão
                    // pois pode ser apenas problema de rede, não necessariamente 404
                    btnReprocessar.style.display = 'none';
                    console.warn('Não foi possível verificar a URL da etiqueta:', url);
                });
            });

            // Event listener para os botões de reprocessar com 404
            document.querySelectorAll('.btn-reprocessar-etiqueta-404').forEach(function(btn) {
                btn.addEventListener('click', function() {
                    const saleTitle = this.getAttribute('data-saletitle');
                    const saleId = this.getAttribute('data-saleid');
                    
                    if (!saleTitle) {
                        Swal.fire('Erro', 'Sale Title não encontrado.', 'error');
                        return;
                    }

                    Swal.fire({
                        title: 'Reprocessar Etiqueta',
                        html: `A etiqueta não foi encontrada (404).<br><br>Deseja reprocessar a venda?<br><br><code>${saleTitle}</code>`,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Sim, reprocessar!',
                        cancelButtonText: 'Cancelar',
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Iniciar reprocessamento com modal de progresso
                            iniciarReprocessamentoComModal(saleTitle, btn);
                        }
                    });
                });
            });
        });

        // Função para iniciar reprocessamento com modal de progresso em tempo real
        function iniciarReprocessamentoComModal(saleTitle, btnOriginal) {
            // Desabilitar botão original
            if (btnOriginal) {
                btnOriginal.disabled = true;
                const originalHtml = btnOriginal.innerHTML;
                btnOriginal.innerHTML = '<span class="spinner-border spinner-border-sm me-1"></span> Processando...';
            }

            // Variável para controle do polling
            let pollingInterval = null;
            let jobId = null;

            // HTML do modal de progresso
            const modalHtml = `
                <div class="text-start">
                    <div class="mb-3">
                        <strong>Sale Title:</strong> <code>${saleTitle}</code>
                    </div>
                    
                    <div class="alert alert-info d-flex align-items-center mb-3">
                        <i class="ti ti-info-circle me-2"></i>
                        <div>Aguarde enquanto processamos a etiqueta...</div>
                    </div>

                    <!-- Status do Job -->
                    <div class="card mb-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="fw-semibold">Status:</span>
                                <span id="modalStatusBadge" class="badge bg-warning">
                                    <i class="ti ti-clock me-1"></i>Iniciando...
                                </span>
                            </div>
                            <div class="progress" style="height: 20px;">
                                <div id="modalProgressBar" class="progress-bar progress-bar-striped progress-bar-animated bg-primary" 
                                     role="progressbar" style="width: 0%">0%</div>
                            </div>
                            <div id="modalDetalhes" class="mt-3" style="display: none;">
                                <hr>
                                <div class="small text-muted">
                                    <div><strong>Fornecedor:</strong> <span id="modalFornecedor">-</span></div>
                                    <div><strong>Tentativas:</strong> <span id="modalTentativas">-</span></div>
                                    <div><strong>Tempo decorrido:</strong> <span id="modalTempo">-</span></div>
                                </div>
                            </div>
                            <div id="modalErro" class="alert alert-danger mt-3" style="display: none;">
                                <i class="ti ti-alert-circle me-2"></i>
                                <span id="modalErroMsg"></span>
                            </div>
                            <div id="modalSucesso" class="alert alert-success mt-3" style="display: none;">
                                <i class="ti ti-check me-2"></i>
                                <span id="modalSucessoMsg">Etiqueta processada com sucesso!</span>
                                <a id="modalEtiquetaLink" href="#" target="_blank" class="btn btn-sm btn-success mt-2 w-100">
                                    <i class="ti ti-download me-1"></i>Baixar Etiqueta
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            `;

            // Abrir modal do SweetAlert
            Swal.fire({
                title: '<i class="ti ti-refresh me-2"></i>Processando Etiqueta',
                html: modalHtml,
                width: '600px',
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                didOpen: () => {
                    // Iniciar o processamento
                    console.log('Iniciando reprocessamento para:', saleTitle);
                    
                    fetch('../../assets/ajax/vendas/processar_reprocessamento.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded'
                        },
                        body: 'saleTitles=' + encodeURIComponent(saleTitle)
                    })
                    .then(res => res.json())
                    .then(data => {
                        console.log('Resposta do processamento:', data);
                        
                        if (data.success && data.detalhes && data.detalhes.length > 0) {
                            // Pegar o job_id do primeiro detalhe
                            jobId = data.detalhes[0].job_id;
                            console.log('Job ID obtido:', jobId);
                            
                            if (jobId) {
                                // Iniciar monitoramento imediatamente
                                setTimeout(() => {
                                    atualizarStatusModal();
                                    pollingInterval = setInterval(atualizarStatusModal, 2000);
                                }, 500);
                            } else {
                                console.error('Job ID não encontrado nos detalhes:', data.detalhes);
                                mostrarErroModal('Job ID não encontrado na resposta.');
                            }
                        } else {
                            console.error('Resposta inválida:', data);
                            mostrarErroModal(data.message || 'Erro ao criar job de reprocessamento.');
                        }
                    })
                    .catch(error => {
                        console.error('Erro:', error);
                        mostrarErroModal('Erro ao processar requisição.');
                    });
                }
            });

            // Função para atualizar status do modal
            function atualizarStatusModal() {
                if (!jobId) {
                    console.warn('JobId não definido, parando polling');
                    clearInterval(pollingInterval);
                    return;
                }

                console.log('Consultando status do job:', jobId);

                // Usar URLSearchParams para enviar corretamente o array
                const params = new URLSearchParams();
                params.append('job_ids[]', jobId);

                fetch('../../assets/ajax/vendas/consultar_status_jobs.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: params.toString()
                })
                .then(res => res.json())
                .then(response => {
                    console.log('Resposta do status:', response);
                    
                    if (response.success && response.jobs && response.jobs.length > 0) {
                        const job = response.jobs[0];
                        atualizarUIModal(job);

                        // Se finalizou (sucesso ou erro), parar polling
                        if (job.status === 'completed' || job.status === 'failed') {
                            clearInterval(pollingInterval);
                            finalizarModal(job);
                        }
                    } else {
                        console.warn('Resposta inesperada:', response);
                    }
                })
                .catch(error => {
                    console.error('Erro ao consultar status:', error);
                });
            }

            // Função para atualizar UI do modal
            function atualizarUIModal(job) {
                console.log('Atualizando UI com job:', job);
                
                const statusBadge = document.getElementById('modalStatusBadge');
                const progressBar = document.getElementById('modalProgressBar');
                const detalhes = document.getElementById('modalDetalhes');
                const fornecedor = document.getElementById('modalFornecedor');
                const tentativas = document.getElementById('modalTentativas');
                const tempo = document.getElementById('modalTempo');

                if (!statusBadge || !progressBar) {
                    console.error('Elementos do modal não encontrados');
                    return;
                }

                // Atualizar badge de status
                const statusConfig = {
                    'pending': { icon: 'ti-clock', class: 'bg-warning', text: 'Pendente' },
                    'processing': { icon: 'ti-loader', class: 'bg-primary', text: 'Processando' },
                    'completed': { icon: 'ti-check', class: 'bg-success', text: 'Concluído' },
                    'failed': { icon: 'ti-x', class: 'bg-danger', text: 'Falhou' }
                };

                const config = statusConfig[job.status] || statusConfig['pending'];
                statusBadge.className = 'badge ' + config.class;
                statusBadge.innerHTML = '<i class="ti ' + config.icon + ' me-1"></i>' + config.text;

                // Atualizar barra de progresso
                let progresso = 0;
                if (job.status === 'pending') progresso = 10;
                else if (job.status === 'processing') progresso = 50;
                else if (job.status === 'completed') progresso = 100;
                else if (job.status === 'failed') progresso = 100;

                progressBar.style.width = progresso + '%';
                progressBar.textContent = progresso + '%';
                
                if (job.status === 'completed') {
                    progressBar.classList.remove('bg-primary');
                    progressBar.classList.add('bg-success');
                } else if (job.status === 'failed') {
                    progressBar.classList.remove('bg-primary', 'progress-bar-animated');
                    progressBar.classList.add('bg-danger');
                }

                // Mostrar detalhes
                if (job.status !== 'pending' && detalhes) {
                    detalhes.style.display = 'block';
                    if (fornecedor) fornecedor.textContent = job.fornecedor || '-';
                    if (tentativas) tentativas.textContent = job.tentativas + '/' + job.max_tentativas;
                    if (tempo) tempo.textContent = job.tempo_decorrido || '-';
                }
            }

            // Função para finalizar modal
            function finalizarModal(job) {
                const modalErro = document.getElementById('modalErro');
                const modalErroMsg = document.getElementById('modalErroMsg');
                const modalSucesso = document.getElementById('modalSucesso');
                const modalEtiquetaLink = document.getElementById('modalEtiquetaLink');

                if (job.status === 'completed') {
                    // Sucesso
                    modalSucesso.style.display = 'block';
                    if (job.etiqueta_url) {
                        modalEtiquetaLink.href = job.etiqueta_url;
                        modalEtiquetaLink.style.display = 'block';
                    } else {
                        modalEtiquetaLink.style.display = 'none';
                    }

                    // Adicionar botão de fechar
                    Swal.update({
                        showConfirmButton: true,
                        confirmButtonText: 'Fechar e Atualizar',
                        confirmButtonColor: '#28a745',
                        preConfirm: () => {
                            location.reload();
                        }
                    });
                } else if (job.status === 'failed') {
                    // Erro
                    modalErro.style.display = 'block';
                    modalErroMsg.textContent = job.erro_mensagem || 'Erro desconhecido ao processar etiqueta.';

                    // Adicionar botão de fechar
                    Swal.update({
                        showConfirmButton: true,
                        confirmButtonText: 'Fechar',
                        confirmButtonColor: '#d33',
                        preConfirm: () => {
                            location.reload();
                        }
                    });
                }

                // Reabilitar botão original
                if (btnOriginal) {
                    btnOriginal.disabled = false;
                    btnOriginal.innerHTML = '<i class="ti ti-refresh me-1"></i> Reprocessar Etiqueta';
                }
            }

            // Função para mostrar erro no modal
            function mostrarErroModal(mensagem) {
                clearInterval(pollingInterval);
                
                const modalErro = document.getElementById('modalErro');
                const modalErroMsg = document.getElementById('modalErroMsg');
                
                if (modalErro && modalErroMsg) {
                    modalErro.style.display = 'block';
                    modalErroMsg.textContent = mensagem;
                }

                Swal.update({
                    showConfirmButton: true,
                    confirmButtonText: 'Fechar',
                    confirmButtonColor: '#d33'
                });

                // Reabilitar botão original
                if (btnOriginal) {
                    btnOriginal.disabled = false;
                    btnOriginal.innerHTML = '<i class="ti ti-refresh me-1"></i> Reprocessar Etiqueta';
                }
            }
        }

        function removerEtiqueta(saleId, el) {
            if (!saleId) return;

            // Fechar menu mobile se estiver aberto
            closeMobileMenu();

            // 🔍 Verificar se a etiqueta está em buffering
            const vendaItem = el.closest('.venda-item');
            if (vendaItem) {
                const buffering = vendaItem.getAttribute('data-buffering') === '1';
                const etiquetaMl = vendaItem.querySelector('[data-etiqueta-ml]')?.getAttribute('data-etiqueta-ml');

                if (buffering || etiquetaMl === 'buffering') {
                    Swal.fire({
                        title: '⏱️ Etiqueta em Buffering',
                        html: `
                            <div class="text-start">
                                <p><strong>Esta etiqueta está aguardando liberação do Mercado Livre.</strong></p>
                                <p class="mb-2">Não é possível remover uma etiqueta em buffering porque ela ainda não foi gerada.</p>
                                <div class="alert alert-info mt-3">
                                    <i class="ti ti-info-circle me-2"></i>
                                    Aguarde a liberação automática pelo Mercado Livre.
                                </div>
                            </div>
                        `,
                        icon: 'warning',
                        confirmButtonText: 'Entendi',
                        customClass: {
                            htmlContainer: 'text-start'
                        }
                    });
                    return; // Bloqueia a ação
                }
            }

            Swal.fire({
                title: 'Remover Etiqueta',
                text: 'Tem certeza que deseja remover a etiqueta?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sim, remover!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch('../../assets/ajax/etiquetas/remover_etiqueta.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded'
                            },
                            body: 'saleId=' + encodeURIComponent(saleId)
                        })
                        .then(res => res.json())
                        .then(data => {
                            if (data.success) {
                                Swal.fire('Sucesso', 'Etiqueta removida com sucesso!', 'success').then(() => {
                                    location.reload();
                                });
                            } else {
                                Swal.fire('Erro', data.message || 'Erro ao remover etiqueta.', 'error');
                            }
                        })
                        .catch((error) => {
                            console.error('Erro ao remover etiqueta:', error);
                            Swal.fire('Erro', 'Erro ao remover etiqueta.', 'error');
                        });
                }
            });
        }

        function reprocessarEtiqueta(saleId, integracao, saleTitle, fornecedor, el) {
            if (!saleId || !saleTitle || !fornecedor) return;

            // Verificar se é um marketplace válido
            if (!marketplaces.includes(integracao)) {
                Swal.fire({
                    title: 'Reprocessamento Não Disponível',
                    text: 'O reprocessamento automático de etiquetas está disponível apenas para marketplaces (Shopee e MercadoLivre).',
                    icon: 'warning',
                    confirmButtonText: 'Entendi'
                });
                return;
            }

            // 🔥 NOVO: Verificar timer de 10 minutos via localStorage
            const timerKey = `etiqueta_timer_${saleId}`;
            const lastProcessed = localStorage.getItem(timerKey);

            if (lastProcessed) {
                const timePassed = Date.now() - parseInt(lastProcessed);
                const fiveMinutes = 5 * 60 * 1000; // 5 minutos em ms

                if (timePassed < fiveMinutes) {
                    const remainingMs = fiveMinutes - timePassed;
                    const remainingMin = Math.ceil(remainingMs / 60000);

                    Swal.fire({
                        title: 'Aguarde um momento',
                        html: `Você já reprocessou esta etiqueta recentemente.<br><br>Aguarde <b>${remainingMin} minuto(s)</b> para tentar novamente.`,
                        icon: 'info',
                        confirmButtonText: 'Entendi'
                    });
                    return;
                }
            }

            // Verificar se a venda tem Erro 338A, 388A ou Buffered nas observações
            let observacoes = el.getAttribute('data-observacoes') || '';
            if (!observacoes) {
                const vendaItem = el.closest('.venda-item');
                if (vendaItem) {
                    observacoes = vendaItem.getAttribute('data-observacoes') || '';
                }
            }

            // ⏱️ VALIDAÇÃO BUFFERED - Verificar se está aguardando liberação
            if (observacoes.includes('[Buffered]')) {
                // Extrair data do buffering usando regex (aceita com ou sem horário)
                // Formatos: [Buffered][DD/MM/YYYY] ou [Buffered][DD/MM/YYYY HH:MM]
                const bufferingMatch = observacoes.match(/\[Buffered\]\[(\d{2}\/\d{2}\/\d{4})(?:\s+(\d{2}:\d{2}))?\]/);

                if (bufferingMatch && bufferingMatch[1]) {
                    const dataLiberacao = bufferingMatch[1];
                    const horaLiberacao = bufferingMatch[2] || '12:00'; // Se não tiver hora, usa meio-dia
                    const dataHoraCompleta = bufferingMatch[2] ? `${dataLiberacao} ${horaLiberacao}` : `${dataLiberacao}`;

                    try {
                        // Converter data para timestamp
                        const [dia, mes, ano] = dataLiberacao.split('/');
                        const [hora, minuto] = horaLiberacao.split(':');

                        const dataLiberacaoObj = new Date(ano, mes - 1, dia, hora, minuto);
                        const agora = new Date();

                        // Se ainda não chegou a data de liberação, bloquear reprocessamento
                        if (dataLiberacaoObj > agora) {
                            // Calcular tempo restante
                            const tempoRestante = dataLiberacaoObj - agora;
                            const diasRestantes = Math.floor(tempoRestante / (1000 * 60 * 60 * 24));
                            const horasRestantes = Math.floor((tempoRestante % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                            const minutosRestantes = Math.floor((tempoRestante % (1000 * 60 * 60)) / (1000 * 60));

                            let tempoRestanteTexto = '';
                            if (diasRestantes > 0) {
                                tempoRestanteTexto = `${diasRestantes}d ${horasRestantes}h`;
                            } else if (horasRestantes > 0) {
                                tempoRestanteTexto = `${horasRestantes}h ${minutosRestantes}min`;
                            } else {
                                tempoRestanteTexto = `${minutosRestantes}min`;
                            }

                            Swal.fire({
                                title: 'Etiqueta em ',
                                html: `
                                    <div class="text-start">
                                        <p><strong>O Mercado Livre ainda não liberou esta etiqueta.</strong></p>
                                        <hr>
                                        <p><i class="ti ti-calendar me-2"></i><strong>Data de Liberação:</strong> ${dataLiberacao}</p>
                                        <p><i class="ti ti-clock me-2"></i><strong>Tempo Restante:</strong> ${tempoRestanteTexto}</p>
                                        <hr>
                                        <p class="text-muted small">
                                            <i class="ti ti-info-circle me-2"></i>
                                            O sistema tentará reprocessar automaticamente quando a etiqueta for liberada.
                                            Você não precisa fazer nada.
                                        </p>
                                    </div>
                                `,
                                icon: 'info',
                                confirmButtonText: 'Entendi',
                                confirmButtonColor: '#0d6efd'
                            });
                            return;
                        } else {
                            // Data de liberação já passou, permitir reprocessamento
                            console.log('✅ Data de liberação do buffering já passou, permitindo reprocessamento');
                        }
                    } catch (e) {
                        console.error('⚠️ Erro ao validar data de buffering:', e);
                    }
                } else {
                    // Se tem [Buffered] mas não conseguiu extrair data, bloquear por segurança
                    Swal.fire({
                        title: '⏱️ Etiqueta em Buffering',
                        html: `
                            <p>O Mercado Livre ainda não liberou esta etiqueta.</p>
                            <p class="text-muted small">Aguarde alguns minutos e tente novamente.</p>
                        `,
                        icon: 'info',
                        confirmButtonText: 'Entendi'
                    });
                    return;
                }
            }

            if (observacoes.includes('Erro 338A')) {
                Swal.fire({
                    title: 'Reprocessamento Bloqueado',
                    text: 'Esta etiqueta possui Erro 338A e não pode ser reprocessada automaticamente. Verifique manualmente no painel do MercadoLivre.',
                    icon: 'warning',
                    confirmButtonText: 'Entendi'
                });
                return;
            }

            // ⚠️ NOVO: Verificar se precisa combinar envio com fornecedor (Shipping ID não encontrado)
            if (observacoes.includes('combinar o envio com o fornecedor') ||
                observacoes.includes('Esta venda está para combinar o envio com o fornecedor')) {
                Swal.fire({
                    title: 'Reprocessamento Bloqueado',
                    html: '<b>Esta venda está para combinar o envio com o fornecedor.</b><br><br>Envie a etiqueta manualmente.<br><br><small class="text-muted">Se acha que foi um engano, por favor nos informe!</small>',
                    icon: 'warning',
                    confirmButtonText: 'Entendi'
                });
                return;
            }

            // Fechar menu mobile se estiver aberto
            closeMobileMenu();

            // Mostrar confirmação
            Swal.fire({
                title: 'Reprocessar Etiqueta',
                html: `Deseja adicionar <b>${saleTitle}</b> na fila de processamento de etiquetas?<br><br><small class="text-muted">A etiqueta será processada pelo worker em segundo plano.</small>`,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sim, reprocessar!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Mostrar loading
                    const originalText = el.innerHTML;
                    el.innerHTML = '<i class="ti ti-loader-2 ti-spin me-1"></i>Adicionando...';
                    el.style.pointerEvents = 'none';

                    // Normalizar nome da plataforma
                    let plataforma = integracao;
                    if (integracao === 'mercado_livre' || integracao === 'mercado livre') {
                        plataforma = 'mercado_livre';
                    }

                    // 🔥 NOVO: Criar job na tabela jobs_etiquetas
                    fetch('../../assets/ajax/etiquetas/criar_job_etiqueta.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded'
                            },
                            body: new URLSearchParams({
                                sale_title: saleTitle,
                                fornecedor: fornecedor,
                                plataforma: plataforma
                            })
                        })
                        .then(res => res.json())
                        .then(data => {
                            if (data.success) {
                                // 🔥 Salvar timestamp no localStorage
                                localStorage.setItem(timerKey, Date.now().toString());

                                // 🔥 Atualizar etiqueta_ml para 'processing_label'
                                fetch('../../assets/ajax/vendas/atualizar_status_etiqueta.php', {
                                    method: 'POST',
                                    headers: {
                                        'Content-Type': 'application/x-www-form-urlencoded'
                                    },
                                    body: new URLSearchParams({
                                        sale_id: saleId,
                                        status: 'processing_label'
                                    })
                                });

                                Swal.fire({
                                    title: 'Sucesso!',
                                    html: `Etiqueta adicionada à fila de processamento!<br><br><small class="text-muted">O worker processará em breve.</small>`,
                                    icon: 'success',
                                    timer: 3000,
                                    showConfirmButton: false
                                }).then(() => {
                                    location.reload();
                                });
                            } else {
                                // Verificar se é erro de buffering
                                if (data.error_code === 'BUFFERED' || data.error_code === 'BUFFERED_WAITING') {
                                    const dataLiberacao = data.buffering_date || 'em breve';
                                    Swal.fire({
                                        title: '⏱️ Etiqueta em Buffering',
                                        html: `
                                            <div class="text-start">
                                                <p><strong>O Mercado Livre ainda não liberou esta etiqueta.</strong></p>
                                                <hr>
                                                <p><i class="ti ti-calendar me-2"></i><strong>Previsão de Liberação:</strong> ${dataLiberacao}</p>
                                                <hr>
                                                <p class="text-muted small">
                                                    <i class="ti ti-info-circle me-2"></i>
                                                    O sistema tentará reprocessar automaticamente quando disponível.
                                                </p>
                                            </div>
                                        `,
                                        icon: 'info',
                                        confirmButtonText: 'Entendi',
                                        confirmButtonColor: '#0d6efd'
                                    }).then(() => {
                                        if (data.reload) {
                                            location.reload();
                                        }
                                    });
                                } else {
                                    Swal.fire('Erro', data.message || 'Erro ao criar job de etiqueta.', 'error');
                                }
                            }
                        })
                        .catch(error => {
                            console.error('Erro:', error);
                            Swal.fire('Erro', 'Erro de conexão ao criar job.', 'error');
                        })
                        .finally(() => {
                            el.innerHTML = originalText;
                            el.style.pointerEvents = 'auto';
                        });
                }
            });
        }

        function comprarEtiqueta(saleId, integracao, saleTitle, fornecedor, el) {
            if (!saleId || !saleTitle || !fornecedor) return;

            // Verificar se é um ecommerce válido
            if (!ecommerces.includes(integracao)) {
                Swal.fire({
                    title: 'Compra Não Disponível',
                    text: 'A compra de etiquetas está disponível apenas para vendas de ecommerce.',
                    icon: 'warning',
                    confirmButtonText: 'Entendi'
                });
                return;
            }

            // Fechar menu mobile se estiver aberto
            closeMobileMenu();

            // Limpar dados anteriores do modal
            limparDadosModalEtiqueta();

            // Preencher dados básicos no modal
            document.getElementById('etq_sale_id').value = saleId;
            document.getElementById('etq_sale_title').value = saleTitle;
            document.getElementById('etq_integracao').value = integracao;
            document.getElementById('etq_fornecedor').value = fornecedor;

            // Buscar whitelabel do contexto
            const whitelabel = el.closest('.venda-item')?.getAttribute('data-whitelabel') ||
                window.userConfig?.whitelabel ||
                '<?= $_SESSION["usuario"]["whitelabel"] ?? "" ?>' ||
                'homolog'; // fallback padrão

            // Debug do whitelabel
            console.log('Whitelabel encontrado:', whitelabel);
            document.getElementById('etq_whitelabel').value = whitelabel;

            // Abrir o modal
            const modalElement = document.getElementById('modalComprarEtiqueta');
            const modal = new bootstrap.Modal(modalElement);

            // Verificar se a estrutura do modal está correta
            console.log('Modal element:', modalElement);
            console.log('Modal footer:', modalElement.querySelector('.modal-footer'));
            console.log('Buttons in footer:', modalElement.querySelectorAll('.modal-footer button'));

            modal.show();

            // Aguardar o modal abrir completamente e verificar novamente
            modalElement.addEventListener('shown.bs.modal', function() {
                console.log('Modal aberto - verificando estrutura...');
                const footer = modalElement.querySelector('.modal-footer');
                const buttons = footer?.querySelectorAll('button');
                console.log('Footer após abertura:', footer);
                console.log('Botões após abertura:', buttons);
            });

            // Carregar dados automaticamente após abrir o modal
            setTimeout(() => {
                carregarDadosVenda();
            }, 500);
        }

        // Função para limpar todos os campos do modal
        function limparDadosModalEtiqueta() {
            const campos = [
                'etq_sale_id', 'etq_sale_title', 'etq_integracao', 'etq_fornecedor', 'etq_whitelabel',
                'etq_produto_nome', 'etq_produto_quantidade', 'etq_produto_peso_total', 'etq_produto_valor',
                'etq_produto_altura', 'etq_produto_largura', 'etq_produto_comprimento', 'etq_produto_marca', 'etq_produto_modelo',
                'etq_dest_nome', 'etq_dest_documento', 'etq_dest_telefone', 'etq_dest_email',
                'etq_dest_cep', 'etq_dest_numero', 'etq_dest_endereco', 'etq_dest_complemento',
                'etq_dest_bairro', 'etq_dest_cidade', 'etq_dest_estado',
                'etq_rem_nome', 'etq_rem_documento', 'etq_rem_endereco', 'etq_rem_numero',
                'etq_rem_complemento', 'etq_rem_bairro', 'etq_rem_cep', 'etq_rem_cidade', 'etq_rem_estado', 'etq_rem_telefone', 'etq_rem_email'
            ];

            campos.forEach(campo => {
                const elemento = document.getElementById(campo);
                if (elemento) elemento.value = '';
            });

            // Limpar lista de produtos
            document.getElementById('etq_produtos_container').innerHTML = '';

            // Esconder loading e botão próxima etapa
            document.getElementById('etq_loading').classList.add('d-none');
            document.getElementById('btnProximaEtapa').classList.add('d-none');

            // Mostrar status inicial
            document.getElementById('etq_status').classList.remove('d-none');
        }

        // Event listeners para os botões do modal
        document.addEventListener('DOMContentLoaded', function() {
            const btnCarregar = document.getElementById('btnCarregarDados');
            if (btnCarregar) {
                btnCarregar.addEventListener('click', function() {
                    carregarDadosVenda();
                });
            }

            const btnProximaEtapa = document.getElementById('btnProximaEtapa');
            if (btnProximaEtapa) {
                btnProximaEtapa.addEventListener('click', function() {
                    const validacao = validarFormularioEtiqueta();

                    if (!validacao.valido) {
                        // Mostrar alerta com campos não preenchidos
                        const camposVaziosNomes = validacao.camposVazios.map(campo => {
                            const label = campo.closest('.col-md-6, .col-md-4, .col-md-3, .col-md-8, .col-md-12')?.querySelector('label')?.textContent || campo.id;
                            return label.replace('*', '').trim();
                        });

                        Swal.fire({
                            title: 'Campos Obrigatórios',
                            html: `<p>Por favor, preencha todos os campos obrigatórios:</p>
                                   <ul class="text-start">
                                       ${camposVaziosNomes.map(nome => `<li>${nome}</li>`).join('')}
                                   </ul>`,
                            icon: 'warning',
                            confirmButtonText: 'OK'
                        });

                        // Focar no primeiro campo vazio
                        if (validacao.camposVazios.length > 0) {
                            validacao.camposVazios[0].focus();
                        }

                        return;
                    }

                    // Se chegou aqui, todos os campos estão preenchidos
                    console.log('Todos os campos estão preenchidos! Prosseguindo para Etapa 2...');

                    // Mostrar seção da Envioecom
                    document.getElementById('secao_envioecom').classList.remove('d-none');

                    // Esconder botão próxima etapa e mostrar processo
                    btnProximaEtapa.style.display = 'none';

                    // Scroll suave até a seção da Envioecom
                    document.getElementById('secao_envioecom').scrollIntoView({
                        behavior: 'smooth'
                    });

                    // Iniciar processo da Envioecom
                    setTimeout(() => {
                        iniciarProcessoEnvioecom();
                    }, 500);

                    // Aqui você pode adicionar a lógica da Etapa 2
                    Swal.fire({
                        title: 'Dados Validados!',
                        text: 'Todos os campos foram preenchidos corretamente. Pronto para Etapa 2!',
                        icon: 'success',
                        confirmButtonText: 'OK'
                    });
                });
            }
        });

        // Função para carregar dados completos da venda
        function carregarDadosVenda() {
            const saleId = document.getElementById('etq_sale_id').value;
            const fornecedor = document.getElementById('etq_fornecedor').value;
            const whitelabel = document.getElementById('etq_whitelabel').value;

            if (!saleId || !fornecedor) {
                document.getElementById('etq_status').innerHTML =
                    '<i class="ti ti-alert-circle me-2"></i>Dados básicos não encontrados.';
                document.getElementById('etq_status').className = 'alert alert-danger';
                return;
            }

            // Mostrar loading
            document.getElementById('etq_loading').classList.remove('d-none');
            document.getElementById('etq_status').classList.add('d-none');

            // Fazer requisição para buscar dados reais
            console.log('Fazendo requisição para:', '../assets/ajax/vendas/buscar_dados_venda.php');
            console.log('Dados enviados:', {
                saleId,
                fornecedor,
                whitelabel
            });

            fetch('../assets/ajax/vendas/buscar_dados_venda.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        saleId: saleId,
                        fornecedor: fornecedor,
                        whitelabel: whitelabel
                    })
                })
                .then(response => {
                    console.log('Response status:', response.status);
                    console.log('Response headers:', response.headers);
                    if (!response.ok) {
                        throw new Error(`HTTP ${response.status}: ${response.statusText}`);
                    }
                    return response.json();
                })
                .then(data => {
                    // Esconder loading
                    document.getElementById('etq_loading').classList.add('d-none');

                    if (data.success) {
                        // Debug info
                        if (data.debug) {
                            console.log('Debug info:', data.debug);
                        }

                        // Atualizar whitelabel se veio da API
                        if (data.data.venda.whitelabel) {
                            document.getElementById('etq_whitelabel').value = data.data.venda.whitelabel;
                        }

                        // Preencher dados nos campos
                        preencherDadosVenda(data.data);

                        // Mostrar status de sucesso
                        document.getElementById('etq_status').innerHTML =
                            '<i class="ti ti-check-circle me-2"></i>Dados carregados com sucesso! Revise as informações antes de prosseguir.';
                        document.getElementById('etq_status').className = 'alert alert-success';
                        document.getElementById('etq_status').classList.remove('d-none');

                        // Mostrar botão próxima etapa
                        document.getElementById('btnProximaEtapa').classList.remove('d-none');
                    } else {
                        // Mostrar erro
                        document.getElementById('etq_status').innerHTML =
                            '<i class="ti ti-alert-circle me-2"></i>Erro ao carregar dados: ' + (data.message || 'Erro desconhecido');
                        document.getElementById('etq_status').className = 'alert alert-danger';
                        document.getElementById('etq_status').classList.remove('d-none');
                    }
                })
                .catch(error => {
                    console.error('Erro completo na requisição:', error);
                    console.error('Tipo do erro:', typeof error);
                    console.error('Stack trace:', error.stack);

                    // Esconder loading
                    document.getElementById('etq_loading').classList.add('d-none');

                    // Mostrar erro detalhado
                    document.getElementById('etq_status').innerHTML =
                        '<i class="ti ti-alert-circle me-2"></i>Erro de conexão: ' + error.message + '<br><small>Verifique o console para mais detalhes.</small>';
                    document.getElementById('etq_status').className = 'alert alert-danger';
                    document.getElementById('etq_status').classList.remove('d-none');
                });
        }

        // Função para preencher os dados nos campos do modal
        function preencherDadosVenda(dados) {
            console.log('Preenchendo dados da venda:', dados);

            // 🔍 Verificar se etiqueta está em buffering
            if (dados.buffering === true || (dados.venda && dados.venda.etiqueta_ml === 'buffering')) {
                // Mostrar alerta de buffering
                Swal.fire({
                    title: '⏱️ Etiqueta em Buffering',
                    html: `
                        <div class="text-start">
                            <p><strong>Esta etiqueta está aguardando liberação do Mercado Livre.</strong></p>
                            <p class="mb-2">Enquanto a etiqueta não for liberada:</p>
                            <ul>
                                <li>❌ Não é possível visualizar a etiqueta</li>
                                <li>❌ Não é possível remover a etiqueta</li>
                                <li>❌ Não é possível reprocessar</li>
                            </ul>
                            <div class="alert alert-info mt-3">
                                <i class="ti ti-info-circle me-2"></i>
                                A etiqueta será liberada automaticamente pelo Mercado Livre em breve.
                            </div>
                        </div>
                    `,
                    icon: 'warning',
                    confirmButtonText: 'Entendi',
                    customClass: {
                        htmlContainer: 'text-start'
                    }
                });

                // Não carregar os dados do modal, pois não tem etiqueta disponível ainda
                return;
            }

            // Lista de todos os produtos da venda
            if (dados.produtos_lista && dados.produtos_lista.length > 0) {
                console.log('Produtos encontrados:', dados.produtos_lista.length, dados.produtos_lista);
                preencherProdutosIndividuais(dados.produtos_lista);
            } else {
                console.log('Nenhum produto encontrado ou dados.produtos_lista vazio');
            }

            // Função auxiliar para definir valor do campo de forma segura
            function setFieldValue(id, value) {
                const element = document.getElementById(id);
                if (element) {
                    element.value = value || '';
                } else {
                    console.warn(`Elemento com ID '${id}' não encontrado`);
                }
            }

            // Dados do destinatário - sempre preencher e permitir edição
            setFieldValue('etq_dest_nome', dados.destinatario.nome);
            setFieldValue('etq_dest_documento', dados.destinatario.documento);
            setFieldValue('etq_dest_telefone', dados.destinatario.telefone);
            setFieldValue('etq_dest_email', dados.destinatario.email);
            setFieldValue('etq_dest_cep', dados.destinatario.cep);
            setFieldValue('etq_dest_numero', dados.destinatario.numero);
            setFieldValue('etq_dest_endereco', dados.destinatario.endereco);
            setFieldValue('etq_dest_complemento', dados.destinatario.complemento);
            setFieldValue('etq_dest_bairro', dados.destinatario.bairro);
            setFieldValue('etq_dest_cidade', dados.destinatario.cidade);
            setFieldValue('etq_dest_estado', dados.destinatario.estado);

            // Dados do remetente - dados pessoais do usuário + endereço do fornecedor
            setFieldValue('etq_rem_nome', dados.remetente.usuario_nome || 'Não informado');
            setFieldValue('etq_rem_documento', dados.remetente.usuario_documento || 'Não informado');
            setFieldValue('etq_rem_telefone', dados.remetente.usuario_telefone || 'Não informado');
            setFieldValue('etq_rem_email', dados.remetente.usuario_email || 'Não informado');

            // Endereço do fornecedor
            setFieldValue('etq_rem_endereco', dados.remetente.fornecedor_endereco || 'Não informado');
            setFieldValue('etq_rem_numero', dados.remetente.fornecedor_numero || 'S/N');
            setFieldValue('etq_rem_complemento', dados.remetente.fornecedor_complemento || '');
            setFieldValue('etq_rem_bairro', dados.remetente.fornecedor_bairro || 'Não informado');
            setFieldValue('etq_rem_cep', dados.remetente.fornecedor_cep || 'Não informado');
            setFieldValue('etq_rem_cidade', dados.remetente.fornecedor_cidade || 'Não informado');
            setFieldValue('etq_rem_estado', dados.remetente.fornecedor_estado || 'Não informado');

            // Sempre permitir edição dos dados do destinatário
            habilitarEdicaoDestinatario(true);

            // Adicionar event listeners para validação em tempo real
            adicionarListenersValidacao();

            // Validação inicial
            setTimeout(() => {
                atualizarStatusBotaoProximaEtapa();
            }, 500);
        }

        // Função para habilitar edição dos campos do destinatário
        function habilitarEdicaoDestinatario(habilitar) {
            const camposDestinatario = [
                'etq_dest_nome', 'etq_dest_documento', 'etq_dest_telefone', 'etq_dest_email',
                'etq_dest_cep', 'etq_dest_numero', 'etq_dest_endereco', 'etq_dest_complemento',
                'etq_dest_bairro', 'etq_dest_cidade', 'etq_dest_estado'
            ];

            camposDestinatario.forEach(campoId => {
                const campo = document.getElementById(campoId);
                if (campo) {
                    campo.readOnly = false; // Sempre editável
                    campo.classList.remove('form-control-plaintext');
                    campo.classList.add('form-control');
                    campo.placeholder = 'Digite aqui...';
                }
            });
        }

        // Função para preencher produtos individuais como inputs separados
        function preencherProdutosIndividuais(produtos) {
            const container = document.getElementById('etq_produtos_container');
            container.innerHTML = '';

            produtos.forEach((produto, index) => {
                const produtoDiv = document.createElement('div');
                produtoDiv.className = 'card border-0 shadow-sm mb-3';
                produtoDiv.innerHTML = `
                
                    <!-- Header do Produto com Accordion -->
                    <div class="card-header bg-primary text-white border-0" id="produto-heading-${index}">
                        <button class="btn w-100 text-start text-white p-0 d-flex align-items-center justify-content-between" 
                                type="button" 
                                data-bs-toggle="collapse" 
                                data-bs-target="#produto-collapse-${index}" 
                                aria-expanded="true" 
                                aria-controls="produto-collapse-${index}">
                            <span class="d-flex align-items-center">
                                <i class="ti ti-package fs-5 me-2"></i>
                                <span class="fw-semibold">Produto ${index + 1}</span>
                            </span>
                            <span class="badge bg-light text-primary rounded-pill px-3">
                                ${produto.quantidade || 1}x
                            </span>
                        </button>
                    </div>

                    <!-- Conteúdo do Produto (Accordion) -->
                    <div id="produto-collapse-${index}" class="collapse show" aria-labelledby="produto-heading-${index}">
                        <div class="card-body p-3">
                            
                            <!-- 📦 Informações Básicas -->
                            <div class="mb-3">
                                <h6 class="text-muted mb-2 d-flex align-items-center">
                                    <i class="ti ti-info-circle me-2"></i>
                                    <span>Informações Básicas</span>
                                </h6>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <label class="form-label small mb-1">
                                            Nome do Produto <span class="text-danger">*</span>
                                        </label>
                                        <input type="text" 
                                               class="form-control form-control-sm" 
                                               id="etq_prod_${index}_nome" 
                                               value="${produto.titulo || produto.product_title || 'Produto ' + (index + 1)}" 
                                               required
                                               placeholder="Digite o nome do produto">
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label small mb-1">SKU / Código</label>
                                        <input type="text" 
                                               class="form-control form-control-sm" 
                                               id="etq_prod_${index}_sku" 
                                               value="${produto.sku || 'Não informado'}"
                                               placeholder="Ex: PRD-001">
                                    </div>
                                </div>
                            </div>

                            <!-- 💰 Quantidade e Valor -->
                            <div class="mb-3">
                                <h6 class="text-muted mb-2 d-flex align-items-center">
                                    <i class="ti ti-currency-dollar me-2"></i>
                                    <span>Quantidade e Valor</span>
                                </h6>
                                <div class="row g-2">
                                    <div class="col-6">
                                        <label class="form-label small mb-1">
                                            Quantidade <span class="text-danger">*</span>
                                        </label>
                                        <div class="input-group input-group-sm">
                                            <span class="input-group-text">
                                                <i class="ti ti-package"></i>
                                            </span>
                                            <input type="number" 
                                                   min="1" 
                                                   class="form-control" 
                                                   id="etq_prod_${index}_quantidade" 
                                                   value="${produto.quantidade || '1'}" 
                                                   required>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label small mb-1">
                                            Valor Unit. <span class="text-danger">*</span>
                                        </label>
                                        <div class="input-group input-group-sm">
                                            <span class="input-group-text">R$</span>
                                            <input type="number" 
                                                   step="0.01" 
                                                   min="0" 
                                                   class="form-control" 
                                                   id="etq_prod_${index}_valor" 
                                                   value="${produto.valor || '0'}" 
                                                   required>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- ⚖️ Peso -->
                            <div class="mb-3">
                                <h6 class="text-muted mb-2 d-flex align-items-center">
                                    <i class="ti ti-weight me-2"></i>
                                    <span>Peso do Produto</span>
                                </h6>
                                <div class="row g-2">
                                    <div class="col-6">
                                        <label class="form-label small mb-1">Peso Unitário</label>
                                        <div class="input-group input-group-sm">
                                            <input type="number" 
                                                   step="0.001" 
                                                   min="0" 
                                                   class="form-control" 
                                                   id="etq_prod_${index}_peso" 
                                                   value="${produto.peso || '0'}"
                                                   placeholder="0.000">
                                            <span class="input-group-text">kg</span>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label small mb-1">Peso Total</label>
                                        <div class="input-group input-group-sm">
                                            <input type="number" 
                                                   step="0.001" 
                                                   class="form-control bg-light" 
                                                   id="etq_prod_${index}_peso_total" 
                                                   value="${(parseFloat(produto.peso || 0) * parseInt(produto.quantidade || 1)).toFixed(3)}" 
                                                   readonly>
                                            <span class="input-group-text">kg</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- 📏 Dimensões -->
                            <div class="mb-3">
                                <h6 class="text-muted mb-2 d-flex align-items-center">
                                    <i class="ti ti-ruler me-2"></i>
                                    <span>Dimensões da Embalagem</span>
                                </h6>
                                <div class="row g-2">
                                    <div class="col-4">
                                        <label class="form-label small mb-1">
                                            Altura <span class="text-danger">*</span>
                                        </label>
                                        <div class="input-group input-group-sm">
                                            <input type="number" 
                                                   step="0.1" 
                                                   min="0" 
                                                   class="form-control" 
                                                   id="etq_prod_${index}_altura" 
                                                   value="${produto.altura || '0'}" 
                                                   required
                                                   placeholder="0">
                                            <span class="input-group-text">cm</span>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <label class="form-label small mb-1">
                                            Largura <span class="text-danger">*</span>
                                        </label>
                                        <div class="input-group input-group-sm">
                                            <input type="number" 
                                                   step="0.1" 
                                                   min="0" 
                                                   class="form-control" 
                                                   id="etq_prod_${index}_largura" 
                                                   value="${produto.largura || '0'}" 
                                                   required
                                                   placeholder="0">
                                            <span class="input-group-text">cm</span>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <label class="form-label small mb-1">
                                            Comp. <span class="text-danger">*</span>
                                        </label>
                                        <div class="input-group input-group-sm">
                                            <input type="number" 
                                                   step="0.1" 
                                                   min="0" 
                                                   class="form-control" 
                                                   id="etq_prod_${index}_comprimento" 
                                                   value="${produto.comprimento || '0'}" 
                                                   required
                                                   placeholder="0">
                                            <span class="input-group-text">cm</span>
                                        </div>
                                    </div>
                                </div>
                                <small class="text-muted d-block mt-1">
                                    <i class="ti ti-info-circle"></i> Dimensões da embalagem do produto
                                </small>
                            </div>

                            <!-- 🏷️ Marca e Modelo (Opcional - Colapsável) -->
                            <div class="accordion accordion-flush" id="accordion-extra-${index}">
                                <div class="accordion-item border-0">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed p-2 bg-light" 
                                                type="button" 
                                                data-bs-toggle="collapse" 
                                                data-bs-target="#collapse-extra-${index}" 
                                                aria-expanded="false">
                                            <i class="ti ti-tag me-2"></i>
                                            <small>Informações Adicionais (opcional)</small>
                                        </button>
                                    </h2>
                                    <div id="collapse-extra-${index}" 
                                         class="accordion-collapse collapse" 
                                         data-bs-parent="#accordion-extra-${index}">
                                        <div class="accordion-body p-2 pt-3">
                                            <div class="row g-2">
                                                <div class="col-6">
                                                    <label class="form-label small mb-1">Marca</label>
                                                    <input type="text" 
                                                           class="form-control form-control-sm" 
                                                           id="etq_prod_${index}_marca" 
                                                           value="${produto.marca || 'Não informado'}"
                                                           placeholder="Ex: Nike">
                                                </div>
                                                <div class="col-6">
                                                    <label class="form-label small mb-1">Modelo</label>
                                                    <input type="text" 
                                                           class="form-control form-control-sm" 
                                                           id="etq_prod_${index}_modelo" 
                                                           value="${produto.modelo || 'Não informado'}"
                                                           placeholder="Ex: Air Max">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                `;
                container.appendChild(produtoDiv);

                // Adicionar listener para o campo de peso para calcular peso total automaticamente
                const campoPeso = produtoDiv.querySelector(`#etq_prod_${index}_peso`);
                const campoQuantidade = produtoDiv.querySelector(`#etq_prod_${index}_quantidade`);
                const campoPesoTotal = produtoDiv.querySelector(`#etq_prod_${index}_peso_total`);

                function calcularPesoTotal() {
                    const peso = parseFloat(campoPeso.value) || 0;
                    const quantidade = parseInt(campoQuantidade.value) || 1;
                    campoPesoTotal.value = (peso * quantidade).toFixed(3);
                }

                campoPeso.addEventListener('input', calcularPesoTotal);
                campoQuantidade.addEventListener('input', calcularPesoTotal);
            });

            // Adicionar listeners de validação aos novos campos
            setTimeout(() => {
                adicionarListenersValidacao();
                atualizarStatusBotaoProximaEtapa();
            }, 100);
        }

        // Função auxiliar para formatar valores monetários
        function formatarMoeda(valor) {
            if (!valor) return 'R$ 0,00';

            // Se já está formatado, retornar como está
            if (typeof valor === 'string' && valor.includes('R$')) {
                return valor;
            }

            // Converter para número e formatar
            const numero = parseFloat(valor);
            if (isNaN(numero)) return 'R$ 0,00';

            return new Intl.NumberFormat('pt-BR', {
                style: 'currency',
                currency: 'BRL'
            }).format(numero);
        }

        // Função para validar todos os campos obrigatórios
        function validarFormularioEtiqueta() {
            const form = document.getElementById('formComprarEtiqueta');
            const camposObrigatorios = form.querySelectorAll('input[required]');
            let camposVazios = [];

            camposObrigatorios.forEach(campo => {
                if (!campo.value.trim()) {
                    camposVazios.push(campo);
                    campo.classList.add('is-invalid');
                } else {
                    campo.classList.remove('is-invalid');
                }
            });

            return {
                valido: camposVazios.length === 0,
                camposVazios: camposVazios,
                totalCampos: camposObrigatorios.length,
                camposPreenchidos: camposObrigatorios.length - camposVazios.length
            };
        }

        // Função para atualizar o status do botão "Próxima Etapa"
        function atualizarStatusBotaoProximaEtapa() {
            const btnProximaEtapa = document.getElementById('btnProximaEtapa');
            const validacao = validarFormularioEtiqueta();

            if (validacao.valido) {
                btnProximaEtapa.classList.remove('btn-secondary');
                btnProximaEtapa.classList.add('btn-success');
                btnProximaEtapa.disabled = false;
                btnProximaEtapa.innerHTML = '<i class="ti ti-arrow-right me-1"></i>Próxima Etapa - Etapa 2';
            } else {
                btnProximaEtapa.classList.remove('btn-success');
                btnProximaEtapa.classList.add('btn-secondary');
                btnProximaEtapa.disabled = true;
                btnProximaEtapa.innerHTML = `<i class="ti ti-alert-circle me-1"></i>Preencha todos os campos (${validacao.camposPreenchidos}/${validacao.totalCampos})`;
            }
        }

        // Função para adicionar listeners de validação nos campos
        function adicionarListenersValidacao() {
            const form = document.getElementById('formComprarEtiqueta');
            const camposObrigatorios = form.querySelectorAll('input[required]');

            camposObrigatorios.forEach(campo => {
                // Remover listeners anteriores para evitar duplicação
                campo.removeEventListener('input', atualizarStatusBotaoProximaEtapa);
                campo.removeEventListener('change', atualizarStatusBotaoProximaEtapa);
                campo.removeEventListener('blur', atualizarStatusBotaoProximaEtapa);

                // Adicionar novos listeners
                campo.addEventListener('input', atualizarStatusBotaoProximaEtapa);
                campo.addEventListener('change', atualizarStatusBotaoProximaEtapa);
                campo.addEventListener('blur', atualizarStatusBotaoProximaEtapa);
            });

            console.log(`Listeners de validação adicionados a ${camposObrigatorios.length} campos obrigatórios`);

            // Adicionar listener para busca automática de CEP
            const campoCep = document.getElementById('etq_dest_cep');
            if (campoCep) {
                // Máscara de CEP
                campoCep.addEventListener('input', function() {
                    let valor = this.value.replace(/\D/g, '');
                    if (valor.length <= 8) {
                        valor = valor.replace(/(\d{5})(\d{1,3})/, '$1-$2');
                        this.value = valor;
                    }
                });

                campoCep.addEventListener('blur', function() {
                    const cep = this.value.replace(/\D/g, '');
                    if (cep.length === 8) {
                        buscarEnderecoPorCEP(cep);
                    }
                });
            }

            // Adicionar máscara para telefone
            const campoTelefone = document.getElementById('etq_dest_telefone');
            if (campoTelefone) {
                campoTelefone.addEventListener('input', function() {
                    let valor = this.value.replace(/\D/g, '');
                    if (valor.length <= 11) {
                        if (valor.length <= 10) {
                            valor = valor.replace(/(\d{2})(\d{4})(\d{1,4})/, '($1) $2-$3');
                        } else {
                            valor = valor.replace(/(\d{2})(\d{5})(\d{1,4})/, '($1) $2-$3');
                        }
                        this.value = valor;
                    }
                });
            }
        }

        // Função para buscar endereço por CEP
        async function buscarEnderecoPorCEP(cep) {
            try {
                const response = await fetch(`https://viacep.com.br/ws/${cep}/json/`);
                const data = await response.json();

                if (!data.erro) {
                    // Preencher campos automaticamente
                    document.getElementById('etq_dest_endereco').value = data.logradouro || '';
                    document.getElementById('etq_dest_bairro').value = data.bairro || '';
                    document.getElementById('etq_dest_cidade').value = data.localidade || '';
                    document.getElementById('etq_dest_estado').value = data.uf || '';

                    // Focar no campo número
                    document.getElementById('etq_dest_numero').focus();

                    // Atualizar validação
                    setTimeout(atualizarStatusBotaoProximaEtapa, 100);

                    console.log('Endereço preenchido automaticamente via CEP:', cep);
                } else {
                    console.warn('CEP não encontrado:', cep);
                }
            } catch (error) {
                console.error('Erro ao buscar CEP:', error);
            }
        }
    </script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.14.305/pdf.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css">
    <script>
        document.querySelectorAll('.uploadEtiquetaForm').forEach(function(form) {
            const saleId = form.getAttribute('data-saleid');
            const pdfInput = form.querySelector(`#pdfInput`);
            const pdfCanvas = form.querySelector(`#pdfCanvas`);
            const cropContainer = form.querySelector(`#cropContainer`);
            const cropButton = form.querySelector(`#cropButton`);

            let cropper; // Variável para armazenar a instância do Cropper.js

            pdfInput.addEventListener('change', function(event) {
                const file = event.target.files[0];
                if (file && file.type === 'application/pdf') {
                    // Limpa o canvas e destrói o Cropper.js antes de carregar o novo documento
                    const context = pdfCanvas.getContext('2d');
                    context.clearRect(0, 0, pdfCanvas.width, pdfCanvas.height);
                    if (cropper) {
                        cropper.destroy();
                        cropper = null;
                    }

                    const fileReader = new FileReader();
                    fileReader.onload = function() {
                        const pdfData = new Uint8Array(this.result);
                        pdfjsLib.getDocument({
                            data: pdfData
                        }).promise.then(function(pdf) {
                            pdf.getPage(1).then(function(page) {
                                // Renderiza em alta resolução diretamente no canvas (sem transform) para manter mapeamento 1:1 do crop
                                const baseViewport = page.getViewport({
                                    scale: 1
                                });
                                const maxW = 2000,
                                    maxH = 3000;
                                const computedScale = Math.min(maxW / baseViewport.width, maxH / baseViewport.height, 6);
                                const viewport = page.getViewport({
                                    scale: computedScale
                                });
                                const context = pdfCanvas.getContext('2d');

                                pdfCanvas.width = Math.floor(viewport.width);
                                pdfCanvas.height = Math.floor(viewport.height);

                                // Fundo branco
                                context.fillStyle = 'white';
                                context.fillRect(0, 0, pdfCanvas.width, pdfCanvas.height);

                                page.render({
                                    canvasContext: context,
                                    viewport: viewport
                                }).promise.then(function() {
                                    cropContainer.style.display = 'block';
                                    cropper = new Cropper(pdfCanvas, {
                                        // Proporção fixa 10x15 (2:3) para impressão térmica 10x15 cm
                                        aspectRatio: 2 / 3,
                                        viewMode: 1,
                                        background: false,
                                        autoCrop: true,
                                        autoCropArea: 0.98, // ocupa quase toda a área disponível
                                        dragMode: 'move',
                                        responsive: true,
                                        restore: false,
                                        movable: true,
                                        cropBoxMovable: true,
                                        cropBoxResizable: true,
                                        ready() {
                                            // Define recorte inicial grande respeitando a razão 2:3 e limites do canvas
                                            const pad = 8;
                                            const maxW = pdfCanvas.width - pad * 2;
                                            const maxH = pdfCanvas.height - pad * 2;
                                            let initW = maxW;
                                            let initH = Math.round(initW * 3 / 2); // 2:3 => h = w * 1.5
                                            if (initH > maxH) {
                                                initH = maxH;
                                                initW = Math.round(initH * 2 / 3);
                                            }
                                            const left = Math.round((pdfCanvas.width - initW) / 2);
                                            const top = Math.round((pdfCanvas.height - initH) / 2);
                                            this.setCropBoxData({
                                                left,
                                                top,
                                                width: initW,
                                                height: initH
                                            });
                                        }
                                    });

                                    cropButton.style.display = 'inline-block';
                                    cropButton.onclick = function() {
                                        // Exporta em 300 DPI (aprox. 1181x1772 px para 10x15cm)
                                        const croppedCanvas = cropper.getCroppedCanvas({
                                            width: 1181,
                                            height: 1772,
                                            imageSmoothingEnabled: true,
                                            imageSmoothingQuality: 'high',
                                            fillColor: 'white'
                                        });

                                        croppedCanvas.toBlob(function(
                                                blob) {
                                                const formData =
                                                    new FormData();
                                                formData.append(
                                                    'croppedImage',
                                                    blob,
                                                    `e_${saleId}.jpg`
                                                );
                                                formData.append(
                                                    'sale_id',
                                                    saleId);

                                                fetch('../../assets/ajax/etiquetas/upload_etiqueta_crop.php', {
                                                        method: 'POST',
                                                        body: formData
                                                    })
                                                    .then(response =>
                                                        response.json())
                                                    .then(data => {
                                                        if (data.success) {
                                                            // Sucesso: apenas fecha o modal e atualiza a lista, sem abrir nova aba
                                                            Swal.fire('Sucesso!', 'Etiqueta salva com alta qualidade.', 'success')
                                                                .then(() => {
                                                                    const modalEl = form.closest('.modal');
                                                                    const bsModal = bootstrap.Modal.getInstance(modalEl) || new bootstrap.Modal(modalEl);
                                                                    bsModal.hide();
                                                                    location.reload();
                                                                });
                                                        } else {
                                                            Swal.fire(
                                                                'Erro!',
                                                                data
                                                                .message,
                                                                'error'
                                                            );
                                                        }
                                                    })
                                                    .catch(error => {
                                                        console
                                                            .error(
                                                                'Erro ao enviar a imagem recortada:',
                                                                error
                                                            );
                                                        Swal.fire(
                                                            'Erro!',
                                                            'Erro ao enviar a imagem recortada.',
                                                            'error'
                                                        );
                                                    });
                                            }, 'image/jpeg',
                                            0.95); // Saída JPEG de alta qualidade
                                    };
                                });
                            });
                        });
                    };
                    fileReader.readAsArrayBuffer(file);
                } else {
                    alert('Por favor, selecione um arquivo PDF válido.');
                }
            });

            // Limpa o canvas e o estado do Cropper.js ao fechar o modal
            form.closest('.modal').addEventListener('hidden.bs.modal', function() {
                const context = pdfCanvas.getContext('2d');
                context.clearRect(0, 0, pdfCanvas.width, pdfCanvas.height);
                cropContainer.style.display = 'none';
                cropButton.style.display = 'none';
                if (cropper) {
                    cropper.destroy();
                    cropper = null;
                }
            });
        });
    </script>

    <script>
        // Garante que o modal de upload seja anexado ao body para centralização padrão do Bootstrap
        document.querySelectorAll('.uploadEtiquetaModal').forEach(function(modalEl) {
            modalEl.addEventListener('show.bs.modal', function() {
                document.body.appendChild(modalEl);
            });
        });
    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css">
    <script>
        document.querySelectorAll('.uploadEtiquetaForm').forEach(function(form) {
            const saleId = form.getAttribute('data-saleid');
            const pdfInput = form.querySelector(`#pdfInput`);
            const pdfCanvas = form.querySelector(`#pdfCanvas`);
            const cropContainer = form.querySelector(`#cropContainer`);
            const cropButton = form.querySelector(`#cropButton`);

            let cropper; // Variável para armazenar a instância do Cropper.js

            pdfInput.addEventListener('change', function(event) {
                const file = event.target.files[0];
                if (file && file.type === 'application/pdf') {
                    // Limpa o canvas e destrói o Cropper.js antes de carregar o novo documento
                    const context = pdfCanvas.getContext('2d');
                    context.clearRect(0, 0, pdfCanvas.width, pdfCanvas.height);
                    if (cropper) {
                        cropper.destroy();
                        cropper = null;
                    }

                    const fileReader = new FileReader();
                    fileReader.onload = function() {
                        const pdfData = new Uint8Array(this.result);
                        pdfjsLib.getDocument({
                            data: pdfData
                        }).promise.then(function(pdf) {
                            pdf.getPage(1).then(function(page) {
                                // Renderiza em alta resolução diretamente no canvas (sem transform) para manter mapeamento 1:1 do crop
                                const baseViewport = page.getViewport({
                                    scale: 1
                                });
                                const maxW = 2000,
                                    maxH = 3000;
                                const computedScale = Math.min(maxW / baseViewport.width, maxH / baseViewport.height, 6);
                                const viewport = page.getViewport({
                                    scale: computedScale
                                });
                                const context = pdfCanvas.getContext('2d');

                                pdfCanvas.width = Math.floor(viewport.width);
                                pdfCanvas.height = Math.floor(viewport.height);

                                // Fundo branco
                                context.fillStyle = 'white';
                                context.fillRect(0, 0, pdfCanvas.width, pdfCanvas.height);

                                page.render({
                                    canvasContext: context,
                                    viewport: viewport
                                }).promise.then(function() {
                                    cropContainer.style.display = 'block';
                                    cropper = new Cropper(pdfCanvas, {
                                        // Proporção fixa 10x15 (2:3) para impressão térmica 10x15 cm
                                        aspectRatio: 2 / 3,
                                        viewMode: 1,
                                        background: false,
                                        autoCrop: true,
                                        autoCropArea: 0.98, // ocupa quase toda a área disponível
                                        dragMode: 'move',
                                        responsive: true,
                                        restore: false,
                                        movable: true,
                                        cropBoxMovable: true,
                                        cropBoxResizable: true,
                                        ready() {
                                            // Define recorte inicial grande respeitando a razão 2:3 e limites do canvas
                                            const pad = 8;
                                            const maxW = pdfCanvas.width - pad * 2;
                                            const maxH = pdfCanvas.height - pad * 2;
                                            let initW = maxW;
                                            let initH = Math.round(initW * 3 / 2); // 2:3 => h = w * 1.5
                                            if (initH > maxH) {
                                                initH = maxH;
                                                initW = Math.round(initH * 2 / 3);
                                            }
                                            const left = Math.round((pdfCanvas.width - initW) / 2);
                                            const top = Math.round((pdfCanvas.height - initH) / 2);
                                            this.setCropBoxData({
                                                left,
                                                top,
                                                width: initW,
                                                height: initH
                                            });
                                        }
                                    });

                                    cropButton.style.display = 'inline-block';
                                    cropButton.onclick = function() {
                                        // Exporta em 300 DPI (aprox. 1181x1772 px para 10x15cm)
                                        const croppedCanvas = cropper.getCroppedCanvas({
                                            width: 1181,
                                            height: 1772,
                                            imageSmoothingEnabled: true,
                                            imageSmoothingQuality: 'high',
                                            fillColor: 'white'
                                        });

                                        croppedCanvas.toBlob(function(
                                                blob) {
                                                const formData =
                                                    new FormData();
                                                formData.append(
                                                    'croppedImage',
                                                    blob,
                                                    `e_${saleId}.jpg`
                                                );
                                                formData.append(
                                                    'sale_id',
                                                    saleId);

                                                fetch('../../assets/ajax/etiquetas/upload_etiqueta_crop.php', {
                                                        method: 'POST',
                                                        body: formData
                                                    })
                                                    .then(response =>
                                                        response.json())
                                                    .then(data => {
                                                        if (data.success) {
                                                            toastAlert('Etiqueta salva com sucesso!', 'success', '2500').reload();
                                                        } else {
                                                            toastAlert('Erro ao salvar etiqueta.', 'error', '2500').reload();
                                                        }
                                                    })
                                                    .catch(error => {
                                                        console
                                                            .error(
                                                                'Erro ao enviar a imagem recortada:',
                                                                error
                                                            );
                                                        Swal.fire(
                                                            'Erro!',
                                                            'Erro ao enviar a imagem recortada.',
                                                            'error'
                                                        );
                                                    });
                                            }, 'image/jpeg',
                                            0.95); // Saída JPEG de alta qualidade
                                    };
                                });
                            });
                        });
                    };
                    fileReader.readAsArrayBuffer(file);
                } else {
                    alert('Por favor, selecione um arquivo PDF válido.');
                }
            });

            // Limpa o canvas e o estado do Cropper.js ao fechar o modal
            form.closest('.modal').addEventListener('hidden.bs.modal', function() {
                const context = pdfCanvas.getContext('2d');
                context.clearRect(0, 0, pdfCanvas.width, pdfCanvas.height);
                cropContainer.style.display = 'none';
                cropButton.style.display = 'none';
                if (cropper) {
                    cropper.destroy();
                    cropper = null;
                }
            });
        });
    </script>

    <script>
        // Garante que o modal de upload seja anexado ao body para centralização padrão do Bootstrap
        document.querySelectorAll('.uploadEtiquetaModal').forEach(function(modalEl) {
            modalEl.addEventListener('show.bs.modal', function() {
                document.body.appendChild(modalEl);
            });
        });
    </script>

    <script>
        if (window.location.search.includes('replaceHistory=1')) {
            history.replaceState({}, '', '/etiqueta');
        }

        // Funcionalidade de seleção múltipla para pagamento em lote
        document.addEventListener('DOMContentLoaded', function() {
            const checkboxes = document.querySelectorAll('.venda-checkbox');
            const selectAllBtn = document.getElementById('selectAllBtn');
            const clearSelectionBtn = document.getElementById('clearSelectionBtn');
            const batchPaymentContainer = document.getElementById('batchPaymentContainer');
            const selectedCount = document.getElementById('selectedCount');
            const totalValue = document.getElementById('totalValue');
            const batchPaymentBtn = document.getElementById('batchPaymentBtn');

            let selectedSales = [];
            let currentFornecedor = null;

            function formatCurrency(value) {
                return new Intl.NumberFormat('pt-BR', {
                    style: 'currency',
                    currency: 'BRL'
                }).format(value);
            }

            function updateBatchInfo() {
                if (selectedSales.length > 0) {
                    batchPaymentContainer.style.display = 'block';
                    selectedCount.textContent = `${selectedSales.length} venda${selectedSales.length > 1 ? 's' : ''} selecionada${selectedSales.length > 1 ? 's' : ''}`;

                    const total = selectedSales.reduce((sum, sale) => sum + parseFloat(sale.valor), 0);
                    totalValue.textContent = `Total: ${formatCurrency(total)}`;
                } else {
                    batchPaymentContainer.style.display = 'none';
                    currentFornecedor = null;
                }
            }

            function toggleSale(checkbox) {
                const saleId = checkbox.dataset.saleId;
                const fornecedor = checkbox.dataset.fornecedor;
                const valor = checkbox.dataset.valor;
                const saleTitle = checkbox.dataset.saleTitle;

                if (checkbox.checked) {
                    // Verifica se é o primeiro item ou se é do mesmo fornecedor
                    if (currentFornecedor === null) {
                        currentFornecedor = fornecedor;
                    } else if (currentFornecedor !== fornecedor) {
                        checkbox.checked = false;
                        Swal.fire({
                            title: 'Atenção!',
                            text: 'Você só pode selecionar vendas do mesmo fornecedor para pagamento em lote.',
                            icon: 'warning',
                            confirmButtonText: 'OK'
                        });
                        return;
                    }

                    selectedSales.push({
                        saleId,
                        fornecedor,
                        valor,
                        saleTitle
                    });
                } else {
                    selectedSales = selectedSales.filter(sale => sale.saleId !== saleId);
                    if (selectedSales.length === 0) {
                        currentFornecedor = null;
                    }
                }

                updateBatchInfo();
            }

            // Event listeners para checkboxes
            checkboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    toggleSale(this);
                });
            });

            // Selecionar todos
            selectAllBtn.addEventListener('click', function() {
                const availableCheckboxes = Array.from(checkboxes);

                if (availableCheckboxes.length === 0) {
                    Swal.fire({
                        title: 'Nenhuma venda disponível',
                        text: 'Não há vendas disponíveis para seleção.',
                        icon: 'info',
                        confirmButtonText: 'OK'
                    });
                    return;
                }

                // Pega o fornecedor da primeira venda disponível
                const firstFornecedor = availableCheckboxes[0].dataset.fornecedor;

                // Seleciona apenas vendas do mesmo fornecedor
                availableCheckboxes.forEach(checkbox => {
                    if (checkbox.dataset.fornecedor === firstFornecedor && !checkbox.checked) {
                        checkbox.checked = true;
                        toggleSale(checkbox);
                    }
                });
            });

            // Limpar seleção
            clearSelectionBtn.addEventListener('click', function() {
                checkboxes.forEach(checkbox => {
                    checkbox.checked = false;
                });
                selectedSales = [];
                currentFornecedor = null;
                updateBatchInfo();
            });

            // Pagamento em lote
            batchPaymentBtn.addEventListener('click', function() {
                if (selectedSales.length === 0) {
                    Swal.fire({
                        title: 'Nenhuma venda selecionada',
                        text: 'Selecione ao menos uma venda para pagar.',
                        icon: 'warning',
                        confirmButtonText: 'OK'
                    });
                    return;
                }

                const total = selectedSales.reduce((sum, sale) => sum + parseFloat(sale.valor), 0);
                const saleIds = selectedSales.map(sale => sale.saleId);

                Swal.fire({
                    title: 'Confirmar pagamento em lote',
                    html: `
                        <p><strong>${selectedSales.length} venda${selectedSales.length > 1 ? 's' : ''} selecionada${selectedSales.length > 1 ? 's' : ''}:</strong></p>
                        <ul style="text-align: left; max-height: 200px; overflow-y: auto;">
                            ${selectedSales.map(sale => `<li>${sale.saleTitle} - ${formatCurrency(parseFloat(sale.valor))}</li>`).join('')}
                        </ul>
                        <p><strong>Total: ${formatCurrency(total)}</strong></p>
                    `,
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonText: 'Pagar Agora',
                    cancelButtonText: 'Cancelar',
                    confirmButtonColor: '#28a745'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Preparar dados para envio
                        const usuario_email = '<?= $_SESSION['usuario']['email'] ?>';
                        const usuario_nome = '<?= $_SESSION['usuario']['nome'] ?>';
                        const usuario_id = '<?= $_SESSION['usuario']['id_usuario'] ?>';

                        const dados = `usuario_email=${encodeURIComponent(usuario_email)}&usuario_nome=${encodeURIComponent(usuario_nome)}&usuario_id=${encodeURIComponent(usuario_id)}&vendas_ids=${encodeURIComponent(JSON.stringify(saleIds))}&fornecedor=${encodeURIComponent(currentFornecedor)}&tipo=pagamento_custo_lote&valor=${total}`;

                        console.log('Dados sendo enviados:', {
                            usuario_email,
                            usuario_nome,
                            usuario_id,
                            vendas_ids: saleIds,
                            fornecedor: currentFornecedor,
                            valor: total
                        });

                        // Enviar dados para preparação
                        fetch('/assets/ajax/pagamento/prepare_batch_payment.php', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/x-www-form-urlencoded'
                                },
                                body: dados
                            })
                            .then(response => {
                                if (!response.ok) {
                                    throw new Error(`HTTP error! status: ${response.status}`);
                                }
                                return response.text();
                            })
                            .then(text => {
                                console.log('Resposta raw:', text);
                                try {
                                    const data = JSON.parse(text);
                                    console.log('Dados retornados:', data);

                                    if (data.success) {
                                        window.location.href = `/dash/v2.checkout?d=${data.encrypted_data}`;
                                    } else {
                                        Swal.fire({
                                            title: 'Erro',
                                            text: data.message || 'Erro ao preparar pagamento.',
                                            icon: 'error',
                                            confirmButtonText: 'OK'
                                        });
                                        console.error('Erro detalhado:', data);
                                    }
                                } catch (parseError) {
                                    console.error('Erro ao fazer parse do JSON:', parseError);
                                    console.error('Resposta recebida:', text);
                                    Swal.fire({
                                        title: 'Erro',
                                        text: 'Erro na resposta do servidor.',
                                        icon: 'error',
                                        confirmButtonText: 'OK'
                                    });
                                }
                            })
                            .catch(error => {
                                console.error('Error completo:', error);
                                Swal.fire({
                                    title: 'Erro',
                                    text: 'Erro ao processar pagamento em lote: ' + error.message,
                                    icon: 'error',
                                    confirmButtonText: 'OK'
                                });
                            });
                    }
                });
            });
        });

        // Função para ir para uma página específica
        function irParaPagina() {
            const pageInput = document.getElementById('gotoPage');
            const pageNumber = parseInt(pageInput.value);
            const maxPages = <?= isset($totalPaginas) ? $totalPaginas : 1 ?>;

            if (pageNumber >= 1 && pageNumber <= maxPages) {
                const currentUrl = new URL(window.location.href);
                currentUrl.searchParams.set('pagina', pageNumber);
                window.location.href = currentUrl.toString();
            } else {
                alert(`Por favor, digite um número entre 1 e ${maxPages}`);
                pageInput.focus();
            }
        }

        // Permitir enter no campo de ir para página
        document.addEventListener('DOMContentLoaded', function() {
            // Função para inicializar tooltips responsivos
            function initializeResponsiveTooltips() {
                const isMobile = window.innerWidth <= 768;

                document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(function(element) {
                    if (isMobile) {
                        // No mobile, usar texto pequeno ao lado do ícone
                        const title = element.getAttribute('title');
                        if (!element.querySelector('.mobile-label')) {
                            const label = document.createElement('span');
                            label.className = 'mobile-label ms-1';
                            label.style.fontSize = '0.65rem';
                            label.textContent = title;
                            element.appendChild(label);
                        }
                        // Remover tooltip no mobile
                        element.removeAttribute('data-bs-toggle');
                    } else {
                        // No desktop, usar Bootstrap tooltip
                        element.setAttribute('data-bs-toggle', 'tooltip');
                        // Remover label mobile se existir
                        const mobileLabel = element.querySelector('.mobile-label');
                        if (mobileLabel) {
                            mobileLabel.remove();
                        }

                        // Inicializar tooltip do Bootstrap 5.3
                        try {
                            new bootstrap.Tooltip(element, {
                                placement: 'top',
                                trigger: 'hover focus'
                            });
                        } catch (e) {
                            console.log('Bootstrap tooltip não disponível');
                        }
                    }
                });
            }

            // Inicializar na carga da página
            initializeResponsiveTooltips();

            // Reinicializar quando a tela for redimensionada
            window.addEventListener('resize', function() {
                // Destruir tooltips existentes primeiro
                document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(function(element) {
                    try {
                        const tooltip = bootstrap.Tooltip.getInstance(element);
                        if (tooltip) tooltip.dispose();
                    } catch (e) {}
                });

                setTimeout(initializeResponsiveTooltips, 100);
            });

            // Observer para novos elementos
            const observer = new MutationObserver(function(mutations) {
                mutations.forEach(function(mutation) {
                    if (mutation.addedNodes.length) {
                        setTimeout(initializeResponsiveTooltips, 100);
                    }
                });
            });

            observer.observe(document.body, {
                childList: true,
                subtree: true
            });

            const pageInput = document.getElementById('gotoPage');
            if (pageInput) {
                pageInput.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        irParaPagina();
                    }
                });
            }

            // Event listener para botões de verificar status
            document.querySelectorAll('.btn-verificar-status').forEach(function(button) {
                button.addEventListener('click', function() {
                    const idPagamento = this.dataset.idPagamento;
                    const idVenda = this.dataset.idVenda;
                    const idFornecedor = this.dataset.idFornecedor;

                    // Mostrar loading no botão
                    const originalText = this.innerHTML;
                    this.disabled = true;
                    this.innerHTML = '<i class="ti ti-loader me-1 spinner-border spinner-border-sm"></i> <small class="ms-1">Verificando...</small>';

                    // Fazer a requisição AJAX
                    fetch('/assets/ajax/plataformas/shipay/shipay_verificar_status.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            body: JSON.stringify({
                                id_pagamento: idPagamento,
                                id_venda: idVenda,
                                id_fornecedor: idFornecedor
                            })
                        })
                        .then(response => response.json())
                        .then(data => {
                            // Restaurar botão
                            this.disabled = false;
                            this.innerHTML = originalText;

                            if (data.success) {
                                // Mostrar mensagem de toast
                                if (data.action === 'approved') {
                                    toastAlert(data.message, "success", 8000, null, null, "right-top");
                                } else {
                                    toastAlert(data.message, "#ffc107", 8000, null, null, "right-top");
                                }

                                // Recarregar a página para atualizar o status após um delay
                                setTimeout(() => {
                                    window.location.reload();
                                }, 2000);
                            } else {
                                // Mostrar erro
                                toastAlert(data.error || 'Erro ao verificar status do pagamento', "error", 8000, null, null, "right-top");
                            }
                        })
                        .catch(error => {
                            // Restaurar botão em caso de erro
                            this.disabled = false;
                            this.innerHTML = originalText;

                            console.error('Erro:', error);
                            toastAlert('Erro ao conectar com o servidor', "error", 8000, null, null, "right-top");
                        });
                });
            });
        });
    </script>

    <!-- Sistema de Verificação Automática de Pagamentos -->
    <script src="../../assets/js/payment-recovery.js"></script>

    <!-- Script para controle do botão de verificação -->
    <script>
        function verificarPagamentosPendentes() {
            const btn = document.getElementById('btnVerificarPagamentos');
            if (!btn) {
                console.error('Botão não encontrado');
                return;
            }

            // Pegar elementos do botão
            const spinner = btn.querySelector('.spinner-border');
            const icon = btn.querySelector('.ti-refresh');
            const textSpan = btn.querySelector('.btn-text');

            // Mostrar spinner e desabilitar botão
            if (spinner) spinner.classList.remove('d-none');
            if (icon) icon.classList.add('d-none');
            btn.disabled = true;

            // Fazer requisição
            fetch('../../assets/ajax/plataformas/shipay/verificar_pagamentos_pendentes_ajax.php', {
                    method: 'GET',
                    headers: {
                        'Content-Type': 'application/json',
                    }
                })
                .then(response => response.json())
                .then(data => {
                    // Esconder spinner e reabilitar botão
                    if (spinner) spinner.classList.add('d-none');
                    if (icon) icon.classList.remove('d-none');
                    btn.disabled = false;

                    // Mostrar toast com resultado
                    if (data.status === 'success') {
                        if (data.pagamentos_processados > 0) {
                            toastAlert(`${data.pagamentos_processados} pagamento(s) processado(s) com sucesso!`, 'success', 5000, null, null, 'right-top');
                            // Recarregar após 2 segundos
                            setTimeout(() => location.reload(), 2000);
                        } else {
                            toastAlert('Nenhum pagamento pendente encontrado', '#17a2b8', 3000, null, null, 'right-top');
                        }
                    } else {
                        toastAlert(data.message || 'Erro ao verificar pagamentos', 'error', 5000, null, null, 'right-top');
                    }
                })
                .catch(error => {
                    console.error('Erro:', error);
                    // Esconder spinner e reabilitar botão
                    if (spinner) spinner.classList.add('d-none');
                    if (icon) icon.classList.remove('d-none');
                    btn.disabled = false;

                    toastAlert('Erro ao verificar pagamentos', 'error', 5000, null, null, 'right-top');
                });
        }
    </script>

    <!-- Sistema de Busca de Vendas em Tempo Real -->

    <!-- Sistema Automático de Reprocessamento de Etiquetas -->
    <script>
        // Sistema de Reprocessamento Automático de Etiquetas
        // class AutoEtiquetaReprocessor {
        //     // constructor() {
        //     //     this.isProcessing = false;
        //     //     this.processedCount = 0;
        //     //     this.init();
        //     // }

        //     // init() {
        //     //     console.log('🏷️ Inicializando Sistema Automático de Reprocessamento de Etiquetas');

        //     //     // 🔧 Verificar se validações estão ativas
        //     //     const validationsEnabled = window.userConfig && window.userConfig.enablePageValidation;

        //     //     if (!validationsEnabled) {
        //     //         console.log('⛔ Sistema de reprocessamento DESATIVADO (modo desenvolvimento)');
        //     //         return; // Não executar nenhuma validação
        //     //     }

        //     //     // Verificar se usuário é afiliado
        //     //     const isAffiliate = window.userConfig && window.userConfig.isAffiliate === 1;

        //     //     if (isAffiliate) {
        //     //         console.log('👥 Usuário afiliado detectado - sistema de reprocessamento apenas visual');

        //     //         // Para afiliados: apenas mostrar toast inicial e depois "concluído"
        //     //         setTimeout(() => {
        //     //             if (typeof toastAlert === 'function') {
        //     //                 toastAlert('Verificando etiquetas...', "#17a2b8", 3000, null, null, "right-bottom");

        //     //                 setTimeout(() => {
        //     //                     toastAlert('Verificação de etiquetas concluída', "#28a745", 2000, null, null, "right-bottom");
        //     //                 }, 3000);
        //     //             }
        //     //         }, 5000);

        //     //         return; // Não executar o resto do sistema
        //     //     }

        //     //     // // Executar primeira verificação após 8 segundos (apenas para não-afiliados)
        //     //     // setTimeout(() => {
        //     //     //     console.log('🏷️ Executando primeira verificação de etiquetas');
        //     //     //     this.findAndProcessLabels();
        //     //     // }, 8000);

        //     //     // // Configurar timer automático a cada 10 minutos (apenas para não-afiliados)
        //     //     // setInterval(() => {
        //     //     //     console.log('🏷️ Verificação automática de etiquetas (10 minutos)');
        //     //     //     this.findAndProcessLabels();
        //     //     // }, 600000); // 10 minutos
        //     // }

        //     // findAndProcessLabels() {
        //     //     if (this.isProcessing) {
        //     //         console.log('🏷️ Reprocessamento já em andamento - pulando execução');
        //     //         return;
        //     //     }

        //     //     // Buscar todos os botões de reprocessar etiqueta
        //     //     const botoes = document.querySelectorAll('span[title="Reprocessar Etiqueta"]');

        //     //     if (botoes.length === 0) {
        //     //         console.log('🏷️ Nenhum botão de "Reprocessar Etiqueta" encontrado');
        //     //         return;
        //     //     }

        //     //     console.log(`🏷️ Encontrados ${botoes.length} botão(ões) de reprocessar etiqueta`);

        //     //     // Processar sequencialmente com intervalo
        //     //     this.processLabelsSequentially(Array.from(botoes));
        //     // }

        //     // async processLabelsSequentially(botoes) {
        //     //     this.isProcessing = true;
        //     //     this.processedCount = 0;

        //     //     console.log(`🏷️ Iniciando reprocessamento sequencial de ${botoes.length} etiquetas`);

        //     //     for (let i = 0; i < botoes.length; i++) {
        //     //         const botao = botoes[i];

        //     //         try {
        //     //             // Verificar se tem "Erro 338A" nas observações antes de processar
        //     //             let observacoes = botao.getAttribute('data-observacoes') || '';

        //     //             // Se não encontrou no botão, verificar no elemento pai (venda-item)
        //     //             if (!observacoes) {
        //     //                 const vendaItem = botao.closest('.venda-item');
        //     //                 if (vendaItem) {
        //     //                     observacoes = vendaItem.getAttribute('data-observacoes') || '';
        //     //                 }
        //     //             }

        //     //             if (observacoes.includes('Erro 338A')) {
        //     //                 console.log(`🏷️ Pulando etiqueta ${i+1} com Erro 338A - não reprocessar`);
        //     //                 continue; // Pular este item
        //     //             }

        //     //             // Extrair dados do onclick
        //     //             const onclickStr = botao.getAttribute('onclick');
        //     //             const match = onclickStr.match(/reprocessarEtiqueta\('([^']+)',\s*'([^']+)',\s*'([^']+)',\s*'([^']+)',\s*this\)/);

        //     //             if (match) {
        //     //                 const [, saleId, integracao, saleTitle, fornecedor] = match;

        //     //                 console.log(`🏷️ Processando etiqueta ${i+1}/${botoes.length}: ${saleTitle}`);

        //     //                 // Mostrar progresso
        //     //                 if (typeof toastAlert === 'function') {
        //     //                     toastAlert(`Reprocessando ${i+1}/${botoes.length}: ${saleTitle}`, "#17a2b8", 5000, null, null, "right-bottom");
        //     //                 }

        //     //                 // Chamar função de reprocessamento diretamente (sem confirmação)
        //     //                 await this.reprocessarEtiquetaAutomatico(saleId, integracao, saleTitle, fornecedor, botao);

        //     //                 this.processedCount++;

        //     //                 // Aguardar 30 segundos entre processamentos
        //     //                 if (i < botoes.length - 1) {
        //     //                     console.log(`🏷️ Aguardando 30 segundos antes da próxima etiqueta...`);
        //     //                     await this.delay(30000);
        //     //                 }

        //     //             } else {
        //     //                 console.warn(`🏷️ Não foi possível extrair dados do botão ${i+1}`);
        //     //             }

        //     //         } catch (error) {
        //     //             console.error(`🏷️ Erro ao processar etiqueta ${i+1}:`, error);
        //     //         }
        //     //     }

        //     //     console.log(`🏷️ Reprocessamento sequencial concluído! ${this.processedCount} etiqueta(s) processadas`);

        //     //     if (this.processedCount > 0 && typeof toastAlert === 'function') {
        //     //         toastAlert(`Reprocessamento concluído! ${this.processedCount} etiqueta(s) processada(s)`, "#28a745", 5000, null, null, "right-bottom");

        //     //         // Recarregar página após 10 segundos se processou algo
        //     //         setTimeout(() => {
        //     //             console.log('🔄 Recarregando página após reprocessamento automático');
        //     //             location.reload();
        //     //         }, 10000);
        //     //     }

        //     //     this.isProcessing = false;
        //     // }

        //     // async reprocessarEtiquetaAutomatico(saleId, integracao, saleTitle, fornecedor, el) {
        //     //     return new Promise((resolve, reject) => {
        //     //         // Determinar o endpoint baseado na integração
        //     //         let endpoint = '';
        //     //         if (integracao === 'shopee') {
        //     //             endpoint = '../../assets/ajax/etiquetas/reprocessar_etiqueta_shopee.php';
        //     //         } else if (integracao === 'mercado_livre' || integracao === 'mercado livre') {
        //     //             endpoint = '../../assets/ajax/etiquetas/reprocessar_etiqueta_ml.php';
        //     //         } else {
        //     //             console.error('🏷️ Integração não reconhecida:', integracao);
        //     //             reject(new Error('Integração não reconhecida: ' + integracao));
        //     //             return;
        //     //         }

        //     //         // Mostrar loading no botão
        //     //         const originalHtml = el.innerHTML;
        //     //         el.innerHTML = '<i class="ti ti-loader-2 ti-spin"></i>';
        //     //         el.style.pointerEvents = 'none';

        //     //         console.log(`🏷️ Enviando requisição para: ${endpoint}`);

        //     //         // Fazer a requisição
        //     //         fetch(endpoint, {
        //     //                 method: 'POST',
        //     //                 headers: {
        //     //                     'Content-Type': 'application/x-www-form-urlencoded'
        //     //                 },
        //     //                 body: 'saleTitle=' + encodeURIComponent(saleTitle) + '&fornecedor=' + encodeURIComponent(fornecedor)
        //     //             })
        //     //             .then(res => res.json())
        //     //             .then(data => {
        //     //                 console.log(`🏷️ Resposta do reprocessamento:`, data);
        //     //                 if (data.success) {
        //     //                     resolve(data);
        //     //                 } else {
        //     //                     // Verificar se é erro de PolicyAgent do MercadoLivre
        //     //                     if (data.error_type === 'policy_agent' && data.manual_solution === true) {
        //     //                         // Criar modal explicativo com instruções
        //     //                         Swal.fire({
        //     //                             title: '🔒 Etiqueta Bloqueada pela API do MercadoLivre',
        //     //                             html: `
        //     //                             <div class="text-start">
        //     //                                 <p><strong>📋 Erro:</strong> ${data.error_code || 'PA_UNAUTHORIZED_RESULT_FROM_POLICIES'}</p>

        //     //                                 <div class="alert alert-info mb-3">
        //     //                                     <i class="ti ti-info-circle me-2"></i>
        //     //                                     <strong>O que aconteceu?</strong><br>
        //     //                                     O MercadoLivre bloqueou a geração automática de etiquetas via API por motivos de segurança/permissões.
        //     //                                 </div>

        //     //                                 <div class="alert alert-success">
        //     //                                     <strong>✅ Solução Imediata:</strong>
        //     //                                     <ol class="mb-0 ps-3">
        //     //                                         ${data.instructions ? Object.values(data.instructions).map((step, i) => `<li>${step}</li>`).join('') : ''}
        //     //                                     </ol>
        //     //                                 </div>

        //     //                                 <small class="text-muted">
        //     //                                     <i class="ti ti-alert-circle"></i> 
        //     //                                     Estamos trabalhando para resolver definitivamente este problema com o MercadoLivre.
        //     //                                 </small>
        //     //                             </div>
        //     //                         `,
        //     //                             icon: 'warning',
        //     //                             width: 600,
        //     //                             confirmButtonText: 'Entendi',
        //     //                             showCancelButton: true,
        //     //                             cancelButtonText: 'Abrir Painel ML',
        //     //                             customClass: {
        //     //                                 htmlContainer: 'text-start'
        //     //                             }
        //     //                         }).then((result) => {
        //     //                             if (result.dismiss === Swal.DismissReason.cancel) {
        //     //                                 // Abrir painel do MercadoLivre em nova aba
        //     //                                 window.open('https://vendedores.mercadolivre.com.br/', '_blank');
        //     //                             }
        //     //                         });
        //     //                     }
        //     //                     reject(new Error(data.message));
        //     //                 }
        //     //             })
        //     //             .catch(error => {
        //     //                 console.error(`🏷️ Erro na requisição:`, error);
        //     //                 reject(error);
        //     //             })
        //     //             .finally(() => {
        //     //                 // Restaurar botão
        //     //                 el.innerHTML = originalHtml;
        //     //                 el.style.pointerEvents = 'auto';
        //     //             });
        //     //     });
        //     // }

        //     // delay(ms) {
        //     //     return new Promise(resolve => setTimeout(resolve, ms));
        //     // }

        //     // // Método para execução manual
        //     // manualProcess() {
        //     //     console.log('🏷️ Reprocessamento manual solicitado');
        //     //     this.findAndProcessLabels();
        //     // }
        // }

        // Inicializar o sistema após carregamento da página
        // document.addEventListener('DOMContentLoaded', function() {
        //     // Aguardar 3 segundos para garantir que tudo foi carregado
        //     setTimeout(() => {
        //         console.log('🏷️ Criando instância do AutoEtiquetaReprocessor');
        //         window.autoEtiquetaReprocessor = new AutoEtiquetaReprocessor();
        //     }, 3000);
        // });

        // // Função global para teste manual de reprocessamento de etiquetas
        // function reprocessarEtiquetasAutomatico() {
        //     console.log('🏷️ Função global reprocessarEtiquetasAutomatico() chamada');

        //     // 🔧 Verificar se validações estão ativas
        //     const validationsEnabled = window.userConfig && window.userConfig.enablePageValidation;

        //     if (!validationsEnabled) {
        //         console.log('⛔ Reprocessamento manual bloqueado - validações desativadas (modo desenvolvimento)');
        //         if (typeof toastAlert === 'function') {
        //             toastAlert('⛔ Validações desativadas no modo desenvolvimento', "#dc3545", 3000, null, null, "right-top");
        //         }
        //         return;
        //     }

        //     // Verificar se usuário é afiliado
        //     const isAffiliate = window.userConfig && window.userConfig.isAffiliate === 1;

        //     if (isAffiliate) {
        //         // Para afiliados: apenas mostrar feedback visual
        //         if (typeof toastAlert === 'function') {
        //             toastAlert('Verificando etiquetas...', "#17a2b8", 3000, null, null, "right-bottom");

        //             setTimeout(() => {
        //                 toastAlert('Verificação concluída', "#28a745", 2000, null, null, "right-bottom");
        //             }, 3000);
        //         }
        //         return;
        //     }

        //     // Para não-afiliados: executar reprocessamento real
        //     if (window.autoEtiquetaReprocessor) {
        //         window.autoEtiquetaReprocessor.manualProcess();
        //     } else {
        //         console.error('🏷️ Sistema de reprocessamento automático não foi inicializado');
        //         if (typeof toastAlert === 'function') {
        //             toastAlert('Sistema de reprocessamento não disponível', "#dc3545", 3000, null, null, "right-bottom");
        //         }
        //     }
        // }
    </script>

    <!-- Modal Solicitar Reembolso -->
    <div class="modal fade" id="modalReembolsoVenda" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="ti ti-arrow-back-up me-2"></i>Solicitar Reembolso</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
                </div>
                <div class="modal-body">
                    <form id="formReembolsoVenda" autocomplete="off">
                        <!-- Hidden fields necessários -->
                        <input type="hidden" id="reembFornecedor" name="fornecedor">
                        <input type="hidden" id="reembIntegracao" name="integracao">
                        <input type="hidden" id="reembWhitelabel" name="whitelabel">
                        <input type="hidden" id="reembSaleId" name="sale_id">
                        <div class="row g-3">
                            <div class="col-md-4 col-12">
                                <label class="form-label mb-1">Pedido</label>
                                <input type="text" class="form-control" id="reembPedido" name="numero_pedido" readonly>
                            </div>
                            <div class="col-md-4 col-12">
                                <label class="form-label mb-1">Valor (R$)</label>
                                <input type="text" class="form-control" id="reembValor" name="valor" readonly>
                            </div>
                            <div class="col-md-4 col-12">
                                <label class="form-label mb-1">Código Devolução / Rastreio <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="reembCodigo" name="codigo_devolucao" required placeholder="Informado pelo marketplace">
                                <div class="invalid-feedback" id="feedbackCodigo">Obrigatório.</div>
                            </div>
                            <div class="col-12">
                                <label class="form-label mb-1">Motivo <small class="text-muted" id="motivoCount">0/100</small></label>
                                <textarea class="form-control" id="reembMotivo" name="motivo_reembolso" rows="3" maxlength="100" placeholder="Descreva o motivo (mín. 10 caracteres)"></textarea>
                                <div class="progress mt-1" style="height:4px;">
                                    <div class="progress-bar" id="motivoProgress" style="width:0%"></div>
                                </div>
                                <div id="motivoHint" class="small mt-1"></div>
                            </div>
                            <div class="col-12">
                                <div class="form-check2">
                                    <input class="form-check-input" type="checkbox" id="reembCancelar" checked>
                                    <label class="form-check-label" for="reembCancelar">Cancelar a venda</label>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-info" id="btnEnviarReembolso">
                        <span class="txt">Enviar Solicitação</span>
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Comprar Etiqueta -->
    <!-- Modal Comprar Etiqueta -->
    <div class="modal fade" id="modalComprarEtiqueta" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="ti ti-package me-2"></i>Comprar Etiqueta - Dados da Venda</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="formComprarEtiqueta" autocomplete="off">

                        <!-- Informações da Venda -->
                        <div class="card mb-3 d-none">
                            <div class="card-header">
                                <h6 class="card-title mb-0"><i class="ti ti-shopping-cart me-1"></i>Informações da Venda</h6>
                            </div>
                            <div class="card-body">
                                <div class="row g-3">
                                    <div class="col-md-3">
                                        <label class="form-label">ID da Venda</label>
                                        <input type="text" class="form-control" required id="etq_sale_id" readonly>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Pedido</label>
                                        <input type="text" class="form-control" required id="etq_sale_title" readonly>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Integração</label>
                                        <input type="text" class="form-control" id="etq_integracao" readonly>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Fornecedor</label>
                                        <input type="text" class="form-control" required id="etq_fornecedor" readonly>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Whitelabel</label>
                                        <input type="text" class="form-control" required id="etq_whitelabel" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Dados dos Produtos -->
                        <div class="card mb-3 d-none">
                            <div class="card-body">
                                <div id="etq_produtos_individuais">
                                    <h6><i class="ti ti-list me-1"></i>Produtos da Venda</h6>
                                    <div id="etq_produtos_container">
                                        <!-- Os produtos serão inseridos aqui dinamicamente -->
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Dados do Destinatário -->
                        <div class="card mb-3">
                            <div class="card-header">
                                <h6 class="card-title mb-0"><i class="ti ti-map-pin me-1"></i>Dados do Destinatário</h6>
                            </div>
                            <div class="card-body">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label"><i class="ti ti-user me-1"></i>Nome Completo <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="etq_dest_nome" placeholder="Digite o nome completo" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label"><i class="ti ti-id me-1"></i>CPF ou CNPJ <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="etq_dest_documento" placeholder="Digite o CPF ou CNPJ" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label"><i class="ti ti-phone me-1"></i>Celular <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="etq_dest_telefone" placeholder="(11) 99999-9999" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label"><i class="ti ti-mail me-1"></i>Email <span class="text-danger">*</span></label>
                                        <input type="email" class="form-control" id="etq_dest_email" placeholder="email@exemplo.com" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label"><i class="ti ti-map-pin me-1"></i>CEP <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="etq_dest_cep" placeholder="00000-000" required>
                                        <small class="text-muted">O endereço será preenchido automaticamente</small>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label"><i class="ti ti-hash me-1"></i>Número <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="etq_dest_numero" placeholder="Número da residência" required>
                                    </div>
                                    <div class="col-md-8">
                                        <label class="form-label"><i class="ti ti-road me-1"></i>Rua/Logradouro <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="etq_dest_endereco" placeholder="Nome da rua" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label"><i class="ti ti-building me-1"></i>Complemento</label>
                                        <input type="text" class="form-control" id="etq_dest_complemento" placeholder="Apto, bloco, etc.">
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label"><i class="ti ti-map me-1"></i>Bairro <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="etq_dest_bairro" placeholder="Nome do bairro" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label"><i class="ti ti-building-community me-1"></i>Cidade <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="etq_dest_cidade" placeholder="Nome da cidade" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label"><i class="ti ti-map-2 me-1"></i>Estado <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="etq_dest_estado" placeholder="UF" maxlength="2" required>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Dados do Remetente -->
                        <div class="card mb-3">
                            <div class="card-header">
                                <h6 class="card-title mb-0"><i class="ti ti-building me-1"></i>Dados do Remetente</h6>
                            </div>
                            <div class="card-body">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Nome/Razão Social</label>
                                        <input type="text" class="form-control" id="etq_rem_nome" readonly>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">CPF/CNPJ</label>
                                        <input type="text" class="form-control" id="etq_rem_documento" readonly>
                                    </div>
                                    <div class="col-md-8">
                                        <label class="form-label">Endereço</label>
                                        <input type="text" class="form-control" id="etq_rem_endereco" readonly>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Número</label>
                                        <input type="text" class="form-control" id="etq_rem_numero" readonly>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Complemento</label>
                                        <input type="text" class="form-control" id="etq_rem_complemento" readonly>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Bairro</label>
                                        <input type="text" class="form-control" id="etq_rem_bairro" readonly>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">CEP</label>
                                        <input type="text" class="form-control" id="etq_rem_cep" readonly>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Cidade</label>
                                        <input type="text" class="form-control" id="etq_rem_cidade" readonly>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Estado</label>
                                        <input type="text" class="form-control" id="etq_rem_estado" readonly>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Telefone</label>
                                        <input type="text" class="form-control" id="etq_rem_telefone" readonly>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Email</label>
                                        <input type="text" class="form-control" id="etq_rem_email" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Campos ocultos -->
                        <input type="hidden" id="etq_produtos_json" name="produtos_json" value="">
                        <input type="hidden" id="etq_total_produtos" name="total_produtos" value="0">
                        <input type="hidden" id="etq_peso_total_todos" name="peso_total_todos" value="0">
                        <input type="hidden" id="etq_valor_total_todos" name="valor_total_todos" value="0">

                        <!-- Status do Carregamento -->
                        <div class="card">
                            <div class="card-body text-center">
                                <div id="etq_loading" class="d-none">
                                    <div class="spinner-border text-primary me-2" role="status">
                                        <span class="visually-hidden">Carregando...</span>
                                    </div>
                                    <span>Carregando dados da venda...</span>
                                </div>
                                <div id="etq_status" class="alert alert-info">
                                    <i class="ti ti-info-circle me-2"></i>
                                    Carregando dados da venda automaticamente...
                                </div>
                            </div>
                        </div>

                        <!-- Seção da Envioecom - Etapa 2 (oculta inicialmente) -->
                        <div id="secao_envioecom" class="d-none">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="card-title mb-0"><i class="ti ti-truck-delivery me-1"></i>Comprar Etiqueta - Envioecom</h6>
                                </div>
                                <div class="card-body">
                                    <div id="etapas-envioecom">
                                        <div class="etapa-envioecom mb-3" id="etapa-1">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="badge bg-secondary rounded-circle me-2" style="width: 24px; height: 24px; display: flex; align-items: center; justify-content: center; font-size: 11px;">1</span>
                                                <small class="text-muted fw-medium">Validando conta EnvioEcom</small>
                                                <div class="spinner-border spinner-border-sm ms-2 text-primary" id="spinner-1" style="display: none; width: 16px; height: 16px;"></div>
                                                <span class="resultado ms-2" id="resultado-1" style="display: none; font-size: 12px;"></span>
                                            </div>
                                            <div class="etapa-detalhe ms-4" id="detalhe-1" style="display: none; font-size: 11px; color: #6c757d;"></div>
                                        </div>

                                        <div class="etapa-envioecom mb-3" id="etapa-2" style="display: none;">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="badge bg-secondary rounded-circle me-2" style="width: 24px; height: 24px; display: flex; align-items: center; justify-content: center; font-size: 11px;">2</span>
                                                <small class="text-muted fw-medium">Configurando endereço do fornecedor</small>
                                                <div class="spinner-border spinner-border-sm ms-2 text-primary" id="spinner-2" style="display: none; width: 16px; height: 16px;"></div>
                                                <span class="resultado ms-2" id="resultado-2" style="display: none; font-size: 12px;"></span>
                                            </div>
                                            <div class="etapa-detalhe ms-4" id="detalhe-2" style="display: none; font-size: 11px; color: #6c757d;"></div>
                                        </div>

                                        <div class="etapa-envioecom mb-3" id="etapa-3" style="display: none;">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="badge bg-secondary rounded-circle me-2" style="width: 24px; height: 24px; display: flex; align-items: center; justify-content: center; font-size: 11px;">3</span>
                                                <small class="text-muted fw-medium">Calculando opções de frete</small>
                                                <div class="spinner-border spinner-border-sm ms-2 text-primary" id="spinner-3" style="display: none; width: 16px; height: 16px;"></div>
                                                <span class="resultado ms-2" id="resultado-3" style="display: none; font-size: 12px;"></span>
                                            </div>
                                            <div class="etapa-detalhe ms-4" id="detalhe-3" style="display: none; font-size: 11px; color: #6c757d;"></div>
                                        </div>

                                        <div id="opcoes-frete" class="mt-4" style="display: none;">
                                            <h6 class="fw-semibold mb-3">
                                                <i class="ti ti-truck-delivery me-1"></i>Selecione uma opção de frete:
                                            </h6>
                                            <div id="lista-opcoes-frete">
                                                <!-- As opções de frete serão inseridas aqui dinamicamente -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary d-none" id="btnCarregarDados">
                        <i class="ti ti-refresh me-1"></i>Recarregar Dados
                    </button>
                    <button type="button" class="btn btn-success d-none" id="btnProximaEtapa">
                        <i class="ti ti-truck-delivery me-1"></i>Comprar Etiqueta
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        (function() {
            const modalEl = document.getElementById('modalReembolsoVenda');
            const motivo = document.getElementById('reembMotivo');
            const count = document.getElementById('motivoCount');
            const progress = document.getElementById('motivoProgress');
            const hint = document.getElementById('motivoHint');
            const btnEnviar = document.getElementById('btnEnviarReembolso');
            const codigo = document.getElementById('reembCodigo');
            let currentSaleId = null;

            function atualizarUI() {
                // Garantir que os elementos existem antes de atualizar
                if (!motivo || !count || !progress || !hint) return;

                const len = motivo.value.trim().length;
                count.textContent = len + '/100';
                progress.style.width = len + '%';
                const val = motivo.value.trim();
                let msg = '',
                    cls = 'text-muted';
                if (len === 0) {
                    msg = 'Digite o motivo.';
                } else if (len < 10) {
                    msg = 'Mínimo 10 caracteres.';
                    cls = 'text-danger';
                } else if (/^\d+$/.test(val)) {
                    msg = 'Não apenas números.';
                    cls = 'text-danger';
                } else if (/^(.)\1{9,}$/.test(val)) {
                    msg = 'Não repetir o mesmo caractere.';
                    cls = 'text-danger';
                } else {
                    msg = 'Motivo válido.';
                    cls = 'text-success';
                }
                hint.className = 'small mt-1 ' + cls;
                hint.textContent = msg;
            }

            // Event listener para o textarea com debounce para evitar travamentos
            let inputTimeout;
            motivo.addEventListener('input', () => {
                clearTimeout(inputTimeout);
                inputTimeout = setTimeout(atualizarUI, 100);
            });

            codigo.addEventListener('input', () => {
                codigo.classList.remove('is-invalid');
            });

            // Tratar visibilidade da página para evitar travamentos ao minimizar/restaurar
            // 🔧 Só executa se validações estiverem ativas
            if (window.userConfig && window.userConfig.enablePageValidation) {
                document.addEventListener('visibilitychange', () => {
                    if (!document.hidden && modalEl && modalEl.classList.contains('show')) {
                        // Página voltou a ser visível e modal está aberto - forçar atualização
                        setTimeout(() => {
                            atualizarUI();
                            // Garantir que os campos estejam desbloqueados
                            if (motivo) motivo.disabled = false;
                            if (codigo) codigo.disabled = false;
                        }, 100);
                    }
                });
            }

            // Garantir que campos sejam desbloqueados quando o modal é aberto
            if (modalEl) {
                modalEl.addEventListener('shown.bs.modal', () => {
                    setTimeout(() => {
                        if (motivo) {
                            motivo.disabled = false;
                            motivo.focus();
                        }
                        if (codigo) codigo.disabled = false;
                        atualizarUI();
                    }, 100);
                });
            }

            document.addEventListener('click', e => {
                const btn = e.target.closest('.btn-solicitar-reembolso-venda');
                if (!btn) return;
                // Verificações de bloqueio lato JS (defesa em profundidade)
                const pago = btn.getAttribute('data-vlr-custo-pago') === '1';
                const reembolsado = btn.getAttribute('data-reembolsado') === '1';
                const cancelado = btn.getAttribute('data-cancelado') === '1';
                const srStatus = btn.getAttribute('data-sr-status');
                const temSolicAtiva = ['0', '1', '2', '3'].includes(srStatus);
                if (!pago) {
                    if (typeof toastAlert === 'function') toastAlert('Venda ainda não está paga', '#dc3545', 5000, null, null, 'right-top');
                    return;
                }
                if (reembolsado) {
                    if (typeof toastAlert === 'function') toastAlert('Venda já reembolsada', '#ffc107', 5000, null, null, 'right-top');
                    return;
                }
                if (cancelado) {
                    if (typeof toastAlert === 'function') toastAlert('Venda cancelada não pode reembolso', '#dc3545', 5000, null, null, 'right-top');
                    return;
                }
                if (temSolicAtiva) {
                    if (typeof toastAlert === 'function') toastAlert('Já existe solicitação em andamento', '#0d6efd', 5000, null, null, 'right-top');
                    return;
                }
                currentSaleId = btn.dataset.saleid;
                document.getElementById('reembPedido').value = btn.dataset.orderid;
                document.getElementById('reembFornecedor').value = btn.dataset.fornecedor;
                document.getElementById('reembValor').value = btn.dataset.valor;
                document.getElementById('reembIntegracao').value = btn.dataset.integracao;
                document.getElementById('reembWhitelabel').value = btn.dataset.whitelabel;
                document.getElementById('reembSaleId').value = btn.dataset.saleid;
                codigo.value = '';
                motivo.value = '';
                atualizarUI();
                new bootstrap.Modal(modalEl).show();
            });

            function motivoValido() {
                const v = motivo.value.trim();
                if (v.length < 10) return false;
                if (/^\d+$/.test(v)) return false;
                if (/^(.)\1{9,}$/.test(v)) return false;
                return true;
            }

            function codigoValido() {
                return codigo.value.trim().length > 0;
            }

            btnEnviar.addEventListener('click', () => {
                if (!codigoValido()) {
                    codigo.classList.add('is-invalid');
                    codigo.focus();
                    return;
                }
                if (!motivoValido()) {
                    atualizarUI();
                    motivo.focus();
                    return;
                }
                const spinner = btnEnviar.querySelector('.spinner-border');
                const txt = btnEnviar.querySelector('.txt');
                btnEnviar.disabled = true;
                spinner.classList.remove('d-none');
                txt.textContent = 'Enviando...';
                const payload = new URLSearchParams();
                payload.append('numero_pedido', document.getElementById('reembPedido').value);
                payload.append('fornecedor', document.getElementById('reembFornecedor').value);
                payload.append('codigo_devolucao', codigo.value.trim());
                payload.append('motivo_reembolso', motivo.value.trim());
                payload.append('whitelabel', document.getElementById('reembWhitelabel').value);
                payload.append('integracao', document.getElementById('reembIntegracao').value);
                payload.append('valor', document.getElementById('reembValor').value);
                fetch('/assets/ajax/pagamentos/solicitar_reembolso.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded'
                        },
                        body: payload.toString()
                    })
                    .then(r => r.json())
                    .then(data => {
                        // API retorna {status:'success'| 'error'}
                        if (!(data && (data.success === true || data.status === 'success'))) {
                            throw new Error(data && (data.message || data.error) ? (data.message || data.error) : 'Erro ao solicitar reembolso');
                        }
                        if (document.getElementById('reembCancelar').checked) {
                            const cPayload = new URLSearchParams();
                            cPayload.append('saleId', currentSaleId);
                            cPayload.append('motivo', 'Cancelado automaticamente ao solicitar reembolso');
                            return fetch('/assets/ajax/vendas/cancelar_venda.php', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/x-www-form-urlencoded'
                                },
                                body: cPayload.toString()
                            }).then(() => data);
                        }
                        return data;
                    })
                    .then(() => {
                        if (typeof toastAlert === 'function') {
                            toastAlert('Solicitação de reembolso registrada', 'success', 8000, null, null, 'right-top');
                        }
                        // Fecha modal e recarrega para atualizar lista
                        const bsModal = bootstrap.Modal.getInstance(modalEl);
                        if (bsModal) bsModal.hide();
                        setTimeout(() => location.reload(), 900);
                    })
                    .catch(err => {
                        if (typeof toastAlert === 'function') {
                            toastAlert(err.message || 'Erro ao solicitar reembolso', 'error', 8000, null, null, 'right-top');
                        } else {
                            console.error(err);
                        }
                    })
                    .finally(() => {
                        btnEnviar.disabled = false;
                        spinner.classList.add('d-none');
                        txt.textContent = 'Enviar Solicitação';
                    });
            });
        })();
    </script>

    <!-- Date Range Picker (mantido dentro do body) -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <script>
        // Garantir que filtros de usuário/whitelabel SEMPRE sejam enviados no backend (já aplicado na query PHP)
        document.addEventListener('DOMContentLoaded', function() {
            const rangeInput = document.getElementById('dateRange');
            if (!rangeInput) return;
            const deHidden = document.getElementById('dta_venda_de_hidden');
            const ateHidden = document.getElementById('dta_venda_ate_hidden');
            const deVal = deHidden.value;
            const ateVal = ateHidden.value;
            let start = deVal ? moment(deVal, 'YYYY-MM-DD') : moment().subtract(29, 'days');
            let end = ateVal ? moment(ateVal, 'YYYY-MM-DD') : moment();

            function updateDisplay(s, e) {
                rangeInput.value = s.format('DD/MM/YYYY') + ' - ' + e.format('DD/MM/YYYY');
                deHidden.value = s.format('YYYY-MM-DD');
                ateHidden.value = e.format('YYYY-MM-DD');
            }

            $(rangeInput).daterangepicker({
                locale: {
                    format: 'DD/MM/YYYY',
                    applyLabel: 'Aplicar',
                    cancelLabel: 'Cancelar',
                    customRangeLabel: 'Personalizado',
                    daysOfWeek: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb'],
                    monthNames: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
                    firstDay: 1
                },
                startDate: start,
                endDate: end,
                opens: 'left',
                autoUpdateInput: false,
                ranges: {
                    'Hoje': [moment(), moment()],
                    'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Últimos 7 dias': [moment().subtract(6, 'days'), moment()],
                    'Últimos 30 dias': [moment().subtract(29, 'days'), moment()],
                    'Este mês': [moment().startOf('month'), moment().endOf('month')],
                    'Mês passado': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, function(s, e) {
                updateDisplay(s, e);
            });

            updateDisplay(start, end);
            rangeInput.addEventListener('dblclick', function() {
                rangeInput.value = '';
                deHidden.value = '';
                ateHidden.value = '';
            });

            // ===== FUNÇÕES DA ENVIOECOM =====

            function iniciarProcessoEnvioecom() {
                console.log('🚀 Iniciando processo EnvioEcom...');
                resetarEtapasEnvioecom();
                validarContaEnvioEcomAutomatico();
            }

            function resetarEtapasEnvioecom() {
                console.log('🔄 Resetando etapas do EnvioEcom...');

                // Resetar todas as etapas
                for (let i = 1; i <= 3; i++) {
                    const etapa = document.getElementById(`etapa-${i}`);
                    const spinner = document.getElementById(`spinner-${i}`);
                    const resultado = document.getElementById(`resultado-${i}`);
                    const detalhe = document.getElementById(`detalhe-${i}`);
                    const badge = etapa?.querySelector('.badge');

                    if (etapa) etapa.style.display = 'none';
                    if (spinner) spinner.style.display = 'none';
                    if (resultado) {
                        resultado.style.display = 'none';
                        resultado.innerHTML = '';
                        resultado.className = 'resultado ms-2';
                    }
                    if (detalhe) {
                        detalhe.style.display = 'none';
                        detalhe.innerHTML = '';
                    }
                    if (badge) {
                        badge.className = 'badge bg-secondary rounded-circle me-2';
                    }
                }

                // Ocultar opções de frete
                const opcoesFrete = document.getElementById('opcoes-frete');
                if (opcoesFrete) {
                    opcoesFrete.style.display = 'none';
                    opcoesFrete.innerHTML = '';
                }
            }

            function mostrarEtapaComLoading(numeroEtapa, mensagem) {
                console.log(`📋 Mostrando etapa ${numeroEtapa}: ${mensagem}`);

                const etapa = document.getElementById(`etapa-${numeroEtapa}`);
                const spinner = document.getElementById(`spinner-${numeroEtapa}`);
                const textoEtapa = etapa?.querySelector('.text-muted');

                if (etapa) etapa.style.display = 'block';
                if (spinner) spinner.style.display = 'inline-block';
                if (textoEtapa) textoEtapa.textContent = mensagem;
            }

            function concluirEtapa(numeroEtapa, sucesso, status, mensagem) {
                console.log(`${sucesso ? '✅' : '❌'} Etapa ${numeroEtapa}: ${status} - ${mensagem}`);

                const spinner = document.getElementById(`spinner-${numeroEtapa}`);
                const resultado = document.getElementById(`resultado-${numeroEtapa}`);
                const detalhe = document.getElementById(`detalhe-${numeroEtapa}`);
                const badge = document.querySelector(`#etapa-${numeroEtapa} .badge`);

                if (spinner) spinner.style.display = 'none';
                if (resultado) {
                    resultado.style.display = 'inline';
                    resultado.textContent = status;
                    resultado.className = `resultado ms-2 ${sucesso ? 'text-success' : 'text-danger'}`;
                }
                if (detalhe && mensagem) {
                    detalhe.style.display = 'block';
                    detalhe.innerHTML = mensagem;
                }
                if (badge) {
                    badge.className = `badge ${sucesso ? 'bg-success' : 'bg-danger'} rounded-circle me-2`;
                }
            }

            function validarContaEnvioEcomAutomatico() {
                console.log('🔍 Iniciando validação automática da conta EnvioEcom...');

                // Mostrar primeira etapa com loading
                mostrarEtapaComLoading(1, 'Verificando conta EnvioEcom...');

                // Fazer requisição para validar/criar conta
                fetch('/whitelabels/homolog/assets/ajax/pedidos/processar_envioecom.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            acao: 'validar_conta_automatico'
                        })
                    })
                    .then(response => response.json())
                    .then(response => {
                        console.log('🔍 Resposta da validação de conta:', response);

                        if (response.success) {
                            console.log('✅ Conta validada com sucesso:', response);
                            concluirEtapa(1, true, 'Configurada', response.message);

                            // Ir para etapa 2: Atualizar endereço do fornecedor
                            setTimeout(() => {
                                atualizarEnderecoFornecedor();
                            }, 500);

                        } else {
                            console.error('❌ Erro na validação:', response.message);

                            // Verificar se é erro de perfil incompleto
                            if (response.profile_incomplete) {
                                const mensagemComLink = response.message +
                                    '<br><br><a href="/dash/perfil" class="btn btn-primary btn-sm mt-2">' +
                                    '<i class="ti ti-user-edit me-1"></i>Completar Perfil</a>';
                                concluirEtapa(1, false, 'Perfil Incompleto', mensagemComLink);
                            } else {
                                concluirEtapa(1, false, 'Erro', response.message);
                            }
                        }
                    })
                    .catch(error => {
                        console.error('❌ Erro na requisição:', error);
                        concluirEtapa(1, false, 'Erro', 'Falha na comunicação com o servidor');
                    });
            }

            function atualizarEnderecoFornecedor() {
                console.log('📍 Iniciando atualização de endereço do fornecedor...');

                // Mostrar etapa 2 com loading
                mostrarEtapaComLoading(2, 'Configurando endereço do fornecedor...');

                // Obter ID do fornecedor dos dados da venda
                const fornecedor = document.getElementById('etq_fornecedor').value;
                if (!fornecedor) {
                    console.error('❌ Nenhum fornecedor encontrado!');
                    concluirEtapa(2, false, 'Erro', 'Fornecedor não identificado');
                    return;
                }

                console.log('📍 Fornecedor identificado:', fornecedor);

                // Fazer requisição para atualizar endereço
                fetch('/whitelabels/homolog/assets/ajax/pedidos/processar_envioecom.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            acao: 'atualizar_endereco_fornecedor',
                            fornecedor_id: fornecedor
                        })
                    })
                    .then(response => response.json())
                    .then(response => {
                        console.log('📍 Resposta da atualização de endereço:', response);

                        if (response.success) {
                            console.log('✅ Endereço atualizado com sucesso');
                            concluirEtapa(2, true, 'Configurado', response.message);

                            // Ir para etapa 3: Cotação de frete
                            setTimeout(() => {
                                obterCotacaoFrete();
                            }, 500);

                        } else {
                            console.error('❌ Erro na atualização de endereço:', response.message);
                            concluirEtapa(2, false, 'Erro', response.message);
                        }
                    })
                    .catch(error => {
                        console.error('❌ Erro na requisição:', error);
                        concluirEtapa(2, false, 'Erro', 'Falha na comunicação com o servidor');
                    });
            }

            function obterCotacaoFrete() {
                console.log('💰 Iniciando cotação de frete...');

                // Mostrar etapa 3 com loading
                mostrarEtapaComLoading(3, 'Calculando opções de frete...');

                // Coletar dados dos produtos do formulário
                const produtosContainer = document.getElementById('etq_produtos_container');
                const produtos = [];

                // Percorrer todos os produtos no container
                const cardsProdutos = produtosContainer.querySelectorAll('.card');
                cardsProdutos.forEach((card, index) => {
                    const produto = {
                        nome: card.querySelector(`#etq_prod_${index}_nome`)?.value || '',
                        quantidade: parseInt(card.querySelector(`#etq_prod_${index}_quantidade`)?.value) || 1,
                        valor: parseFloat(card.querySelector(`#etq_prod_${index}_valor`)?.value) || 0,
                        peso: parseFloat(card.querySelector(`#etq_prod_${index}_peso`)?.value) || 0,
                        altura: parseFloat(card.querySelector(`#etq_prod_${index}_altura`)?.value) || 0,
                        largura: parseFloat(card.querySelector(`#etq_prod_${index}_largura`)?.value) || 0,
                        comprimento: parseFloat(card.querySelector(`#etq_prod_${index}_comprimento`)?.value) || 0
                    };
                    produtos.push(produto);
                });

                // Coletar dados do destinatário
                const destinatario = {
                    nome: document.getElementById('etq_dest_nome').value,
                    cep: document.getElementById('etq_dest_cep').value,
                    endereco: document.getElementById('etq_dest_endereco').value,
                    numero: document.getElementById('etq_dest_numero').value,
                    bairro: document.getElementById('etq_dest_bairro').value,
                    cidade: document.getElementById('etq_dest_cidade').value,
                    estado: document.getElementById('etq_dest_estado').value,
                    complemento: document.getElementById('etq_dest_complemento').value
                };

                console.log('💰 Produtos para cotação:', produtos);
                console.log('💰 Destinatário:', destinatario);

                // Fazer requisição para obter cotação
                fetch('/whitelabels/homolog/assets/ajax/pedidos/processar_envioecom.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            acao: 'obter_cotacao',
                            produtos: produtos,
                            destinatario: destinatario
                        })
                    })
                    .then(response => response.json())
                    .then(response => {
                        console.log('💰 Resposta da cotação:', response);

                        if (response.success && response.opcoes_frete && response.opcoes_frete.length > 0) {
                            console.log('✅ Cotação obtida com sucesso');
                            concluirEtapa(3, true, 'Calculado', `${response.opcoes_frete.length} opções encontradas`);

                            // Mostrar opções de frete
                            setTimeout(() => {
                                exibirOpcoesFrete(response.opcoes_frete);
                            }, 500);

                        } else {
                            console.error('❌ Erro na cotação:', response.message);
                            concluirEtapa(3, false, 'Erro', response.message || 'Nenhuma opção de frete encontrada');
                        }
                    })
                    .catch(error => {
                        console.error('❌ Erro na requisição:', error);
                        concluirEtapa(3, false, 'Erro', 'Falha na comunicação com o servidor');
                    });
            }

            function exibirOpcoesFrete(opcoes) {
                console.log('🚚 Exibindo opções de frete:', opcoes);

                const container = document.getElementById('lista-opcoes-frete');
                const opcoesFrete = document.getElementById('opcoes-frete');

                if (!container || !opcoesFrete) return;

                container.innerHTML = '';

                opcoes.forEach((opcao, index) => {
                    const opcaoDiv = document.createElement('div');
                    opcaoDiv.className = 'card mb-2';
                    opcaoDiv.innerHTML = `
                <div class="card-body py-2">
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="opcao_frete" id="frete_${index}" value="${index}">
                        <label class="form-check-label d-flex justify-content-between w-100" for="frete_${index}">
                            <div>
                                <strong>${opcao.transportadora || 'Transportadora'}</strong><br>
                                <small class="text-muted">${opcao.servico || 'Serviço padrão'} - ${opcao.prazo || 'N/A'} dias úteis</small>
                            </div>
                            <div class="text-end">
                                <strong class="text-primary">R$ ${opcao.valor || '0,00'}</strong>
                            </div>
                        </label>
                    </div>
                </div>
            `;
                    container.appendChild(opcaoDiv);
                });

                // Adicionar botão de comprar
                const btnComprar = document.createElement('button');
                btnComprar.className = 'btn btn-success mt-3';
                btnComprar.innerHTML = '<i class="ti ti-shopping-cart me-1"></i>Comprar Etiqueta Selecionada';
                btnComprar.addEventListener('click', comprarEtiquetaSelecionada);
                container.appendChild(btnComprar);

                opcoesFrete.style.display = 'block';
            }

            function comprarEtiquetaSelecionada() {
                const opcaoSelecionada = document.querySelector('input[name="opcao_frete"]:checked');

                if (!opcaoSelecionada) {
                    Swal.fire({
                        title: 'Atenção',
                        text: 'Selecione uma opção de frete para continuar',
                        icon: 'warning',
                        confirmButtonText: 'OK'
                    });
                    return;
                }

                console.log('🛒 Comprando etiqueta - opção selecionada:', opcaoSelecionada.value);

                // Aqui você pode implementar a compra da etiqueta
                Swal.fire({
                    title: 'Funcionalidade em Desenvolvimento',
                    text: 'A compra da etiqueta será implementada na próxima versão.',
                    icon: 'info',
                    confirmButtonText: 'OK'
                });
            }
        });

        // ========================================
        // FUNÇÕES DE ETIQUETAS - REPROCESSAMENTO E COMPRA
        // ========================================

        // Função para reprocessar etiqueta
        function reprocessarEtiqueta(saleId, integracao, saleTitle, fornecedor, el) {
            if (!saleId || !saleTitle || !fornecedor) return;

            // Verificar se é um marketplace válido
            if (!marketplaces.includes(integracao)) {
                Swal.fire({
                    title: 'Reprocessamento Não Disponível',
                    text: 'O reprocessamento automático de etiquetas está disponível apenas para marketplaces (Shopee e MercadoLivre).',
                    icon: 'warning',
                    confirmButtonText: 'Entendi'
                });
                return;
            }

            // Verificar timer de 5 minutos via localStorage
            const timerKey = `etiqueta_timer_${saleId}`;
            const lastProcessed = localStorage.getItem(timerKey);

            if (lastProcessed) {
                const timePassed = Date.now() - parseInt(lastProcessed);
                const fiveMinutes = 5 * 60 * 1000; // 5 minutos em ms

                if (timePassed < fiveMinutes) {
                    const remainingMs = fiveMinutes - timePassed;
                    const remainingMin = Math.ceil(remainingMs / 60000);

                    Swal.fire({
                        title: 'Aguarde um momento',
                        html: `Você já reprocessou esta etiqueta recentemente.<br><br>Aguarde <b>${remainingMin} minuto(s)</b> para tentar novamente.`,
                        icon: 'info',
                        confirmButtonText: 'Entendi'
                    });
                    return;
                }
            }

            // Verificar se a venda tem Erro 338A, 388A ou Buffered nas observações
            let observacoes = el.getAttribute('data-observacoes') || '';
            if (!observacoes) {
                const vendaItem = el.closest('.venda-item');
                if (vendaItem) {
                    observacoes = vendaItem.getAttribute('data-observacoes') || '';
                }
            }

            // ⏱️ VALIDAÇÃO BUFFERED - Verificar se está aguardando liberação
            if (observacoes.includes('[Buffered]')) {
                // Extrair data do buffering usando regex (aceita com ou sem horário)
                // Formatos: [Buffered][DD/MM/YYYY] ou [Buffered][DD/MM/YYYY HH:MM]
                const bufferingMatch = observacoes.match(/\[Buffered\]\[(\d{2}\/\d{2}\/\d{4})(?:\s+(\d{2}:\d{2}))?\]/);

                if (bufferingMatch && bufferingMatch[1]) {
                    const dataLiberacao = bufferingMatch[1];
                    const horaLiberacao = bufferingMatch[2] || '12:00'; // Se não tiver hora, usa meio-dia
                    const dataHoraCompleta = bufferingMatch[2] ? `${dataLiberacao} ${horaLiberacao}` : `${dataLiberacao}`;

                    try {
                        // Converter data para timestamp
                        const [dia, mes, ano] = dataLiberacao.split('/');
                        const [hora, minuto] = horaLiberacao.split(':');

                        const dataLiberacaoObj = new Date(ano, mes - 1, dia, hora, minuto);
                        const agora = new Date();

                        // Se ainda não chegou a data de liberação, bloquear reprocessamento
                        if (dataLiberacaoObj > agora) {
                            // Calcular tempo restante
                            const tempoRestante = dataLiberacaoObj - agora;
                            const diasRestantes = Math.floor(tempoRestante / (1000 * 60 * 60 * 24));
                            const horasRestantes = Math.floor((tempoRestante % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                            const minutosRestantes = Math.floor((tempoRestante % (1000 * 60 * 60)) / (1000 * 60));

                            let tempoRestanteTexto = '';
                            if (diasRestantes > 0) {
                                tempoRestanteTexto = `${diasRestantes}d ${horasRestantes}h`;
                            } else if (horasRestantes > 0) {
                                tempoRestanteTexto = `${horasRestantes}h ${minutosRestantes}min`;
                            } else {
                                tempoRestanteTexto = `${minutosRestantes}min`;
                            }

                            Swal.fire({
                                title: '⏱️ Etiqueta em Buffering',
                                html: `
                                    <div class="text-start">
                                        <p><strong>O Mercado Livre ainda não liberou esta etiqueta.</strong></p>
                                        <hr>
                                        <p><i class="ti ti-calendar me-2"></i><strong>Data de Liberação:</strong> ${dataLiberacao}</p>
                                        <p><i class="ti ti-clock me-2"></i><strong>Tempo Restante:</strong> ${tempoRestanteTexto}</p>
                                        <hr>
                                        <p class="text-muted small">
                                            <i class="ti ti-info-circle me-2"></i>
                                            O sistema tentará reprocessar automaticamente quando a etiqueta for liberada.
                                            Você não precisa fazer nada.
                                        </p>
                                    </div>
                                `,
                                icon: 'info',
                                confirmButtonText: 'Entendi',
                                confirmButtonColor: '#0d6efd'
                            });
                            return;
                        } else {
                            // Data de liberação já passou, permitir reprocessamento
                            console.log('✅ Data de liberação do buffering já passou, permitindo reprocessamento');
                        }
                    } catch (e) {
                        console.error('⚠️ Erro ao validar data de buffering:', e);
                    }
                } else {
                    // Se tem [Buffered] mas não conseguiu extrair data, bloquear por segurança
                    Swal.fire({
                        title: '⏱️ Etiqueta em Buffering',
                        html: `
                            <p>O Mercado Livre ainda não liberou esta etiqueta.</p>
                            <p class="text-muted small">Aguarde alguns minutos e tente novamente.</p>
                        `,
                        icon: 'info',
                        confirmButtonText: 'Entendi'
                    });
                    return;
                }
            }

            if (observacoes.includes('Erro 388A')) {
                Swal.fire({
                    title: 'Reprocessamento Bloqueado',
                    html: '<b>Este pedido já foi enviado ao cliente.</b><br><br>Não é possível reprocessar a etiqueta.<br><br><small class="text-muted">Consulte as observações para mais detalhes.</small>',
                    icon: 'error',
                    confirmButtonText: 'Entendi'
                });
                return;
            }

            if (observacoes.includes('Erro 338A')) {
                Swal.fire({
                    title: 'Reprocessamento Bloqueado',
                    text: 'Esta etiqueta possui Erro 338A e não pode ser reprocessada automaticamente. Verifique manualmente no painel do MercadoLivre.',
                    icon: 'warning',
                    confirmButtonText: 'Entendi'
                });
                return;
            }

            // ⚠️ NOVO: Verificar se precisa combinar envio com fornecedor (Shipping ID não encontrado)
            if (observacoes.includes('combinar o envio com o fornecedor') ||
                observacoes.includes('Esta venda está para combinar o envio com o fornecedor')) {
                Swal.fire({
                    title: 'Reprocessamento Bloqueado',
                    html: '<b>Esta venda está para combinar o envio com o fornecedor.</b><br><br>Envie a etiqueta manualmente.<br><br><small class="text-muted">Se acha que foi um engano, por favor nos informe!</small>',
                    icon: 'warning',
                    confirmButtonText: 'Entendi'
                });
                return;
            }

            // Fechar menu mobile se estiver aberto
            closeMobileMenu();

            // Mostrar confirmação
            Swal.fire({
                title: 'Reprocessar Etiqueta',
                html: `Deseja adicionar <b>${saleTitle}</b> na fila de processamento de etiquetas?<br><br><small class="text-muted">A etiqueta será processada pelo worker em segundo plano.</small>`,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sim, reprocessar!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Mostrar loading
                    const originalText = el.innerHTML;
                    el.innerHTML = '<i class="ti ti-loader-2 ti-spin me-1"></i>Adicionando...';
                    el.style.pointerEvents = 'none';
                    el.disabled = true;

                    // Normalizar nome da plataforma
                    let plataforma = integracao;
                    if (integracao === 'mercado_livre' || integracao === 'mercado livre') {
                        plataforma = 'mercado_livre';
                    }

                    // Criar job na tabela jobs_etiquetas
                    fetch('../../assets/ajax/etiquetas/criar_job_etiqueta.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded'
                            },
                            body: new URLSearchParams({
                                sale_title: saleTitle,
                                fornecedor: fornecedor,
                                plataforma: plataforma
                            })
                        })
                        .then(res => res.json())
                        .then(data => {
                            if (data.success) {
                                // Salvar timestamp no localStorage
                                localStorage.setItem(timerKey, Date.now().toString());

                                // Atualizar etiqueta_ml para 'processing_label'
                                fetch('../../assets/ajax/vendas/atualizar_status_etiqueta.php', {
                                    method: 'POST',
                                    headers: {
                                        'Content-Type': 'application/x-www-form-urlencoded'
                                    },
                                    body: new URLSearchParams({
                                        sale_id: saleId,
                                        status: 'processing_label'
                                    })
                                });

                                Swal.fire({
                                    title: 'Sucesso!',
                                    html: `Etiqueta adicionada à fila de processamento!<br><br><small class="text-muted">O worker processará em breve.</small>`,
                                    icon: 'success',
                                    timer: 3000,
                                    showConfirmButton: false
                                }).then(() => {
                                    location.reload();
                                });
                            } else {
                                // Verificar se é erro de buffering
                                if (data.error_code === 'BUFFERED' || data.error_code === 'BUFFERED_WAITING') {
                                    const dataLiberacao = data.buffering_date || 'em breve';
                                    Swal.fire({
                                        title: '⏱️ Etiqueta em Buffering',
                                        html: `
                                        <div class="text-start">
                                            <p><strong>O Mercado Livre ainda não liberou esta etiqueta.</strong></p>
                                            <hr>
                                            <p><i class="ti ti-calendar me-2"></i><strong>Previsão de Liberação:</strong> ${dataLiberacao}</p>
                                            <hr>
                                            <p class="text-muted small">
                                                <i class="ti ti-info-circle me-2"></i>
                                                O sistema tentará reprocessar automaticamente quando disponível.
                                            </p>
                                        </div>
                                    `,
                                        icon: 'info',
                                        confirmButtonText: 'Entendi',
                                        confirmButtonColor: '#0d6efd'
                                    }).then(() => {
                                        if (data.reload) {
                                            location.reload();
                                        }
                                    });
                                } else {
                                    Swal.fire('Erro', data.message || 'Erro ao criar job de etiqueta.', 'error');
                                }
                            }
                        })
                        .catch(error => {
                            console.error('Erro:', error);
                            Swal.fire('Erro', 'Erro de conexão ao criar job.', 'error');
                        })
                        .finally(() => {
                            el.innerHTML = originalText;
                            el.style.pointerEvents = 'auto';
                            el.disabled = false;
                        });
                }
            });
        }

        // Função para comprar etiqueta (placeholder)
        function comprarEtiquetaSimples(saleId, integracao, saleTitle, fornecedor, el) {
            if (!saleId || !saleTitle || !fornecedor) return;

            // Verificar se é um ecommerce válido
            if (!ecommerces.includes(integracao)) {
                Swal.fire({
                    title: 'Compra Não Disponível',
                    text: 'A compra de etiquetas está disponível apenas para vendas de ecommerce.',
                    icon: 'warning',
                    confirmButtonText: 'Entendi'
                });
                return;
            }

            Swal.fire({
                title: 'Funcionalidade em Desenvolvimento',
                text: 'A compra de etiquetas será implementada em breve.',
                icon: 'info',
                confirmButtonText: 'OK'
            });
        }
    </script>

    <!-- Modal Importar Vendas -->
    <div class="modal fade" id="modalImportarVendas" tabindex="-1" aria-labelledby="modalImportarVendasLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalImportarVendasLabel">
                        <i class="ti ti-search me-2"></i>Buscar Vendas
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Etapa 1: Seleção de Marketplace -->
                    <div id="stepSelectMarketplace">
                        <h6 class="mb-3">Selecione o Marketplace:</h6>
                        <div class="row g-3">
                            <div class="col-6">
                                <button type="button" class="btn btn-outline-primary w-100 h-100 py-4" onclick="selectMarketplace('shopee')">
                                    <i class="ti ti-shopping-cart mb-2" style="font-size: 2rem;"></i><br>
                                    <strong>Shopee</strong>
                                </button>
                            </div>
                            <div class="col-6">
                                <button type="button" class="btn btn-outline-success w-100 h-100 py-4" onclick="selectMarketplace('mercado_livre')">
                                    <i class="ti ti-tag mb-2" style="font-size: 2rem;"></i><br>
                                    <strong>Mercado Livre</strong>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Etapa 2: Seleção de Loja -->
                    <div id="stepSelectLoja" style="display: none;">
                        <button type="button" class="btn btn-sm btn-link mb-3 p-0" onclick="backToMarketplaceSelection()">
                            <i class="ti ti-arrow-left"></i> Voltar
                        </button>
                        <h6 class="mb-3" id="lojaStepTitle">Selecione a Loja:</h6>
                        
                        <!-- Loading -->
                        <div id="lojasLoading" class="text-center py-4">
                            <div class="spinner-border text-primary" role="status">
                                <span class="visually-hidden">Carregando lojas...</span>
                            </div>
                            <p class="mt-2 text-muted">Carregando suas lojas...</p>
                        </div>
                        
                        <!-- Container de Lojas -->
                        <div id="lojasContainer" style="display: none;">
                            <select id="selectLoja" class="form-select form-select-lg mb-3" required>
                                <option value="">Selecione uma loja...</option>
                            </select>
                            <button type="button" class="btn btn-primary w-100" onclick="confirmLojaAndShowForm()">
                                Continuar <i class="ti ti-arrow-right ms-1"></i>
                            </button>
                        </div>
                        
                        <!-- Erro -->
                        <div id="lojasError" class="alert alert-warning" style="display: none;">
                            <i class="ti ti-alert-circle me-2"></i>
                            <span id="lojasErrorMessage"></span>
                        </div>
                    </div>

                    <!-- Etapa 3: Formulário de Importação -->
                    <div id="stepImportForm" style="display: none;">
                        <button type="button" class="btn btn-sm btn-link mb-3 p-0" onclick="backToLojaSelection()">
                            <i class="ti ti-arrow-left"></i> Voltar
                        </button>
                        
                        <div class="alert alert-info mb-3">
                            <strong id="marketplaceInfo"></strong>
                            <br><small id="lojaInfo" class="text-muted"></small>
                        </div>

                        <form id="formImportarVendas">
                            <input type="hidden" id="marketplaceType" name="marketplace">
                            <input type="hidden" id="lojaId" name="loja_id">
                            <input type="hidden" id="lojaSellerId" name="seller_id">
                            <input type="hidden" id="lojaFornecedor" name="fornecedor">

                            <div class="mb-3">
                                <label for="orderIdImport" class="form-label fw-semibold">Código do Pedido:</label>
                                <input type="text" 
                                       class="form-control form-control-lg" 
                                       id="orderIdImport" 
                                       name="order_id" 
                                       placeholder="Ex: 123456789" 
                                       required>
                                <small class="form-text text-muted">
                                    Insira o código completo do pedido
                                </small>
                            </div>

                            <div id="importResult" class="alert" style="display: none;"></div>

                            <button type="submit" class="btn btn-primary w-100" id="btnIniciarImportacao">
                                <i class="ti ti-search me-2"></i>Buscar Vendas
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Resultado da Importação -->
    <div class="modal fade" id="modalResultadoImportacao" tabindex="-1" aria-labelledby="modalResultadoImportacaoLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-success text-white" id="resultModalHeader">
                    <h5 class="modal-title" id="modalResultadoImportacaoLabel">
                        <i class="ti ti-check-circle me-2"></i>Resultado
                    </h5>
                    <button type="button" class="btn-close btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="resultModalBody">
                    <!-- Conteúdo dinâmico -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" onclick="location.reload()">
                        <i class="ti ti-refresh me-2"></i>Ver Vendas
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Controle do botão flutuante (igual ao baixar_etiquetas.php)
        document.addEventListener('DOMContentLoaded', function() {
            const btnImportarVendas = document.getElementById('btnImportarVendas');

            function handleScroll() {
                if (!btnImportarVendas) return;

                // Se rolou mais que 200px, torna flutuante
                if (window.scrollY > 200) {
                    if (!btnImportarVendas.classList.contains('floating-import-btn')) {
                        btnImportarVendas.classList.add('floating-import-btn');
                    }
                } else {
                    if (btnImportarVendas.classList.contains('floating-import-btn')) {
                        btnImportarVendas.classList.remove('floating-import-btn');
                    }
                }
            }

            window.addEventListener('scroll', handleScroll);
        });

        // Variável global para armazenar o marketplace selecionado
        let selectedMarketplace = '';
        let selectedLojaData = null;

        // Função para selecionar marketplace
        function selectMarketplace(marketplace) {
            selectedMarketplace = marketplace;

            // Ocultar seleção de marketplace e mostrar seleção de loja
            document.getElementById('stepSelectMarketplace').style.display = 'none';
            document.getElementById('stepSelectLoja').style.display = 'block';

            // Atualizar título
            const marketplaceName = marketplace === 'shopee' ? 'Shopee' : 'Mercado Livre';
            document.getElementById('lojaStepTitle').textContent = `Selecione a Loja (${marketplaceName}):`;

            // Carregar lojas
            carregarLojas(marketplace);
        }

        // Função para carregar lojas do usuário
        function carregarLojas(marketplace) {
            const lojasLoading = document.getElementById('lojasLoading');
            const lojasContainer = document.getElementById('lojasContainer');
            const lojasError = document.getElementById('lojasError');
            const selectLoja = document.getElementById('selectLoja');

            // Mostrar loading
            lojasLoading.style.display = 'block';
            lojasContainer.style.display = 'none';
            lojasError.style.display = 'none';

            // Limpar select
            selectLoja.innerHTML = '<option value="">Selecione uma loja...</option>';

            // Buscar whitelabel do contexto PHP
            const whitelabel = '<?= Config::get('database.dbname') ?>';

            // Usuario Logado
            const user_id = '<?= $_SESSION['usuario']['id_usuario'] ?>';

            // Fazer requisição para buscar lojas
            fetch('../../assets/ajax/vendas/buscar_lojas_usuario.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `plataforma=${encodeURIComponent(marketplace)}&whitelabel=${encodeURIComponent(whitelabel)}&user_id=${encodeURIComponent(user_id)}`
            })
            .then(response => response.json())
            .then(data => {
                lojasLoading.style.display = 'none';

                if (data.success && data.lojas && data.lojas.length > 0) {
                    // Preencher select com as lojas
                    data.lojas.forEach(loja => {
                        const option = document.createElement('option');
                        option.value = loja.id;
                        option.textContent = `${loja.tipo} - ${loja.nome}`;
                        option.setAttribute('data-seller-id', loja.seller_id);
                        option.setAttribute('data-fornecedor', loja.fornecedor);
                        option.setAttribute('data-nome', loja.nome);
                        selectLoja.appendChild(option);
                    });

                    lojasContainer.style.display = 'block';
                } else {
                    // Mostrar erro
                    lojasError.style.display = 'block';
                    document.getElementById('lojasErrorMessage').textContent = 
                        data.message || 'Nenhuma loja encontrada. Conecte uma loja primeiro.';
                }
            })
            .catch(error => {
                console.error('Erro ao carregar lojas:', error);
                lojasLoading.style.display = 'none';
                lojasError.style.display = 'block';
                document.getElementById('lojasErrorMessage').textContent = 
                    'Erro ao carregar lojas. Tente novamente.';
            });
        }

        // Função para confirmar loja e mostrar formulário
        function confirmLojaAndShowForm() {
            const selectLoja = document.getElementById('selectLoja');
            const lojaId = selectLoja.value;

            if (!lojaId) {
                if (typeof toastAlert === 'function') {
                    toastAlert('Selecione uma loja primeiro', '#dc3545', 3000, null, null, 'right-top');
                } else {
                    alert('Selecione uma loja primeiro');
                }
                return;
            }

            // Obter dados da loja selecionada
            const selectedOption = selectLoja.options[selectLoja.selectedIndex];
            const sellerId = selectedOption.getAttribute('data-seller-id');
            const fornecedor = selectedOption.getAttribute('data-fornecedor');
            const nomeLoja = selectedOption.getAttribute('data-nome');

            selectedLojaData = {
                id: lojaId,
                seller_id: sellerId,
                fornecedor: fornecedor,
                nome: nomeLoja
            };

            // Ocultar seleção de loja e mostrar formulário
            document.getElementById('stepSelectLoja').style.display = 'none';
            document.getElementById('stepImportForm').style.display = 'block';

            // Atualizar informações no formulário
            const marketplaceInfo = document.getElementById('marketplaceInfo');
            const lojaInfo = document.getElementById('lojaInfo');
            const marketplaceType = document.getElementById('marketplaceType');

            if (selectedMarketplace === 'shopee') {
                marketplaceInfo.textContent = 'Importação via Shopee';
            } else if (selectedMarketplace === 'mercado_livre') {
                marketplaceInfo.textContent = 'Importação via Mercado Livre';
            }

            lojaInfo.textContent = `Loja: ${nomeLoja}`;
            marketplaceType.value = selectedMarketplace;

            // Preencher campos hidden
            document.getElementById('lojaId').value = lojaId;
            document.getElementById('lojaSellerId').value = sellerId;
            document.getElementById('lojaFornecedor').value = fornecedor;

            // Limpar campo de input e resultado
            document.getElementById('orderIdImport').value = '';
            document.getElementById('importResult').style.display = 'none';
        }

        // Função para voltar à seleção de marketplace
        function backToMarketplaceSelection() {
            document.getElementById('stepSelectLoja').style.display = 'none';
            document.getElementById('stepSelectMarketplace').style.display = 'block';
            selectedMarketplace = '';
            selectedLojaData = null;
        }

        // Função para voltar à seleção de loja
        function backToLojaSelection() {
            document.getElementById('stepImportForm').style.display = 'none';
            document.getElementById('stepSelectLoja').style.display = 'block';
            selectedLojaData = null;
        }

        // Reset modal ao fechar
        document.getElementById('modalImportarVendas').addEventListener('hidden.bs.modal', function() {
            // Resetar para primeira etapa
            document.getElementById('stepSelectMarketplace').style.display = 'block';
            document.getElementById('stepSelectLoja').style.display = 'none';
            document.getElementById('stepImportForm').style.display = 'none';
            
            // Limpar variáveis
            selectedMarketplace = '';
            selectedLojaData = null;
            
            // Resetar formulário
            document.getElementById('formImportarVendas').reset();
            document.getElementById('importResult').style.display = 'none';
        });

        // Refresh ao fechar modal de resultado (somente se for sucesso)
        document.getElementById('modalResultadoImportacao').addEventListener('hidden.bs.modal', function() {
            const header = document.getElementById('resultModalHeader');
            // Se o header tiver classe de sucesso, dar refresh
            if (header.classList.contains('bg-success')) {
                location.reload();
            }
        });

        // Submeter formulário de importação
        document.getElementById('formImportarVendas').addEventListener('submit', function(e) {
            e.preventDefault();

            const orderId = document.getElementById('orderIdImport').value.trim();
            const marketplace = document.getElementById('marketplaceType').value;
            const lojaId = document.getElementById('lojaId').value;
            const sellerId = document.getElementById('lojaSellerId').value;
            const fornecedor = document.getElementById('lojaFornecedor').value;
            const btnSubmit = document.getElementById('btnIniciarImportacao');
            const resultDiv = document.getElementById('importResult');

            if (!orderId) {
                resultDiv.innerHTML = '<div class="alert alert-warning"><i class="ti ti-alert-triangle me-2"></i>Por favor, insira o código do pedido.</div>';
                resultDiv.style.display = 'block';
                return;
            }

            if (!lojaId || !sellerId || !fornecedor) {
                resultDiv.innerHTML = '<div class="alert alert-warning"><i class="ti ti-alert-triangle me-2"></i>Dados da loja incompletos. Volte e selecione novamente.</div>';
                resultDiv.style.display = 'block';
                return;
            }

            // Desabilitar botão e mostrar loading
            btnSubmit.disabled = true;
            btnSubmit.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Buscando...';

            // Definir endpoint baseado no marketplace
            let endpoint = '';
            if (marketplace === 'shopee') {
                endpoint = '../../assets/ajax/plataformas/shopee/importar_vendas.php';
            } else if (marketplace === 'mercado_livre') {
                endpoint = '../../assets/ajax/plataformas/mercado_livre/importar_vendas.php';
            }

            // Preparar dados para envio
            const formData = new FormData();
            formData.append('order_id', orderId);
            formData.append('marketplace', marketplace);
            formData.append('loja_id', lojaId);
            formData.append('seller_id', sellerId);
            formData.append('fornecedor', fornecedor);

            // Fazer requisição AJAX
            fetch(endpoint, {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    console.log('Resposta da API:', data);
                    
                    if (data.success) {
                        // Esconder completamente o botão de buscar
                        btnSubmit.style.display = 'none';
                        btnSubmit.classList.add('d-none');
                        
                        // Verificar se retornou múltiplos pedidos (pack_id)
                        if (data.total_pedidos && data.total_pedidos > 1) {
                            // Pack com múltiplos pedidos
                            let htmlPedidos = `
                                <div class="alert alert-success">
                                    <i class="ti ti-check-circle me-2"></i>
                                    <strong>${data.message}</strong>
                                </div>
                                
                                <!-- Informações do Pack -->
                                <div class="card mb-3">
                                    <div class="card-header">
                                        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
                                            <h6 class="mb-0">
                                                <i class="ti ti-box me-2"></i>Pack ID: ${data.pack_id}
                                            </h6>
                                            <span class="badge bg-label-primary">${data.total_pedidos} pedidos</span>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <div class="d-flex align-items-start">
                                                <i class="ti ti-building-store me-2 mt-1"></i>
                                                <div>
                                                    <small class="text-muted d-block">Loja</small>
                                                    <strong>${data.loja.nome}</strong>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <hr class="my-3">
                                        
                                        <h6 class="mb-3">
                                            <i class="ti ti-shopping-cart me-2"></i>Produtos do Pack
                                        </h6>
                            `;

                            let valorTotal = 0;
                            let pedidoIndex = 0;
                            
                            data.pedidos.forEach(pedido => {
                                pedidoIndex++;
                                
                                htmlPedidos += `
                                    <div class="mb-3">
                                        <div class="d-flex align-items-center mb-2 gap-2">
                                            <span class="badge bg-label-secondary">Pedido ${pedidoIndex}</span>
                                            <code>${pedido.order_id}</code>
                                        </div>
                                `;
                                
                                pedido.items.forEach(item => {
                                    const itemTitle = item.item_name || item.title || 'Produto sem nome';
                                    const itemSku = item.item_sku || item.model_sku || item.seller_sku || 'N/A';
                                    const itemQty = item.quantity || 1;
                                    const unitPrice = item.discounted_price || item.unit_price || 0;
                                    const itemImage = item.product_image || null;
                                    
                                    const subtotal = parseFloat(unitPrice) * parseInt(itemQty);
                                    valorTotal += subtotal;
                                    
                                    htmlPedidos += `
                                        <div class="card border mb-2">
                                            <div class="card-body p-2">
                                                <div class="row align-items-center g-2">
                                                    ${itemImage ? `
                                                    <div class="col-auto">
                                                        <img src="${itemImage}" 
                                                             alt="Produto" 
                                                             class="rounded border" 
                                                             style="width: 50px; height: 50px; object-fit: cover;">
                                                    </div>` : ''}
                                                    <div class="col">
                                                        <div class="fw-semibold small">${itemTitle}</div>
                                                        <div class="d-flex flex-wrap gap-2 align-items-center" style="font-size: 0.75rem;">
                                                            <span class="text-muted">
                                                                <i class="ti ti-barcode"></i> <code>${itemSku}</code>
                                                            </span>
                                                            <span class="badge bg-label-primary">${itemQty}x</span>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto">
                                                        <div class="text-end">
                                                            <div class="text-success fw-semibold small">R$ ${parseFloat(unitPrice).toFixed(2)}</div>
                                                            ${itemQty > 1 ? `
                                                            <div class="text-muted" style="font-size: 0.7rem;">
                                                                Total: R$ ${subtotal.toFixed(2)}
                                                            </div>` : ''}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    `;
                                });
                                
                                htmlPedidos += `
                                    </div>
                                `;
                            });

                            htmlPedidos += `
                                        <!-- Total do Pack -->
                                        <div class="alert alert-info mb-0">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <h5 class="mb-0">Total do Pack</h5>
                                                <h4 class="mb-0 text-success">R$ ${valorTotal.toFixed(2)}</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Botões de Ação -->
                                <div class="d-grid gap-2">
                                    <button class="btn btn-success btn-lg" id="btnConfirmarImportacao" onclick='confirmarImportacaoML(${JSON.stringify(data).replace(/'/g, "\\'").replace(/"/g, "&quot;")})'>
                                        <i class="ti ti-check me-2"></i>Confirmar e Importar ${data.total_pedidos} Pedidos
                                    </button>
                                    <button class="btn btn-outline-secondary" onclick="cancelarImportacao()">
                                        <i class="ti ti-x me-1"></i>Cancelar
                                    </button>
                                </div>
                            `;

                            resultDiv.innerHTML = htmlPedidos;
                            resultDiv.style.display = 'block';
                        } else {
                            // Pedido único
                            const pedido = data.pedidos[0];
                            let valorTotal = 0;
                            
                            // Detectar se é Shopee ou Mercado Livre pela estrutura dos dados
                            const isShopee = pedido.order_status !== undefined;
                            const statusDisplay = isShopee ? pedido.order_status : pedido.status;
                            const statusBadgeClass = statusDisplay === 'PROCESSED' || statusDisplay === 'paid' ? 'bg-success' : 'bg-info';
                            
                            let htmlPedido = `
                                <div class="alert alert-success">
                                    <i class="ti ti-check-circle me-2"></i>
                                    <strong>${data.message}</strong>
                                </div>
                                
                                <!-- Informações do Pedido -->
                                <div class="card mb-3">
                                    <div class="card-header">
                                        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
                                            <h6 class="mb-0">
                                                <i class="ti ti-package me-2"></i>${pedido.order_id}
                                            </h6>
                                            <span class="badge ${statusBadgeClass}">${statusDisplay || 'N/A'}</span>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <!-- Info Geral -->
                                        <div class="row g-3 mb-3">
                                            <div class="col-12 col-md-6">
                                                <div class="d-flex align-items-start">
                                                    <i class="ti ti-building-store me-2 mt-1"></i>
                                                    <div>
                                                        <small class="text-muted d-block">Loja</small>
                                                        <strong>${data.loja.nome}</strong>
                                                    </div>
                                                </div>
                                            </div>
                                            ${pedido.pack_id ? `
                                            <div class="col-12 col-md-6">
                                                <div class="d-flex align-items-start">
                                                    <i class="ti ti-box me-2 mt-1"></i>
                                                    <div>
                                                        <small class="text-muted d-block">Pack ID</small>
                                                        <strong>${pedido.pack_id}</strong>
                                                    </div>
                                                </div>
                                            </div>` : ''}
                                            ${isShopee && pedido.buyer_username ? `
                                            <div class="col-12 col-md-6">
                                                <div class="d-flex align-items-start">
                                                    <i class="ti ti-user me-2 mt-1"></i>
                                                    <div>
                                                        <small class="text-muted d-block">Comprador</small>
                                                        <strong>${pedido.buyer_username}</strong>
                                                    </div>
                                                </div>
                                            </div>` : ''}
                                        </div>
                                        
                                        <hr class="my-3">
                                        
                                        <!-- Produtos -->
                                        <h6 class="mb-3">
                                            <i class="ti ti-shopping-cart me-2"></i>Produtos
                                        </h6>
                            `;

                            pedido.items.forEach((item, index) => {
                                const itemTitle = item.item_name || item.title || 'Produto sem nome';
                                const itemSku = item.item_sku || item.model_sku || item.seller_sku || 'N/A';
                                const itemQty = item.quantity || 1;
                                const unitPrice = item.discounted_price || item.unit_price || 0;
                                const itemImage = item.product_image || null;
                                
                                const subtotal = parseFloat(unitPrice) * parseInt(itemQty);
                                valorTotal += subtotal;
                                
                                htmlPedido += `
                                    <div class="card border mb-2">
                                        <div class="card-body p-3">
                                            <div class="row align-items-center g-2">
                                                ${itemImage ? `
                                                <div class="col-auto">
                                                    <img src="${itemImage}" 
                                                         alt="Produto" 
                                                         class="rounded border" 
                                                         style="width: 60px; height: 60px; object-fit: cover;">
                                                </div>` : ''}
                                                <div class="col">
                                                    <h6 class="mb-1">${itemTitle}</h6>
                                                    <div class="d-flex flex-wrap gap-2 align-items-center">
                                                        <small class="text-muted">
                                                            <i class="ti ti-barcode"></i> SKU: <code>${itemSku}</code>
                                                        </small>
                                                        <span class="badge bg-label-primary">
                                                            ${itemQty}x
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="col-12 col-md-auto text-end">
                                                    <div>
                                                        <small class="text-muted d-block">Unitário</small>
                                                        <div class="h6 mb-0 text-success">R$ ${parseFloat(unitPrice).toFixed(2)}</div>
                                                        ${itemQty > 1 ? `
                                                        <small class="text-muted">Subtotal: <strong>R$ ${subtotal.toFixed(2)}</strong></small>
                                                        ` : ''}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                `;
                            });

                            htmlPedido += `
                                        <!-- Total -->
                                        <div class="alert alert-info mt-3 mb-0">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <h5 class="mb-0">Total do Pedido</h5>
                                                <h4 class="mb-0 text-success">R$ ${valorTotal.toFixed(2)}</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Botões de Ação -->
                                <div class="d-grid gap-2">
                                    <button class="btn btn-success btn-lg" id="btnConfirmarImportacao" onclick='confirmarImportacaoML(${JSON.stringify(data).replace(/'/g, "\\'").replace(/"/g, "&quot;")})'>
                                        <i class="ti ti-check me-2"></i>Confirmar e Importar Pedido
                                    </button>
                                    <button class="btn btn-outline-secondary" onclick="cancelarImportacao()">
                                        <i class="ti ti-x me-1"></i>Cancelar
                                    </button>
                                </div>
                            `;

                            resultDiv.innerHTML = htmlPedido;
                            resultDiv.style.display = 'block';
                        }
                    } else {
                        // Em caso de erro, mostrar botão novamente
                        btnSubmit.style.display = 'block';
                        btnSubmit.classList.remove('d-none');
                        btnSubmit.disabled = false;
                        btnSubmit.innerHTML = '<i class="ti ti-search me-2"></i>Buscar Vendas';
                        resultDiv.innerHTML = '<div class="alert alert-danger"><i class="ti ti-x me-2"></i>' + (data.message || 'Erro ao buscar venda.') + '</div>';
                        resultDiv.style.display = 'block';
                    }
                })
                .catch(error => {
                    console.error('Erro na importação:', error);
                    // Em caso de erro, mostrar botão novamente
                    btnSubmit.style.display = 'block';
                    btnSubmit.classList.remove('d-none');
                    btnSubmit.disabled = false;
                    btnSubmit.innerHTML = '<i class="ti ti-search me-2"></i>Buscar Vendas';
                    resultDiv.innerHTML = '<div class="alert alert-danger"><i class="ti ti-x me-2"></i>Erro ao processar requisição.</div>';
                    resultDiv.style.display = 'block';
                });
        });

        // Função para processar a importação final dos dados do Mercado Livre
        function processarImportacaoML(data) {
            console.log('Processando importação ML:', data);

            Swal.fire({
                title: 'Importando pedido(s)...',
                html: 'Aguarde enquanto processamos os dados',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            // Aqui você pode adicionar a lógica para salvar no banco de dados
            // Por enquanto, vou apenas simular e mostrar os dados
            setTimeout(() => {
                Swal.fire({
                    icon: 'success',
                    title: 'Pedido(s) Importado(s)!',
                    html: `
                        <p><strong>Total de pedidos:</strong> ${data.total_pedidos}</p>
                        <p><strong>Pack ID:</strong> ${data.pack_id || 'N/A'}</p>
                        <p class="text-muted small">Os dados foram processados com sucesso.</p>
                    `,
                    confirmButtonText: 'Recarregar Página'
                }).then(() => {
                    location.reload();
                });
            }, 2000);
        }

        // Função para confirmar a importação
        function confirmarImportacaoML(dataStr) {
            // Parse do JSON escapado
            const data = typeof dataStr === 'string' ? JSON.parse(dataStr.replace(/&quot;/g, '"')) : dataStr;
            
            console.log('Confirmando importação:', data);

            const btnConfirmar = document.getElementById('btnConfirmarImportacao');
            if (btnConfirmar) {
                btnConfirmar.disabled = true;
                btnConfirmar.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Importando...';
            }

            // IMEDIATAMENTE minimizar modal de importação e fechar qualquer SweetAlert
            const modalImportar = bootstrap.Modal.getInstance(document.getElementById('modalImportarVendas'));
            if (modalImportar) {
                modalImportar.hide();
            }
            
            // Fechar qualquer SweetAlert aberto
            Swal.close();
            
            // Remover backdrops do SweetAlert
            const backdrops = document.querySelectorAll('.swal2-container');
            backdrops.forEach(backdrop => backdrop.remove());

            // Configurar e mostrar modal de processamento
            setTimeout(() => {
                const resultHeader = document.getElementById('resultModalHeader');
                const resultBody = document.getElementById('resultModalBody');
                
                resultHeader.className = 'modal-header bg-info text-white';
                resultHeader.querySelector('.modal-title').innerHTML = '<i class="ti ti-loader me-2"></i>Processando...';
                
                resultBody.innerHTML = `
                    <div class="text-center py-4">
                        <div class="spinner-border text-primary mb-3" role="status" style="width: 3rem; height: 3rem;">
                            <span class="visually-hidden">Carregando...</span>
                        </div>
                        <h5>Importando Pedido(s)</h5>
                        <p class="text-muted">Processando dados do Mercado Livre...</p>
                        <div class="progress mt-3" style="height: 25px;">
                            <div class="progress-bar progress-bar-striped progress-bar-animated bg-success" 
                                 role="progressbar" 
                                 id="importProgressBar"
                                 style="width: 0%">
                                <span id="progressText">0%</span>
                            </div>
                        </div>
                        <p class="mt-3 text-muted small" id="progressStatus">Iniciando importação...</p>
                    </div>
                `;
                
                // Esconder footer durante processamento
                document.querySelector('#modalResultadoImportacao .modal-footer').style.display = 'none';
                
                // Mostrar modal de resultado em modo "processando"
                const modalResultado = new bootstrap.Modal(document.getElementById('modalResultadoImportacao'), {
                    backdrop: 'static',
                    keyboard: false
                });
                modalResultado.show();
                
                // Iniciar animação de progresso
                let progress = 0;
                const progressBar = document.getElementById('importProgressBar');
                const progressText = document.getElementById('progressText');
                const progressStatus = document.getElementById('progressStatus');
                
                const timerInterval = setInterval(() => {
                    progress += 5;
                    if (progress <= 100) {
                        progressBar.style.width = progress + '%';
                        progressText.textContent = progress + '%';
                        
                        // Atualizar mensagens de status
                        if (progress <= 20) {
                            progressStatus.textContent = 'Validando dados...';
                        } else if (progress <= 40) {
                            progressStatus.textContent = 'Buscando preços de custo...';
                        } else if (progress <= 60) {
                            progressStatus.textContent = 'Calculando totais...';
                        } else if (progress <= 80) {
                            progressStatus.textContent = 'Salvando no banco de dados...';
                        } else {
                            progressStatus.textContent = 'Finalizando importação...';
                        }
                    }
                }, 200);

                // Detectar plataforma (Shopee tem order_status, ML tem status)
                const isShopee = data.pedidos && data.pedidos[0] && data.pedidos[0].order_status !== undefined;
                const endpoint = isShopee 
                    ? '../../assets/ajax/plataformas/shopee/salvar_importacao.php'
                    : '../../assets/ajax/plataformas/mercado_livre/salvar_importacao.php';
                
                console.log('Plataforma detectada:', isShopee ? 'Shopee' : 'Mercado Livre');
                console.log('Endpoint:', endpoint);

                // Fazer requisição para salvar no banco
                fetch(endpoint, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(data)
                })
                .then(response => response.json())
                .then(result => {
                    clearInterval(timerInterval);
                    
                    // Log completo do resultado
                    console.log('=== RESULTADO DA IMPORTAÇÃO ===');
                    console.log(result);
                    
                    // Mostrar logs de debug de forma legível
                    if (result.debug && Array.isArray(result.debug)) {
                        console.log('\n=== DEBUG DETALHADO ===');
                        result.debug.forEach(log => console.log(log));
                        console.log('======================\n');
                    }
                    
                    if (result.success) {
                        // Completar barra de progresso
                        const progressBar = document.getElementById('importProgressBar');
                        const progressText = document.getElementById('progressText');
                        const progressStatus = document.getElementById('progressStatus');
                        
                        if (progressBar) {
                            progressBar.style.width = '100%';
                            progressText.textContent = '100%';
                            progressStatus.textContent = 'Concluído!';
                        }
                        
                        // Atualizar modal que já está aberto para mostrar sucesso
                        setTimeout(() => {
                            const resultHeader = document.getElementById('resultModalHeader');
                            const resultBody = document.getElementById('resultModalBody');
                            
                            resultHeader.className = 'modal-header bg-success text-white';
                            resultHeader.querySelector('.modal-title').innerHTML = '<i class="ti ti-check-circle me-2"></i>Sucesso!';
                           
                            resultBody.innerHTML = `
                                <div class="text-center mb-3">
                                    <i class="ti ti-check-circle text-success" style="font-size: 64px;"></i>
                                </div>
                                <div class="text-start">
                                    <p class="lead"><strong>${result.message}</strong></p>
                                    <hr>
                                    <div class="row g-3">
                                        <div class="col-6">
                                            <div class="d-flex align-items-center">
                                                <i class="ti ti-package me-2 text-primary fs-4"></i>
                                                <div>
                                                    <small class="text-muted d-block">Sale ID</small>
                                                    <strong>${result.sale_id}</strong>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="d-flex align-items-center">
                                                <i class="ti ti-file-invoice me-2 text-info fs-4"></i>
                                                <div>
                                                    <small class="text-muted d-block">Total de Pedidos</small>
                                                    <strong>${result.total_pedidos}</strong>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="d-flex align-items-center">
                                                <i class="ti ti-shopping-cart me-2 text-warning fs-4"></i>
                                                <div>
                                                    <small class="text-muted d-block">Total de Produtos</small>
                                                    <strong>${result.total_produtos}</strong>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="d-flex align-items-center">
                                                <i class="ti ti-currency-real me-2 text-success fs-4"></i>
                                                <div>
                                                    <small class="text-muted d-block">Valor Total</small>
                                                    <strong>R$ ${parseFloat(result.valor_total).toFixed(2)}</strong>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="d-flex align-items-center">
                                                <i class="ti ti-chart-line me-2 text-danger fs-4"></i>
                                                <div>
                                                    <small class="text-muted d-block">Custo Total</small>
                                                    <strong>R$ ${parseFloat(result.valor_custo).toFixed(2)}</strong>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `;
                            
                            // Mostrar footer com botão
                            const footer = document.querySelector('#modalResultadoImportacao .modal-footer');
                            footer.style.display = 'block';
                            footer.innerHTML = `
                                <button type="button" class="btn btn-primary w-100" onclick="location.reload()">
                                    <i class="ti ti-refresh me-2"></i>Ver Vendas
                                </button>
                            `;
                        }, 800);
                } else {
                    // Fechar SweetAlert e mostrar erro no modal Bootstrap
                    setTimeout(() => {
                        Swal.close();
                        
                        // Remover backdrop do SweetAlert
                        const backdrops = document.querySelectorAll('.swal2-container');
                        backdrops.forEach(backdrop => backdrop.remove());
                        
                        // Fechar modal de importação
                        const modalImportar = bootstrap.Modal.getInstance(document.getElementById('modalImportarVendas'));
                        if (modalImportar) {
                            modalImportar.hide();
                        }
                        
                        setTimeout(() => {
                            // Configurar conteúdo do modal
                            const resultHeader = document.getElementById('resultModalHeader');
                            const resultBody = document.getElementById('resultModalBody');
                            
                            resultHeader.className = 'modal-header bg-danger text-white';
                            resultHeader.querySelector('.modal-title').innerHTML = '<i class="ti ti-alert-circle me-2"></i>Erro ao Importar';
                            
                            resultBody.innerHTML = `
                                <div class="text-center mb-3">
                                    <i class="ti ti-alert-circle text-danger" style="font-size: 64px;"></i>
                                </div>
                                <div class="alert alert-danger">
                                    <strong>${result.message || 'Erro ao salvar os dados'}</strong>
                                </div>
                            `;
                            
                            // Atualizar botão do footer
                            document.querySelector('#modalResultadoImportacao .modal-footer').innerHTML = `
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                    <i class="ti ti-x me-2"></i>Fechar
                                </button>
                            `;
                            
                            // Mostrar modal de resultado
                            const modalResultado = new bootstrap.Modal(document.getElementById('modalResultadoImportacao'));
                            modalResultado.show();
                        }, 500);
                    }, 300);
                    if (btnConfirmar) {
                        btnConfirmar.disabled = false;
                        btnConfirmar.innerHTML = '<i class="ti ti-check me-2"></i>Confirmar e Importar Pedido(s)';
                    }
                }
            })
            .catch(error => {
                clearInterval(timerInterval);
                console.error('Erro ao importar:', error);
                
                // Fechar SweetAlert e mostrar erro no modal Bootstrap
                setTimeout(() => {
                    Swal.close();
                    
                    // Remover backdrop do SweetAlert
                    const backdrops = document.querySelectorAll('.swal2-container');
                    backdrops.forEach(backdrop => backdrop.remove());
                    
                    // Fechar modal de importação
                    const modalImportar = bootstrap.Modal.getInstance(document.getElementById('modalImportarVendas'));
                    if (modalImportar) {
                        modalImportar.hide();
                    }
                    
                    setTimeout(() => {
                        // Configurar conteúdo do modal
                        const resultHeader = document.getElementById('resultModalHeader');
                        const resultBody = document.getElementById('resultModalBody');
                        
                        resultHeader.className = 'modal-header bg-danger text-white';
                        resultHeader.querySelector('.modal-title').innerHTML = '<i class="ti ti-alert-circle me-2"></i>Erro';
                        
                        resultBody.innerHTML = `
                            <div class="text-center mb-3">
                                <i class="ti ti-alert-circle text-danger" style="font-size: 64px;"></i>
                            </div>
                            <div class="alert alert-danger">
                                <strong>Erro ao processar importação. Verifique sua conexão e tente novamente.</strong>
                            </div>
                        `;
                        
                        // Atualizar botão do footer
                        document.querySelector('#modalResultadoImportacao .modal-footer').innerHTML = `
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                <i class="ti ti-x me-2"></i>Fechar
                            </button>
                        `;
                        
                        // Mostrar modal de resultado
                        const modalResultado = new bootstrap.Modal(document.getElementById('modalResultadoImportacao'));
                        modalResultado.show();
                    }, 500);
                }, 300);
                
                if (btnConfirmar) {
                    btnConfirmar.disabled = false;
                    btnConfirmar.innerHTML = '<i class="ti ti-check me-2"></i>Confirmar e Importar Pedido(s)';
                }
            });
            }, 300); // Fecha setTimeout principal
        }

        // Função para cancelar a importação
        function cancelarImportacao() {
            const btnSubmit = document.getElementById('btnIniciarImportacao');
            const resultDiv = document.getElementById('importResult');
            
            if (btnSubmit) {
                btnSubmit.style.display = 'block';
                btnSubmit.classList.remove('d-none');
                btnSubmit.disabled = false;
                btnSubmit.innerHTML = '<i class="ti ti-search me-2"></i>Buscar Vendas';
            }
            
            if (resultDiv) {
                resultDiv.innerHTML = '';
                resultDiv.style.display = 'none';
            }
            
            // Limpar campo de input
            const orderIdInput = document.getElementById('orderIdImport');
            if (orderIdInput) {
                orderIdInput.value = '';
            }
        }
    </script>

</body>

</html>