<?php
date_default_timezone_set('America/Sao_Paulo');

// Utilizando caminho relativo correto
require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
include_once('../../funcoes/general.php');

// Função para gerar UUID
function generateUUID()
{
    return sprintf(
        '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0x0fff) | 0x4000,
        mt_rand(0, 0x3fff) | 0x8000,
        mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0xffff)
    );
}

// Função para validar CPF
function validarCPF($cpf)
{
    // Remove caracteres especiais do CPF
    $cpf = preg_replace('/[^0-9]/', '', $cpf);

    // Verifica se o CPF tem 11 dígitos
    if (strlen($cpf) != 11) {
        return false;
    }

    // Verifica se todos os dígitos são iguais
    if (preg_match('/(\d)\1{10}/', $cpf)) {
        return false;
    }

    // Calcula os dígitos verificadores
    for ($t = 9; $t < 11; $t++) {
        for ($d = 0, $c = 0; $c < $t; $c++) {
            $d += $cpf[$c] * (($t + 1) - $c);
        }
        $d = ((10 * $d) % 11) % 10;
        if ($cpf[$c] != $d) {
            return false;
        }
    }

    return true;
}

// Processa a requisição AJAX
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_user') {
    try {
        // Captura e valida os dados recebidos
        $full_name = $_POST['full_name'] ?? '';
        $email = filter_var($_POST['email'] ?? '', FILTER_VALIDATE_EMAIL);
        $mobile = $_POST['mobile'] ?? '';
        $cpf = $_POST['CPF'] ?? '';
        $plano_id = !empty($_POST['plano']) ? intval($_POST['plano']) : 30;
        
        // SEMPRE busca o nome real do plano na tabela para garantir consistência
        $stmt_plano = $pdo->prepare("SELECT nome FROM planos_assinatura WHERE id = :id");
        $stmt_plano->execute([':id' => $plano_id]);
        if ($stmt_plano->rowCount() > 0) {
            $plano_result = $stmt_plano->fetch(PDO::FETCH_ASSOC);
            $plano_nome = $plano_result['nome']; // Usa o nome EXATO da tabela
        } else {
            // Se não encontrar o plano, usa o ID 30 como fallback
            $plano_id = 30;
            $stmt_fallback = $pdo->prepare("SELECT nome FROM planos_assinatura WHERE id = 30");
            $stmt_fallback->execute();
            if ($stmt_fallback->rowCount() > 0) {
                $fallback_result = $stmt_fallback->fetch(PDO::FETCH_ASSOC);
                $plano_nome = $fallback_result['nome'];
            } else {
                $plano_nome = "NACIONAL START"; // último recurso
            }
        }
        $dta_fim_assinatura = $_POST['dta_fim_assinatura'] ?? '';
        $is_admin = intval($_POST['is_admin'] ?? 0);
        $is_supplier = intval($_POST['is_supplier'] ?? 0);

        // Validações básicas
        if (empty($full_name) || empty($email) || empty($mobile) || empty($cpf)) {
            echo json_encode(['success' => false, 'message' => 'Nome, e-mail, WhatsApp e CPF são obrigatórios.']);
            exit();
        }

        // Validação de CPF
        if (!validarCPF($cpf)) {
            echo json_encode(['success' => false, 'message' => 'CPF inválido.']);
            exit();
        }

        // Verifica se o e-mail já existe
        $stmt = $pdo->prepare("SELECT id FROM usuarios WHERE email = :email");
        $stmt->execute([':email' => $email]);
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => false, 'message' => 'Este e-mail já está cadastrado.']);
            exit();
        }

        // Verifica se o CPF já existe
        $cpf_numerico = preg_replace('/[^0-9]/', '', $cpf);
        $stmt = $pdo->prepare("SELECT id FROM usuarios WHERE documento = :cpf");
        $stmt->execute([':cpf' => $cpf_numerico]);
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => false, 'message' => 'Este CPF já está cadastrado.']);
            exit();
        }

        // Gerar ordem ID único
        $order_id = "TEST" . substr(md5(time()), 0, 6);
        $created_at = date('Y-m-d H:i:s');

        // Formatação das datas
        $dta_inicio = date('Y-m-d H:i:s');
        $dta_fim = !empty($dta_fim_assinatura) ?
            date('Y-m-d H:i:s', strtotime($dta_fim_assinatura)) :
            date('Y-m-d H:i:s', strtotime('+3 days'));

        // Formatar CPF (remover caracteres especiais)
        $cpf_numerico = preg_replace('/[^0-9]/', '', $cpf);

        // Formatar mobile (remover caracteres especiais)
        $mobile_numerico = preg_replace('/[^0-9]/', '', $mobile);

        // Formate as datas para o formato ISO 8601 (c) que é o esperado pelo criar_contas.php
        $start_date_iso = date('c', strtotime($dta_inicio));
        $next_payment_iso = date('c', strtotime($dta_fim));

        // Construir o objeto JSON com informações detalhadas
        $data = json_encode([
            "order_id" => $order_id,
            "order_ref" => $order_id,
            "order_status" => "paid",
            "product_type" => "membership",
            "payment_method" => "trial",
            "store_id" => generateUUID(),
            "payment_merchant_id" => $order_id,
            "installments" => 1,
            "card_type" => null,
            "card_last4digits" => null,
            "card_rejection_reason" => null,
            "boleto_barcode" => null,
            "boleto_expiry_date" => null,
            "pix_code" => null,
            "pix_expiration" => null,
            "sale_type" => "producer",
            "created_at" => $created_at,
            "updated_at" => $created_at,
            "approved_date" => $created_at,
            "refunded_at" => null,
            "webhook_event_type" => "order_approved",
            "Product" => [
                "product_id" => generateUUID(),
                "product_name" => $plano_nome,
            ],
            "Customer" => [
                "full_name" => $full_name,
                "first_name" => explode(' ', $full_name)[0],
                "email" => $email,
                "mobile" => $mobile_numerico,
                "CPF" => $cpf_numerico,
                "dta_nascimento" => "",
                "data_nascimento" => "",
                "birth_date" => "",
                "nascimento" => "",
                "ip" => $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1',
            ],
            "Commissions" => [
                "charge_amount" => 0,
                "product_base_price" => 0,
                "kiwify_fee" => 0,
                "commissioned_stores" => [
                    [
                        "id" => generateUUID(),
                        "type" => "producer",
                        "custom_name" => Config::get('site_configs.name'),
                        "email" => Config::get('site_configs.principal_email'),
                        "value" => "0"
                    ]
                ],
                "currency" => "BRL",
                "my_commission" => 0,
                "funds_status" => "waiting",
                "estimated_deposit_date" => null,
                "deposit_date" => null
            ],
            "TrackingParameters" => [
                "src" => null,
                "sck" => null,
                "utm_source" => "trial_page",
                "utm_medium" => "web",
                "utm_campaign" => "free_trial",
                "utm_content" => null,
                "utm_term" => null
            ],
            "Subscription" => [
                "start_date" => $start_date_iso,
                "next_payment" => $next_payment_iso,
                "status" => "trial",
                "plan" => [
                    "id" => $plano_id,
                    "name" => $plano_nome,
                    "frequency" => "trial",
                    "qty_charges" => 0
                ],
                "charges" => [
                    "completed" => [
                        [
                            "order_id" => $order_id,
                            "amount" => 0,
                            "status" => "paid",
                            "installments" => 1,
                            "card_type" => null,
                            "card_last_digits" => null,
                            "card_first_digits" => null,
                            "created_at" => date('c')
                        ]
                    ],
                    "future" => []
                ]
            ],
            "subscription_id" => generateUUID(),
            "access_url" => null,
            "admin_data" => [
                "is_admin" => $is_admin,
                "is_supplier" => $is_supplier,
                "nicho" => "",
                "liberar_forn_whitelabel" => 0,
                "dta_fim_assinatura" => $dta_fim,
                "trial_account" => true
            ],
            "client_id" => '161382504218144',
            "client_secret" => '00zCkQERe7WY5wACQ856ZD3yG0fLjX92'
        ], JSON_UNESCAPED_UNICODE);

        // Salvar no banco de dados
        $stmt = $pdo->prepare("INSERT INTO callback_kiwify (order_id, event_type, order_status, event_timestamp, data, processed) VALUES (:order_id, :event_type, :order_status, :event_timestamp, :data, 0)");
        $result = $stmt->execute([
            ':order_id' => $order_id,
            ':event_type' => 'order_approved',
            ':order_status' => 'paid',
            ':event_timestamp' => $created_at,
            ':data' => $data
        ]);

        if ($result) {
            echo json_encode([
                'success' => true,
                'message' => 'Cadastro realizado com sucesso! Sua conta de teste será criada automaticamente em alguns minutos. Você receberá um e-mail com seus dados de acesso.'
            ], JSON_UNESCAPED_UNICODE);
        } else {
            throw new Exception("Erro ao inserir dados na tabela callback_kiwify");
        }
    } catch (Exception $e) {
        error_log("Erro no cadastro de teste: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Erro ao processar o cadastro: ' . $e->getMessage()], JSON_UNESCAPED_UNICODE);
    }
    exit();
}

// Se não for uma requisição POST ou a ação não for 'add_user'
header('Content-Type: application/json');
echo json_encode(['success' => false, 'message' => 'Requisição inválida.'], JSON_UNESCAPED_UNICODE);
exit();
?>