<?php
session_start();

header('Content-Type: application/json'); // Define o cabeçalho como JSON

require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');

require '../../class/chamadosClass.php';

try {
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Verifique se o formulário foi enviado via POST
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Capture os dados enviados pelo formulário
        $protocolo = $_POST['protocolo'];
        $topico = $_POST['topico'];
        $descricao = $_POST['descricao'];
        $fornecedor = $_POST['fornecedor'];
        $status = $_POST['status'];
        $usuario_id = $_POST['usuario_id'];
        $usuario_email = $_POST['usuario_email'];
        $nome_usuario = $_POST['nome_usuario'];
        $tipo = $_POST['tipo'];
        $atendente = isset($_POST['atendente']) && !empty($_POST['atendente']) ? $_POST['atendente'] : null;


        // Instancie a classe Chamados passando API configs
        $chamados = new Chamados(
            $pdo,
            Config::get('api_configs.base_url'),
            Config::get('api_configs.token')
        );

        // Insira o chamado no banco de dados
        $resposta = $chamados->inserirChamado($protocolo, $topico, $descricao, $status, $usuario_id, $usuario_email, $tipo, $atendente, $fornecedor, $nome_usuario);


        // Verifique a resposta e envie um JSON apropriado
        if (strpos($resposta, 'sucesso') !== false) {
            echo json_encode(['success' => true, 'message' => $resposta]);
        } else {
            echo json_encode(['success' => false, 'message' => $resposta]);
        }
    }

} catch (PDOException $e) {
    // Em caso de erro, envie uma resposta JSON com a mensagem de erro
    echo json_encode(['success' => false, 'message' => "Erro na conexão: " . $e->getMessage()]);
}
?>
